/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.HList;
import com.sas.mdtable.AxisInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.commands.FilterNameCommand;
import com.sas.sasserver.mdtable.commands.FindCommand;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.NameCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.commands.SortNameCommand;
import com.sas.table.TableException;
import com.sas.util.Command;

public class LevelNameCommand
extends NameCommand {
    protected transient Level _level;
    protected transient Member _member;
    protected static final String RB_KEY = "LevelNameCommand.";

    public LevelNameCommand(Level level) {
        this.setText(level.isAnalysisLevel() || level.isStatisticLevel() ? "Statistic" : level.getLabel());
        this._level = level;
    }

    public LevelNameCommand(Member member) {
        this((Level)member.getMember().getLevel());
        this._member = member;
    }

    @Override
    public Command[] getCommands() {
        OrderedCollection oc = new OrderedCollection();
        if (this.isSortAllowed()) {
            if (this._member != null) {
                oc.add((Object)new SortNameCommand(this._member));
                if (this.isFilterAllowed()) {
                    oc.add((Object)new FilterNameCommand(this._member));
                }
            } else {
                oc.add((Object)new SortNameCommand(this._level));
                if (this.isFilterAllowed()) {
                    oc.add((Object)new FilterNameCommand(this._level));
                }
            }
        }
        if (this.isFindAllowed()) {
            if (this._member != null) {
                oc.add((Object)new FindCommand(this._member));
            } else {
                oc.add((Object)new FindCommand(this._level));
            }
        }
        if (this.isTotalAllowed()) {
            if (this._level.getTotalState()) {
                oc.add((Object)new MDCommand(RB.getStringResource("totalsOff.txt"), this._level));
            } else {
                oc.add((Object)new MDCommand(RB.getStringResource("totalsOn.txt"), this._level));
            }
        }
        Command[] commands = new Command[oc.count()];
        for (int i = 0; i < commands.length; ++i) {
            commands[i] = (Command)oc.get(i);
        }
        return commands;
    }

    private boolean isSortAllowed() {
        block6: {
            if (this._level.isStatisticLevel()) {
                Level measLevel;
                ParentNode meas;
                HList hl = (HList)this._level.getImddb()._getCustomizations("STATSPERMEASURE");
                if (hl.itemExists("STATSPERMEASURE", 1, 0) && hl.getDouble("STATSPERMEASURE") == 0.0) {
                    try {
                        AxisInterface[] a = this._level.getImddb().getAxes(0, -1);
                        if (a.length > 1 && ((Axis)a[1]).getLevels().length > 1) {
                            return false;
                        }
                        break block6;
                    }
                    catch (TableException te) {
                        return false;
                    }
                }
                if (this._member != null && (meas = (ParentNode)this._member.getParent()) instanceof Member && (measLevel = (Level)((Member)meas).getLevel()).isAnalysisLevel() && ((Member)meas).isComputedValue()) {
                    return false;
                }
            }
        }
        return !this._level.isAnalysisLevel();
    }

    private boolean isFilterAllowed() {
        if (!(this._level.getImddb() instanceof MultidimensionalTableV2Interface)) {
            return false;
        }
        return this._level.isStatisticLevel();
    }

    private boolean isFindAllowed() {
        return this._level.getImddb() instanceof MultidimensionalTableV2Interface;
    }

    private boolean isTotalAllowed() {
        return !this._level.isStatisticLevel() && !this._level.isAnalysisLevel();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new LevelNameCommand(this._level);
    }
}

