/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.mdtable.MultidimensionalTableView;
import com.sas.mdtable.StaticMultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableWriter;

public class ExportToExcelCommand
extends MDCommand {
    public ExportToExcelCommand(String name, MultidimensionalTableInterface imddb) {
        super(name, imddb);
    }

    public ExportToExcelCommand(MultidimensionalTableInterface imddb) {
        this(com.sas.sasserver.mdtable.RB.getStringResource("excel.txt"), imddb);
    }

    @Override
    public void execute(Object data) {
        super.execute(data);
    }

    @Override
    public void performAction() {
        if (this._view != null && this._view instanceof MultidimensionalTableView) {
            ExportToExcelCommand.export(this._imddb, true, ((MultidimensionalTableView)this._view).isTransposed());
        } else {
            ExportToExcelCommand.export(this._imddb);
        }
    }

    public static byte[] getCSV(MultidimensionalTableInterface mddb) {
        return TableWriter.getCSVAsByteArray(mddb);
    }

    public static byte[] getCSV(StaticTableInterface table) {
        return TableWriter.getCSVAsByteArray(table);
    }

    public static byte[] getCSV(StaticMultidimensionalTableInterface mddb, boolean formattedDataUsed) {
        return TableWriter.getCSVAsByteArray(mddb, formattedDataUsed);
    }

    public static byte[] getCSV(StaticTableInterface table, boolean formattedDataUsed) {
        return TableWriter.getCSVAsByteArray(table, formattedDataUsed);
    }

    public static byte[] getCSV(StaticMultidimensionalTableInterface mddb, boolean formattedDataUsed, boolean isTransposed) {
        return TableWriter.getCSVAsByteArray(mddb, formattedDataUsed, isTransposed);
    }

    public static void export(MultidimensionalTableInterface mddb) {
        if (!ExportToExcelCommand.isExportAllowed()) {
            return;
        }
        TableWriter.export(mddb);
    }

    public static void export(StaticTableInterface table) {
        if (!ExportToExcelCommand.isExportAllowed()) {
            return;
        }
        TableWriter.export(table);
    }

    public static void export(StaticMultidimensionalTableInterface mddb, boolean formattedDataUsed) {
        if (!ExportToExcelCommand.isExportAllowed()) {
            return;
        }
        TableWriter.export(mddb, formattedDataUsed);
    }

    public static void export(StaticMultidimensionalTableInterface mddb, boolean formattedDataUsed, boolean isTransposed) {
        if (!ExportToExcelCommand.isExportAllowed()) {
            return;
        }
        TableWriter.export(mddb, formattedDataUsed, isTransposed);
    }

    public static void export(StaticTableInterface table, boolean formattedDataUsed) {
        if (!ExportToExcelCommand.isExportAllowed()) {
            return;
        }
        TableWriter.export(table, formattedDataUsed);
    }

    public static boolean isExportAllowed() {
        return TableWriter.isExportAllowed();
    }

    public static void resetCheck() {
        TableWriter.resetCheck();
    }

    @Override
    public long getMask() {
        return 32L;
    }

    @Override
    public String getText() {
        return RB.getStringResource("excel.txt");
    }
}

