/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.sasserver.mdtable.Element;
import com.sas.sasserver.mdtable.TextParserConstants;
import java.util.Vector;

class TextParser
implements TextParserConstants {
    Vector _elements;
    String _text;

    TextParser() {
    }

    private void reset() {
        if (this._elements != null) {
            this._elements.removeAllElements();
        } else {
            this._elements = new Vector(10);
        }
    }

    public int processText(String text, int[] errorPos) {
        if (errorPos == null || errorPos.length < 1) {
            throw new IllegalArgumentException("int[] errorPos must be an array of at least 1");
        }
        errorPos[0] = -1;
        if (text == null || text.length() == 0 || text == this._text) {
            return 0;
        }
        this._text = text;
        this.reset();
        int nestCount = 0;
        int length = text.length();
        char[] chars = text.toCharArray();
        Element currStruct = new Element();
        currStruct.beforeStart = 0;
        block5: for (int i = 0; i < length; ++i) {
            switch (chars[i]) {
                case '\\': {
                    if (i + 1 >= length || chars[i + 1] != '{' && chars[i + 1] != '}' && chars[i + 1] != '\\') continue block5;
                    ++i;
                    currStruct.hasEscapeOrBracket = true;
                    continue block5;
                }
                case '{': {
                    if (++nestCount > 2) {
                        errorPos[0] = i;
                        return 1;
                    }
                    if (nestCount == 1 && currStruct.beforeStart != -5 && currStruct.beforeStart != i) {
                        currStruct.beforeEnd = i - 1;
                        this._elements.addElement(currStruct);
                        currStruct = new Element();
                        currStruct.beforeStart = i + 1;
                        continue block5;
                    }
                    if (nestCount == 1) {
                        currStruct.beforeStart = i + 1;
                        continue block5;
                    }
                    if (i - 1 < currStruct.beforeStart) {
                        currStruct.beforeStart = -5;
                    } else {
                        currStruct.beforeEnd = i - 1;
                    }
                    currStruct.levelStart = i + 1;
                    continue block5;
                }
                case '}': {
                    if (--nestCount < 0) {
                        errorPos[0] = i;
                        return 2;
                    }
                    if (nestCount == 0 && currStruct.levelStart == -5) {
                        currStruct.levelStart = currStruct.beforeStart;
                        currStruct.beforeStart = -5;
                        if (i - 1 < currStruct.levelStart) {
                            errorPos[0] = i;
                            return 3;
                        }
                        if (currStruct.levelName != null) {
                            errorPos[0] = i;
                            return 4;
                        }
                        currStruct.levelEnd = i - 1;
                        currStruct.setLevelName(text.substring(currStruct.levelStart, currStruct.levelEnd + 1));
                        i = this.pullInEOL(currStruct, chars, length, i);
                        this._elements.addElement(currStruct);
                        currStruct = new Element();
                        currStruct.beforeStart = i + 1;
                        continue block5;
                    }
                    if (nestCount == 0 && currStruct.levelEnd != -5) {
                        if (i - 1 < currStruct.afterStart) {
                            currStruct.afterStart = -5;
                        } else {
                            currStruct.afterEnd = i - 1;
                        }
                        i = this.pullInEOL(currStruct, chars, length, i);
                        this._elements.addElement(currStruct);
                        currStruct = new Element();
                        currStruct.beforeStart = i + 1;
                        continue block5;
                    }
                    if (nestCount != 1) continue block5;
                    if (i - 1 < currStruct.levelStart) {
                        errorPos[0] = i;
                        return 3;
                    }
                    if (currStruct.levelName != null) {
                        errorPos[0] = i;
                        return 4;
                    }
                    currStruct.levelEnd = i - 1;
                    currStruct.setLevelName(text.substring(currStruct.levelStart, currStruct.levelEnd + 1));
                    currStruct.afterStart = i + 1;
                    continue block5;
                }
            }
        }
        if (currStruct.beforeStart != -5 && length > currStruct.beforeStart) {
            currStruct.beforeEnd = length - 1;
            this._elements.addElement(currStruct);
        }
        if (nestCount > 0) {
            errorPos[0] = length;
            return 1;
        }
        if (nestCount < 0) {
            errorPos[0] = length;
            return 2;
        }
        return 0;
    }

    private int pullInEOL(Element currStruct, char[] chars, int length, int i) {
        int tmpIndx;
        boolean allWhiteSpace = true;
        boolean foundEOL = false;
        for (tmpIndx = i + 1; tmpIndx < length; ++tmpIndx) {
            boolean bl = foundEOL = chars[tmpIndx] == '\n' || chars[tmpIndx] == '\r';
            if (foundEOL) break;
            boolean bl2 = allWhiteSpace = allWhiteSpace && Character.isWhitespace(chars[tmpIndx]);
            if (!allWhiteSpace) break;
        }
        if (foundEOL && allWhiteSpace) {
            if (currStruct.afterStart == -5) {
                currStruct.afterStart = i + 1;
            } else {
                currStruct.hasEscapeOrBracket = true;
            }
            if (chars[tmpIndx] == '\r' && tmpIndx + 1 < length && chars[tmpIndx + 1] == '\n') {
                ++tmpIndx;
            }
            currStruct.afterEnd = tmpIndx;
            i = tmpIndx;
        }
        return i;
    }

    public static void main(String[] args) {
        int[] errorPos = new int[1];
        TextParser parse = new TextParser();
        if (args.length == 0) {
            args = new String[]{"asdf asdf {sdf}", "{asdf}", "{{kdkd}}", "{{fjjf", "} hello", "Revenue for {COUNTRY} shown below", "{Revenue for {COUNTRY} shown below}", "Revenue for {COUNTRY} shown { below", "{Revenue for {COUNTRY} {shown}}", "{Revenue for {COUNTRY\\} \\{shown}}", "\\\\\\\\\\{", "make sure last x found: {stuff {sss}}x{jfjf {jjdjd}}x", "new line test1: {foo}\n{bar}", "new line test2: {{foo}} \t\n{{bar}} ", "new line test3 (has\\r\\n): {{foo}}  \r\n  {{bar}} ", "{Country: {Country}xxx}\n{Year: {Year}}"};
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println("#-delimited argument: #" + args[i] + "#");
            int retCode = parse.processText(args[i], errorPos);
            System.out.println("retCode = " + retCodeStrings[retCode] + ", errorPos = " + errorPos[0] + "\r\n");
            System.out.println(parse._elements);
            parse.reset();
        }
    }
}

