/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ComponentException;
import com.sas.awt.util.Util;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.SortedCollection;
import com.sas.collection.StringCollection;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.measures.Length;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.LevelTable;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.dialogs.FindDialog;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Comparator;
import com.sas.util.StringComparator;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SubsetCustomizerPanel
extends BaseMDInterfaceCustomizerPanel
implements MouseListener {
    public static final String RB_KEY = "SubsetCustomizerPanel.";
    private transient JComboBox _levelsChoice;
    private transient LevelTable[] _levels;
    private transient JList _subsetsList;
    private transient TableView _membersTable;
    private transient Dictionary _origSubsets;
    private transient OrderedCollection _newSubsets;
    private transient OrderedCollection _subsetsDisplayList;
    LevelTable levelTable;
    private transient LevelInterface _currentLevel;
    private transient boolean _dirty;
    private transient JFrame _parentFrame;
    private transient JButton findButton;
    private transient JButton addButton;
    private transient JButton removeButton;
    private transient boolean _inSetup;
    private EqualSpacePartitioner equalSpace;
    protected SubsetComparator _subsetComparator;
    protected transient FindDialog _dialog;
    private transient boolean _fromOK;
    private transient boolean _eventsEnabled;

    public SubsetCustomizerPanel(String tabName) {
        this(tabName, null);
    }

    public SubsetCustomizerPanel(String tabName, LevelInterface level) {
        super(tabName);
        this._currentLevel = level;
    }

    @Override
    protected void initializeValues() {
        super.initializeValues();
        this._subsetComparator = new SubsetComparator();
        this._currentLevel = null;
        this._eventsEnabled = true;
    }

    @Override
    protected void createGUI() {
        JPanel upperLeftPanel = new JPanel();
        AutoSizingGridLayout ulplayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        ulplayout.setRemainderRow(2);
        ulplayout.setRemainderColumn(1);
        upperLeftPanel.setLayout((LayoutManager)ulplayout);
        JPanel levelsPanel = new JPanel();
        AutoSizingGridLayout lplayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        lplayout.setRemainderRow(2);
        lplayout.setRemainderColumn(1);
        levelsPanel.setLayout((LayoutManager)lplayout);
        upperLeftPanel.add(levelsPanel);
        JLabel levelsLabel = new JLabel(RB.getStringResource(RB_KEY, "levelsLabel.txt"));
        levelsPanel.add(levelsLabel);
        this._levelsChoice = new JComboBox();
        this._levelsChoice.setLightWeightPopupEnabled(false);
        levelsPanel.add(this._levelsChoice);
        JPanel membersPanel = new JPanel();
        AutoSizingGridLayout mplayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        mplayout.setRemainderRow(2);
        mplayout.setRemainderColumn(1);
        membersPanel.setLayout((LayoutManager)mplayout);
        upperLeftPanel.add(membersPanel);
        JLabel membersLabel = new JLabel(RB.getStringResource(RB_KEY, "membersLabel.txt"));
        membersPanel.add(membersLabel);
        this._membersTable = new TableView();
        this._membersTable.setRowLabelsVisible(false);
        this._membersTable.setColumnLabelsVisible(false);
        this._membersTable.setColumnsConformed(true);
        this._membersTable.setExtendedSelectionAllowed(true);
        this._membersTable.setGridVisible(false);
        this._membersTable.setMultipleSelectionAllowed(true);
        CellStyle cs = this._membersTable.getDefaultCellStyle();
        cs.setBottomMargin(new Length(0.0, "pt"));
        cs.setTopMargin(new Length(0.0, "pt"));
        cs.setOpacity(0);
        cs.setBackgroundColor(SystemColor.window);
        membersPanel.add(this._membersTable);
        JPanel lowerLeftPanel = new JPanel();
        this.addButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "addButtonLabel.txt"), (Object)"   ", (Object)"   "));
        this.findButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "findButtonLabel.txt"), (Object)"  ", (Object)" "));
        AutoSizingGridLayout llplayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        lowerLeftPanel.setLayout((LayoutManager)llplayout);
        lowerLeftPanel.add(this.addButton);
        lowerLeftPanel.add(this.findButton);
        JPanel upperRightPanel = new JPanel();
        AutoSizingGridLayout urplayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        urplayout.setRemainderRow(2);
        urplayout.setRemainderColumn(1);
        upperRightPanel.setLayout((LayoutManager)urplayout);
        JLabel subsetsLabel = new JLabel(RB.getStringResource(RB_KEY, "subsetsLabel.txt"));
        upperRightPanel.add(subsetsLabel);
        this._subsetsList = new JList();
        JScrollPane scrollPane = new JScrollPane(this._subsetsList);
        scrollPane.setPreferredSize(new java.awt.Dimension(130, 250));
        upperRightPanel.add(scrollPane);
        JPanel lowerRightPanel = new JPanel();
        AutoSizingGridLayout lrplayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        lowerRightPanel.setLayout((LayoutManager)lrplayout);
        this.removeButton = new JButton(com.sas.util.Util.getCommonStringResource((String)"Remove.txt"));
        lowerRightPanel.add(this.removeButton);
        this._membersTable.addMouseListener(this);
        ItemListener listListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getSource() instanceof JList) {
                    JList list = (JList)e.getSource();
                    this.itemStateChanged(e, list == SubsetCustomizerPanel.this._subsetsList ? SubsetCustomizerPanel.this.removeButton : SubsetCustomizerPanel.this.addButton, list);
                } else if (e.getSource() instanceof TableView) {
                    TableView table = (TableView)e.getSource();
                    this.itemStateChanged(e, table == SubsetCustomizerPanel.this._membersTable ? SubsetCustomizerPanel.this.addButton : SubsetCustomizerPanel.this.removeButton, table);
                } else if (!SubsetCustomizerPanel.this._inSetup) {
                    SubsetCustomizerPanel.this.update(true);
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }

            public void itemStateChanged(ItemEvent e, JButton b, TableView table) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getStateChange() == 1) {
                    b.setEnabled(true);
                } else if (e.getStateChange() == 2 && table.getSelectedObjects() == null) {
                    b.setEnabled(false);
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }

            public void itemStateChanged(ItemEvent e, JButton b, JList list) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getStateChange() == 1) {
                    b.setEnabled(true);
                } else if (e.getStateChange() == 2 && list.getSelectedValues() == null) {
                    b.setEnabled(false);
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }
        };
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getSource() instanceof JList) {
                    JList list = (JList)e.getSource();
                    this.valueChanged(e, list == SubsetCustomizerPanel.this._subsetsList ? SubsetCustomizerPanel.this.removeButton : SubsetCustomizerPanel.this.addButton, list);
                    SubsetCustomizerPanel.this.showWaitCursor(false);
                }
            }

            public void valueChanged(ListSelectionEvent e, JButton b, JList list) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (list.getSelectedValues() == null) {
                    b.setEnabled(false);
                } else {
                    b.setEnabled(true);
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }
        };
        this._levelsChoice.addItemListener(listListener);
        this._membersTable.addItemListener(listListener);
        this._subsetsList.addListSelectionListener(listSelectionListener);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getSource() == SubsetCustomizerPanel.this.removeButton || e.getSource() == SubsetCustomizerPanel.this._subsetsList) {
                    SubsetCustomizerPanel.this.performRemove();
                } else if (e.getSource() == SubsetCustomizerPanel.this.findButton) {
                    SubsetCustomizerPanel.this.performFind();
                } else {
                    SubsetCustomizerPanel.this.performAdd();
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }
        };
        this.addButton.addActionListener(buttonListener);
        this.findButton.addActionListener(buttonListener);
        this.removeButton.addActionListener(buttonListener);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SubsetCustomizerPanel.this.showWaitCursor(true);
                if (e.getKeyCode() == 127) {
                    SubsetCustomizerPanel.this.performRemove();
                }
                SubsetCustomizerPanel.this.showWaitCursor(false);
            }
        };
        this._subsetsList.addKeyListener(keyListener);
        AutoSizingGridLayout asgl2 = new AutoSizingGridLayout(2, 2, 5, 5, true, true, true);
        asgl2.setRemainderRow(1);
        this.equalSpace = new EqualSpacePartitioner(true);
        asgl2.setColumnSpacePartitioner((SpacePartitionerInterface)this.equalSpace);
        this.setLayout((LayoutManager)asgl2);
        this.setPreferredSize(new java.awt.Dimension(400, 350));
        this.add(upperLeftPanel);
        this.add(upperRightPanel);
        this.add(lowerLeftPanel);
        this.add(lowerRightPanel);
        this.setEnabled(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (source == this._membersTable && e.getClickCount() == 2) {
            this.performAdd();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected void update(boolean mustSubset) {
        if (this._levels == null || this._levels.length == 0) {
            return;
        }
        int index = this._levelsChoice.getSelectedIndex();
        LevelTable level = index < 0 ? this._levels[0] : this._levels[index];
        try {
            int count = this._newSubsets.count();
            if (count > 0) {
                Subset currentSubset = new Subset(null);
                Object temp = null;
                int tempPos = 0;
                for (int i = 0; i < count; ++i) {
                    if (!((Subset)this._newSubsets.get(i)).getName().equals(level.getName())) continue;
                    currentSubset = (Subset)this._newSubsets.get(i);
                    temp = this._newSubsets.get(i);
                    tempPos = i;
                    this._newSubsets.removeAt(i);
                    Subset clear = new Subset(currentSubset.getLevel());
                    clear.setSubset(new Object[0]);
                    this._newSubsets.add((Object)clear, tempPos);
                    break;
                }
                if (mustSubset) {
                    SubsetInterface[] subsets = new SubsetInterface[count];
                    for (int i = 0; i < count; ++i) {
                        subsets[i] = (SubsetInterface)this._newSubsets.get(i);
                    }
                    this._dirty = true;
                    ((MultidimensionalTableV2Interface)this.getRuntimeTableInterface()).setSubsetsProperty(subsets);
                }
                if (temp != null) {
                    this._newSubsets.removeAt(tempPos);
                    this._newSubsets.add(temp, tempPos);
                }
                this.populateMembersList(level, currentSubset, tempPos);
            } else {
                this.populateMembersList(level, new Subset(null), -1);
            }
            this.populateSubsetsList();
        }
        catch (TableException e) {
            this.showExceptionWarning((Exception)((Object)e));
        }
    }

    public void populateMembersList(LevelTable currentLevel, Subset currentSubset, int pos) {
        if (this.levelTable != null) {
            this.levelTable.setLevel(currentLevel.getLevel());
        } else {
            this.levelTable = new LevelTable(currentLevel.getLevel());
        }
        if (this._membersTable.getModel() == null) {
            if (currentSubset != null && currentSubset.getLevel() != null && this.levelTable.getLevel().equals(currentSubset.getLevel()) && pos >= 0) {
                this.levelTable.addSubset(currentSubset, pos);
            }
            this._membersTable.setModel(this.levelTable);
        } else if (this.levelTable != currentLevel) {
            if (currentSubset != null && currentSubset.getLevel() != null && this.levelTable.getLevel().equals(currentSubset.getLevel()) && pos >= 0) {
                this.levelTable.addSubset(currentSubset, pos);
            }
            this._membersTable.refresh(this.levelTable);
        } else {
            this._membersTable.refresh(this.levelTable);
        }
    }

    public void populateSubsetsList() {
        this._subsetsList.removeAll();
        this._subsetsDisplayList.sort((Comparator)this._subsetComparator);
        int count = this._subsetsDisplayList.count();
        Object[] subsetsListData = new Object[count];
        for (int i = 0; i < count; ++i) {
            subsetsListData[i] = this._subsetsDisplayList.get(i).toString();
        }
        this._subsetsList.setListData(subsetsListData);
    }

    public void performAdd() {
        Object[] values;
        if (this._levels == null || this._levels.length == 0) {
            return;
        }
        Enumeration enumer = this._membersTable.getSelectedCells();
        ArrayList al = new ArrayList();
        if (enumer != null) {
            while (enumer.hasMoreElements()) {
                al.add(enumer.nextElement());
            }
        }
        int cnt = al.size();
        Object valuesTemp = null;
        OrderedCollection valuesOC = new OrderedCollection();
        try {
            for (int l = 0; l < cnt; ++l) {
                DataCell dc = (DataCell)al.get(l);
                valuesTemp = dc.getObjectData();
                if (valuesTemp == null || valuesTemp == LevelTable.blankString) continue;
                valuesOC.add(valuesTemp);
            }
        }
        catch (TableException l) {
            // empty catch block
        }
        if ((values = valuesOC.toArray()) == null || values.length == 0) {
            return;
        }
        int index = this._levelsChoice.getSelectedIndex();
        LevelTable level = index < 0 ? this._levels[0] : this._levels[index];
        int count = this._newSubsets.count();
        int i = -1;
        Subset subset = null;
        if (count > 0) {
            for (i = 0; i < count && ((Subset)this._newSubsets.get(i)).getLevel() != level.getLevel().getDelegate() && ((Subset)this._newSubsets.get(i)).getLevel() != level.getLevel(); ++i) {
            }
            if (i != count) {
                int j;
                subset = (Subset)this._newSubsets.get(i);
                Object[] oldSubset = subset.getSubset();
                StringCollection valColl = new StringCollection();
                if (oldSubset != null) {
                    for (j = 0; j < oldSubset.length; ++j) {
                        valColl.add(oldSubset[j]);
                    }
                }
                for (j = 0; j < values.length; ++j) {
                    valColl.add(values[j]);
                }
                valColl.sort(true);
                subset.setSubset(valColl.toStringArray());
            }
        }
        if (count == 0 || i == count) {
            subset = new Subset(level.getLevel());
            this._newSubsets.add((Object)subset);
            subset.setSubset(values);
        }
        for (i = 0; i < values.length; ++i) {
            this._subsetsDisplayList.add((Object)new SubsetRecord(subset, values[i].toString(), this._levelsChoice.getSelectedIndex()));
        }
        if (this._subsetsDisplayList.count() > 0) {
            this.update(true);
        }
    }

    public void performFind() {
        int index = this._levelsChoice.getSelectedIndex();
        if (index < 0) {
            return;
        }
        LevelTable level = this._levels[index];
        if (level != null && level.getImddb() instanceof MultidimensionalTableV2Interface) {
            Container parent = com.sas.swing.visuals.util.Util.getParent((Component)this, JDialog.class);
            if (parent == null) {
                parent = com.sas.swing.visuals.util.Util.getParent((Component)this, JFrame.class);
            }
            if (parent == null) {
                parent = new JFrame();
            }
            if (parent instanceof Dialog) {
                this._dialog = new FindDialog((Dialog)parent, false);
            } else if (parent instanceof Frame) {
                this._dialog = new FindDialog((Frame)parent, false);
            }
            if (level != null && this._membersTable != null) {
                this._dialog.setLevel(level.getLevel());
                this._dialog.setMultidimensionalTableView(this._membersTable);
            }
            this._dialog.initialize();
            this._dialog.pack();
            try {
                Util.centerOverWindow(this._dialog, parent);
            }
            catch (IllegalComponentStateException e) {
                java.awt.Dimension size = this._dialog.getSize();
                java.awt.Dimension screenSize = this._dialog.getToolkit().getScreenSize();
                this._dialog.setLocation(screenSize.width - size.width, 0);
            }
            this._dialog.pack();
            this._dialog.setVisible(true);
        }
        if (this._membersTable.getSelectedObjects() != null) {
            this.addButton.setEnabled(true);
        }
    }

    public void performRemove() {
        int i;
        if (this._levels == null || this._levels.length == 0) {
            return;
        }
        int[] indices = this._subsetsList.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return;
        }
        SubsetRecord[] records = new SubsetRecord[indices.length];
        for (i = 0; i < indices.length; ++i) {
            records[i] = (SubsetRecord)this._subsetsDisplayList.get(indices[i]);
            Object[] oldSubset = records[i]._subset.getSubset();
            Object[] newSubset = new Object[oldSubset.length - 1];
            int k = 0;
            for (int j = 0; j < oldSubset.length; ++j) {
                if (oldSubset[j].equals(records[i]._value)) continue;
                newSubset[k++] = oldSubset[j];
            }
            records[i]._subset.setSubset(newSubset);
        }
        try {
            for (i = 0; i < records.length; ++i) {
                this._subsetsDisplayList.remove((Object)records[i]);
                this._levels[records[i]._levelIndex].addMember(records[i]._value);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        this.update(true);
        this.populateSubsetsList();
    }

    protected void setup() {
        this._inSetup = true;
        MultidimensionalTableInterface rTable = this.getRuntimeTableInterface();
        this._dirty = false;
        if (rTable instanceof MultidimensionalTableV2Interface) {
            this.findButton.setEnabled(true);
        }
        OrderedCollection levels = new OrderedCollection();
        this.setSkipExpand(rTable, true);
        try {
            Dictionary levelIDs = rTable.getAllLevels();
            if (levelIDs != null) {
                Enumeration enumer = levelIDs.getKeys();
                while (enumer.hasMoreElements()) {
                    Level l = (Level)levelIDs.get(enumer.nextElement());
                    LevelTable level = new LevelTable(l);
                    Dimension dim = (Dimension)l.getDimension();
                    if (dim == null || dim.getType() == 1) continue;
                    levels.add((Object)level);
                }
            }
            SortedCollection sc = new SortedCollection(levels.getItems(), (Comparator)new NodeComparator(), true);
            if (this._levels == null) {
                int count = levels.count();
                this._levels = new LevelTable[count];
                if (this._levelsChoice != null) {
                    this._levelsChoice.removeAllItems();
                }
                for (int i = 0; i < count; ++i) {
                    this._levels[i] = (LevelTable)sc.get(i);
                    this._levelsChoice.addItem(this._levels[i].getLabel());
                }
                try {
                    if (this._currentLevel != null) {
                        this._levelsChoice.setSelectedItem(this._currentLevel.getLabel());
                    }
                }
                catch (TableException i) {
                    // empty catch block
                }
            }
            if (this._origSubsets == null) {
                this._origSubsets = new Dictionary();
                this._newSubsets = new OrderedCollection();
                this._subsetsDisplayList = new OrderedCollection();
            } else {
                this._origSubsets.removeAll();
                this._newSubsets.removeAll();
                this._subsetsDisplayList.removeAll();
            }
            SubsetInterface[] subsets = this.getTableDelegate().getSubsets();
            if (subsets != null) {
                for (int i = 0; i < subsets.length; ++i) {
                    this._origSubsets.set((Object)subsets[i], (Object)subsets[i].getSubset());
                    if (subsets[i].getSubset() == null) continue;
                    Subset temp = new Subset((Level)subsets[i]);
                    temp.setSubset((Object[])subsets[i].getSubset().clone());
                    this._newSubsets.add((Object)temp);
                    Object[] values = subsets[i].getSubset();
                    for (int j = 0; j < values.length; ++j) {
                        this._subsetsDisplayList.add((Object)new SubsetRecord(temp, (String)values[j], this._levelsChoice.getSelectedIndex()));
                    }
                }
            }
            if (this._levels != null && this._levels.length > 0) {
                this.update(true);
            } else {
                this._dirty = true;
                this._levels = null;
            }
        }
        catch (TableException e) {
            this.showExceptionWarning((Exception)((Object)e));
        }
        this._inSetup = false;
    }

    private void setSkipExpand(MultidimensionalTableInterface mdtable, boolean skipExpand) {
        HList hlist = new HList();
        if (skipExpand) {
            hlist.addItem("Y", 0, "MDSkipExpand");
        } else {
            hlist.addItem("N", 0, "MDSkipExpand");
        }
        mdtable._setOptions((HListInterface)hlist);
    }

    public void showWaitCursor(boolean waitCursor) {
        if (this._parentFrame == null) {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof JFrame); c = c.getParent()) {
            }
            this._parentFrame = (JFrame)c;
        }
        if (waitCursor) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this._parentFrame != null) {
                this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            if (this._parentFrame != null) {
                this._parentFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        this.onClear();
        if (!(bean instanceof MultidimensionalTableInterface)) {
            throw new ComponentException(RB.getStringResource("invalidObject.ex.txt"));
        }
        super.setObject(bean);
        this.addLinks();
    }

    @Override
    public void updateData() throws TableException {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    @Override
    public void preCustomizerClosing() {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onHidden();
        }
        this.onClear();
    }

    private boolean isAllValuesSet() {
        return this.isMetabaseAndDatabaseSet() && this.isRowAxisSet() && this.isMeasuresSet() && this.isStatisticsSet();
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    public void enableEventsOnModel(boolean enable) {
        if (this.isRuntimeTableReady() && this._eventsEnabled != enable) {
            MultidimensionalTableInterface rTable = this.getRuntimeTableInterface();
            this._eventsEnabled = enable;
            if (enable) {
                rTable.enableEvents();
            } else {
                rTable.disableEvents();
            }
        }
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onApply() {
        if (this.isEnabled() && this.isRuntimeTableReady() && !this.isDesignTimeEISApplication()) {
            this.showWaitCursor(true);
            if (this._newSubsets != null) {
                int count = this._newSubsets.count();
                try {
                    SubsetInterface[] sa = new SubsetInterface[count];
                    for (int i = 0; i < count; ++i) {
                        Subset subset = (Subset)this._newSubsets.get(i);
                        Level l = (Level)subset.getLevel();
                        l.setSubset(subset.getSubset());
                        sa[i] = l;
                    }
                    this.getTableDelegate().setSubsets(sa);
                }
                catch (TableException e) {
                    this.showExceptionWarning((Exception)((Object)e));
                }
            }
            MultidimensionalTableInterface rTable = this.getRuntimeTableInterface();
            this.enableEventsOnModel(true);
            try {
                rTable.firePropertyChange("subsets", null, this.getTableDelegate().getSubsets());
            }
            catch (TableException tableException) {
                // empty catch block
            }
            this.setSkipExpand(rTable, false);
            if (this._dialog != null) {
                this._dialog.setVisible(false);
            }
            this._dirty = false;
            this.showWaitCursor(false);
        }
    }

    public void onCancel() {
        if (this.isEnabled() && this.isRuntimeTableReady() && this._dirty) {
            this.showWaitCursor(true);
            int count = this._origSubsets.count();
            Enumeration keys = this._origSubsets.getKeys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    SubsetInterface subset = (SubsetInterface)keys.nextElement();
                    try {
                        subset.setSubset((Object[])this._origSubsets.get((Object)subset));
                    }
                    catch (TableException e) {
                        this.showExceptionWarning((Exception)((Object)e));
                    }
                }
                try {
                    this.getTableDelegate().setSubsets(this.getRuntimeTableInterface().getSubsets());
                }
                catch (TableException e) {
                    this.showExceptionWarning((Exception)((Object)e));
                }
            }
            MultidimensionalTableInterface rTable = this.getRuntimeTableInterface();
            this.enableEventsOnModel(true);
            try {
                rTable.firePropertyChange("subsets", null, this.getTableDelegate().getSubsets());
            }
            catch (TableException tableException) {
                // empty catch block
            }
            this.setSkipExpand(rTable, false);
            if (this._dialog != null) {
                this._dialog.setVisible(false);
            }
            this.showWaitCursor(false);
        }
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        this._levels = null;
        this.enableEventsOnModel(true);
        this._subsetsList.removeAll();
        this._levelsChoice.removeAllItems();
        this._membersTable.setModel(null);
        this.setEnabled(false);
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || !this.isAllValuesSet() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = true;
        this.enableEventsOnModel(false);
        this.setup();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    class SubsetRecord {
        Subset _subset;
        String _value;
        String _displayString;
        int _levelIndex;

        public SubsetRecord(Subset subset, String value, int levelIndex) {
            this._subset = subset;
            this._value = value;
            this.createDisplayString();
            this._levelIndex = levelIndex;
        }

        protected void createDisplayString() {
            try {
                this._displayString = this._subset.getLevel().getLabel() + " = " + this._value;
            }
            catch (TableException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this._displayString;
        }
    }

    class Subset
    implements SubsetInterface {
        LevelInterface _level;
        Object[] _subset;

        public Subset(LevelInterface level) {
            this._level = level;
        }

        public LevelInterface getLevel() {
            return this._level;
        }

        @Override
        public String getName() {
            try {
                return this._level == null ? null : this._level.getName();
            }
            catch (TableException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void setSubset(Object[] subset) {
            this._subset = subset;
        }

        @Override
        public Object[] getDrillSubset() {
            return null;
        }

        public void setDrillSubset(Object[] subset) {
        }

        @Override
        public Object[] getSubset() {
            return this._subset;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName());
            sb.append(" --> ");
            for (int i = 0; this._subset != null && i < this._subset.length; ++i) {
                sb.append(this._subset[i]);
                sb.append(" ");
            }
            return sb.toString();
        }
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object node1, Object node2) {
            StringComparator sc = new StringComparator(true);
            if (node1 instanceof LevelTable && node2 instanceof LevelTable) {
                return sc.compare((Object)((LevelTable)node1).getLabel(), (Object)((LevelTable)node2).getLabel());
            }
            return Integer.MAX_VALUE;
        }
    }

    class SubsetComparator
    implements Comparator {
        SubsetComparator() {
        }

        public int compare(Object first, Object second) {
            return first.toString().compareTo(second.toString());
        }
    }
}

