/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ComponentException;
import com.sas.collection.Dictionary;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.mdtable.NodeInterface;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.RB;
import com.sas.swing.visuals.DualSelector;
import com.sas.table.TableException;
import com.sas.util.CharBuffer;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class QueryCustomizerPanel
extends BaseMDInterfaceCustomizerPanel
implements ItemListener {
    public static final String RB_KEY = "QueryCustomizerPanel.";
    protected JRadioButton _rows;
    protected JRadioButton _columns;
    protected JRadioButton _measures;
    protected JRadioButton _statistics;
    protected JComboBox _measuresCombo;
    protected JCheckBox _hideStatisticLabel;
    protected ButtonGroup _buttonGroup;
    protected DualSelector _values;
    protected DefaultListModel _availableItems;
    protected DefaultListModel _selectedItems;
    protected DefaultComboBoxModel _measuresComboModel;
    protected boolean _inUpdate;
    protected Updater _updater;
    protected Dictionary _allLevels;
    protected DimensionInterface[] _dimensions;
    protected MemberInterface[] _measureMembers;
    protected MemberInterface[] _statisticMembers;
    protected ArrayList _allAxisItems;
    protected ArrayList _oriRowAxis;
    protected ArrayList _oriColumnAxis;
    protected ArrayList _oriMeasures;
    protected ArrayList _oriStatistics;
    protected Dictionary _oriStatisticsDict;
    protected ArrayList _availAxis;
    protected ArrayList _availMeasures;
    protected ArrayList _availStatistics;
    protected Dictionary _availStatisticsDict;
    protected ArrayList _selRowsAxis;
    protected ArrayList _selColumnAxis;
    protected ArrayList _selMeasures;
    protected ArrayList _selStatistics;
    protected Dictionary _selStatisticsDict;
    private boolean _statsPerMeasure;
    private boolean _alreadyInitialized;
    protected String ALL_MEASURES = RB.getStringResource("QueryCustomizerPanel.", "AllMeasures.txt");
    private static final Icon MEASURE_ICON = new ImageIcon(Resources.getImage((String)RB.getStringResource("QueryCustomizerPanel.", "MeasureIcon.image")));
    private static final Icon STATISTIC_ICON = new ImageIcon(Resources.getImage((String)RB.getStringResource("QueryCustomizerPanel.", "StatisticIcon.image")));
    private static final Icon HIERARCHY_ICON = new ImageIcon(Resources.getImage((String)RB.getStringResource("QueryCustomizerPanel.", "HierarchyIcon.image")));
    private static final Icon LEVEL_ICON = new ImageIcon(Resources.getImage((String)RB.getStringResource("QueryCustomizerPanel.", "LevelIcon.image")));

    public QueryCustomizerPanel(String tabName) {
        super(tabName);
    }

    @Override
    protected void initializeValues() {
        super.initializeValues();
        this._statsPerMeasure = true;
    }

    @Override
    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.setInsets(10, 10, 10, 10);
        JPanel queryPanel = new JPanel();
        queryPanel.setDoubleBuffered(false);
        queryPanel.setOpaque(false);
        queryPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, true, true));
        this.add((Component)queryPanel, "Center");
        JPanel rbPanel = new JPanel();
        rbPanel.setDoubleBuffered(false);
        rbPanel.setOpaque(false);
        rbPanel.setLayout((LayoutManager)new AutoSizingGridLayout(4, 2, 0, 5, true, false, true));
        queryPanel.add((Component)rbPanel, "Center");
        this._rows = new JRadioButton(RB.getStringResource(RB_KEY, "Rows.txt"));
        this._columns = new JRadioButton(RB.getStringResource(RB_KEY, "Columns.txt"));
        this._measures = new JRadioButton(RB.getStringResource(RB_KEY, "Measures.txt"));
        this._statistics = new JRadioButton(RB.getStringResource(RB_KEY, "StatisticsFor.txt"));
        this._measuresCombo = new JComboBox();
        this._measuresCombo.setRenderer(new MyCellRenderer());
        this._measuresComboModel = new DefaultComboBoxModel();
        this._measuresComboModel.addElement(this.ALL_MEASURES);
        this._measuresCombo.setModel(this._measuresComboModel);
        this._measuresCombo.addItemListener(this);
        this._measuresCombo.setLightWeightPopupEnabled(false);
        this._buttonGroup = new ButtonGroup();
        this._buttonGroup.add(this._rows);
        this._buttonGroup.add(this._columns);
        this._buttonGroup.add(this._measures);
        this._buttonGroup.add(this._statistics);
        this._rows.setSelected(true);
        this._rows.addItemListener(this);
        this._columns.addItemListener(this);
        this._measures.addItemListener(this);
        this._statistics.addItemListener(this);
        rbPanel.add(this._rows);
        rbPanel.add(Box.createGlue());
        rbPanel.add(this._columns);
        rbPanel.add(Box.createGlue());
        rbPanel.add(this._measures);
        rbPanel.add(Box.createGlue());
        rbPanel.add(this._statistics);
        rbPanel.add(this._measuresCombo);
        this._values = new DualSelector();
        queryPanel.add(this._values);
        this._availableItems = new DefaultListModel();
        this._values.setModel(this._availableItems);
        this._selectedItems = new DefaultListModel();
        this._values.setList2Model(this._selectedItems);
        this._values.setDynamic(true);
        this._values.setList2ControlsVisible(true);
        this._values.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this._values.setCellRenderer(this._measuresCombo.getRenderer());
        this._hideStatisticLabel = new JCheckBox(RB.getStringResource(RB_KEY, "HideStatisticLabel.txt"));
        this.add((Component)this._hideStatisticLabel, "South");
        this._hideStatisticLabel.setEnabled(false);
        this.setEnabled(false);
    }

    @Override
    public void setObject(Object bean) {
        this.onClear();
        if (!(bean instanceof MultidimensionalTableInterface)) {
            throw new ComponentException(RB.getStringResource(RB_KEY, "WrongInterface.txt"));
        }
        super.setObject(bean);
        this._statsPerMeasure = bean instanceof MultidimensionalTableV3Interface;
        this._updater = this._statsPerMeasure ? new V3Updater() : new Updater();
        this._measuresCombo.setEnabled(this._statsPerMeasure);
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (newValue && this.connection == null && !this.isMetabaseAndDatabaseSet() && !this.isApplicationSet()) {
            return;
        }
        super.setEnabled(newValue);
        this._rows.setEnabled(newValue);
        this._columns.setEnabled(newValue);
        this._measures.setEnabled(newValue);
        this._statistics.setEnabled(newValue);
        this._measuresCombo.setEnabled(newValue && this._statsPerMeasure);
        this._values.setEnabled(newValue);
    }

    @Override
    public void preCustomizerClosing() {
        if (this.isVisible()) {
            this.onHidden();
        }
        this.onClear();
        super.preCustomizerClosing();
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        this._availableItems.clear();
        this._selectedItems.clear();
        this._allLevels = null;
        this._dimensions = null;
        this._measureMembers = null;
        this._statisticMembers = null;
        this._measuresComboModel.removeAllElements();
        if (this._allAxisItems != null) {
            this._allAxisItems.clear();
            this._allAxisItems = null;
        }
        if (this._availAxis != null) {
            this._availAxis.clear();
            this._availAxis = null;
        }
        if (this._availMeasures != null) {
            this._availMeasures.clear();
            this._availMeasures = null;
        }
        if (this._availStatistics != null) {
            this._availStatistics.clear();
            this._availStatistics = null;
        }
        if (this._availStatisticsDict != null) {
            this._availStatisticsDict.removeAll();
            this._availStatisticsDict = null;
        }
        if (this._selRowsAxis != null) {
            this._selRowsAxis.clear();
            this._selRowsAxis = null;
        }
        if (this._selColumnAxis != null) {
            this._selColumnAxis.clear();
            this._selColumnAxis = null;
        }
        if (this._selMeasures != null) {
            this._selMeasures.clear();
            this._selMeasures = null;
        }
        if (this._selStatistics != null) {
            this._selStatistics.clear();
            this._selStatistics = null;
        }
        if (this._selStatisticsDict != null) {
            this._selStatisticsDict.removeAll();
            this._selStatisticsDict = null;
        }
        this.setEnabled(false);
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = true;
        if (this._allAxisItems == null) {
            this._allAxisItems = new ArrayList();
        }
        if (this._availAxis == null) {
            this._availAxis = new ArrayList();
        }
        if (this._selRowsAxis == null) {
            this._selRowsAxis = new ArrayList();
        }
        if (this._selColumnAxis == null) {
            this._selColumnAxis = new ArrayList();
        }
        this._updater.updateAxisFromModel();
        if (this._availMeasures == null) {
            this._availMeasures = new ArrayList();
        }
        if (this._selMeasures == null) {
            this._selMeasures = new ArrayList();
        }
        this._updater.updateMeasuresFromModel();
        if (this._statsPerMeasure) {
            if (this._availStatisticsDict == null) {
                this._availStatisticsDict = new Dictionary();
            }
            if (this._selStatisticsDict == null) {
                this._selStatisticsDict = new Dictionary();
            }
            this._availStatistics = null;
            this._selStatistics = null;
        } else {
            if (this._availStatistics == null) {
                this._availStatistics = new ArrayList();
            }
            if (this._selStatistics == null) {
                this._selStatistics = new ArrayList();
            }
            this._availStatisticsDict = null;
            this._selStatisticsDict = null;
        }
        this._updater.updateStatisticsFromModel();
        this._updater.updateMeasuresComboFromModel();
        this.updateSelectors();
        if (this.getTableInterface() instanceof MultidimensionalTableV3Interface) {
            this._hideStatisticLabel.setEnabled(true);
            this._hideStatisticLabel.setSelected(this.isStatisticLabelHidden());
        } else {
            this._hideStatisticLabel.setEnabled(false);
            this._hideStatisticLabel.setSelected(false);
        }
        this.updateOriginalLists();
        if (!this.isEnabled() && this.isRuntimeTableReady()) {
            this.setEnabled(true);
        }
    }

    @Override
    public void onApply() {
        if (!this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._updater.updateModelFromRows();
        this._updater.updateModelFromColumns();
        this._updater.updateModelFromMeasures();
        this._updater.updateModelFromStatistics();
        if (this.isStatisticLabelHidden() != this._hideStatisticLabel.isSelected()) {
            this.setStatisticLabelHidden(this._hideStatisticLabel.isSelected());
        }
        this.updateOriginalLists();
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().refreshTable();
        }
    }

    private boolean isStatisticLabelHidden() {
        if (this.getTableInterface() instanceof MultidimensionalTableV3Interface && this.getRuntimeTableInterface() != null) {
            return ((MultidimensionalTableV3Interface)this.getRuntimeTableInterface()).isStatisticLabelHidden();
        }
        return false;
    }

    private void setStatisticLabelHidden(boolean newValue) {
        if (this.getTableInterface() instanceof MultidimensionalTableV3Interface) {
            ((MultidimensionalTableV3Interface)this.getTableInterface()).setStatisticLabelHidden(newValue);
            if (this.getTableDelegate().isDifferent()) {
                ((MultidimensionalTableV3Interface)this.getRuntimeTableInterface()).setStatisticLabelHidden(newValue);
            }
        }
    }

    private void updateOriginalLists() {
        Iterator iterator;
        if (this._oriRowAxis == null) {
            this._oriRowAxis = new ArrayList();
        }
        this._oriRowAxis.clear();
        if (this._selRowsAxis != null) {
            iterator = this._selRowsAxis.iterator();
            while (iterator.hasNext()) {
                this._oriRowAxis.add(iterator.next());
            }
        }
        if (this._oriColumnAxis == null) {
            this._oriColumnAxis = new ArrayList();
        }
        this._oriColumnAxis.clear();
        if (this._selColumnAxis != null) {
            iterator = this._selColumnAxis.iterator();
            while (iterator.hasNext()) {
                this._oriColumnAxis.add(iterator.next());
            }
        }
        if (this._oriMeasures == null) {
            this._oriMeasures = new ArrayList();
        }
        this._oriMeasures.clear();
        if (this._selMeasures != null) {
            iterator = this._selMeasures.iterator();
            while (iterator.hasNext()) {
                this._oriMeasures.add(iterator.next());
            }
        }
        if (this._statsPerMeasure) {
            if (this._oriStatisticsDict == null) {
                this._oriStatisticsDict = new Dictionary();
            }
            this._oriStatisticsDict.removeAll();
            if (this._selColumnAxis != null) {
                Enumeration enumer = this._selStatisticsDict.getKeys();
                while (enumer.hasMoreElements()) {
                    Object measure = enumer.nextElement();
                    ArrayList aList = (ArrayList)this._selStatisticsDict.get(measure);
                    ArrayList newList = new ArrayList();
                    Iterator iterator2 = aList.iterator();
                    while (iterator2.hasNext()) {
                        newList.add(iterator2.next());
                    }
                    this._oriStatisticsDict.set(measure, newList);
                }
            }
            this._oriStatistics = null;
        } else {
            if (this._oriStatistics == null) {
                this._oriStatistics = new ArrayList();
            }
            this._oriStatistics.clear();
            if (this._selStatistics != null) {
                iterator = this._selStatistics.iterator();
                while (iterator.hasNext()) {
                    this._oriStatistics.add(iterator.next());
                }
            }
            this._oriStatisticsDict = null;
        }
    }

    protected void updateSelectors() {
        if (this.isConnectionDesignTimeActive && this.isRuntimeTableReady()) {
            this._inUpdate = true;
            this._availableItems.removeAllElements();
            this._selectedItems.removeAllElements();
            if (this._rows.isSelected()) {
                this._updater.updateSelectorFromRows();
            } else if (this._columns.isSelected()) {
                this._updater.updateSelectorFromColumns();
            } else if (this._measures.isSelected()) {
                this._updater.updateSelectorFromMeasures();
            } else if (this._statistics.isSelected()) {
                this._updater.updateSelectorFromStatistics();
            }
            this._inUpdate = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            if (event.getSource() == this._measuresCombo) {
                if (this._statistics.isSelected()) {
                    this._availableItems.removeAllElements();
                    this._selectedItems.removeAllElements();
                    this._updater.updateSelectorFromStatistics();
                }
            } else {
                this.updateSelectors();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        Object text = null;
        if (source == this.getRuntimeTableInterface()) {
            if (Util.equal((Object)propertyName, (Object)"database") || Util.equal((Object)propertyName, (Object)"metabase") || Util.equal((Object)propertyName, (Object)"application")) {
                this.onClear();
                if (this.isVisible()) {
                    this.onVisible();
                }
            }
        } else if (source == this._values && !this._inUpdate && Util.equal((Object)propertyName, (Object)"list2Items")) {
            if (this._rows.isSelected()) {
                this._updater.updateRowsFromSelector();
            } else if (this._columns.isSelected()) {
                this._updater.updateColumnsFromSelector();
            } else if (this._measures.isSelected()) {
                this._updater.updateMeasuresFromSelector();
            } else if (this._statistics.isSelected()) {
                this._updater.updateStatisticsFromSelector();
            }
        }
        super.propertyChange(event);
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    @Override
    public void updateData() throws TableException {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        super.disposeRemoteObjects();
    }

    protected Dictionary getAllLevels() throws TableException {
        if (this._allLevels == null) {
            this._allLevels = this.getRuntimeTableInterface().getAllLevels();
        }
        return this._allLevels;
    }

    protected DimensionInterface[] getDimensions() throws TableException {
        if (this._dimensions == null) {
            this._dimensions = this.getRuntimeTableInterface().getDimensions(0, -1);
        }
        return this._dimensions;
    }

    protected MemberInterface[] getMeasureMembers() throws TableException {
        if (this._measureMembers == null) {
            this._measureMembers = this.getRuntimeTableInterface().getMeasureMembers();
        }
        return this._measureMembers;
    }

    protected MemberInterface[] getStatisticMembers() throws TableException {
        if (this._statisticMembers == null) {
            this._statisticMembers = this.getRuntimeTableInterface().getStatisticMembers();
        }
        return this._statisticMembers;
    }

    private static final boolean containsLevel(HierarchyInterface hInt, LevelInterface lInt) throws TableException {
        int cnt = hInt.getLevelCount();
        for (int i = 0; i < cnt; ++i) {
            LevelInterface level = hInt.getLevel(i);
            if (!Util.equal((Object)level, (Object)lInt)) continue;
            return true;
        }
        return false;
    }

    private static final MemberInterface getMember(String name, MemberInterface[] measures) {
        try {
            int cnt = measures.length;
            for (int i = 0; i < cnt; ++i) {
                if (!QueryCustomizerPanel.equal(name, measures[i])) continue;
                return measures[i];
            }
        }
        catch (TableException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static final boolean contains(NodeInterface nInt, ArrayList list) throws TableException {
        int cnt = list.size();
        for (int i = 0; i < cnt; ++i) {
            if (!QueryCustomizerPanel.equal(nInt.getName(), (NodeInterface)list.get(i))) continue;
            return true;
        }
        return false;
    }

    private static final void remove(NodeInterface nInt, ArrayList model) throws TableException {
        int removeIndex = -1;
        int cnt = model.size();
        for (int i = 0; i < cnt; ++i) {
            if (!QueryCustomizerPanel.equal(nInt.getName(), (NodeInterface)model.get(i))) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1) {
            model.remove(removeIndex);
        }
    }

    private static final Object getMember(String name, ArrayList members) {
        try {
            int cnt = members.size();
            for (int i = 0; i < cnt; ++i) {
                if (!QueryCustomizerPanel.equal(name, (NodeInterface)members.get(i))) continue;
                return members.get(i);
            }
        }
        catch (TableException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static final boolean equal(String name, NodeInterface node) throws TableException {
        return Util.equal((Object)name, (Object)node.getName()) || Util.equal((Object)name, (Object)node.getLabel());
    }

    private static final boolean isLevelOnAxis(Object member, ArrayList otherMembers) throws TableException {
        NodeInterface nInt = (NodeInterface)member;
        if (otherMembers != null && otherMembers.size() > 0) {
            int cnt = otherMembers.size();
            for (int i = 0; i < cnt; ++i) {
                NodeInterface axisMember = (NodeInterface)otherMembers.get(i);
                if (axisMember instanceof HierarchyInterface) {
                    HierarchyInterface hInt = (HierarchyInterface)axisMember;
                    int cnt2 = hInt.getLevelCount();
                    for (int j = 0; j < cnt2; ++j) {
                        if (!Util.equal((Object)nInt.getName(), (Object)hInt.getLevel(j).getName())) continue;
                        return true;
                    }
                    continue;
                }
                if (!Util.equal((Object)nInt.getName(), (Object)axisMember.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isOnAxis(String name, String[] otherNames) {
        if (otherNames != null && otherNames.length > 0) {
            int cnt = otherNames.length;
            for (int i = 0; i < cnt; ++i) {
                if (!Util.equal((Object)name, (Object)otherNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isOnAxis(Object member, ArrayList otherMembers) {
        if (otherMembers != null && otherMembers.size() > 0) {
            int cnt = otherMembers.size();
            for (int i = 0; i < cnt; ++i) {
                if (!Util.equal((Object)member, otherMembers.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isLevelsOnAxis(HierarchyInterface hInt, String[] otherNames) throws TableException {
        int cnt = hInt.getLevelCount();
        for (int i = 0; i < cnt; ++i) {
            LevelInterface lInt = hInt.getLevel(i);
            if (!QueryCustomizerPanel.isOnAxis(lInt.getName(), otherNames)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isLevelsOnAxis(HierarchyInterface hInt, ArrayList otherMembers) throws TableException {
        int cnt = hInt.getLevelCount();
        for (int i = 0; i < cnt; ++i) {
            LevelInterface lInt = hInt.getLevel(i);
            if (!QueryCustomizerPanel.isLevelOnAxis(lInt, otherMembers)) continue;
            return true;
        }
        return false;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            block18: {
                if (value != null) {
                    if (value instanceof NodeInterface) {
                        try {
                            this.setText(((NodeInterface)value).getLabel());
                            if (value instanceof HierarchyInterface) {
                                HierarchyInterface hInt = (HierarchyInterface)value;
                                if (hInt.getLevelCount() > 0) {
                                    CharBuffer cbuf = new CharBuffer();
                                    cbuf.append(hInt.getLabel());
                                    cbuf.append(" (");
                                    int cnt = hInt.getLevelCount();
                                    for (int i = 0; i < cnt; ++i) {
                                        cbuf.append(QueryCustomizerPanel.this._updater.getLabel(hInt.getLevel(i)));
                                        if (i == cnt - 1) continue;
                                        cbuf.append(", ");
                                    }
                                    cbuf.append(')');
                                    this.setText(cbuf.toString());
                                }
                                this.setIcon(HIERARCHY_ICON);
                                break block18;
                            }
                            if (value instanceof LevelInterface) {
                                this.setText(QueryCustomizerPanel.this._updater.getLabel((LevelInterface)value));
                                this.setIcon(LEVEL_ICON);
                                break block18;
                            }
                            if (value instanceof MemberInterface) {
                                MemberInterface mi = (MemberInterface)value;
                                LevelInterface li = mi.getLevel();
                                if (li instanceof Level) {
                                    Level l = (Level)li;
                                    if (l.isStatisticLevel()) {
                                        this.setIcon(STATISTIC_ICON);
                                    } else if (l.isAnalysisLevel()) {
                                        this.setIcon(MEASURE_ICON);
                                    } else {
                                        this.setIcon(null);
                                    }
                                }
                                break block18;
                            }
                            this.setIcon(null);
                        }
                        catch (TableException tableException) {}
                    } else {
                        this.setText(value.toString());
                        this.setIcon(null);
                    }
                } else {
                    this.setText(null);
                    this.setIcon(null);
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class V3Updater
    extends Updater {
        V3Updater() {
        }

        @Override
        public void updateStatisticsFromModel() {
            if (!QueryCustomizerPanel.this._statsPerMeasure) {
                super.updateStatisticsFromModel();
                return;
            }
            try {
                MultidimensionalTableV2Interface v2Table = (MultidimensionalTableV2Interface)QueryCustomizerPanel.this.getRuntimeTableInterface();
                MemberInterface[] measures = QueryCustomizerPanel.this.getMeasureMembers();
                if (measures != null && measures.length > 0) {
                    int cnt = measures.length;
                    for (int i = 0; i < cnt; ++i) {
                        ArrayList statsList = this.getArrayList(((MultidimensionalTableV2Interface)QueryCustomizerPanel.this.getRuntimeTableInterface()).getStatistics(measures[i].getName()));
                        QueryCustomizerPanel.this._availStatisticsDict.set((Object)measures[i], (Object)statsList);
                        QueryCustomizerPanel.this._selStatisticsDict.set((Object)measures[i], new ArrayList());
                    }
                }
                Enumeration iterator = QueryCustomizerPanel.this._availStatisticsDict.getKeys();
                while (iterator.hasMoreElements()) {
                    Object next = iterator.nextElement();
                    if (next instanceof String) continue;
                    MemberInterface measure = (MemberInterface)next;
                    Object[] stats = ((MultidimensionalTableV2Interface)QueryCustomizerPanel.this.getTableInterface()).getSelectedStatistics(measure.getName());
                    if (stats != null && stats.length > 0) {
                        MemberInterface[] realStats = new MemberInterface[stats.length];
                        int cnt = stats.length;
                        for (int i = 0; i < cnt; ++i) {
                            realStats[i] = this.getStatistic((MemberInterface)stats[i]);
                        }
                        stats = realStats;
                    }
                    ArrayList selStatsList = this.getArrayList(stats);
                    QueryCustomizerPanel.this._selStatisticsDict.set((Object)measure, (Object)selStatsList);
                    ArrayList availableStats = (ArrayList)QueryCustomizerPanel.this._availStatisticsDict.get((Object)measure);
                    this.removeItems(selStatsList, availableStats);
                }
                this.updateCommonStatisticsFromSelector();
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        @Override
        public void updateModelFromStatistics() {
            if (!QueryCustomizerPanel.this._statsPerMeasure) {
                super.updateModelFromStatistics();
                return;
            }
            if (QueryCustomizerPanel.this._selMeasures != null) {
                try {
                    if (QueryCustomizerPanel.this._selMeasures.isEmpty()) {
                        if (this.isDifferent(QueryCustomizerPanel.this.ALL_MEASURES, (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)QueryCustomizerPanel.this.ALL_MEASURES), QueryCustomizerPanel.this._oriStatisticsDict)) {
                            QueryCustomizerPanel.this.getTableDelegate().setSelectedStatistics(this.getSelectedItems((ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)QueryCustomizerPanel.this.ALL_MEASURES)));
                        }
                    } else {
                        Enumeration iterator = QueryCustomizerPanel.this._selStatisticsDict.getKeys();
                        while (iterator.hasMoreElements()) {
                            Object next = iterator.nextElement();
                            ArrayList nextArray = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get(next);
                            if (!(next instanceof MemberInterface) || !this.isDifferent(next, nextArray, QueryCustomizerPanel.this._oriStatisticsDict)) continue;
                            MemberInterface measure = (MemberInterface)next;
                            MemberInterface[] stats = this.getSelectedStatistics(measure);
                            QueryCustomizerPanel.this.getTableDelegate().setSelectedStatistics(measure.getName(), stats);
                        }
                    }
                }
                catch (TableException ex) {
                    QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void updateStatisticsFromSelector() {
            Object selItem = QueryCustomizerPanel.this._measuresCombo.getSelectedItem();
            ArrayList[] changes = this.getChangesInStatistics(selItem);
            if (selItem == QueryCustomizerPanel.this.ALL_MEASURES) {
                try {
                    MemberInterface[] measures = QueryCustomizerPanel.this.getMeasureMembers();
                    if (measures == null || measures.length <= 0) return;
                    int cnt = measures.length;
                    for (int i = 0; i < cnt; ++i) {
                        this.updateStatisticsForMeasure(measures[i], changes[0], changes[1]);
                    }
                    return;
                }
                catch (TableException ex) {
                    QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
                    return;
                }
            } else {
                this.updateCommonStatisticsFromSelector();
            }
        }

        @Override
        public void updateSelectorFromStatistics() {
            QueryCustomizerPanel.this._availableItems.clear();
            QueryCustomizerPanel.this._selectedItems.clear();
            Object selItem = QueryCustomizerPanel.this._measuresCombo.getSelectedItem();
            ArrayList availStats = (ArrayList)QueryCustomizerPanel.this._availStatisticsDict.get(selItem);
            Iterator iterator = availStats.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._availableItems.addElement(iterator.next());
            }
            ArrayList selStats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get(selItem);
            iterator = selStats.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._selectedItems.addElement(iterator.next());
            }
        }

        private MemberInterface[] getSelectedStatistics(MemberInterface measure) {
            MemberInterface[] selItems = null;
            ArrayList stats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)measure);
            if (stats.size() > 0) {
                selItems = new MemberInterface[stats.size()];
                int cnt = selItems.length;
                for (int i = 0; i < cnt; ++i) {
                    selItems[i] = (MemberInterface)stats.get(i);
                }
            }
            return selItems;
        }

        private MemberInterface getStatistic(MemberInterface stat) throws TableException {
            MemberInterface[] statistics = QueryCustomizerPanel.this.getStatisticMembers();
            if (statistics == null || statistics.length == 0) {
                return null;
            }
            int cnt = statistics.length;
            for (int i = 0; i < cnt; ++i) {
                if (!Util.equal((Object)stat.getName(), (Object)statistics[i].getName())) continue;
                return statistics[i];
            }
            return null;
        }

        private void updateStatisticsForMeasure(MemberInterface measure, ArrayList selected, ArrayList deselected) {
            ArrayList curAvailStats = (ArrayList)QueryCustomizerPanel.this._availStatisticsDict.get((Object)measure);
            ArrayList curSelStats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)measure);
            for (Object next : selected) {
                curAvailStats.remove(next);
                if (curSelStats.contains(next)) continue;
                curSelStats.add(next);
            }
            for (Object next : deselected) {
                if (!curAvailStats.contains(next)) {
                    curAvailStats.add(next);
                }
                curSelStats.remove(next);
            }
        }

        private ArrayList[] getChangesInStatistics(Object measure) {
            Object next;
            ArrayList selected = new ArrayList();
            ArrayList deselected = new ArrayList();
            ArrayList availStats = (ArrayList)QueryCustomizerPanel.this._availStatisticsDict.get(measure);
            ArrayList selStats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get(measure);
            Iterator iterator = availStats.iterator();
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!QueryCustomizerPanel.this._selectedItems.contains(next)) continue;
                iterator.remove();
                selected.add(next);
                selStats.add(next);
            }
            iterator = selStats.iterator();
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!QueryCustomizerPanel.this._availableItems.contains(next)) continue;
                iterator.remove();
                deselected.add(next);
                availStats.add(next);
            }
            return new ArrayList[]{selected, deselected};
        }

        private void updateCommonStatisticsFromSelector() {
            ArrayList[] alStats = this.getCommonStatistics();
            if (alStats != null && alStats.length > 0) {
                QueryCustomizerPanel.this._availStatisticsDict.set((Object)QueryCustomizerPanel.this.ALL_MEASURES, (Object)alStats[0]);
                QueryCustomizerPanel.this._selStatisticsDict.set((Object)QueryCustomizerPanel.this.ALL_MEASURES, (Object)alStats[1]);
            }
        }

        private ArrayList getArrayList(Object[] array) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (array != null && array.length > 0) {
                int cnt = array.length;
                for (int i = 0; i < cnt; ++i) {
                    arrayList.add(array[i]);
                }
            }
            return arrayList;
        }

        private void removeItems(ArrayList keepIn, ArrayList removeFrom) throws TableException {
            block0: for (MemberInterface selStat : keepIn) {
                Iterator iterator2 = removeFrom.iterator();
                while (iterator2.hasNext()) {
                    MemberInterface availStat = (MemberInterface)iterator2.next();
                    if (!Util.equal((Object)selStat.getName(), (Object)availStat.getName())) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private ArrayList[] getCommonStatistics() {
            try {
                MemberInterface[] members = QueryCustomizerPanel.this.getMeasureMembers();
                if (members != null && members.length > 0) {
                    int i;
                    ArrayList list = new ArrayList();
                    ArrayList selList = new ArrayList();
                    int cnt = members.length;
                    for (i = 0; i < cnt; ++i) {
                        list.add(members[i]);
                        selList.add(members[i]);
                    }
                    list = this.getStatisticIntersection(list);
                    if (!(selList = this.getSelectedStatisticIntersection(selList)).isEmpty()) {
                        cnt = selList.size();
                        for (i = 0; i < cnt; ++i) {
                            Object stat = selList.get(i);
                            if (!list.contains(stat)) continue;
                            list.remove(stat);
                        }
                    }
                    return new ArrayList[]{list, selList};
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            return null;
        }

        public ArrayList getStatisticIntersection(ArrayList list) throws TableException {
            ArrayList aRet = new ArrayList();
            if (!list.isEmpty()) {
                int i;
                int cnt;
                MemberInterface measure = (MemberInterface)list.get(0);
                MemberInterface[] selStats = ((MultidimensionalTableV3Interface)QueryCustomizerPanel.this.getRuntimeTableInterface()).getStatistics(measure.getName());
                if (selStats != null && selStats.length > 0) {
                    cnt = selStats.length;
                    for (i = 0; i < cnt; ++i) {
                        aRet.add(selStats[i]);
                    }
                }
                if (list.size() > 1) {
                    cnt = list.size();
                    for (i = 1; i < cnt; ++i) {
                        measure = (MemberInterface)list.get(i);
                        selStats = ((MultidimensionalTableV3Interface)QueryCustomizerPanel.this.getRuntimeTableInterface()).getStatistics(measure.getName());
                        aRet = this.getIntersection(measure, selStats, aRet);
                    }
                }
            }
            return aRet;
        }

        public ArrayList getSelectedStatisticIntersection(ArrayList list) throws TableException {
            ArrayList aRet = new ArrayList();
            if (!list.isEmpty()) {
                MemberInterface measure = (MemberInterface)list.get(0);
                if (QueryCustomizerPanel.this._selStatisticsDict.containsKey((Object)measure)) {
                    ArrayList selStats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)measure);
                    Iterator iterator = selStats.iterator();
                    while (iterator.hasNext()) {
                        aRet.add(iterator.next());
                    }
                }
                if (list.size() > 1) {
                    int cnt = list.size();
                    for (int i = 1; i < cnt; ++i) {
                        measure = (MemberInterface)list.get(i);
                        if (!QueryCustomizerPanel.this._selStatisticsDict.containsKey((Object)measure)) continue;
                        ArrayList selStats = (ArrayList)QueryCustomizerPanel.this._selStatisticsDict.get((Object)measure);
                        aRet = this.getIntersection(measure, selStats, aRet);
                    }
                }
            }
            return aRet;
        }

        public ArrayList getIntersection(MemberInterface measure, MemberInterface[] selStats, ArrayList list) throws TableException {
            if (selStats == null || selStats.length == 0) {
                return new ArrayList();
            }
            ArrayList<MemberInterface> aRet = new ArrayList<MemberInterface>();
            int cnt = selStats.length;
            for (int i = 0; i < cnt; ++i) {
                if (!list.contains(selStats[i])) continue;
                aRet.add(selStats[i]);
            }
            return aRet;
        }

        public ArrayList getIntersection(MemberInterface measure, ArrayList selStats, ArrayList list) throws TableException {
            if (selStats == null || selStats.isEmpty()) {
                return new ArrayList();
            }
            ArrayList aRet = new ArrayList();
            int cnt = selStats.size();
            for (int i = 0; i < cnt; ++i) {
                if (!list.contains(selStats.get(i))) continue;
                aRet.add(selStats.get(i));
            }
            return aRet;
        }

        protected boolean isDifferent(Object member, ArrayList selStats, Dictionary dict) throws TableException {
            return this.isDifferent(selStats, (ArrayList)dict.get(member));
        }
    }

    class Updater {
        Updater() {
        }

        public void updateAxisFromModel() {
            QueryCustomizerPanel.this._availAxis.clear();
            QueryCustomizerPanel.this._selRowsAxis.clear();
            QueryCustomizerPanel.this._selColumnAxis.clear();
            QueryCustomizerPanel.this._allAxisItems.clear();
            try {
                int i;
                int cnt;
                String[] rows = QueryCustomizerPanel.this.getTableInterface().getRowAxis();
                String[] cols = QueryCustomizerPanel.this.getTableInterface().getColumnAxis();
                ArrayList<NodeInterface> rowsList = new ArrayList<NodeInterface>();
                ArrayList<NodeInterface> colsList = new ArrayList<NodeInterface>();
                DimensionInterface[] dims = QueryCustomizerPanel.this.getDimensions();
                ArrayList<LevelInterface> levels = new ArrayList<LevelInterface>();
                int cnt2 = dims.length;
                for (int i2 = 0; i2 < cnt2; ++i2) {
                    if (dims[i2] instanceof Dimension && ((Dimension)dims[i2]).isMeasure()) continue;
                    int cnt22 = dims[i2].getHierarchyCount();
                    for (int j = 0; j < cnt22; ++j) {
                        HierarchyInterface hInt = dims[i2].getHierarchy(j);
                        if (dims[i2] instanceof Dimension && ((Dimension)dims[i2]).getType() == 2) {
                            int cnt3 = hInt.getLevelCount();
                            for (int k = 0; k < cnt3; ++k) {
                                LevelInterface lInt = hInt.getLevel(k);
                                if (!QueryCustomizerPanel.contains(lInt, levels)) {
                                    levels.add(lInt);
                                }
                                if (QueryCustomizerPanel.isOnAxis(lInt.getName(), rows)) {
                                    rowsList.add(lInt);
                                    continue;
                                }
                                if (!QueryCustomizerPanel.isOnAxis(lInt.getName(), cols)) continue;
                                colsList.add(lInt);
                            }
                            continue;
                        }
                        QueryCustomizerPanel.this._allAxisItems.add(dims[i2].getHierarchy(j));
                    }
                }
                for (HierarchyInterface hInt : QueryCustomizerPanel.this._allAxisItems) {
                    if (QueryCustomizerPanel.isOnAxis(hInt.getName(), rows)) {
                        rowsList.add(hInt);
                    } else if (QueryCustomizerPanel.isOnAxis(hInt.getName(), cols)) {
                        colsList.add(hInt);
                    } else if (!QueryCustomizerPanel.isLevelsOnAxis(hInt, rows) && !QueryCustomizerPanel.isLevelsOnAxis(hInt, cols)) {
                        QueryCustomizerPanel.this._availAxis.add(hInt);
                    }
                    int cnt3 = hInt.getLevelCount();
                    for (int i3 = 0; i3 < cnt3; ++i3) {
                        LevelInterface lInt = hInt.getLevel(i3);
                        if (!QueryCustomizerPanel.contains(lInt, levels)) {
                            levels.add(lInt);
                        }
                        if (QueryCustomizerPanel.isOnAxis(lInt.getName(), rows)) {
                            rowsList.add(lInt);
                            continue;
                        }
                        if (!QueryCustomizerPanel.isOnAxis(lInt.getName(), cols)) continue;
                        colsList.add(lInt);
                    }
                }
                Iterator iterator = levels.iterator();
                while (iterator.hasNext()) {
                    QueryCustomizerPanel.this._allAxisItems.add(iterator.next());
                }
                if (!rowsList.isEmpty() && rows != null && rows.length > 0) {
                    cnt = rows.length;
                    for (i = 0; i < cnt; ++i) {
                        Object member = QueryCustomizerPanel.getMember(rows[i], rowsList);
                        if (member == null) continue;
                        QueryCustomizerPanel.this._selRowsAxis.add(member);
                    }
                }
                if (!colsList.isEmpty() && cols != null && cols.length > 0) {
                    cnt = cols.length;
                    for (i = 0; i < cnt; ++i) {
                        Object member = QueryCustomizerPanel.getMember(cols[i], colsList);
                        if (member == null) continue;
                        QueryCustomizerPanel.this._selColumnAxis.add(member);
                    }
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateModelFromRows() {
            try {
                if (this.isDifferent(QueryCustomizerPanel.this._oriRowAxis, QueryCustomizerPanel.this._selRowsAxis)) {
                    QueryCustomizerPanel.this.getTableDelegate().setRowAxis(this.getSelectedItems(QueryCustomizerPanel.this._selRowsAxis));
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateRowsFromSelector() {
            this.updateAxisItemsFromSelector(QueryCustomizerPanel.this._selRowsAxis);
        }

        public void updateSelectorFromRows() {
            QueryCustomizerPanel.this._selectedItems.clear();
            Iterator iterator = QueryCustomizerPanel.this._selRowsAxis.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._selectedItems.addElement(iterator.next());
            }
            this.updateAvailableItemsAxisFromSelector();
        }

        public void updateModelFromColumns() {
            try {
                if (this.isDifferent(QueryCustomizerPanel.this._oriColumnAxis, QueryCustomizerPanel.this._selColumnAxis)) {
                    QueryCustomizerPanel.this.getTableDelegate().setColumnAxis(this.getSelectedItems(QueryCustomizerPanel.this._selColumnAxis));
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateColumnsFromSelector() {
            this.updateAxisItemsFromSelector(QueryCustomizerPanel.this._selColumnAxis);
        }

        public void updateSelectorFromColumns() {
            QueryCustomizerPanel.this._selectedItems.clear();
            Iterator iterator = QueryCustomizerPanel.this._selColumnAxis.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._selectedItems.addElement(iterator.next());
            }
            this.updateAvailableItemsAxisFromSelector();
        }

        public void updateMeasuresFromModel() {
            try {
                this.updateItemsFromModel(QueryCustomizerPanel.this._availMeasures, QueryCustomizerPanel.this._selMeasures, QueryCustomizerPanel.this.getMeasureMembers(), QueryCustomizerPanel.this.getTableInterface().getSelectedMeasures());
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateModelFromMeasures() {
            try {
                if (this.isDifferent(QueryCustomizerPanel.this._oriMeasures, QueryCustomizerPanel.this._selMeasures)) {
                    QueryCustomizerPanel.this.getTableDelegate().setSelectedMeasures(this.getSelectedItems(QueryCustomizerPanel.this._selMeasures));
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateMeasuresFromSelector() {
            this.updateItemsFromSelector(QueryCustomizerPanel.this._availMeasures, QueryCustomizerPanel.this._selMeasures);
        }

        public void updateSelectorFromMeasures() {
            this.updateSelectorFromItems(QueryCustomizerPanel.this._availMeasures, QueryCustomizerPanel.this._selMeasures);
        }

        public void updateStatisticsFromModel() {
            try {
                this.updateItemsFromModel(QueryCustomizerPanel.this._availStatistics, QueryCustomizerPanel.this._selStatistics, QueryCustomizerPanel.this.getStatisticMembers(), QueryCustomizerPanel.this.getTableInterface().getSelectedStatistics());
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateModelFromStatistics() {
            try {
                if (this.isDifferent(QueryCustomizerPanel.this._oriStatistics, QueryCustomizerPanel.this._selStatistics)) {
                    QueryCustomizerPanel.this.getTableDelegate().setSelectedStatistics(this.getSelectedItems(QueryCustomizerPanel.this._selStatistics));
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        public void updateStatisticsFromSelector() {
            this.updateItemsFromSelector(QueryCustomizerPanel.this._availStatistics, QueryCustomizerPanel.this._selStatistics);
        }

        public void updateSelectorFromStatistics() {
            this.updateSelectorFromItems(QueryCustomizerPanel.this._availStatistics, QueryCustomizerPanel.this._selStatistics);
        }

        private void updateAxisItemsFromSelector(ArrayList axisList) {
            ArrayList aList = new ArrayList();
            Enumeration iterator = QueryCustomizerPanel.this._selectedItems.elements();
            while (iterator.hasMoreElements()) {
                aList.add(iterator.nextElement());
            }
            try {
                for (Object obj : aList) {
                    if (!(obj instanceof HierarchyInterface)) continue;
                    HierarchyInterface hInt = (HierarchyInterface)obj;
                    int cnt = hInt.getLevelCount();
                    for (int i = 0; i < cnt; ++i) {
                        QueryCustomizerPanel.this._selectedItems.removeElement(hInt.getLevel(i));
                    }
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this._selectedItems.removeAllElements();
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            axisList.clear();
            iterator = QueryCustomizerPanel.this._selectedItems.elements();
            while (iterator.hasMoreElements()) {
                axisList.add(iterator.nextElement());
            }
            this.updateAvailableItemsAxisFromSelector();
        }

        private void updateAvailableItemsAxisFromSelector() {
            QueryCustomizerPanel.this._inUpdate = true;
            QueryCustomizerPanel.this._availableItems.clear();
            QueryCustomizerPanel.this._availAxis.clear();
            ArrayList selLevels = new ArrayList();
            try {
                for (Object next : QueryCustomizerPanel.this._allAxisItems) {
                    if (next instanceof HierarchyInterface) {
                        HierarchyInterface hInt = (HierarchyInterface)next;
                        if (QueryCustomizerPanel.isOnAxis(hInt, QueryCustomizerPanel.this._selRowsAxis) || QueryCustomizerPanel.isOnAxis(hInt, QueryCustomizerPanel.this._selColumnAxis) || QueryCustomizerPanel.isLevelsOnAxis(hInt, QueryCustomizerPanel.this._selRowsAxis) || QueryCustomizerPanel.isLevelsOnAxis(hInt, QueryCustomizerPanel.this._selColumnAxis)) continue;
                        QueryCustomizerPanel.this._availAxis.add(hInt);
                        continue;
                    }
                    LevelInterface lInt = (LevelInterface)next;
                    if (QueryCustomizerPanel.isLevelOnAxis(lInt, QueryCustomizerPanel.this._selRowsAxis) || QueryCustomizerPanel.isLevelOnAxis(lInt, QueryCustomizerPanel.this._selColumnAxis)) continue;
                    QueryCustomizerPanel.this._availAxis.add(lInt);
                }
                Iterator iterator2 = QueryCustomizerPanel.this._availAxis.iterator();
                while (iterator2.hasNext()) {
                    QueryCustomizerPanel.this._availableItems.addElement((NodeInterface)iterator2.next());
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            QueryCustomizerPanel.this._inUpdate = false;
        }

        protected String getLabel(LevelInterface lInt) throws TableException {
            NodeInterface lTemp = null;
            Dictionary labelDict = QueryCustomizerPanel.this.getAllLevels();
            if (labelDict != null) {
                lTemp = (LevelInterface)labelDict.get((Object)lInt.getName());
            }
            if (lTemp != null && lTemp.getLabel() != null) {
                return lTemp.getLabel();
            }
            return lInt.getLabel();
        }

        protected void updateItemsFromModel(ArrayList available, ArrayList selected, MemberInterface[] items, String[] selItems) {
            block5: {
                available.clear();
                selected.clear();
                if (items == null || items.length <= 0) break block5;
                if (selItems == null || selItems.length == 0) {
                    int cnt = items.length;
                    for (int i = 0; i < cnt; ++i) {
                        if (this.isComputedValue(items[i])) continue;
                        available.add(items[i]);
                    }
                } else {
                    int i;
                    int cnt = selItems.length;
                    for (i = 0; i < cnt; ++i) {
                        selected.add(QueryCustomizerPanel.getMember(selItems[i], items));
                    }
                    cnt = items.length;
                    for (i = 0; i < cnt; ++i) {
                        if (items[i] == null || selected.contains(items[i]) || this.isComputedValue(items[i])) continue;
                        available.add(items[i]);
                    }
                }
            }
        }

        protected void updateItemsFromSelector(ArrayList available, ArrayList selected) {
            available.clear();
            selected.clear();
            Enumeration iterator = QueryCustomizerPanel.this._availableItems.elements();
            while (iterator.hasMoreElements()) {
                available.add(iterator.nextElement());
            }
            iterator = QueryCustomizerPanel.this._selectedItems.elements();
            while (iterator.hasMoreElements()) {
                selected.add(iterator.nextElement());
            }
        }

        public void updateSelectorFromItems(ArrayList available, ArrayList selected) {
            QueryCustomizerPanel.this._availableItems.clear();
            QueryCustomizerPanel.this._selectedItems.clear();
            Iterator iterator = available.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._availableItems.addElement(iterator.next());
            }
            iterator = selected.iterator();
            while (iterator.hasNext()) {
                QueryCustomizerPanel.this._selectedItems.addElement(iterator.next());
            }
        }

        private boolean isComputedValue(NodeInterface node) {
            if (node == null) {
                return false;
            }
            String name = null;
            try {
                name = node.getName();
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            if (name != null) {
                return name.toUpperCase().startsWith("CVALUE");
            }
            return false;
        }

        protected String[] getSelectedItems(ArrayList list) {
            String[] selItems = null;
            try {
                if (list.size() > 0) {
                    selItems = new String[list.size()];
                    int cnt = selItems.length;
                    for (int i = 0; i < cnt; ++i) {
                        selItems[i] = ((NodeInterface)list.get(i)).getName();
                    }
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            return selItems;
        }

        public void updateMeasuresComboFromModel() {
            if (QueryCustomizerPanel.this.getRuntimeTableInterface() == null || !QueryCustomizerPanel.this._statsPerMeasure) {
                return;
            }
            QueryCustomizerPanel.this._measuresComboModel.removeAllElements();
            QueryCustomizerPanel.this._measuresComboModel.addElement(QueryCustomizerPanel.this.ALL_MEASURES);
            try {
                MemberInterface[] measures = QueryCustomizerPanel.this.getMeasureMembers();
                if (measures != null && measures.length > 0) {
                    int cnt = measures.length;
                    for (int i = 0; i < cnt; ++i) {
                        if (this.isComputedValue(measures[i])) continue;
                        QueryCustomizerPanel.this._measuresComboModel.addElement(measures[i]);
                    }
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
        }

        protected String[] getSelectedItems() {
            String[] selItems = null;
            try {
                if (QueryCustomizerPanel.this._selectedItems.size() > 0) {
                    selItems = new String[QueryCustomizerPanel.this._selectedItems.size()];
                    int cnt = selItems.length;
                    for (int i = 0; i < cnt; ++i) {
                        selItems[i] = ((NodeInterface)QueryCustomizerPanel.this._selectedItems.getElementAt(i)).getName();
                    }
                }
            }
            catch (TableException ex) {
                QueryCustomizerPanel.this.showExceptionWarning((Exception)((Object)ex));
            }
            return selItems;
        }

        protected boolean isDifferent(ArrayList list1, ArrayList list2) throws TableException {
            if (list1 == null && list2 != null) {
                return true;
            }
            if (list1 != null && list2 == null) {
                return true;
            }
            if (list1 == null && list2 == null) {
                return false;
            }
            if (list1.size() != list2.size()) {
                return true;
            }
            int cnt = list1.size();
            for (int i = 0; i < cnt; ++i) {
                NodeInterface node1 = (NodeInterface)list1.get(i);
                NodeInterface node2 = (NodeInterface)list2.get(i);
                if (!Util.unequal((Object)node1.getName(), (Object)node2.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

