/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ModelInterface;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.mdtable.NodeInterface;
import com.sas.models.CacheBase;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.SparseCache;
import com.sas.models.StaticCacheInterface;
import com.sas.models.TreeInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.text.Message;
import java.io.Serializable;

public class ParentNode
implements NodeInterface,
ExtendedNodeInterface,
TreeInterface,
ModelInterface,
Serializable {
    static final long serialVersionUID = -2693643757948078581L;
    protected static final String RB_KEY = "ParentNode.";
    protected transient MultidimensionalTableInterface Imddb;
    protected transient int ordinal;
    protected transient ExtendedNodeInterface parent;
    protected transient ExtendedNodeInterface delegate;
    protected PropertyBagInterface properties;
    protected String name;
    protected String label;
    protected transient StaticCacheInterface _childrenCache;
    protected transient StaticCacheInterface _secondaryCache;
    protected transient int numChildren;
    protected transient int BUFFER_SIZE;
    protected transient int READ_AHEAD;
    protected boolean isV2Interface;
    protected long _commandsMask;

    public ParentNode(MultidimensionalTableInterface Imddb) {
        this.Imddb = Imddb;
        this.init();
        this.isV2Interface = Imddb != null ? Imddb instanceof MultidimensionalTableV2Interface : false;
    }

    public ParentNode(String name) {
        this.Imddb = null;
        this.setName(name);
        this.init();
        this.isV2Interface = this.Imddb != null ? this.Imddb instanceof MultidimensionalTableV2Interface : false;
    }

    private void init() {
        this.ordinal = -1;
        this.parent = null;
        this.delegate = null;
        this.numChildren = -1;
        this.properties = null;
        this._secondaryCache = null;
        this._childrenCache = null;
        this.BUFFER_SIZE = 0;
        this.READ_AHEAD = 0;
    }

    protected StaticCacheInterface createCache() {
        return null;
    }

    public void clearCache() throws CacheException {
        this.numChildren = -1;
        if (this._secondaryCache != null && this._secondaryCache instanceof AbstractChildrenReader) {
            ((AbstractChildrenReader)this._secondaryCache).count = -1;
        }
        if (this._childrenCache != null) {
            ((CacheBase)this._childrenCache).invalidateCache();
        }
    }

    protected void initCache() {
        if (this._childrenCache == null) {
            this._secondaryCache = this.createCache();
            int count = this._secondaryCache.count();
            if (count > 0) {
                this.BUFFER_SIZE = Math.min(count, 15000);
                this.READ_AHEAD = 100;
                this._childrenCache = this._secondaryCache.getCacheKeyUse() == 0 ? new SequentialCache(this._secondaryCache, this.BUFFER_SIZE, this.READ_AHEAD) : new SparseCache(this._secondaryCache, null, this.BUFFER_SIZE, this.READ_AHEAD);
            } else {
                this._secondaryCache = null;
            }
        } else if (this._childrenCache.count() == 0) {
            if (this._secondaryCache != null) {
                this.numChildren = this._secondaryCache.count();
            }
            try {
                if (this.numChildren > ((CacheBase)this._childrenCache).getCacheCapacity()) {
                    this._childrenCache.configureCache(Math.min(this.numChildren, 15000), -1, -1, -1, -1);
                }
            }
            catch (CacheException ce) {
                this._childrenCache = null;
            }
        }
    }

    @Override
    public int getOrdinal() {
        StaticOrderedCollectionInterface kids;
        if (this.ordinal == -1 && this.delegate != null) {
            this.ordinal = this.delegate.getOrdinal();
        }
        if (this.ordinal == -1 && (kids = ((ParentNode)this.getParent()).getNodeChildren()).contains((Object)this)) {
            this.ordinal = kids.getIndex((Object)this, 0);
        }
        return this.ordinal;
    }

    @Override
    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public ExtendedNodeInterface getRootParent() {
        ExtendedNodeInterface root = this.getParent();
        if (root == null) {
            return this;
        }
        if (root != this) {
            root = ((ParentNode)this.getParent()).getRootParent();
        }
        return root;
    }

    @Override
    public ExtendedNodeInterface getParent() {
        if (this.parent == null && this.delegate != null) {
            return this.delegate.getParent();
        }
        return this.parent;
    }

    @Override
    public void setParent(ExtendedNodeInterface node) {
        this.parent = node;
    }

    @Override
    public ExtendedNodeInterface getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(ExtendedNodeInterface node) {
        this.delegate = node;
    }

    @Override
    public PropertyBagInterface getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyBag();
        }
        return this.properties;
    }

    @Override
    public void setProperties(PropertyBagInterface properties) {
        this.properties = properties;
    }

    public Object getProperty(String name, Object defValue) {
        PropertyBagInterface pbi;
        Object prop = defValue;
        if (this.getProperties().containsKey(name)) {
            prop = this.properties.get(name.intern());
        } else if (this.delegate != null && (pbi = this.delegate.getProperties()) != null && pbi.containsKey(name)) {
            prop = pbi.get(name.intern());
        }
        return prop;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new PropertyBag();
        }
        this.properties.set(name.intern(), value);
    }

    public SimpleNodeInterface[] getNodeChildren(int key, int count) {
        try {
            if (count == -1) {
                count = this.countNodeChildren(0) - key;
            }
            if (key < 0 || key >= this.countNodeChildren(0)) {
                throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource(RB_KEY, "indexOutOfBounds.ex.txt"), (Object)new Integer(key)));
            }
            if (count > 0) {
                this.initCache();
                Object[] obj = null;
                obj = count == 1 ? new Object[]{this._childrenCache.getFromCache((long)key)} : this._childrenCache.getFromCache((long)key, (long)key + (long)count - 1L, false);
                if (obj.length < count) {
                    count = obj.length;
                }
                SimpleNodeInterface[] si = new SimpleNodeInterface[count];
                for (int i = 0; i < count; ++i) {
                    si[i] = (SimpleNodeInterface)obj[i];
                }
                return si;
            }
            return null;
        }
        catch (CacheException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    public StaticOrderedCollectionInterface getNodeChildren() {
        try {
            int count = this.countNodeChildren(0);
            this.initCache();
            return new OrderedCollection(this._childrenCache.getFromCache(0L, (long)count, true));
        }
        catch (CacheException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    public SimpleNodeInterface getNodeChild(int index) {
        try {
            this.initCache();
            return (SimpleNodeInterface)this._childrenCache.getFromCache((long)index);
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public void removeNodeChild(int index) {
        try {
            if (this._childrenCache != null) {
                ((CacheBase)this._childrenCache).invalidateCache((long)index);
            }
            --this.numChildren;
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void addNodeChild(SimpleNodeInterface node) {
        try {
            this.initCache();
            ((CacheBase)this._childrenCache).storeInCache((long)this._childrenCache.count(), (Object)node);
        }
        catch (CacheException ce) {
            ce.printStackTrace();
        }
    }

    public int getNodeChildCount() {
        return this.numChildren;
    }

    public boolean isLeafNode() {
        return this.countNodeChildren(0) <= 0;
    }

    public String getNodeText() {
        if (this.name == null) {
            ParentNode meta = (ParentNode)this.getDelegate();
            if (meta != null && meta != this) {
                this.name = meta.getName();
            }
            if (this.name == null) {
                this.name = this.getLabel();
            }
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.getNodeText();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeExpandedText() {
        ParentNode meta;
        if (this.label == null && (meta = (ParentNode)this.getDelegate()) != null && meta != this) {
            this.label = meta.getLabel();
        }
        return this.label == null ? this.name : this.label;
    }

    public String getNodeType() {
        return null;
    }

    public int countNodeChildren(int index) {
        if (this.numChildren == -1) {
            if (this._childrenCache == null) {
                this.initCache();
            }
            if (this._childrenCache != null) {
                this.numChildren = this._secondaryCache != null ? this._secondaryCache.count() : this._childrenCache.count();
            }
        }
        return index > 0 && this.numChildren > index ? index : this.numChildren;
    }

    @Override
    public String getLabel() {
        return this.getNodeExpandedText();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public com.sas.models.NodeInterface getRoot() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        boolean isEqual = super.equals(object);
        if (!isEqual && object instanceof ParentNode) {
            ParentNode node = (ParentNode)object;
            ParentNode granddad1 = (ParentNode)node.getDelegate();
            ParentNode granddad2 = (ParentNode)this.getDelegate();
            if (granddad1 == null) {
                granddad1 = node;
            } else {
                while (granddad1.getDelegate() != null) {
                    granddad1 = (ParentNode)granddad1.getDelegate();
                }
            }
            if (granddad2 == null) {
                granddad2 = this;
            } else {
                while (granddad2.getDelegate() != null) {
                    granddad2 = (ParentNode)granddad2.getDelegate();
                }
            }
            isEqual = granddad1.getName().equalsIgnoreCase(granddad2.getName());
        }
        return isEqual;
    }

    public MultidimensionalTableInterface getImddb() {
        return this.Imddb;
    }

    protected boolean addShowDetailDataCommand() {
        block3: {
            block2: {
                if (!this.isV2Interface) break block2;
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                if ((this._commandsMask & 1L) == 0L) break block3;
            }
            return true;
        }
        return false;
    }

    protected boolean addComputedValuesCommand() {
        block3: {
            block2: {
                if (!this.isV2Interface) break block2;
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                if ((this._commandsMask & 2L) == 0L) break block3;
            }
            return true;
        }
        return false;
    }

    protected boolean addTotalsCommand() {
        block3: {
            block2: {
                if (!this.isV2Interface) break block2;
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                if ((this._commandsMask & 4L) == 0L) break block3;
            }
            return true;
        }
        return false;
    }

    protected boolean addSubsetsCommand() {
        block3: {
            block2: {
                if (!this.isV2Interface) break block2;
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                if ((this._commandsMask & 8L) == 0L) break block3;
            }
            return true;
        }
        return false;
    }

    protected boolean addExceptionHighlightingCommand() {
        block3: {
            block2: {
                if (!this.isV2Interface) break block2;
                MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                if ((this._commandsMask & 0x10L) == 0L) break block3;
            }
            return true;
        }
        return false;
    }

    protected boolean addExportToExcelCommand() {
        block4: {
            block3: {
                block2: {
                    if (!ExportToExcelCommand.isExportAllowed() || !this.isV2Interface) break block2;
                    MultidimensionalTableV2Interface cfr_ignored_0 = (MultidimensionalTableV2Interface)this.Imddb;
                    if ((this._commandsMask & 0x20L) != 0L) break block3;
                }
                if (this.isV2Interface) break block4;
            }
            return true;
        }
        return false;
    }

    public boolean attachView() {
        return true;
    }

    public void detachView() {
    }
}

