/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.format.FormatInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Delegate;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.RangeCollection;
import com.sas.sasserver.mdtable.SortInterface;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.table.TableException;
import com.sas.text.SASFormat;
import com.sas.util.Util;
import java.util.Enumeration;

public class MultidimensionalTableV3Delegate
extends MultidimensionalTableV2Delegate {
    private transient FormatInterface _formatInterface;
    private transient String _previousFormat;

    public SortInterface[] getSortOrders() throws TableException {
        Dictionary levels = this.getAllLevels();
        if (levels == null) {
            return new SortInterface[0];
        }
        Enumeration enumer = levels.getItems();
        OrderedCollection temp = new OrderedCollection();
        int i = 0;
        while (enumer.hasMoreElements()) {
            Level level = (Level)enumer.nextElement();
            if (level.getDimension() != null && ((Dimension)level.getDimension()).getType() == 1) continue;
            temp.add((Object)level);
        }
        Axis columnAxis = (Axis)this.Imddb.getAxis(0);
        AxisLabelInterface al = columnAxis.getSortIdentifier();
        if (al != null) {
            temp.add((Object)al);
        }
        int count = temp.count();
        SortInterface[] sortableItems = new SortInterface[count];
        for (i = 0; i < count; ++i) {
            sortableItems[i] = (SortInterface)temp.get(i);
        }
        return sortableItems;
    }

    public void setSortOrders() throws TableException {
        Axis columnAxis;
        Dictionary levels = this.getAllLevels();
        Enumeration enumer = levels.getItems();
        AxisLabelInterface al = null;
        if (this._axisCount > 0 && (columnAxis = (Axis)this.Imddb.getAxis(0)) != null) {
            al = columnAxis.getSortIdentifier();
        }
        int cnt = al != null ? levels.count() + 1 : levels.count();
        SortInterface[] sorts = new SortInterface[cnt];
        Level level = null;
        int i = 0;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.sortNeedsRefresh()) continue;
            sorts[i++] = level;
        }
        if (al != null) {
            sorts[i] = (SortInterface)((Object)al);
        }
        this.setSortOrders(sorts);
    }

    public void setSortOrders(SortInterface[] sortableItems) {
        if (sortableItems != null && sortableItems.length > 0) {
            OrderedCollection levelCollection = new OrderedCollection();
            OrderedCollection memberCollection = new OrderedCollection();
            for (int i = 0; i < sortableItems.length; ++i) {
                if (sortableItems[i] != null && sortableItems[i] instanceof Level) {
                    int sortOrder = ((Level)sortableItems[i]).getSortOrder();
                    if (!((Level)sortableItems[i]).sortNeedsRefresh()) continue;
                    ((MultidimensionalTableV2Interface)this.Imddb).sort((Level)sortableItems[i], sortOrder);
                    continue;
                }
                if (sortableItems[i] == null || !(sortableItems[i] instanceof AxisLabelInterface) || !(sortableItems[i] instanceof Member)) continue;
                Axis axis = (Axis)((Member)sortableItems[i]).getAxis();
                if (axis != null) {
                    HList hlist = Member.tupleToHList((ParentNode)((Object)sortableItems[i]));
                    this._orderSet = true;
                    ((MultidimensionalTableV3Interface)this.Imddb).sort(axis.getOrdinal(), (HListInterface)hlist, sortableItems[i].getSortOrder(), sortableItems[i].getTopBottomN());
                    try {
                        this.Imddb.refreshTable((Axis)this.Imddb.getAxis(1), null);
                    }
                    catch (TableException tableException) {}
                    continue;
                }
                try {
                    axis = (Axis)this.Imddb.getAxis(0);
                    LevelInterface[] li = axis.getLevels();
                    if (li == null || li.length <= 0) continue;
                    HList tuple = new HList();
                    int j = li.length - 1;
                    ParentNode p = (ParentNode)((Member)sortableItems[i]).getParent();
                    ParentNode m = (Member)sortableItems[i];
                    Level l = null;
                    l = (Level)li[j--];
                    String levelName = l.getLabel();
                    if (l.isStatisticLevel() || l.isAnalysisLevel()) {
                        levelName = l.getName();
                    }
                    tuple.addItem(m.getLabel(), 0, levelName);
                    while (p != null && !m.equals(p) && j >= 0) {
                        m = p;
                        p = (ParentNode)m.getParent();
                        l = (Level)li[j--];
                        levelName = l.getLabel();
                        if (l.isStatisticLevel() || l.isAnalysisLevel()) {
                            levelName = l.getName();
                        }
                        tuple.addItem(m.getLabel(), 0, levelName);
                    }
                    this.sort(0, (HListInterface)tuple, sortableItems[i].getSortOrder(), sortableItems[i].getTopBottomN());
                    continue;
                }
                catch (TableException tableException) {
                    // empty catch block
                }
            }
        }
    }

    public void setStatisticLabelHidden(boolean isHidden) {
        try {
            long error = 0L;
            this._isStatLabelHidden = isHidden ? 1 : 0;
            error = ((MultidimensionalTableV3Interface)this.Imddb)._setStatisticLabelHidden(isHidden);
            if (error == 0L) {
                this.refreshTable();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isStatisticLabelHidden() {
        boolean isHidden = false;
        int serverHidden = 0;
        isHidden = this._isStatLabelHidden == -1 ? (serverHidden = ((MultidimensionalTableV3Interface)this.Imddb)._isStatisticLabelHidden()) > 0 : this._isStatLabelHidden == 1;
        return isHidden;
    }

    public long[][] getCommandsMasks(int axisOrdinal, int start, int count) throws TableException {
        Object returnMasks = new long[0][0];
        HListInterface hlist = ((MultidimensionalTableV3Interface)this.Imddb)._getActionsMasks(axisOrdinal, start, count);
        int cnt = hlist.count();
        returnMasks = new long[cnt][];
        for (int i = 0; i < cnt; ++i) {
            HListInterface commandList = hlist.getList(i);
            int cnt1 = commandList.count();
            returnMasks[i] = new long[cnt1];
            for (int j = 0; j < cnt1; ++j) {
                returnMasks[i][j] = (long)commandList.getDouble(j);
            }
        }
        return returnMasks;
    }

    public String[] formatValues(int id, Object[] values) throws TableException {
        String format = null;
        String[] formattedValues = new String[values.length];
        AxisInterface column = this.getAxis(0);
        if (id >= 0 && column.getMagnitude() > id) {
            Member mstat;
            AxisLabelInterface[] axisLabel = column.getLabels(id);
            int idx = axisLabel.length - 1;
            String measure = null;
            String stat = null;
            int ishidden = this._isStatLabelHidden;
            if (ishidden == -1 || ishidden == 1) {
                int n = ishidden = ((Level)axisLabel[idx].getMember().getLevel()).isStatisticLevel() ? 0 : 1;
            }
            if (ishidden == 0) {
                stat = axisLabel[idx--].getName();
            } else if (ishidden == 1 && (mstat = MDCommand.getHiddenStatMember(this.Imddb)) != null) {
                stat = mstat.getLabel();
            }
            measure = axisLabel[idx].getName();
            format = this.getMeasureFormat(measure, stat);
        }
        if (format != null) {
            SASFormat sf = SASFormat.getInstance(format);
            if (sf != null) {
                for (int i = 0; i < values.length; ++i) {
                    StringBuffer sb = new StringBuffer();
                    try {
                        sb = sf.format(values[i], sb, null);
                        formattedValues[i] = sb.toString();
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        formattedValues[i] = values[i].toString();
                    }
                }
            } else {
                try {
                    HList hlist = new HList();
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Double) {
                            hlist.addItem((HListItem)new DoubleItem(((Double)values[i]).doubleValue()));
                            continue;
                        }
                        if (values[i] instanceof String) {
                            hlist.addItem((HListItem)new StringItem((String)values[i]));
                            continue;
                        }
                        formattedValues[i] = values[i].toString();
                    }
                    if (this._formatInterface == null) {
                        Connection con = ((RemoteBaseClient)((Object)this.Imddb))._RemoteObject_getContext();
                        Rocf rocf = con.getClassFactory();
                        this._formatInterface = (FormatInterface)rocf.newInstance(FormatInterface.class, con);
                    }
                    if (Util.unequal((Object)this._previousFormat, format)) {
                        this._formatInterface.setFormat(format);
                        this._previousFormat = format;
                    }
                    HListInterface flist = this._formatInterface.formatValues((HListInterface)hlist);
                    for (int i = 0; i < formattedValues.length; ++i) {
                        if (formattedValues[i] != null) continue;
                        formattedValues[i] = flist.getItem(i).toString();
                    }
                }
                catch (Exception ex) {
                    for (int i = 0; i < values.length; ++i) {
                        formattedValues[i] = values[i].toString();
                    }
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                formattedValues[i] = values[i].toString();
            }
        }
        return formattedValues;
    }

    public String getMeasureFormat(String measure, String statistic) {
        String format = null;
        if (this._formatList == null) {
            this._formatList = ((MultidimensionalTableV3Interface)this.Imddb)._getMeasureFormats(null);
        }
        if (((HList)this._formatList).itemExists(measure, 1, 0)) {
            HList flist = (HList)this._formatList.getList(measure);
            if (flist.itemExists(statistic, 1, 0)) {
                format = flist.getString(statistic);
            }
            if (format != null && format.equals(" ")) {
                format = null;
            }
        }
        return format;
    }

    public void addRange(String measureName, String statisticName, RangeCollection rangeCollection) throws TableException {
        int i;
        MemberInterface[] measures = this.getMeasureMembers();
        int j = 0;
        for (i = 0; i < measures.length && !measures[i].getName().equalsIgnoreCase(measureName) && !measures[i].getLabel().equalsIgnoreCase(measureName); ++i) {
        }
        MemberInterface[] stat = this.getStatisticMembers();
        while (j < stat.length && !stat[j].getLabel().equalsIgnoreCase(statisticName) && !stat[j].getName().equalsIgnoreCase(statisticName)) {
            ++j;
        }
        if (i < measures.length && j < stat.length) {
            this.addRange(measures[i], stat[j], rangeCollection);
        }
    }

    public synchronized long modifyTable() throws TableException {
        return this.modifyTable(null);
    }

    public synchronized long modifyTable(String[][] axisDimensions) throws TableException {
        if (!this._tableSet) {
            throw new TableException(RB.getStringResource("MultidimensionalTableDelegate.", "tablenotset.ex.txt"));
        }
        HList axesList = new HList();
        if (axisDimensions == null) {
            String[][] axes = new String[2][];
            if (this._rowAxis == null || this._rowAxis.length == 0) {
                throw new TableException(RB.getStringResource("MultidimensionalTableDelegate.", "rowaxis.ex.txt"));
            }
            axes[0] = this._columnAxis;
            axes[1] = this._rowAxis;
            for (int i = 0; i < axes.length; ++i) {
                HList dims = new HList();
                for (int j = 0; axes[i] != null && j < axes[i].length; ++j) {
                    StringItem dimId = new StringItem(axes[i][j]);
                    dims.add((Object)dimId);
                }
                axesList.add((Object)new ListItem((HListInterface)dims));
            }
        } else {
            if (axisDimensions == null || axisDimensions.length < 2 || axisDimensions[1] == null || axisDimensions[1].length < 1) {
                throw new TableException(RB.getStringResource("MultidimensionalTableDelegate.", "rowaxis.ex.txt"));
            }
            for (int i = 0; i < axisDimensions.length; ++i) {
                HList dims = new HList();
                for (int j = 0; axisDimensions[i] != null && j < axisDimensions[i].length; ++j) {
                    StringItem dimId = new StringItem(axisDimensions[i][j]);
                    dims.add((Object)dimId);
                }
                axesList.add((Object)new ListItem((HListInterface)dims));
            }
        }
        HList measuresList = new HList();
        if (this._measures == null || this._measures.length == 0) {
            throw new TableException(RB.getStringResource("MultidimensionalTableDelegate.", "measure.ex.txt"));
        }
        this._needsRefresh = false;
        measuresList = this.statsToHList(this._stats);
        long error = -1L;
        if (measuresList.count() >= 0) {
            error = ((MultidimensionalTableV3Interface)this.Imddb)._modifyTable((HListInterface)axesList, (HListInterface)measuresList);
            if (error != 0L) {
                throw new TableException(this.Imddb.getMessage());
            }
        } else {
            throw new TableException(RB.getStringResource("MultidimensionalTableDelegate.", "statistic.ex.txt"));
        }
        this.setRangeCollection();
        this.refreshTable();
        return error;
    }

    public int[] _getAxisCoordinates(int p0) {
        try {
            return this.getAxisCoordinates(p0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RangeCollection getRange(Member measure, Member statistic) throws TableException {
        try {
            return this.getRange(measure.getMember(), statistic.getMember());
        }
        catch (TableException e) {
            return null;
        }
    }

    public int findNextLabel(int axisOrdinal, HListInterface tupleList, String pattern, boolean ignoreCase, int startPosition, int how) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV3Interface)this.Imddb)._findLabel(axisOrdinal, tupleList, pattern, ignoreCase, startPosition, 1, how);
    }

    public int findPrevLabel(int axisOrdinal, HListInterface tupleList, String pattern, boolean ignoreCase, int startPosition, int how) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV3Interface)this.Imddb)._findLabel(axisOrdinal, tupleList, pattern, ignoreCase, startPosition, -1, how);
    }

    public int findNextMember(String level, String pattern, boolean ignoreCase, int startPosition, int how) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV3Interface)this.Imddb)._findMemberLabel(level, pattern, ignoreCase, how, "Y", startPosition, 1);
    }

    public int findPrevMember(String level, String pattern, boolean ignoreCase, int startPosition, int how) {
        if (pattern == null) {
            return -1;
        }
        return ((MultidimensionalTableV3Interface)this.Imddb)._findMemberLabel(level, pattern, ignoreCase, how, "Y", startPosition, -1);
    }

    public void setSelectedStatistics(String measure, MemberInterface[] statisticMembers) throws TableException {
        String[] statisticNames = null;
        if (statisticMembers != null) {
            statisticNames = new String[statisticMembers.length];
            for (int i = 0; i < statisticMembers.length; ++i) {
                statisticNames[i] = statisticMembers[i].getName();
            }
        }
        this.setSelectedStatistics(measure, statisticNames);
    }

    public synchronized void close() {
        ((MultidimensionalTableV3Interface)this.Imddb)._close();
        this.setDefaultValues();
        this._levels = null;
        this.refreshTable();
    }

    public final ComputedValueInterface[] getComputedValuesProperty() throws TableException {
        return this.getComputedValues();
    }

    public final SubsetInterface[] getSubsetsProperty() throws TableException {
        return this.getSubsets();
    }

    public final TotalInterface[] getTotalsProperty() throws TableException {
        return this.getTotals();
    }

    public void sort(int axisOrdinal, HListInterface tupleList, int sortOrder, int N) {
        if (sortOrder >= 1 && sortOrder <= 4) {
            String direction = this.getSortString(sortOrder);
            this.sort(axisOrdinal, tupleList, direction, N);
        }
    }

    public Level findLevel(String levelName) throws TableException {
        Dictionary allLevels = this.Imddb.getAllLevels();
        Level level = null;
        if (this._sourceSet && allLevels != null && allLevels.count() > 0) {
            if (allLevels.containsKey((Object)levelName)) {
                level = (Level)allLevels.get((Object)levelName);
            } else {
                Level l = (Level)this.Imddb.findCubeLevel(levelName);
                if (l != null && allLevels.containsKey((Object)l.getName())) {
                    level = (Level)allLevels.get((Object)l.getName());
                }
            }
        }
        return level;
    }

    public long getDefaultActionMask() {
        try {
            if (this._defaultActionMask == -1L) {
                this.setApplicationInfo();
            }
        }
        catch (TableException te) {
            this._defaultActionMask = 256L;
        }
        return this._defaultActionMask;
    }
}

