/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.CacheException;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.SortInterface;
import com.sas.sasserver.mdtable.TotalMember;
import com.sas.sasserver.mdtable.commands.ComputedValuesCommand;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.sasserver.mdtable.commands.LevelNameCommand;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.commands.RangeTypesCommand;
import com.sas.sasserver.mdtable.commands.ShowDetailCommand;
import com.sas.sasserver.mdtable.commands.SubsetsCommand;
import com.sas.sasserver.mdtable.commands.TotalsCommand;
import com.sas.table.TableException;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.Util;

public class Member
extends ParentNode
implements MemberInterface,
AxisLabelInterface,
CommandsInterface,
Command,
SortInterface {
    static final long serialVersionUID = -6216443228442630210L;
    public transient HListInterface dependents;
    private transient int _minCoordinate;
    private transient int _maxCoordinate;
    protected transient String _sortDirection;
    protected transient int _sortOrder;
    private transient int _N;
    protected static final String RB_KEY = "Member.";

    public Member(MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.parent = this;
        this.reset();
    }

    public Member(Level level, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.setParent(level);
        this.reset();
    }

    public Member(Member member, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.reset();
        this.setParent(member);
    }

    public Member(ExtendedNodeInterface member, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.reset();
        this.setDelegate(member);
    }

    public Member(Level level, String name, String label, MultidimensionalTableInterface mdDelegate) throws TableException {
        super(mdDelegate);
        this.reset();
        this.setParent(level);
        this.setName(name);
        this.setLabel(label);
    }

    Member(String name) {
        super(name);
    }

    public void reset() {
        this.dependents = null;
        this._minCoordinate = -1;
        this._maxCoordinate = -1;
        try {
            this.clearCache();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Override
    public LevelInterface getLevel() {
        LevelInterface level = null;
        ExtendedNodeInterface root = this.getRootParent();
        level = root instanceof MemberInterface ? (this.getDelegate() != null ? ((MemberInterface)((Object)this.getDelegate())).getLevel() : null) : (LevelInterface)((Object)this.getParent());
        return level;
    }

    @Override
    public void setParent(ExtendedNodeInterface parent) {
        this.parent = parent;
    }

    @Override
    public AxisInterface getAxis() {
        ExtendedNodeInterface root = this.getRootParent();
        if (root instanceof MemberInterface && this.getDelegate() != null) {
            root = this.getDelegate().getRootParent();
        }
        return root instanceof AxisInterface ? (AxisInterface)((Object)root) : null;
    }

    @Override
    public MemberInterface getMember() {
        return (MemberInterface)((Object)this.getDelegate());
    }

    @Override
    public int getMinimumCoordinate() {
        Axis axis = (Axis)this.getAxis();
        this._minCoordinate = -1;
        int axisDepth = -1;
        if (axis != null) {
            try {
                axisDepth = axis.getLevels().length;
            }
            catch (TableException te) {
                axisDepth = -1;
            }
        }
        if (axisDepth == 1) {
            this._minCoordinate = this.getDelegate().getOrdinal();
        } else if (this.getOrdinal() == 0 && axisDepth == 2 && this.dependents != null) {
            int depCount = this.dependents.count();
            try {
                if (this._childrenCache != null && !this._childrenCache.cacheContainsKey(0L) && this._childrenCache.cacheContainsKey((long)(depCount - 1)) && depCount > 0) {
                    this._minCoordinate = this.getMaximumCoordinate() - depCount + 1;
                }
            }
            catch (CacheException ce) {
                this._minCoordinate = -1;
            }
        }
        if (this._minCoordinate == -1 && axis != null) {
            try {
                ExtendedNodeInterface label;
                ExtendedNodeInterface root = this.getRootParent();
                OrderedCollection oc = new OrderedCollection();
                oc.add((Object)label);
                for (label = this; label != root; label = label.getParent()) {
                    oc.add((Object)label, 0);
                }
                label = this;
                while (!label.isLeafNode() && (label = (ExtendedNodeInterface)label.getNodeChild(0)) != null) {
                    oc.add((Object)label);
                }
                this._minCoordinate = axis.getAxisCoordinate(oc);
            }
            catch (TableException te) {
                te.printStackTrace();
            }
        }
        return this._minCoordinate;
    }

    @Override
    public int getMaximumCoordinate() {
        Axis axis = (Axis)this.getAxis();
        this._maxCoordinate = -1;
        int axisDepth = -1;
        if (axis != null) {
            try {
                axisDepth = axis.getLevels().length;
            }
            catch (TableException te) {
                axisDepth = -1;
            }
        }
        if (axisDepth == 1) {
            this._maxCoordinate = this.getDelegate().getOrdinal();
        } else if (this.getOrdinal() == 0 && axisDepth == 2 && this.dependents != null) {
            try {
                int depCount = this.dependents.count();
                if (this._childrenCache != null && this._childrenCache.cacheContainsKey(0L) && depCount > 0) {
                    this._maxCoordinate = this.getMinimumCoordinate() + depCount - 1;
                }
            }
            catch (CacheException ce) {
                this._maxCoordinate = -1;
            }
        }
        if (this._maxCoordinate == -1 && axis != null) {
            try {
                ExtendedNodeInterface label = this;
                int depth = label.getOrdinal();
                OrderedCollection oc = new OrderedCollection();
                for (int i = depth; i >= 0; --i) {
                    oc.add((Object)label, 0);
                    label = label.getParent();
                }
                label = this;
                while (!label.isLeafNode() && (label = (ExtendedNodeInterface)label.getNodeChild(label.getNodeChildCount() - 1)) != null) {
                    oc.add((Object)label);
                }
                this._maxCoordinate = ((Axis)this.getAxis()).getAxisCoordinate(oc);
            }
            catch (TableException te) {
                te.printStackTrace();
            }
        }
        return this._maxCoordinate;
    }

    public Command[] getCommands() {
        if (this.Imddb instanceof MultidimensionalTableV3Interface) {
            return MDCommand.getCommands(this);
        }
        String[] actions = null;
        Command[] commands = null;
        OrderedCollection oc = new OrderedCollection();
        try {
            boolean addCV = false;
            if (this.isV2Interface) {
                this._commandsMask = ((MultidimensionalTableV2Interface)this.Imddb).getCommandsMask();
            }
            boolean v1Server = false;
            boolean v11Server = false;
            boolean needsSeparator = false;
            HList tupleList = Member.tupleToHList(this);
            int axis = this.getDelegate().getRootParent().getOrdinal();
            actions = this.Imddb._getActions(axis, (HListInterface)tupleList);
            if (actions == null) {
                actions = new String[]{};
            }
            if (actions.length > 0) {
                ExtendedNodeInterface prevp = null;
                if (((Level)this.getLevel()).isStatisticLevel()) {
                    ExtendedNodeInterface p = this.getParent();
                    while (p != null && !(prevp = p).equals(p = prevp.getParent())) {
                    }
                }
                if (actions[actions.length - 1].equals(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt"))) {
                    v1Server = true;
                } else if (actions[actions.length - 1].indexOf(this.getLevel().getName()) >= 0) {
                    v11Server = true;
                } else if (prevp != null && actions[actions.length - 1].indexOf(((ParentNode)prevp).getName()) >= 0) {
                    v11Server = true;
                }
            }
            if (!v1Server && !v11Server && this.isV2Interface) {
                String label = this.getLabel();
                if (this.getName().equals("_ANLSYS_")) {
                    label = com.sas.sasserver.mdtable.RB.getStringResource("anlsys.txt");
                } else if (this.getName().equals("_STATS_")) {
                    label = com.sas.sasserver.mdtable.RB.getStringResource("stats.txt");
                }
                if (!label.equals(com.sas.sasserver.mdtable.RB.getStringResource("stats.txt")) && actions.length > 0 && actions[actions.length - 1].indexOf(label) < 0) {
                    needsSeparator = true;
                }
            }
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("showDetail.txt"))) {
                    if (!this.addShowDetailDataCommand()) continue;
                    oc.add((Object)new ShowDetailCommand(actions[i], this));
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("computedValues.txt"))) {
                    if (!this.addComputedValuesCommand()) continue;
                    addCV = true;
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("totals.txt")) && this.addTotalsCommand()) {
                    oc.add((Object)new TotalsCommand(actions[i], this));
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("subsets.txt")) && this.addSubsetsCommand()) {
                    oc.add((Object)new SubsetsCommand(actions[i], this));
                    continue;
                }
                if (actions[i].equals("_SEPARATOR")) {
                    if (oc.count() <= 0 || oc.get(oc.count() - 1).equals(MenuSeparatorCommand.instance())) continue;
                    oc.add((Object)MenuSeparatorCommand.instance());
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt")) && this.addExceptionHighlightingCommand()) {
                    oc.add((Object)new RangeTypesCommand(actions[i], this));
                    continue;
                }
                oc.add((Object)new MDCommand(actions[i], this));
            }
            if (!this.isV2Interface) {
                addCV = true;
            }
            if (!v1Server) {
                if (oc.count() > 0 && !oc.get(oc.count() - 1).equals(MenuSeparatorCommand.instance())) {
                    oc.add((Object)MenuSeparatorCommand.instance());
                }
                if (!(v1Server || v11Server || ((Level)this.getLevel()).isAnalysisLevel())) {
                    oc.add((Object)new LevelNameCommand(this));
                    oc.add((Object)MenuSeparatorCommand.instance());
                }
                if (addCV) {
                    oc.add((Object)new ComputedValuesCommand(com.sas.sasserver.mdtable.RB.getStringResource("computedValues.txt"), this));
                }
                if (this.addTotalsCommand()) {
                    oc.add((Object)new TotalsCommand(com.sas.sasserver.mdtable.RB.getStringResource("totals.txt"), this));
                }
                if (this.addSubsetsCommand()) {
                    oc.add((Object)new SubsetsCommand(com.sas.sasserver.mdtable.RB.getStringResource("subsets.txt"), this));
                }
                if (this.addExceptionHighlightingCommand()) {
                    oc.add((Object)new RangeTypesCommand(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt"), this));
                }
            }
            if (this.addExportToExcelCommand()) {
                oc.add((Object)new ExportToExcelCommand(com.sas.sasserver.mdtable.RB.getStringResource("excel.txt"), this.Imddb));
            }
            if (oc.get(oc.count() - 1) == MenuSeparatorCommand.instance()) {
                oc.removeAt(oc.count() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        commands = new Command[oc.count()];
        for (int c = 0; c < commands.length; ++c) {
            commands[c] = (Command)oc.get(c);
        }
        return commands;
    }

    public synchronized String[] getActions(MemberInterface[] tuple) throws TableException {
        String[] retval = null;
        try {
            HList tupleList = Member.tupleToHList((ParentNode)((Object)tuple[tuple.length - 1]));
            retval = this.Imddb._getActions(this.getOrdinal(), (HListInterface)tupleList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public static HList tupleToHList(ParentNode member) {
        ParentNode node = member;
        int depth = member.getOrdinal();
        HList tupleList = new HList();
        String levelName = null;
        ParentNode level = null;
        for (int i = depth; i >= 0; --i) {
            level = (ParentNode)node.getDelegate().getParent();
            levelName = level != null ? level.getName() : null;
            tupleList.addItem(node.getLabel(), 0, levelName);
            node = (ParentNode)node.getParent();
        }
        return tupleList;
    }

    @Override
    protected StaticCacheInterface createCache() {
        return new ChildrenReader();
    }

    @Override
    public int countNodeChildren(int index) {
        this.numChildren = this.dependents != null ? this.dependents.count() : 0;
        return index > 0 && this.numChildren > index ? index : this.numChildren;
    }

    @Override
    public boolean equals(Object object) {
        boolean isEqual;
        if (object == null) {
            return false;
        }
        boolean bl = isEqual = this == object;
        if (!isEqual && object instanceof ExtendedNodeInterface) {
            ParentNode node = (ParentNode)object;
            ParentNode granddad1 = (ParentNode)node.getDelegate();
            ParentNode granddad2 = (ParentNode)this.getDelegate();
            if (granddad1 == null) {
                granddad1 = node;
            } else {
                while (granddad1.getDelegate() != null) {
                    granddad1 = (ParentNode)granddad1.getDelegate();
                }
            }
            if (granddad2 == null) {
                granddad2 = this;
            } else {
                while (granddad2.getDelegate() != null) {
                    granddad2 = (ParentNode)granddad2.getDelegate();
                }
            }
            if (granddad2.getName().equals(granddad1.getName())) {
                if (granddad2.getParent() == null || granddad1.getParent() == null) {
                    isEqual = true;
                } else if (granddad2.getParent().equals(granddad1.getParent())) {
                    ParentNode p1 = (ParentNode)node.getParent();
                    ParentNode p2 = (ParentNode)this.getParent();
                    isEqual = p1 != null && p2 != null && p1 != node && p2 != this ? p1.equals(p2) : p1 == p2 || p1 == node && p2 == this;
                }
            }
        }
        return isEqual;
    }

    @Override
    public int getTopBottomN() {
        try {
            Axis a = (Axis)this.Imddb.getAxis(0);
            AxisLabelInterface al = a.getSortIdentifier();
            if (al != null && this.equalsLabel(al)) {
                return ((Member)al)._N;
            }
        }
        catch (TableException te) {
            return 0;
        }
        return 0;
    }

    public void setTopBottomN(int N) {
        this._N = N;
        Axis a = (Axis)this.getAxis();
        if (a != null) {
            Member al = (Member)a.getSortIdentifier();
            try {
                if (al != null && this.equalsLabel(al)) {
                    al._N = N;
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
    }

    public void setSortOrder(int order) {
        Level l = (Level)this.getLevel();
        this._sortOrder = order;
        if (l != null) {
            if (l.isStatisticLevel()) {
                int saveN = this._N;
                this.clearLevelSort(false);
                Axis a = (Axis)this.getAxis();
                if (a != null) {
                    Member al = (Member)a.getSortIdentifier();
                    try {
                        if (al != null && !this.equalsLabel(al)) {
                            al.setSortOrder(3);
                            al.setTopBottomN(0);
                        }
                        this._N = saveN;
                        Member m = new Member(this.getImddb());
                        m.setDelegate(this.getDelegate());
                        m.setOrdinal(this.getOrdinal());
                        m.setTopBottomN(this._N);
                        if (this.getDelegate() != null) {
                            Member member = m;
                            for (ParentNode parent = (ParentNode)this.getParent(); parent != null && parent.getLabel() != member.getLabel(); parent = (ParentNode)parent.getParent()) {
                                Member mParent = new Member(parent.getImddb());
                                mParent.setDelegate(parent.getDelegate());
                                mParent.setOrdinal(parent.getOrdinal());
                                ((ParentNode)member).setParent(mParent);
                                member = mParent;
                            }
                        }
                        a.setSortIdentifier(m);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            l.setSortOrder(order);
        }
    }

    @Override
    public void sort(int order) {
        if (this.getAxis() == null || ((Axis)this.getAxis()).getOrdinal() != 0) {
            return;
        }
        LevelInterface l = this.getLevel();
        if (l != null && l instanceof Level && ((Level)l).isStatisticLevel() || ((Level)l).isAnalysisLevel()) {
            int depth = this.getOrdinal() + 1;
            MemberInterface[] mi = new MemberInterface[depth];
            ParentNode m = this;
            for (int i = depth - 1; m != null && i >= 0; --i) {
                if (!(m instanceof Member)) continue;
                mi[i] = m;
                m = (ParentNode)m.getParent();
            }
            if (this.Imddb instanceof MultidimensionalTableV2Interface) {
                ((MultidimensionalTableV2Interface)this.Imddb).sort(mi, order);
            }
        }
    }

    public void setSortDirection(String direction) {
        if (direction != null) {
            if (direction.equalsIgnoreCase(RB.getStringResource("descending.txt"))) {
                this.setSortOrder(1);
            } else if (direction.equalsIgnoreCase(RB.getStringResource("ascending.txt"))) {
                this.setSortOrder(2);
            } else if (direction.equalsIgnoreCase(RB.getStringResource("reset.txt"))) {
                this.setSortOrder(3);
            } else if (direction.equalsIgnoreCase("None")) {
                this.setSortOrder(4);
            }
        }
    }

    public String getSortDirection() {
        int so = this.getSortOrder();
        if (so == 1) {
            this._sortDirection = RB.getStringResource("descending.txt");
        } else if (so == 2) {
            this._sortDirection = RB.getStringResource("ascending.txt");
        } else if (so == 3) {
            this._sortDirection = RB.getStringResource("reset.txt");
        } else if (so == 4) {
            this._sortDirection = "None";
        }
        return this._sortDirection;
    }

    @Override
    public int getSortOrder() {
        block9: {
            Level l = (Level)this.getLevel();
            if (l != null && l.isStatisticLevel()) {
                try {
                    Axis a = (Axis)this.Imddb.getAxis(0);
                    AxisLabelInterface al = a.getSortIdentifier();
                    if (al == null) {
                        Level level;
                        this._sortOrder = 3;
                        Axis rowAxis = (Axis)this.Imddb.getAxis(1);
                        LevelInterface[] ls = rowAxis.getLevels();
                        if (ls != null && ls.length > 0 && (level = (Level)ls[ls.length - 1]).getSortOrder() != 4 && level.getSortOrder() != 3) {
                            this._sortOrder = 4;
                        }
                        break block9;
                    }
                    if (al != null && this.equalsLabel(al)) {
                        l = (Level)((Member)al).getLevel();
                        if (l != null) {
                            this._sortOrder = l.getSortOrder();
                        }
                        break block9;
                    }
                    this._sortOrder = 4;
                }
                catch (TableException tableException) {}
            } else if (l != null) {
                this._sortOrder = l.getSortOrder();
            }
        }
        return this._sortOrder;
    }

    private boolean equalsLabel(AxisLabelInterface al) throws TableException {
        if (al != null && al instanceof Member) {
            if (Util.unequal((Object)this.getLabel(), (Object)al.getLabel()) || this.getOrdinal() != ((Member)al).getOrdinal()) {
                return false;
            }
            ParentNode p = (ParentNode)this.getParent();
            ParentNode alp = (ParentNode)((Member)al).getParent();
            while (Util.equal((Object)p.getLabel(), (Object)alp.getLabel())) {
                if (p.equals(p.getParent()) && alp.equals(alp.getParent())) {
                    return true;
                }
                if (p.equals(p.getParent()) || alp.equals(alp.getParent())) break;
                p = (ParentNode)p.getParent();
                alp = (ParentNode)alp.getParent();
            }
        }
        return false;
    }

    private void clearLevelSort(boolean statLevelOnly) {
        try {
            AxisInterface[] axes = this.Imddb.getAxes(0, -1);
            boolean j = false;
            for (int i = 0; i < axes.length; ++i) {
                Axis a;
                LevelInterface[] ls;
                if (axes[i].equals(this.getAxis()) || (ls = (a = (Axis)axes[i]).getLevels()) == null || ls.length <= 0 || statLevelOnly) continue;
                ((Level)ls[ls.length - 1]).setSortDirection("None");
            }
        }
        catch (TableException te) {
            return;
        }
    }

    public boolean isExecutable() {
        return this.getAxis() != null;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void execute(Object object) {
        try {
            Command defaultCommand = this.getDefaultCommand();
            if (defaultCommand != null) {
                defaultCommand.execute(null);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private Command getDefaultCommand() throws TableException {
        block7: {
            Command[] c;
            int version;
            String defaultAction;
            String action;
            block6: {
                Command[] c2;
                action = null;
                defaultAction = null;
                long defaultActionMask = 0L;
                version = 1;
                if (this.Imddb instanceof MultidimensionalTableV3Interface) {
                    version = 3;
                } else if (this.Imddb instanceof MultidimensionalTableV2Interface) {
                    version = 2;
                }
                if (version != 3) break block6;
                defaultActionMask = ((MultidimensionalTableV3Interface)this.Imddb).getDefaultActionMask();
                if (defaultActionMask <= 0L || (c2 = MDCommand.getCommands(this)) == null || c2.length <= 0) break block7;
                for (int i = 0; i < c2.length; ++i) {
                    if (!(c2[i] instanceof MDCommand) || ((MDCommand)c2[i]).getMask() != defaultActionMask) continue;
                    return c2[i];
                }
                break block7;
            }
            if (version == 2 && (defaultAction = ((MultidimensionalTableV2Interface)this.Imddb).getDefaultAction()) != null && !defaultAction.equals("NOT_SUPPORTED") && (c = MDCommand.getCommands(this)) != null && c.length > 0) {
                for (int i = 0; i < c.length; ++i) {
                    action = c[i].getText();
                    if (!action.equalsIgnoreCase(defaultAction)) continue;
                    return c[i];
                }
            }
        }
        return null;
    }

    public String getText() {
        return this.getName();
    }

    public void setText(String name) {
        this.setName(name);
    }

    public boolean isComputedValue() {
        return this.getName().startsWith("CV");
    }

    public boolean isTotal() {
        return this.getName().startsWith("_T");
    }

    class ChildrenReader
    extends AbstractChildrenReader {
        ChildrenReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            MemberInterface[] mi = null;
            if (Member.this.dependents != null) {
                int sIndex = (int)startOrdinal;
                int eIndex = (int)endOrdinal;
                Level level = (Level)Member.this.getLevel();
                Axis axis = (Axis)level.getRootParent();
                try {
                    LevelInterface[] axisLevels = axis.getLevels();
                    int levelId = level.getAxisOffset();
                    if (levelId < axisLevels.length - 1) {
                        Level nextLevel = (Level)axisLevels[++levelId];
                        int cnt = eIndex - sIndex + 1;
                        if (cnt > Member.this.dependents.count() - sIndex) {
                            cnt = Member.this.dependents.count() - sIndex;
                            eIndex = sIndex + cnt - 1;
                        }
                        mi = new MemberInterface[cnt];
                        int idx = 0;
                        boolean j = false;
                        for (int i = sIndex; i <= eIndex; ++i) {
                            Member delegate = (Member)nextLevel.getMember(Integer.parseInt(Member.this.dependents.getName(i)));
                            Member member = null;
                            member = delegate.isTotal() ? new TotalMember(Member.this, Member.this.Imddb) : new Member(Member.this, Member.this.Imddb);
                            member.dependents = Member.this.dependents.getList(i);
                            member.setOrdinal(levelId);
                            member.setDelegate(delegate);
                            mi[idx++] = member;
                        }
                    }
                }
                catch (TableException te) {
                    te.printStackTrace();
                }
            }
            return mi;
        }

        @Override
        public int count() {
            if (this.count == -1) {
                this.count = Member.this.dependents != null ? Member.this.dependents.count() : 0;
            }
            return this.count;
        }

        @Override
        public int getCacheKeyUse() {
            return 0;
        }
    }
}

