/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class MDTableUtil {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static HList convertHexStringToHList(String hexString) {
        byte[] hlistData = MDTableUtil.convertHexStringToByteArray(hexString);
        HList hlist = new HList();
        Byte firstByte = new Byte(hlistData[0]);
        try {
            if (firstByte.toString().equals("95")) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(hlistData);
                int underscore = byteStream.read();
                GZIPInputStream zipInputStream = new GZIPInputStream(byteStream);
                DataInputStream stream = new DataInputStream(zipInputStream);
                hlist.read(stream);
                stream.close();
                zipInputStream.close();
                byteStream.close();
            } else {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(hlistData);
                DataInputStream stream = new DataInputStream(byteStream);
                hlist.read(stream);
                stream.close();
                byteStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hlist;
    }

    private static byte[] convertHexStringToByteArray(String hexString) {
        int length = hexString.length() / 2;
        byte[] byteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            String s = "#" + hexString.substring(i * 2, i * 2 + 2);
            byteArray[i] = Integer.decode(s).byteValue();
        }
        return byteArray;
    }

    public static String convertHListToHexString(HListInterface infoList) {
        String hlistDataString = "";
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byteStream.write(95);
            GZIPOutputStream zipOutputStream = new GZIPOutputStream(byteStream);
            DataOutputStream stream = new DataOutputStream(zipOutputStream);
            infoList.write(stream);
            stream.close();
            zipOutputStream.close();
            byte[] hlistData = byteStream.toByteArray();
            byteStream.close();
            hlistDataString = MDTableUtil.convertByteArrayToHexString(hlistData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hlistDataString;
    }

    private static String convertByteArrayToHexString(byte[] hlistData) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < hlistData.length; ++i) {
            buffer.append(MDTableUtil.getByte(hlistData[i]));
        }
        return buffer.toString();
    }

    private static String getByte(byte data) {
        int lowNibble = data & 0xF;
        int highNibble = (data & 0xF0) >> 4;
        StringBuffer buffer = new StringBuffer();
        buffer.append(hexDigits[highNibble]);
        buffer.append(hexDigits[lowNibble]);
        return buffer.toString();
    }
}

