/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.AssociationList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Hierarchy;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.SortInterface;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.sasserver.mdtable.TotalMember;
import com.sas.sasserver.mdtable.commands.ComputedValuesCommand;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.sasserver.mdtable.commands.LevelNameCommand;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.commands.RangeTypesCommand;
import com.sas.sasserver.mdtable.commands.ShowDetailCommand;
import com.sas.sasserver.mdtable.commands.SubsetsCommand;
import com.sas.sasserver.mdtable.commands.TotalsCommand;
import com.sas.table.TableException;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class Level
extends ParentNode
implements LevelInterface,
TotalInterface,
SubsetInterface,
SortInterface,
ComputedValueInterface,
CommandsInterface {
    static final long serialVersionUID = -2850629519433376481L;
    private transient int axisOffset;
    private Object[] _subset;
    private Object[] _drillSubset;
    AssociationList _computedValues;
    public boolean refreshSubset;
    public boolean refreshDrillSubset;
    public boolean refreshTotal;
    public boolean refreshComputedValues;
    public transient boolean _isDown;
    public transient AxisLabelInterface _upMember;
    protected transient String _sortDirection;
    protected transient int _sortOrder;
    private transient boolean refreshSort;
    private transient StaticPropertyBagInterface _cellStyles;
    private transient StaticPropertyBagInterface _labelStyles;
    protected static final String RB_KEY = "Member.";

    public Level(Hierarchy hierarchy, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.setParent(hierarchy);
        this._sortOrder = 4;
        this.reset();
    }

    public Level(Hierarchy hierarchy, String name, String label, MultidimensionalTableInterface mdDelegate) throws TableException {
        this(hierarchy, mdDelegate);
        this.setName(name);
        this.setLabel(label);
    }

    public Level(String name) {
        super(name);
        this._sortOrder = 4;
        this.reset();
    }

    public Level(MultidimensionalTableInterface imddb) {
        super(imddb);
        this._sortOrder = 4;
    }

    protected void reset(boolean clearAll) {
        this.axisOffset = -1;
        this.refreshTotal = false;
        this.refreshSubset = false;
        this.refreshDrillSubset = false;
        this.refreshSort = false;
        this._isDown = false;
        this._subset = null;
        this._drillSubset = null;
        this._upMember = null;
        if (clearAll) {
            try {
                this.clearCache();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void setDefaultValues() {
        this.reset();
    }

    public Command[] getCommands() {
        if (this.Imddb instanceof MultidimensionalTableV3Interface) {
            return MDCommand.getCommands(this);
        }
        String[] actions = new String[]{};
        Command[] commands = null;
        OrderedCollection oc = new OrderedCollection();
        boolean addCV = false;
        if (this.isV2Interface) {
            this._commandsMask = ((MultidimensionalTableV2Interface)this.Imddb).getCommandsMask();
        }
        try {
            boolean v1Server = false;
            boolean v11Server = false;
            boolean needsSeparator = false;
            HList tupleList = Level.tupleToHList(this);
            int axis = this.getRootParent().getOrdinal();
            actions = this.Imddb._getActions(axis, (HListInterface)tupleList);
            if (actions == null) {
                actions = new String[]{};
            }
            if (actions.length > 0) {
                if (actions[actions.length - 1].equals(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt"))) {
                    v1Server = true;
                } else if (actions[actions.length - 1].indexOf(this.getName()) >= 0) {
                    v11Server = true;
                } else if (this.isAnalysisLevel() && actions[actions.length - 1].indexOf(com.sas.sasserver.mdtable.RB.getStringResource("showDetail.txt")) >= 0) {
                    v11Server = true;
                }
            }
            if (!v1Server && !v11Server && this.isV2Interface) {
                String label = this.getLabel();
                if (this.getName().equals("_ANLSYS_")) {
                    label = com.sas.sasserver.mdtable.RB.getStringResource("anlsys.txt");
                } else if (this.getName().equals("_STATS_")) {
                    label = com.sas.sasserver.mdtable.RB.getStringResource("stats.txt");
                }
                if (!label.equals(com.sas.sasserver.mdtable.RB.getStringResource("stats.txt")) && actions.length > 0 && actions[actions.length - 1].indexOf(label) < 0) {
                    needsSeparator = true;
                }
            }
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("computedValues.txt"))) {
                    if (!this.addComputedValuesCommand()) continue;
                    addCV = true;
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("showDetail.txt"))) {
                    if (this.addShowDetailDataCommand()) {
                        oc.add((Object)new ShowDetailCommand(this.Imddb));
                    }
                    if (oc.count() <= 0 || oc.get(oc.count() - 1) == MenuSeparatorCommand.instance()) continue;
                    oc.add((Object)MenuSeparatorCommand.instance());
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("totals.txt")) && this.addTotalsCommand()) {
                    oc.add((Object)new TotalsCommand(actions[i], this));
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("subsets.txt")) && this.addSubsetsCommand()) {
                    oc.add((Object)new SubsetsCommand(actions[i], this));
                    continue;
                }
                if (actions[i].equals("_SEPARATOR")) {
                    if (oc.count() <= 0 || oc.get(oc.count() - 1) == MenuSeparatorCommand.instance()) continue;
                    oc.add((Object)MenuSeparatorCommand.instance());
                    continue;
                }
                if (actions[i].equals(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt")) && this.addExceptionHighlightingCommand()) {
                    oc.add((Object)new RangeTypesCommand(actions[i], this));
                    continue;
                }
                if (v11Server && (actions[i].indexOf(this.getName()) < 0 || actions[i].indexOf(com.sas.sasserver.mdtable.RB.getStringResource("showDetail.txt")) >= 0)) continue;
                oc.add((Object)new MDCommand(actions[i], this));
            }
            if (!this.isV2Interface) {
                addCV = true;
            }
            if (!v1Server) {
                if (this.isV2Interface && !v1Server && !v11Server && !this.isAnalysisLevel() && actions.length > 0) {
                    oc.add((Object)new LevelNameCommand(this));
                }
                if (oc.count() > 0 && oc.get(oc.count() - 1) != MenuSeparatorCommand.instance()) {
                    oc.add((Object)MenuSeparatorCommand.instance());
                }
                if (addCV) {
                    oc.add((Object)new ComputedValuesCommand(com.sas.sasserver.mdtable.RB.getStringResource("computedValues.txt"), this));
                }
                if (this.addTotalsCommand()) {
                    oc.add((Object)new TotalsCommand(com.sas.sasserver.mdtable.RB.getStringResource("totals.txt"), this));
                }
                if (this.addSubsetsCommand()) {
                    oc.add((Object)new SubsetsCommand(com.sas.sasserver.mdtable.RB.getStringResource("subsets.txt"), this));
                }
                if (this.addExceptionHighlightingCommand()) {
                    oc.add((Object)new RangeTypesCommand(com.sas.sasserver.mdtable.RB.getStringResource("rangeTypes.txt"), this));
                }
            }
            if (this.addExportToExcelCommand()) {
                oc.add((Object)new ExportToExcelCommand(com.sas.sasserver.mdtable.RB.getStringResource("excel.txt"), this.Imddb));
            }
            if (oc.get(oc.count() - 1) == MenuSeparatorCommand.instance()) {
                oc.removeAt(oc.count() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        commands = new Command[oc.count()];
        for (int c = 0; c < commands.length; ++c) {
            commands[c] = (Command)oc.get(c);
        }
        return commands;
    }

    public static HList tupleToHList(Level level) {
        try {
            HList tupleList = new HList();
            ParentNode p = (ParentNode)level.getRootParent();
            int depth = 0;
            if (p instanceof Axis) {
                depth = level.getAxisOffset();
            }
            if (depth <= 0) {
                tupleList.addItem("", 0, level.getName());
            } else {
                LevelInterface[] axisLevels = ((Axis)level.getRootParent()).getLevels();
                String levelName = null;
                for (int i = depth; i <= axisLevels.length - 1 && i >= 0; --i) {
                    Level l = (Level)axisLevels[i];
                    levelName = level != null ? l.getName() : null;
                    tupleList.addItem("", 0, levelName);
                }
            }
            return tupleList;
        }
        catch (TableException te) {
            return null;
        }
    }

    @Override
    public DimensionInterface getDimension() {
        DimensionInterface di = null;
        Hierarchy h = null;
        if (this.getParent() instanceof Hierarchy) {
            h = (Hierarchy)this.getParent();
        } else if (this.getParent() instanceof Level) {
            h = (Hierarchy)this.getDelegate().getParent();
        }
        if (h != null) {
            di = (DimensionInterface)((Object)h.getParent());
        }
        return di;
    }

    public int getAxisOffset() throws TableException {
        if (this.axisOffset == -1) {
            Axis axis = (Axis)this.getRootParent();
            LevelInterface[] axisLevels = axis.getLevels();
            if (this.axisOffset == -1) {
                for (int i = 0; i < axisLevels.length; ++i) {
                    try {
                        String name = this.getName();
                        if (!name.equals(axisLevels[i].getName())) continue;
                        this.axisOffset = i;
                        break;
                    }
                    catch (TableException te) {
                        te.printStackTrace();
                    }
                }
            }
        }
        return this.axisOffset;
    }

    public void setAxisOffset(int offset) {
        this.axisOffset = offset;
    }

    @Override
    public int getMemberCount() throws TableException {
        return this.countNodeChildren(0);
    }

    @Override
    public MemberInterface getMember(int index) throws TableException {
        return this.getMembers(index, 1)[0];
    }

    @Override
    public MemberInterface[] getMembers(int index, int count) throws TableException {
        SimpleNodeInterface[] si;
        if (count == -1) {
            count = this.getMemberCount() - index;
        }
        if ((si = this.getNodeChildren(index, count)) == null) {
            throw new TableException();
        }
        MemberInterface[] mi = new MemberInterface[si.length];
        for (int i = 0; i < si.length; ++i) {
            mi[i] = (MemberInterface)si[i];
        }
        return mi;
    }

    @Override
    public LevelInterface getMetaLevel() {
        return (LevelInterface)((Object)this.getDelegate());
    }

    @Override
    public synchronized boolean isTotalEnabled() {
        return (Boolean)this.getProperty("TotalEnabled", Boolean.TRUE);
    }

    public synchronized void setTotalEnabled(boolean state) {
        this.setProperty("TotalEnabled", new Boolean(state));
        this.refreshTotal = true;
    }

    @Override
    public synchronized boolean getTotalState() {
        return (Boolean)this.getProperty("TotalState", Boolean.FALSE);
    }

    @Override
    public synchronized void setTotalState(boolean state) {
        this.setProperty("TotalState", new Boolean(state));
        this.refreshTotal = true;
    }

    @Override
    public synchronized String getTotalLabel() {
        return (String)this.getProperty("TotalLabel", this.label);
    }

    @Override
    public synchronized void setTotalLabel(String label) {
        this.setProperty("TotalLabel", label);
        this.refreshTotal = true;
    }

    public synchronized Object[] getSubsetMember() {
        if (this._subset == null && this.getMetaLevel() != null && !this.refreshSubset) {
            Level l = (Level)this.getMetaLevel();
            Object[] subs = l.getSubset();
            this.refreshSubset = l.refreshSubset;
            return subs;
        }
        return this._subset;
    }

    @Override
    public synchronized Object[] getSubset() {
        if (this._subset == null && this.getMetaLevel() != null && !this.refreshSubset) {
            Level l = (Level)this.getMetaLevel();
            Object[] subs = l.getSubset();
            this.refreshSubset = l.refreshSubset;
            return subs;
        }
        return this._subset;
    }

    @Override
    public synchronized void setSubset(Object[] subset) {
        if (!Util.arrayEqual((Object)this._subset, (Object)subset)) {
            this._subset = subset != null && (subset.length == 0 || subset[0] == null) ? null : subset;
            this.refreshSubset = true;
        }
    }

    @Override
    public synchronized Object[] getDrillSubset() {
        if (this._drillSubset == null && this.getMetaLevel() != null && !this.refreshDrillSubset) {
            Level l = (Level)this.getMetaLevel();
            Object[] drillSubs = l.getDrillSubset();
            this.refreshDrillSubset = l.refreshDrillSubset;
            return drillSubs;
        }
        return this._drillSubset;
    }

    public synchronized void setDrillSubset(Object[] drillSubset) {
        if (!Util.arrayEqual((Object)this._drillSubset, (Object)drillSubset)) {
            this._drillSubset = drillSubset != null && (drillSubset.length == 0 || drillSubset[0] == null) ? null : drillSubset;
            this.refreshDrillSubset = true;
        }
    }

    public synchronized boolean totalNeedsRefresh() {
        boolean refresh = this.refreshTotal;
        if (this.getMetaLevel() != null) {
            refresh |= ((Level)this.getMetaLevel()).refreshTotal;
        }
        return refresh;
    }

    public synchronized void setTotalNeedsRefresh(boolean refresh) {
        if (this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            l.refreshTotal = refresh;
        }
        this.refreshTotal = refresh;
    }

    public synchronized boolean subsetNeedsRefresh() {
        boolean refresh = this.refreshSubset;
        if (this.getMetaLevel() != null) {
            refresh |= ((Level)this.getMetaLevel()).refreshSubset;
        }
        return refresh;
    }

    public synchronized void setSubsetNeedsRefresh(boolean refresh) {
        if (this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            l.refreshSubset = refresh;
        }
        this.refreshSubset = refresh;
    }

    public synchronized boolean drillSubsetNeedsRefresh() {
        boolean refresh = this.refreshDrillSubset;
        if (this.getMetaLevel() != null) {
            refresh |= ((Level)this.getMetaLevel()).refreshDrillSubset;
        }
        return refresh;
    }

    public synchronized void setDrillSubsetNeedsRefresh(boolean refresh) {
        if (this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            l.refreshDrillSubset = refresh;
        }
        this.refreshDrillSubset = refresh;
    }

    @Override
    public AssociationList getComputedValues() {
        if (this._computedValues == null && this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            AssociationList computedValues = l.getComputedValues();
            this.refreshComputedValues = l.refreshComputedValues;
            return computedValues;
        }
        if (this._computedValues != null) {
            Enumeration enumer = this._computedValues.getItems();
            AssociationList asl = new AssociationList();
            int startIndex = 0;
            block2: while (enumer.hasMoreElements()) {
                Object value = enumer.nextElement();
                String key = (String)this._computedValues.getKey(value, startIndex++);
                if (value == null) {
                    try {
                        for (int i = this.getMemberCount() - 1; i >= 0; --i) {
                            if (!key.equalsIgnoreCase(this.getMember(i).getLabel())) continue;
                            this.removeNodeChild(i);
                            continue block2;
                        }
                        continue;
                    }
                    catch (TableException tableException) {
                        continue;
                    }
                }
                asl.set((Object)key, value);
            }
            return asl;
        }
        return this._computedValues;
    }

    public AssociationList getComputedValues(boolean includeDeletes) {
        if (includeDeletes) {
            return this._computedValues;
        }
        return this.getComputedValues();
    }

    @Override
    public void setComputedValues(AssociationList computedValues) {
        if (computedValues != null && computedValues.count() == 0 || computedValues == null) {
            this._computedValues = null;
        } else {
            if (this._computedValues == null) {
                this._computedValues = new AssociationList();
            }
            int cnt = computedValues.count();
            for (int i = 0; i < cnt; ++i) {
                String key = (String)computedValues.getKey(i);
                if (key == null) continue;
                Object item = computedValues.get((Object)key);
                OrderedCollection oc = null;
                if (item != null && (oc = (OrderedCollection)item).count() == 1 && oc.get(0) == "") {
                    oc = null;
                }
                this._computedValues.set((Object)key, (Object)oc);
            }
        }
        this.refreshComputedValues = true;
    }

    public synchronized void setComputedValue(String label, Object[] expression) {
        if (this._computedValues == null) {
            this._computedValues = new AssociationList();
        }
        if (expression == null || expression.length == 1 && expression[0] == null) {
            this._computedValues.set((Object)label, null);
        } else {
            this._computedValues.set((Object)label, (Object)new OrderedCollection(expression, 5));
        }
        this.refreshComputedValues = true;
    }

    public synchronized void setComputedValueNeedsRefresh(boolean refresh) {
        if (this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            l.refreshComputedValues = refresh;
        }
        this.refreshComputedValues = refresh;
    }

    public synchronized boolean computedValueNeedsRefresh() {
        boolean refresh = this.refreshComputedValues;
        if (this.getMetaLevel() != null) {
            refresh |= ((Level)this.getMetaLevel()).refreshComputedValues;
        }
        return refresh;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        boolean totals = this.refreshTotal;
        boolean subsets = this.refreshSubset;
        boolean cvals = this.refreshComputedValues;
        boolean drillsub = this.refreshDrillSubset;
        boolean sort = this.refreshSort;
        if (this._subset != null) {
            for (int i = 0; i < this._subset.length; ++i) {
                if (this._subset[i].equals(null) && this._subset[i].equals("")) continue;
                this.refreshSubset = true;
                break;
            }
        }
        Object[] saveDrill = this._drillSubset;
        if (this._drillSubset != null) {
            this._drillSubset = null;
            this.refreshDrillSubset = false;
        }
        if (this.getTotalLabel() != null) {
            this.refreshTotal = true;
        }
        if (this.getComputedValues() != null && this.getComputedValues().count() > 0) {
            this.refreshComputedValues = true;
        }
        out.defaultWriteObject();
        this.refreshTotal = totals;
        this.refreshSubset = subsets;
        this.refreshDrillSubset = drillsub;
        this._drillSubset = saveDrill;
        this.refreshComputedValues = cvals;
        this.refreshSort = sort;
    }

    @Override
    protected StaticCacheInterface createCache() {
        return new ChildrenReader();
    }

    public MemberInterface[] getAvailableMembers() throws TableException {
        if (this._childrenCache == null) {
            this._secondaryCache = this.createCache();
            this._childrenCache = new SequentialCache(this._secondaryCache, 400, 100);
        } else {
            try {
                this.clearCache();
            }
            catch (CacheException ce) {
                throw new TableException();
            }
        }
        ((ChildrenReader)this._secondaryCache).YN = "C";
        ((ChildrenReader)this._secondaryCache).count = -1;
        this.numChildren = -1;
        MemberInterface[] mi = this.getMembers(0, -1);
        ((ChildrenReader)this._secondaryCache).YN = null;
        try {
            this.clearCache();
        }
        catch (CacheException ce) {
            throw new TableException();
        }
        return mi;
    }

    public boolean isAnalysisLevel() {
        return this.getName().equalsIgnoreCase("_ANLSYS_");
    }

    public boolean isStatisticLevel() {
        return this.getName().equalsIgnoreCase("_STATS_");
    }

    @Override
    public int getTopBottomN() {
        return 0;
    }

    @Override
    public void sort(int order) {
        if (this._sortOrder != order) {
            this.setSortOrder(order);
            if (this.Imddb instanceof MultidimensionalTableV2Interface) {
                ((MultidimensionalTableV2Interface)this.Imddb).sort(this, order);
                this.refreshSort = false;
            }
        }
    }

    @Override
    public int getSortOrder() {
        return this._sortOrder;
    }

    public void setSortOrder(int order) {
        if (this._sortOrder != order) {
            try {
                Axis a;
                this._sortOrder = order;
                if (this.getRootParent() instanceof Axis && (a = (Axis)this.getRootParent()).getOrdinal() == 1) {
                    Axis axis = (Axis)this.Imddb.getAxis(0);
                    LevelInterface[] lva = a.getLevels();
                    if (lva[lva.length - 1].equals(this)) {
                        axis.setSortIdentifier(null);
                    }
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
            this.refreshSort = true;
        }
    }

    public synchronized void setSort(boolean refresh) {
        if (this.getMetaLevel() != null) {
            Level l = (Level)this.getMetaLevel();
            l.refreshSort = refresh;
        }
        this.refreshSort = refresh;
    }

    public synchronized boolean sortNeedsRefresh() {
        boolean refresh = this.refreshSort;
        if (this.getMetaLevel() != null) {
            refresh |= ((Level)this.getMetaLevel()).refreshSort;
        }
        return refresh;
    }

    public void setSortDirection(String direction) {
        if (direction != null) {
            if (direction.equalsIgnoreCase("descending") || direction.equalsIgnoreCase(RB.getStringResource("descending.txt"))) {
                this.setSortOrder(1);
            } else if (direction.equalsIgnoreCase("ascending") || direction.equalsIgnoreCase(RB.getStringResource("ascending.txt"))) {
                this.setSortOrder(2);
            } else if (direction.equalsIgnoreCase("reset") || direction.equalsIgnoreCase(RB.getStringResource("reset.txt"))) {
                this.setSortOrder(3);
            } else if (direction.equalsIgnoreCase("None")) {
                this.setSortOrder(4);
            }
        }
    }

    public String getSortDirection() {
        int so = this.getSortOrder();
        if (so == 1) {
            this._sortDirection = RB.getStringResource("descending.txt");
        } else if (so == 2) {
            this._sortDirection = RB.getStringResource("ascending.txt");
        } else if (so == 3) {
            this._sortDirection = RB.getStringResource("reset.txt");
        } else if (so == 4) {
            this._sortDirection = "None";
        }
        return this._sortDirection;
    }

    public StaticPropertyBagInterface getTotalCellStyle() {
        return this._cellStyles;
    }

    public void setTotalCellStyle(StaticPropertyBagInterface cellStyles) {
        StaticPropertyBagInterface oldStyles = this._cellStyles;
        this._cellStyles = cellStyles;
        this.refreshTotal = true;
        if (this.Imddb != null) {
            this.Imddb.firePropertyChange("totalCellStyle", oldStyles, this._cellStyles);
        }
    }

    public StaticPropertyBagInterface getTotalLabelStyle() {
        return this._labelStyles;
    }

    public void setTotalLabelStyle(StaticPropertyBagInterface labelStyles) {
        StaticPropertyBagInterface oldStyles = this._labelStyles;
        this._labelStyles = labelStyles;
        this.refreshTotal = true;
        if (this.Imddb != null) {
            this.Imddb.firePropertyChange("totalLabelStyle", oldStyles, this._labelStyles);
        }
    }

    class ChildrenReader
    extends AbstractChildrenReader {
        public String YN = null;

        ChildrenReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            MemberInterface[] memArray = null;
            try {
                int cnt = Level.this.getMemberCount();
                if (endOrdinal == -1L || endOrdinal > (long)(cnt - 1)) {
                    endOrdinal = cnt - 1;
                }
                cnt = (int)(endOrdinal - startOrdinal + 1L);
                if (Level.this.getRootParent() instanceof Axis || Level.this.getRootParent() instanceof Dimension) {
                    HListInterface hlist;
                    if (this.YN == null || this.YN != "C") {
                        this.YN = Level.this.getRootParent() instanceof Dimension && Level.this.getDelegate() == null ? "N" : "Y";
                    }
                    if ((hlist = Level.this.Imddb._getMembers(Level.this.getName(), this.YN, (int)startOrdinal, cnt)).count() < cnt) {
                        cnt = hlist.count();
                    }
                    memArray = new MemberInterface[cnt];
                    for (int j = 0; j < cnt; ++j) {
                        String name = hlist.getName(j);
                        String label = hlist.getString(j);
                        if (name == null || name.equals("")) {
                            name = label;
                        }
                        Member mem = null;
                        mem = name.trim().toUpperCase().startsWith("_TOTAL_") ? new TotalMember(Level.this, name, label, Level.this.Imddb) : new Member(Level.this, name, label, Level.this.Imddb);
                        mem.setOrdinal((int)startOrdinal + j);
                        memArray[j] = mem;
                    }
                } else if (Level.this.getMetaLevel() != null) {
                    int memberId = -1;
                    Axis axis = (Axis)Level.this.getDelegate().getRootParent();
                    HListInterface _indexes = axis.getDependentIndexes((int)startOrdinal, cnt);
                    if (_indexes.count() < cnt) {
                        cnt = _indexes.count();
                    }
                    memArray = new MemberInterface[cnt];
                    boolean idx = false;
                    for (int i = 0; i < cnt; ++i) {
                        Member memberLabel = null;
                        memberId = Integer.parseInt(_indexes.getName(i));
                        Member delegate = (Member)Level.this.getMetaLevel().getMember(memberId);
                        memberLabel = delegate.isTotal() ? new TotalMember(Level.this.Imddb) : new Member(Level.this.Imddb);
                        memberLabel.setOrdinal(0);
                        memberLabel.dependents = _indexes.getList(i);
                        memberLabel.numChildren = memberLabel.dependents.count();
                        memberLabel.setDelegate((ExtendedNodeInterface)((Object)Level.this.getMetaLevel().getMember(memberId)));
                        memArray[i] = memberLabel;
                    }
                }
            }
            catch (TableException te) {
                throw new CacheException((Exception)((Object)te));
            }
            return memArray;
        }

        @Override
        public int count() {
            if (this.count == -1) {
                if (Level.this.getParent() instanceof Level) {
                    this.count = ((ParentNode)Level.this.getDelegate()).countNodeChildren(0);
                } else {
                    if (this.YN == null) {
                        this.YN = Level.this.getRootParent() instanceof Dimension && Level.this.getDelegate() == null ? "N" : "Y";
                    }
                    this.count = Level.this.Imddb._getMemberCount(Level.this.getName(), this.YN);
                }
            }
            return this.count;
        }
    }
}

