/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.models.CacheException;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Hierarchy;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.table.TableException;

public class Dimension
extends ParentNode
implements DimensionInterface {
    static final long serialVersionUID = -2426360926621337697L;
    private transient Level[] dimLevels;
    private transient HierarchyInterface activeHierarchy;
    private transient HListInterface hli;
    private transient int type;
    public static final int NONE = 0;
    public static final int MEASURE = 1;
    public static final int GENERATED = 2;
    protected static final String RB_KEY = "Dimension.";

    public Dimension(Axis axis, MultidimensionalTableInterface mdDelegate) {
        super(mdDelegate);
        this.setParent(axis);
        this.reset();
    }

    public Dimension(Axis axis, String name, String label, MultidimensionalTableInterface mdDelegate) throws TableException {
        this(name, label, mdDelegate);
        this.setParent(axis);
    }

    public Dimension(String name, String label, MultidimensionalTableInterface mdDelegate) throws TableException {
        super(mdDelegate);
        this.setName(name);
        this.setLabel(label);
        this.reset();
    }

    public void reset(boolean clearAll) {
        if (clearAll) {
            this.type = -1;
            this.hli = null;
            this.activeHierarchy = null;
            try {
                this.clearCache();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        this.dimLevels = null;
    }

    public void reset() {
        this.reset(true);
    }

    public int getType() {
        int returnType = this.type;
        if (returnType == -1) {
            returnType = this.getDelegate() != null ? ((Dimension)this.getDelegate()).getType() : 0;
        }
        return returnType;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public boolean isMeasure() {
        return this.type == 1;
    }

    @Override
    public AxisInterface getAxis() {
        return (AxisInterface)((Object)this.getParent());
    }

    @Override
    public int getHierarchyCount() throws TableException {
        return this.countNodeChildren(0);
    }

    @Override
    public HierarchyInterface getHierarchy(int index) throws TableException {
        return this.getHierarchies(index, 1)[0];
    }

    @Override
    public HierarchyInterface[] getHierarchies(int index, int count) throws TableException {
        SimpleNodeInterface[] si;
        if (count == -1) {
            count = this.getHierarchyCount() - index;
        }
        if ((si = this.getNodeChildren(index, count)) == null) {
            throw new TableException(RB.getStringResource(RB_KEY, "noHierarchy.ex.txt"));
        }
        HierarchyInterface[] hi = new HierarchyInterface[si.length];
        for (int i = 0; i < si.length; ++i) {
            hi[i] = (HierarchyInterface)si[i];
        }
        return hi;
    }

    @Override
    public int getLevelCount() throws TableException {
        LevelInterface[] levels = this.getLevels(0, -1);
        return levels.length;
    }

    @Override
    public LevelInterface getLevel(int index) throws TableException {
        return this.getLevels(index, 1)[0];
    }

    @Override
    public LevelInterface[] getLevels(int index, int count) throws TableException {
        if (this.dimLevels == null) {
            int cnt;
            OrderedCollection oc = new OrderedCollection();
            Axis axis = (Axis)this.getAxis();
            if (axis != null) {
                LevelInterface[] axisLevels = axis.getLevels();
                cnt = axisLevels.length;
                for (int i = 0; i < cnt; ++i) {
                    Dimension d = (Dimension)axisLevels[i].getDimension();
                    if (d.getName().equals(this.getName()) || axisLevels[i].getName().equals(this.getName())) {
                        if (d.getRootParent() instanceof Dimension) {
                            ((Level)axisLevels[i]).setParent((ExtendedNodeInterface)((Object)this.getActiveHierarchy()));
                        }
                        oc.add((Object)axisLevels[i]);
                        continue;
                    }
                    if (oc.count() <= 0) {
                        continue;
                    }
                    break;
                }
            } else {
                cnt = this.getHierarchyCount();
                for (int i = 0; i < cnt; ++i) {
                    HierarchyInterface hier = this.getHierarchy(i);
                    int lcnt = hier.getLevelCount();
                    for (int h = 0; h < lcnt; ++h) {
                        Level l = (Level)hier.getLevel(h);
                        if (oc.contains((Object)l)) continue;
                        oc.add((Object)l);
                    }
                }
            }
            cnt = oc.count();
            this.dimLevels = new Level[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.dimLevels[i] = (Level)oc.get(i);
            }
        }
        if (count == -1 || index + count > this.dimLevels.length) {
            count = this.dimLevels.length - index;
        }
        LevelInterface[] tempLevels = new LevelInterface[count];
        int offset = index;
        int i = 0;
        while (i < tempLevels.length) {
            tempLevels[i] = this.dimLevels[offset];
            ++i;
            ++offset;
        }
        return tempLevels;
    }

    public void setLevelSet(boolean levelSet) {
        if (!levelSet) {
            this.reset();
        }
    }

    @Override
    public DimensionInterface getMetaDimension() {
        return (DimensionInterface)((Object)this.getDelegate());
    }

    public HierarchyInterface getActiveHierarchy() throws TableException {
        if (this.activeHierarchy == null) {
            Dimension cubeDim = this;
            if (this.getAxis() != null) {
                cubeDim = (Dimension)this.getDelegate();
            }
            if (cubeDim != null && cubeDim.getHierarchyCount() > 0) {
                this.activeHierarchy = new Hierarchy(this, null, null, this.Imddb);
                ((Hierarchy)this.activeHierarchy).setDelegate((ExtendedNodeInterface)((Object)cubeDim.getHierarchy(0)));
            } else {
                this.activeHierarchy = new Hierarchy(this, this.getName(), this.getLabel(), this.Imddb);
            }
        }
        return this.activeHierarchy;
    }

    public void setActiveHierarchy(HierarchyInterface activeHier) {
        this.activeHierarchy = activeHier;
    }

    @Override
    protected StaticCacheInterface createCache() {
        return new ChildrenReader();
    }

    class ChildrenReader
    extends AbstractChildrenReader {
        ChildrenReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            Object[] hi;
            block13: {
                block12: {
                    hi = null;
                    if (Dimension.this.getAxis() != null) break block12;
                    if (Dimension.this.hli == null) {
                        Dimension.this.hli = Dimension.this.Imddb._getHierarchies(Dimension.this.getName());
                    }
                    if (Dimension.this.hli == null) break block13;
                    int count = (int)(endOrdinal - startOrdinal + 1L);
                    if (count > Dimension.this.hli.count()) {
                        if (readFully) {
                            throw new CacheException();
                        }
                        count = (int)((long)Dimension.this.hli.count() - startOrdinal);
                    }
                    hi = new HierarchyInterface[count];
                    int offset = (int)startOrdinal;
                    int i = 0;
                    while (i < count) {
                        String label = Dimension.this.hli.getString(offset);
                        String name = Dimension.this.hli.getName(offset);
                        if (name == null || name.equals("")) {
                            name = label;
                        }
                        if (name == null) {
                            hi[i] = null;
                        } else {
                            try {
                                hi[i] = new Hierarchy(Dimension.this, name, label, Dimension.this.Imddb);
                            }
                            catch (TableException te) {
                                hi[i] = null;
                            }
                        }
                        ++i;
                        ++offset;
                    }
                    break block13;
                }
                if (endOrdinal != startOrdinal && readFully) {
                    throw new CacheException();
                }
                hi = new HierarchyInterface[1];
                try {
                    hi[0] = Dimension.this.getActiveHierarchy();
                }
                catch (TableException te) {
                    hi[0] = null;
                }
            }
            return hi;
        }

        @Override
        public int count() {
            if (this.count == -1) {
                if (Dimension.this.getAxis() == null) {
                    if (Dimension.this.hli == null) {
                        Dimension.this.hli = Dimension.this.Imddb._getHierarchies(Dimension.this.getName());
                    }
                    this.count = Dimension.this.hli != null ? Dimension.this.hli.count() : 0;
                } else {
                    try {
                        Dimension cubeDim = (Dimension)Dimension.this.getDelegate();
                        this.count = cubeDim != null ? cubeDim.getHierarchyCount() : 0;
                    }
                    catch (TableException te) {
                        this.count = -1;
                        return 0;
                    }
                }
            }
            return this.count;
        }
    }
}

