/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import antlr.CommonAST;
import antlr.Token;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.SortedCollection;
import com.sas.collection.StringCollection;
import com.sas.collection.hlist.HList;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.measures.Length;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.Tree;
import com.sas.models.TreeInterface;
import com.sas.sasserver.mdtable.BaseMDInterfaceCustomizerPanel;
import com.sas.sasserver.mdtable.ComputedValueInterface;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.LevelTable;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.sasserver.mdtable.computedvalues.ExprLexer;
import com.sas.sasserver.mdtable.computedvalues.ExprParser;
import com.sas.sasserver.mdtable.computedvalues.ParserAST;
import com.sas.sasserver.mdtable.computedvalues.ParserError;
import com.sas.sasserver.mdtable.dialogs.NewDialog;
import com.sas.swing.dialogs.remote.FormatDialog;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.NodeView;
import com.sas.swing.visuals.TreeView;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.Comparator;
import com.sas.util.StringComparator;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.ImageView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.security.AccessControlException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ComputedValuesCustomizerPanel
extends BaseMDInterfaceCustomizerPanel
implements ActionListener,
MouseListener,
ItemListener,
PropertyChangeListener,
ListSelectionListener {
    protected transient TreeView treeview;
    protected transient JButton newButton;
    protected transient JButton deleteButton;
    protected transient JButton renameButton;
    protected transient JButton saveButton;
    protected transient JButton formatButton;
    protected transient JButton addButton;
    protected transient JList functionlb;
    protected transient TableView _membersTable;
    protected transient JLabel sampleLabel;
    protected transient JTextArea textArea;
    protected transient JComboBox functionCB;
    protected transient NewDialog _dialog;
    protected transient FormatDialog _dialog2;
    protected transient JPanel calculationPanel;
    protected transient NodeInterface rootNode;
    protected transient Tree levelTree;
    protected transient Dictionary levelDictionary;
    protected transient String prevText;
    protected transient LevelTable levelTable;
    protected transient LevelInterface _currentLevel;
    protected transient ComputedValueInterface[] levelArray;
    protected transient AssociationList functionList;
    protected transient OrderedCollection expressionList;
    protected transient SASFormat _format;
    protected transient NodeView _currentNode;
    private transient ExprParser parser;
    private transient JPanel lc1;
    private transient StringCollection sc;
    private transient int selectedIndex;
    private transient boolean _inNewAction;
    protected static final int WEBAF = 1;
    protected static final int WEBEIS = 2;
    protected static final int RUNTIME = 3;
    private transient MemberInterface[] mi;
    private transient boolean isApplied;
    private static final String LCB = "{";
    private static final String RCB = "}";
    public static final String RB_KEY = "ComputedValuesCustomizerPanel.";
    private static String VALUE = RB.getStringResource("ComputedValuesCustomizerPanel.", "value.txt");
    static boolean DEBUG = false;

    private static final void _debug(String s) {
        if (DEBUG) {
            System.out.println("ComputedValuesCustomizerPanel: " + s);
        }
    }

    public ComputedValuesCustomizerPanel() {
        this(RB.getStringResource(RB_KEY, "label.txt"), null);
    }

    public ComputedValuesCustomizerPanel(String tabName, LevelInterface level) {
        super(tabName);
        this._currentLevel = level;
    }

    @Override
    public void createGUI() {
        this.setInsets(5, 5, 5, 5);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 2, 0);
        this.setLayout((LayoutManager)layout);
        this.makeLeftPanel();
        this.makeRightPanel();
        super.setEnabled(false);
    }

    private boolean isDesignTimeEISApplication() {
        try {
            return this.getTableInterface() != this.getRuntimeTableInterface() && this.getTableInterface().getApplication() != null;
        }
        catch (TableException ex) {
            return true;
        }
    }

    @Override
    public void onInitialize() {
        if (this._alreadyInitialized || !this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this._alreadyInitialized = true;
        try {
            ((MultidimensionalTableV2Interface)this.getRuntimeTableInterface()).getStatistics(null);
        }
        catch (TableException tableException) {
            // empty catch block
        }
        ComputedValuesCustomizerPanel._debug("onInitialize");
        this.levelTree = new Tree(this.populateTree());
        this.treeview.setModel((TreeInterface)this.levelTree);
        if (this._currentLevel != null && !((Level)this._currentLevel).isStatisticLevel()) {
            try {
                this.treeview.setSelectedItem(this._currentLevel.getName());
                this.treeview.getNodeView(this._currentLevel.getName(), 1).setExpanded(true);
                this.populateMemberTable();
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        this.hideRootNode();
        this.addLinks();
        this.expressionList = new OrderedCollection();
        this.populateFunctionInfo();
        this._currentNode = this.treeview.getSelectedNode();
        this.treeview.setNodeExpandedTextDisplayed(true);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean newValue) {
        ComputedValuesCustomizerPanel._debug("setEnabled: " + newValue);
        if (newValue && this.connection == null && !this.isMetabaseAndDatabaseSet() && !this.isApplicationSet()) {
            return;
        }
        super.setEnabled(newValue);
        if (this._currentNode != null && this._currentNode.getNode() instanceof MemberNode) {
            this.setMemberEnabled();
        } else {
            this.setLevelEnabled();
        }
        if (this._currentNode == null) {
            this.newButton.setEnabled(false);
        }
    }

    private void hideRootNode() {
        NodeView nv = this.treeview.getRoot();
        if (nv != null) {
            nv.setExpanded(true);
            if (nv.getNodeChildCount() > 1 && nv.getNodeChild(1) != null) {
                ((NodeView)nv.getNodeChild(1)).setExpanded(true);
            }
            this.treeview.setRootNodeVisible(false);
        }
    }

    @Override
    public void setObject(Object object) {
        this.onClear();
        ComputedValuesCustomizerPanel._debug("setObject");
        super.setObject(object);
        this.onInitialize();
    }

    @Override
    public void setVisible(boolean visible) {
        ComputedValuesCustomizerPanel._debug("setVisible:");
        super.setVisible(visible);
    }

    private void makeLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout leftLayout = new AutoSizingGridLayout(2, 1, 5, 0);
        leftPanel.setLayout((LayoutManager)leftLayout);
        this.lc1 = new JPanel();
        this.lc1.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        AutoSizingGridLayout layout1 = new AutoSizingGridLayout(1, 1, 5, 5, false, true, true);
        this.lc1.setLayout((LayoutManager)layout1);
        this.treeview = new TreeView();
        this.treeview.initialize();
        this.treeview.setLightWeightPopupEnabled(false);
        this.treeview.setPreferredSize(new Dimension(195, 300));
        NodeView nv = this.treeview.getRoot();
        if (nv != null) {
            nv.setExpanded(true);
            if (nv.getNodeChildCount() > 1 && nv.getNodeChild(1) != null) {
                ((NodeView)nv.getNodeChild(1)).setExpanded(true);
                this.treeview.setRootNodeVisible(false);
            }
        }
        this.lc1.add(this.treeview);
        leftPanel.add(this.lc1);
        JPanel lc2 = new JPanel();
        lc2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(2, 2, 2, 5);
        lc2.setLayout((LayoutManager)layout2);
        this.newButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "newButton.txt"), (Object)"   ", (Object)"    "));
        lc2.add(this.newButton);
        this.deleteButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "deleteButton.txt"), (Object)"   ", (Object)"   "));
        lc2.add(this.deleteButton);
        this.renameButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "renameButton.txt"), (Object)"", (Object)""));
        lc2.add(this.renameButton);
        leftPanel.add(lc2);
        this.add(leftPanel);
    }

    private void makeRightPanel() {
        this.calculationPanel = new JPanel();
        AutoSizingGridLayout calculationLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        this.calculationPanel.setLayout((LayoutManager)calculationLayout);
        BaseBorder border = new BaseBorder();
        Border eBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        border.setStyle(3);
        border.setLightSource(10);
        border.setText(RB.getStringResource(RB_KEY, "border.txt"));
        border.setTextMargin(5);
        this.calculationPanel.setBorder(BorderFactory.createCompoundBorder((Border)border, eBorder));
        JPanel topContainer = new JPanel();
        AutoSizingGridLayout topLayout = new AutoSizingGridLayout(2, 2, 2, 0, true, false, false);
        topContainer.setLayout((LayoutManager)topLayout);
        JLabel functionLabel = new JLabel(RB.getStringResource(RB_KEY, "functionLabel.txt"));
        topContainer.add(functionLabel);
        JLabel memberLabel = new JLabel(RB.getStringResource(RB_KEY, "memberLabel.txt"));
        topContainer.add(memberLabel);
        JPanel inContainer = new JPanel();
        AutoSizingGridLayout inLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, false, false);
        inContainer.setLayout((LayoutManager)inLayout);
        this.functionCB = new JComboBox();
        this.functionlb = new JList();
        JScrollPane scrollPane = new JScrollPane(this.functionlb);
        scrollPane.setPreferredSize(new Dimension(150, 124));
        this.functionlb.setVisibleRowCount(8);
        inContainer.add(scrollPane);
        topContainer.add(inContainer);
        this._membersTable = new TableView();
        this._membersTable.initialize();
        this._membersTable.setRowLabelsVisible(false);
        this._membersTable.setColumnLabelsVisible(false);
        this._membersTable.setColumnsConformed(true);
        TableView.setDefaultWidth(150);
        TableView.setDefaultHeight(124);
        this._membersTable.setGridVisible(false);
        this._membersTable.setExtendedSelectionAllowed(false);
        this._membersTable.setMultipleSelectionAllowed(false);
        CellStyle cs = this._membersTable.getDefaultCellStyle();
        cs.setBottomMargin(new Length(0.0, "pt"));
        cs.setTopMargin(new Length(0.0, "pt"));
        this._membersTable.setOpaque(true);
        this._membersTable.setBackground(SystemColor.window);
        topContainer.add(this._membersTable);
        this.calculationPanel.add(topContainer);
        JPanel middleContainer = new JPanel();
        middleContainer.setLayout((LayoutManager)new AutoSizingGridLayout(3, 1, 0, 5));
        JPanel sc = new JPanel();
        sc.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2));
        Font font = Util.getDialogFont();
        JLabel sl = new JLabel(RB.getStringResource(RB_KEY, "slLabel.txt"));
        sl.setFont(new Font(font.getName(), 2, font.getSize()));
        sc.add(sl);
        this.sampleLabel = new JLabel("                                                    ");
        this.sampleLabel.setPreferredSize(new Dimension(250, 30));
        JLabel noteLabel = new JLabel(RB.getStringResource(RB_KEY, "noteLabel.txt"));
        this.sampleLabel.setFont(new Font(font.getName(), 2, font.getSize()));
        noteLabel.setFont(new Font(font.getName(), 2, font.getSize()));
        sc.add(this.sampleLabel);
        middleContainer.add(sc);
        middleContainer.add(noteLabel);
        JPanel a = new JPanel();
        AutoSizingGridLayout al = new AutoSizingGridLayout(1, 2, 0, 5);
        a.setLayout((LayoutManager)al);
        a.add(new JLabel("                         "));
        this.addButton = new JButton((Icon)new com.sas.swing.visuals.ImageView(ImageView.class, "res/DownArrow.gif"));
        this.addButton.setText(Message.format((String)RB.getStringResource(RB_KEY, "addButton.txt"), (Object)" ", (Object)"  "));
        this.addButton.setHorizontalTextPosition(4);
        a.add(this.addButton);
        middleContainer.add(a);
        this.calculationPanel.add(middleContainer);
        JPanel bottomContainer = new JPanel();
        AutoSizingGridLayout bottomLayout = new AutoSizingGridLayout(3, 1, 0, 5);
        bottomContainer.setLayout((LayoutManager)bottomLayout);
        JLabel formulaLabel = new JLabel(RB.getStringResource(RB_KEY, "formulaLabel.txt"));
        bottomContainer.add(formulaLabel);
        this.textArea = new JTextArea(3, 42);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane scrollPaneForTextArea = new JScrollPane(this.textArea);
        this.expressionList = new OrderedCollection();
        bottomContainer.add(scrollPaneForTextArea);
        JPanel bottomInContainer = new JPanel();
        AutoSizingGridLayout bottomInLayout = new AutoSizingGridLayout(1, 2, 50, 0);
        bottomInContainer.setLayout((LayoutManager)bottomInLayout);
        this.formatButton = new JButton(Message.format((String)RB.getStringResource(RB_KEY, "formatButton.txt"), (Object)"   ", (Object)"  "));
        bottomInContainer.add(this.formatButton);
        this.saveButton = new JButton(RB.getStringResource(RB_KEY, "saveButton.txt"));
        bottomInContainer.add(this.saveButton);
        bottomContainer.add(bottomInContainer);
        this.calculationPanel.add(bottomContainer);
        this.add(this.calculationPanel);
    }

    private void setMemberEnabled() {
        this.newButton.setEnabled(false);
        if (!this._inNewAction) {
            this.renameButton.setEnabled(true);
        }
        this.deleteButton.setEnabled(true);
        Util.setEnabledOnContainer(this.calculationPanel, true);
    }

    private void setLevelEnabled() {
        this.newButton.setEnabled(true);
        this.renameButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        Util.setEnabledOnContainer(this.calculationPanel, false);
    }

    private NodeInterface populateTree() {
        this.rootNode = new Node(RB.getStringResource(RB_KEY, "rootNode.txt"));
        ((Node)this.rootNode).setNodeExpandedText(RB.getStringResource(RB_KEY, "rootNode.txt"));
        try {
            if (this.getRuntimeTableInterface() != null) {
                this.levelArray = this.getRuntimeTableInterface().getComputedValues();
            }
            if (this.levelArray != null) {
                NodeComparator lc = new NodeComparator();
                SortedCollection sc = new SortedCollection((Object[])this.levelArray, (Comparator)lc, true);
                Enumeration levelNodes = sc.getItems();
                while (levelNodes.hasMoreElements()) {
                    Level l = (Level)levelNodes.nextElement();
                    if (l.isStatisticLevel()) continue;
                    LevelNode n = new LevelNode(l);
                    AssociationList asl = l.getComputedValues();
                    for (int i = 0; asl != null && i < asl.count(); ++i) {
                        n.addNodeChild((SimpleNodeInterface)new MemberNode((String)asl.getKey(i)));
                    }
                    ((Node)this.rootNode).addNodeChild((SimpleNodeInterface)n);
                }
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return this.rootNode;
    }

    public boolean addCVNode(String cvName) {
        this.textArea.setText("");
        this._format = null;
        LevelNode ln = null;
        this._currentNode = this.treeview.getSelectedNode();
        if (this._currentNode == null) {
            return false;
        }
        NodeInterface n = this._currentNode.getNode();
        if (n instanceof MemberNode) {
            ln = (LevelNode)this._currentNode.getParent().getNode();
        } else if (n instanceof LevelNode) {
            ln = (LevelNode)n;
        }
        if (!ln.isLeafNode()) {
            for (int i = 0; i < ln.getNodeChildCount(); ++i) {
                if (!((NodeInterface)ln.getNodeChild(i)).getNodeText().equalsIgnoreCase(cvName)) continue;
                return false;
            }
        }
        if (this.getMember(cvName) != null) {
            return false;
        }
        ln.addNodeChild((SimpleNodeInterface)new MemberNode(cvName));
        AssociationList cvasl = ln.getComputedValues();
        if (cvasl == null) {
            cvasl = new AssociationList();
        }
        cvasl.set((Object)cvName, null);
        NodeView pn = this._currentNode;
        if (n instanceof MemberNode) {
            pn = this._currentNode.getParent();
            pn.setExpanded(true);
        } else {
            this._currentNode.setExpanded(true);
        }
        NodeView nn = (NodeView)pn.getNodeChild(pn.getNodeChildCount() - 1);
        if (nn != null) {
            nn.setSelected(true);
        }
        this.setMemberEnabled();
        Util.setEnabledOnContainer(this.lc1, false);
        return true;
    }

    public boolean replaceCVNode(String cvName) {
        try {
            LevelNode ln = null;
            this._currentNode = this.treeview.getSelectedNode();
            NodeInterface n = this._currentNode.getNode();
            if (n instanceof MemberNode) {
                ln = (LevelNode)this._currentNode.getParent().getNode();
            } else if (n instanceof LevelNode) {
                ln = (LevelNode)n;
            }
            if (this.addCVNode(cvName)) {
                AssociationList cvasl = ln.getComputedValues();
                OrderedCollection oc = (OrderedCollection)cvasl.get((Object)n.getNodeText());
                cvasl.set((Object)cvName, (Object)oc);
                cvasl.set((Object)n.getNodeText(), null);
                ln.setComputedValues(cvasl);
                ln.removeNodeChild((SimpleNodeInterface)n);
                this.updateTextArea();
                Util.setEnabledOnContainer(this.lc1, true);
                return true;
            }
            this._currentNode.setSelected(true);
            return false;
        }
        catch (TableException te) {
            return false;
        }
    }

    @Override
    void addLinks() {
        ComputedValuesCustomizerPanel._debug("addLinks");
        this.functionlb.getSelectionModel().addListSelectionListener(this);
        this.newButton.addActionListener(this);
        this.formatButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.treeview.addMouseListener(this);
        this.treeview.addItemListener(this);
        this.functionlb.addMouseListener(this);
        this.functionCB.addItemListener(this);
        this._membersTable.addItemListener(this);
        this._membersTable.addMouseListener(this);
    }

    private void populateFunctionInfo() {
        this.functionList = new AssociationList();
        StringCollection sc = new StringCollection(RB.getStringResource(RB_KEY, "functionList.txt"), ',');
        this.functionList.set((Object)RB.getStringResource(RB_KEY, "calculationType"), (Object)sc);
        Enumeration enumer = this.functionList.getKeys();
        while (enumer.hasMoreElements()) {
            this.functionCB.addItem((String)enumer.nextElement());
        }
        this.functionCB.setSelectedIndex(0);
        this.functionlb.setListData(((StringCollection)this.functionList.get(this.functionCB.getSelectedItem())).toStringArray());
        this.selectedIndex = this.functionlb.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.newButton) {
            this.renameButton.setEnabled(false);
            this._inNewAction = true;
            this.newRenameUpdate(true);
        } else if (source == this.deleteButton) {
            this.deleteUpdate();
        } else if (source == this.renameButton) {
            this.newRenameUpdate(false);
        } else if (source == this.addButton) {
            this.setFormula();
            this.addToTextArea();
            this.textArea.requestFocus();
        } else if (source == this.saveButton) {
            this.saveButtonUpdate();
        } else if (source == this.formatButton) {
            this.formatUpdate();
        }
    }

    private MemberInterface getMember(String memberLabel) {
        Level l = this.getLevel();
        MemberInterface member = null;
        try {
            Level delegate = (Level)l.getDelegate();
            MultidimensionalTableInterface mddb = this.getMDDB();
            if (mddb instanceof MultidimensionalTableV2Interface) {
                MultidimensionalTableV2Interface v2Imddb = (MultidimensionalTableV2Interface)mddb;
                int index = -1;
                index = v2Imddb.findCubeMember(l.getName(), memberLabel, false, true);
                ComputedValuesCustomizerPanel._debug("index:" + index + " delgate:" + delegate);
                if (index != -1 && delegate != null) {
                    member = (MemberInterface)delegate.getNodeChild(index);
                }
            } else {
                if (this.mi == null && delegate != null) {
                    this.mi = delegate.getMembers(0, -1);
                }
                member = this.getV1Member(this.mi, memberLabel);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return member;
    }

    private MemberInterface getV1Member(MemberInterface[] mi, String memberLabel) {
        Level l = this.getLevel();
        MemberInterface member = null;
        try {
            for (int j = 0; mi != null && j < mi.length && !memberLabel.equals((member = mi[j]).getLabel()); ++j) {
                member = null;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return member;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (e.getClickCount() == 2 && source == this._membersTable) {
            this.setFormula();
            this.addToTextArea();
        } else if (source == this.functionlb) {
            this.setSample();
            if (e.getClickCount() == 2) {
                this.setFormula();
                this.addToTextArea();
            }
        }
        this.textArea.requestFocus();
    }

    private void updateTextArea() {
        OrderedCollection oc;
        LevelNode ll = this.getLevelNode();
        AssociationList cvasl = ll.getComputedValues();
        this._format = null;
        if (cvasl != null && cvasl.containsKey((Object)this._currentNode.getNodeText()) && (oc = (OrderedCollection)cvasl.get((Object)this._currentNode.getNodeText())) != null) {
            Enumeration enumer = oc.getItems();
            this.textArea.setText("");
            while (enumer.hasMoreElements()) {
                Object o = enumer.nextElement();
                try {
                    if (o instanceof MemberInterface) {
                        this.textArea.append(LCB + ((MemberInterface)o).getLabel() + RCB + " ");
                        continue;
                    }
                    if (o instanceof String) {
                        if (((String)o).startsWith("FORMAT=")) {
                            String formatString = ((String)o).substring(7);
                            if (formatString.length() > 0) {
                                this._format = SASFormat.getInstance((String)formatString);
                                continue;
                            }
                            this._format = null;
                            continue;
                        }
                        this.textArea.append(o + " ");
                        continue;
                    }
                    if (o == null) continue;
                    this.textArea.append(o + " ");
                }
                catch (TableException tableException) {}
            }
        }
    }

    private void setSample() {
        int index = this.functionlb.getSelectedIndex();
        if (this.functionCB.getSelectedIndex() == 0) {
            switch (index) {
                case 0: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "sumFormula"), (Object)VALUE));
                    break;
                }
                case 1: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "differenceFormula"), (Object)VALUE));
                    break;
                }
                case 2: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "minFormula"), (Object)VALUE));
                    break;
                }
                case 3: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "maxFormula"), (Object)VALUE));
                    break;
                }
                case 4: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "meanFormula"), (Object)VALUE));
                    break;
                }
                case 5: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "percentFormula"), (Object)VALUE));
                    break;
                }
                case 6: {
                    this.sampleLabel.setText(Message.format((String)RB.getStringResource(RB_KEY, "ratioFormula"), (Object)VALUE));
                    break;
                }
                default: {
                    this.sampleLabel.setText("");
                }
            }
        }
    }

    private void setFormula() {
        int index = this.functionlb.getSelectedIndex();
        int start = this.textArea.getSelectionStart();
        int end = this.textArea.getSelectionEnd();
        int pos = this.textArea.getCaretPosition();
        int len = VALUE.length();
        if (this.functionCB.getSelectedIndex() == 0) {
            switch (index) {
                case 0: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "sumText"), (Object)VALUE), start, end);
                        this.textArea.select(start + 4, start + 4 + len);
                        this.textArea.setCaretPosition(start + 4);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "sumText"), (Object)VALUE), pos);
                    this.textArea.select(pos + 4, pos + 4 + len);
                    break;
                }
                case 1: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "differenceFormula"), (Object)VALUE), start, end);
                        this.textArea.select(start + 4, start + 4 + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "differenceFormula"), (Object)VALUE), pos);
                    this.textArea.select(pos + 4, pos + 4 + len);
                    break;
                }
                case 2: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "minText"), (Object)VALUE), start, end);
                        this.textArea.select(start + 4, start + 4 + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "minText"), (Object)VALUE), pos);
                    this.textArea.select(pos + 4, pos + 4 + len);
                    break;
                }
                case 3: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "maxText"), (Object)VALUE), start, end);
                        this.textArea.select(start + 4, start + 4 + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "maxText"), (Object)VALUE), pos);
                    this.textArea.select(pos + 4, pos + 4 + len);
                    break;
                }
                case 4: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "meanFormula"), (Object)VALUE), start, end);
                        this.textArea.select(start + 5, start + 5 + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "meanFormula"), (Object)VALUE), pos);
                    this.textArea.select(pos + 5, pos + 5 + len);
                    break;
                }
                case 5: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "percentFormula"), (Object)VALUE), start, end);
                        this.textArea.select(start, start + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "percentFormula"), (Object)VALUE), pos);
                    this.textArea.select(pos, pos + len);
                    break;
                }
                case 6: {
                    if (start != end) {
                        this.textArea.replaceRange(Message.format((String)RB.getStringResource(RB_KEY, "ratioFormula"), (Object)VALUE), start, end);
                        this.textArea.select(start, start + len);
                        break;
                    }
                    this.textArea.insert(Message.format((String)RB.getStringResource(RB_KEY, "ratioFormula"), (Object)VALUE), pos);
                    this.textArea.select(pos, pos + len);
                    break;
                }
            }
            this.functionlb.clearSelection();
        }
    }

    private void addToTextArea() {
        Enumeration enumer = this._membersTable.getSelectedCells();
        int start = 0;
        int end = 0;
        if (enumer.hasMoreElements()) {
            try {
                DataCell c = (DataCell)enumer.nextElement();
                String m = (String)c.getObjectData();
                start = this.textArea.getSelectionStart();
                end = this.textArea.getSelectionEnd();
                int len = VALUE.length();
                if (start != end) {
                    this.textArea.replaceRange(LCB + m + RCB, start, end);
                } else {
                    this.textArea.insert(LCB + m + RCB, start);
                }
                String s = this.textArea.getText();
                int i = s.indexOf(VALUE);
                if (i >= 0) {
                    this.textArea.select(i, i + len);
                } else {
                    this.textArea.setCaretPosition(s.length());
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        this._membersTable.unselect();
        this.textArea.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setSample();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.functionCB) {
            this.functionCBUpdate();
        } else if (source == this.functionlb) {
            this.setSample();
        } else if (source == this.treeview && ie.getStateChange() == 1) {
            Object item = ie.getItem();
            if (item != null && item.toString().equals(this.rootNode.getNodeText())) {
                this.newButton.setEnabled(false);
                this.renameButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                return;
            }
            Level level = this.getLevel();
            LevelNode ll = this.getLevelNode();
            if (level != this._currentLevel) {
                this.populateMemberTable();
                if (level != null) {
                    this._currentLevel = level;
                }
            }
            if (this._currentNode != null && this._currentNode.getNode() instanceof LevelNode) {
                this.setLevelEnabled();
            } else if (this._currentNode != null && this._currentNode.getNode() instanceof MemberNode) {
                this.setMemberEnabled();
                this.updateTextArea();
                return;
            }
            this.textArea.setText("");
        }
    }

    private LevelNode getLevelNode() {
        NodeInterface n;
        this._currentNode = this.treeview.getSelectedNode();
        LevelNode ln = null;
        if (this._currentNode != null && (n = this._currentNode.getNode()) != null) {
            if (n instanceof MemberNode) {
                ln = (LevelNode)this._currentNode.getParent().getNode();
            } else if (n instanceof LevelNode) {
                ln = (LevelNode)this._currentNode.getNode();
            }
        }
        return ln;
    }

    private Level getLevel() {
        NodeInterface n;
        this._currentNode = this.treeview.getSelectedNode();
        Level level = null;
        if (this._currentNode != null && (n = this._currentNode.getNode()) != null) {
            LevelNode ln = null;
            if (n instanceof MemberNode) {
                ln = (LevelNode)this._currentNode.getParent().getNode();
            } else if (n instanceof LevelNode) {
                ln = (LevelNode)this._currentNode.getNode();
            }
            if (ln != null) {
                String l = ln.getNodeText();
                for (int i = 0; i < this.levelArray.length; ++i) {
                    if (!this.levelArray[i].getName().equals(l) || !(this.levelArray[i] instanceof Level)) continue;
                    level = (Level)this.levelArray[i];
                    break;
                }
            }
        }
        return level;
    }

    private void functionCBUpdate() {
        String categoryName = (String)this.functionCB.getSelectedItem();
        StringCollection sc = (StringCollection)this.functionList.get((Object)categoryName);
        if (sc != null) {
            this.functionlb.setListData(sc.toStringArray());
        } else {
            this.functionlb.removeAll();
        }
    }

    private void newRenameUpdate(boolean isNew) {
        JFrame f = com.sas.swing.visuals.util.Util.getParentFrame((Component)this);
        if (f == null) {
            f = new JFrame();
        }
        this._dialog = new NewDialog((Frame)f, isNew, true, this);
        Util.centerOverWindow(this._dialog, this);
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private void formatUpdate() {
        int _formatsOnComputedValues = 0;
        Frame f = Util.getParentFrame(this);
        if (f == null) {
            f = new Frame();
        }
        MultidimensionalTableInterface mddb = this.getMDDB();
        if (this.getMode() == 3) {
            HList hl = (HList)mddb._getCustomizations("FORMATSONCOMPUTEDVALUES");
            if (hl.itemExists("FORMATSONCOMPUTEDVALUES", 1, 0)) {
                _formatsOnComputedValues = (int)hl.getDouble("FORMATSONCOMPUTEDVALUES");
            }
        } else {
            _formatsOnComputedValues = 1;
        }
        if (_formatsOnComputedValues <= 0) {
            MessageBoxErrorHandler eh = new MessageBoxErrorHandler(f);
            eh.handleError(mddb, new Message(RB.getStringResource(RB_KEY, "servererror")), "");
        } else {
            if (this._format == null) {
                this._format = SASNumericFormat.getInstance((String)"F8.0");
            }
            this._dialog2 = new FormatDialog(f, this._format);
            this._dialog2.addPropertyListener(this);
            this._dialog2.pack();
            this._dialog2.setSize(400, 500);
            Util.centerOverWindow(this._dialog2, this);
            this._dialog2.setVisible(true);
        }
    }

    protected int getMode() {
        try {
            String webAFdir = System.getProperty("webaf.project.directory");
            if (webAFdir != null && webAFdir.length() != 0) {
                return 1;
            }
        }
        catch (AccessControlException webAFdir) {
            // empty catch block
        }
        try {
            String webEISdir = System.getProperty("webeis.document.directory");
            if (webEISdir != null && webEISdir.length() != 0) {
                return 2;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return 3;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        String propertyName = e.getPropertyName();
        if (e.getNewValue() instanceof SASFormat) {
            SASFormat newFormat = (SASFormat)e.getNewValue();
            this.setFormat(newFormat);
        }
        super.propertyChange(e);
    }

    private void deleteUpdate() {
        NodeView n;
        LevelNode ll = this.getLevelNode();
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        if (this._currentLevel != level) {
            this._currentLevel = level;
        }
        NodeView pn = this._currentNode.getParent();
        AssociationList cvasl = ll.getComputedValues();
        if (cvasl != null) {
            String label = this._currentNode.getNodeText();
            if (cvasl.containsKey((Object)label)) {
                cvasl.set((Object)label, null);
                try {
                    ll.setComputedValues(cvasl);
                }
                catch (TableException tableException) {
                    // empty catch block
                }
                ((Node)pn.getNode()).removeNodeChild((SimpleNodeInterface)((Node)this._currentNode.getNode()));
            }
        } else if (pn.getNode() instanceof LevelNode) {
            ((Node)pn.getNode()).removeNodeChild((SimpleNodeInterface)((Node)this._currentNode.getNode()));
        }
        this.textArea.setText("");
        pn.setSelected(true);
        this._currentNode = n = this.treeview.getSelectedNode();
        if (n != null && n.getNode() instanceof LevelNode) {
            this.setLevelEnabled();
        } else if (n != null && n.getNode() instanceof MemberNode) {
            this.setMemberEnabled();
        } else if (n == null) {
            this.setLevelEnabled();
            this.newButton.setEnabled(false);
        }
        Util.setEnabledOnContainer(this.lc1, true);
        this.isApplied = false;
        this._inNewAction = false;
    }

    private boolean saveButtonUpdate() {
        NodeView pn;
        int ec = this.parseExpression();
        if (ec > 0) {
            return false;
        }
        Level level = this.getLevel();
        LevelNode ll = this.getLevelNode();
        AssociationList cvasl = ll.getComputedValues();
        if (cvasl == null) {
            cvasl = new AssociationList();
        }
        if (this.isValid()) {
            cvasl.set((Object)this._currentNode.getNodeText(), (Object)this.expressionList);
            try {
                if (ll != null) {
                    ll.setComputedValues(cvasl);
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        this._currentNode = pn = this._currentNode.getParent();
        if (pn != null) {
            pn.setSelected(true);
            this.setLevelEnabled();
        }
        this.textArea.setText("");
        Util.setEnabledOnContainer(this.lc1, true);
        this.mi = null;
        this.isApplied = false;
        this._inNewAction = false;
        return true;
    }

    private String removeBraces(String text) {
        String t = text;
        if (text.startsWith(LCB) && text.endsWith(RCB)) {
            t = text.substring(1, text.length() - 1);
        }
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tokenizeText(String text1, boolean addToList) {
        MultidimensionalTableInterface mddb;
        String origText = this.textArea.getText();
        String t = this.replaceMember(text1);
        StringReader st = new StringReader(t);
        ExprLexer l = new ExprLexer(st);
        if (!addToList) {
            this.expressionList = new OrderedCollection();
        }
        if (!((mddb = this.getMDDB()) instanceof MultidimensionalTableV2Interface) && this.mi == null) {
            try {
                Level level = (Level)this.getLevel().getDelegate();
                if (level != null) {
                    this.mi = level.getMembers(0, -1);
                }
            }
            catch (TableException level) {
                // empty catch block
            }
        }
        try {
            Token tok = l.nextToken();
            String text = tok.getText();
            int i = 0;
            while (tok.getType() != 1 || text != null) {
                if (tok.getType() == 6) {
                    text = (String)this.sc.get(i++);
                    text = this.removeBraces(text);
                    MemberInterface m = null;
                    m = mddb instanceof MultidimensionalTableV2Interface ? this.getMember(text) : this.getV1Member(this.mi, text);
                    if (m == null) {
                        this.displayError(0);
                        return false;
                    }
                    if (((Member)m).isComputedValue()) {
                        OrderedCollection ecv = this.explodeCV((Member)m);
                        if (ecv == null) return false;
                        this.expressionList.addItems(ecv.getItems());
                    } else if (!addToList) {
                        if (((Member)m).getDelegate() != null) {
                            m = (Member)((Member)m).getDelegate();
                        }
                        this.expressionList.add((Object)m);
                    }
                } else if (!addToList) {
                    this.expressionList.add((Object)text);
                }
                tok = l.nextToken();
                text = tok.getText();
            }
            if (this._format == null) return true;
            this.expressionList.add((Object)("FORMAT=" + this._format.getName()));
            return true;
        }
        catch (Exception io) {
            System.err.println(RB.getStringResource(RB_KEY, "ioexception"));
            return false;
        }
    }

    private String replaceMember(String t) {
        this.sc = new StringCollection();
        StringBuffer sb = new StringBuffer(t);
        int leftIndex = t.indexOf(LCB);
        int rightIndex = t.indexOf(RCB);
        while (leftIndex < t.length() && leftIndex < rightIndex) {
            this.sc.add(t.substring(leftIndex + 1, rightIndex));
            char ch = 'a';
            while (leftIndex < rightIndex - 1) {
                sb.setCharAt(++leftIndex, ch);
            }
            leftIndex = t.indexOf(LCB, rightIndex);
            if (leftIndex <= 0) break;
            rightIndex = t.indexOf(RCB, leftIndex);
        }
        return sb.toString();
    }

    private OrderedCollection explodeCV(Member m) {
        OrderedCollection oc = null;
        if (this._currentNode.getNodeText().equalsIgnoreCase(m.getLabel())) {
            this.displayError(1);
            return oc;
        }
        AssociationList asl = ((Level)this._currentLevel).getComputedValues();
        if (asl != null && asl.containsKey((Object)m.getLabel())) {
            oc = (OrderedCollection)asl.get((Object)m.getLabel());
            int j = 0;
            String item = "";
            while (j < oc.count()) {
                Object o;
                if ((o = oc.get(j++)) instanceof Member) {
                    if (((Member)o).isComputedValue()) {
                        oc.addItems(this.explodeCV((Member)o).getItems(), j - 1);
                        oc.remove(o);
                        return oc;
                    }
                    item = item + LCB + ((Member)o).getLabel() + RCB;
                    continue;
                }
                if (!(o instanceof String)) continue;
                item = item + (String)o;
            }
            return oc;
        }
        return oc;
    }

    public int parseExpression() {
        int errorCount = 0;
        String origText = this.textArea.getText();
        String text = this.replaceMember(origText);
        StringReader st = new StringReader(text);
        ExprLexer lexer = new ExprLexer(st);
        if (!this.tokenizeText(origText, false)) {
            return 1;
        }
        lexer.setTokenObjectClass("com.sas.sasserver.mdtable.computedvalues.ColumnToken");
        this.parser = new ExprParser(lexer);
        this.parser.setASTNodeType("com.sas.sasserver.mdtable.computedvalues.ParserAST");
        try {
            this.parser.topRule();
        }
        catch (Exception io) {
            System.err.println(RB.getStringResource(RB_KEY, "ioexception"));
        }
        errorCount = this.parser.getErrorCount();
        if (errorCount > 0) {
            ParserError error = this.parser.getErrorRecord(0);
            int column = error.mSourceIndex;
            this.textArea.select(column, column + 1);
            this.displayError(0);
        } else {
            CommonAST t = (CommonAST)this.parser.getAST();
            this.verifyTree(t);
        }
        return errorCount;
    }

    private void displayError(int errorNum) {
        String findError = RB.getStringResource(RB_KEY, "parseError.txt");
        if (errorNum == 1) {
            findError = RB.getStringResource(RB_KEY, "parseError1.txt");
        }
        JOptionPane.showMessageDialog(null, RB.getStringResource(RB_KEY, "errorTitle.txt"), "Error", 2);
    }

    public boolean valid(ParserAST ast, String textString) {
        return true;
    }

    public boolean verifyTree(CommonAST t) {
        boolean okay = this.valid((ParserAST)t, t.getText());
        if (!okay) {
            return false;
        }
        for (CommonAST child = (CommonAST)t.getFirstChild(); child != null; child = (CommonAST)child.getNextSibling()) {
            if (this.verifyTree(child)) continue;
            return false;
        }
        return true;
    }

    private void populateMemberTable() {
        Level l = this.getLevel();
        if (l != null) {
            Level le = (Level)l.getDelegate();
            if (le == null) {
                le = l;
            }
            if (this.levelTable == null) {
                this.levelTable = new LevelTable(le, false, false);
                this._membersTable.setModel(null);
                this._membersTable.setModel(this.levelTable);
            } else if (this._currentLevel != l) {
                this.levelTable.setLevel(le);
                this._membersTable.refresh(this.levelTable);
                this._currentLevel = l;
            }
        }
    }

    public void refreshMembers() {
        if (this.levelTable != null) {
            this.levelTable.reset();
        }
    }

    @Override
    public void preCustomizerClosing() {
        if (this.isVisible()) {
            this.onHidden();
        }
        this.getTableInterface().removePropertyChangeListener(this);
        this.finish(false, false);
        super.preCustomizerClosing();
    }

    public boolean finish(boolean _wasCancelled, boolean isApply) {
        boolean isOk = true;
        try {
            if (!_wasCancelled) {
                int cnt;
                String s = this.textArea.getText();
                this._currentNode = this.treeview.getSelectedNode();
                if (s == null || s.length() == 0 && this._currentNode != null && this._currentNode.getNode() instanceof MemberNode) {
                    this.displayError(0);
                    return false;
                }
                if (s != null && s.length() > 0) {
                    isOk = this.saveButtonUpdate();
                }
                if (isOk && !this.isApplied && this.rootNode != null && (cnt = this.rootNode.getNodeChildCount()) > 0) {
                    SimpleNodeInterface[] si = this.rootNode.getNodeChildren(0, cnt);
                    ComputedValueInterface[] li = new ComputedValueInterface[si.length];
                    for (int i = 0; i < si.length; ++i) {
                        LevelNode ln = (LevelNode)si[i];
                        li[i] = ln.getLevel();
                        if (!ln.computedValueNeedsRefresh()) continue;
                        ln.getLevel().setComputedValues(ln.getComputedValues());
                    }
                    this.getTableDelegate().setComputedValues(li);
                    this.isApplied = true;
                }
            } else {
                this.setAppliedOnHide(false);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return isOk;
    }

    public void setFormat(SASFormat format) {
        this._format = format;
    }

    @Override
    protected void disposeRemoteObjects() {
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().removePropertyChangeListener(this);
        }
        super.disposeRemoteObjects();
    }

    @Override
    protected boolean createRuntimeTable() {
        return !this.isRuntimeTableReady() && this.isMetabaseAndDatabaseSet();
    }

    @Override
    public void onApply() {
        if (!this.isRuntimeTableReady() || this.isDesignTimeEISApplication()) {
            return;
        }
        this.finish(false, true);
    }

    @Override
    public void onVisible() {
        ComputedValuesCustomizerPanel._debug("onVisible");
        try {
            this.onInitialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateData() throws TableException {
        ComputedValuesCustomizerPanel._debug("updatData");
        if (this.getRuntimeTableInterface() != null) {
            this.getRuntimeTableInterface().addPropertyChangeListener(this);
        }
        if (this.isVisible()) {
            this.onVisible();
        }
    }

    @Override
    public void onClear() {
        this._alreadyInitialized = false;
        try {
            if (this.getTableDelegate() != null) {
                this.getTableDelegate().setComputedValues(null);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        this.treeview.setModel(null);
        this._membersTable.setModel(null);
        super.setEnabled(false);
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object node1, Object node2) {
            StringComparator sc = new StringComparator(true);
            if (node1 instanceof ExtendedNodeInterface && node2 instanceof ExtendedNodeInterface) {
                return sc.compare((Object)((ParentNode)node1).getLabel(), (Object)((ParentNode)node2).getLabel());
            }
            return Integer.MAX_VALUE;
        }
    }

    class PopupCommand
    implements Command {
        String _commandName;

        PopupCommand(String commandName) {
            this.setText(commandName);
        }

        public void setText(String commandName) {
            this._commandName = commandName.trim();
        }

        public String getText() {
            return this._commandName;
        }

        public void execute(Object o) {
            if (Message.format((String)RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "deleteButton.txt"), (Object)"", (Object)"").trim().indexOf(this._commandName) >= 0) {
                ComputedValuesCustomizerPanel.this.deleteUpdate();
            } else if (RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "newButton.txt").trim().indexOf(this._commandName) >= 0) {
                ComputedValuesCustomizerPanel.this.newRenameUpdate(true);
            } else if (RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "renameButton.txt").trim().indexOf(this._commandName) >= 0) {
                ComputedValuesCustomizerPanel.this.newRenameUpdate(false);
            } else if (RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "formatButton.txt").trim().indexOf(this._commandName) >= 0) {
                ComputedValuesCustomizerPanel.this.formatUpdate();
            }
        }

        public boolean isExecutable() {
            return true;
        }

        public boolean isUndoable() {
            return false;
        }

        public void undo() {
        }

        public Object clone() {
            return new PopupCommand(this._commandName);
        }
    }

    class MemberNode
    extends Node
    implements CommandsInterface {
        private transient ActionListener actionListener;

        MemberNode(String name) {
            super(name);
            this.setNodeExpandedText(name);
        }

        public Command[] getCommands() {
            Command[] commands = new Command[]{new PopupCommand(Message.format((String)RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "deleteButton.txt"), (Object)"", (Object)"")), new PopupCommand(Message.format((String)RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "renameButton.txt"), (Object)"", (Object)""))};
            return commands;
        }

        public void performAction(Object action) {
        }
    }

    class LevelNode
    extends Node
    implements CommandsInterface,
    ComputedValueInterface {
        private transient ActionListener actionListener;
        Level _level;
        AssociationList asl;
        boolean _refreshCV;

        LevelNode(Level level) {
            super(level.getName());
            this._level = level;
            this.asl = this._level.getComputedValues();
            this.setNodeExpandedText(level.getLabel());
            if (this._level.isAnalysisLevel()) {
                this.setNodeExpandedText(RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "measures.txt"));
            }
        }

        public Level getLevel() {
            return this._level;
        }

        public Command[] getCommands() {
            Command[] commands = new Command[]{new PopupCommand(Message.format((String)RB.getStringResource(ComputedValuesCustomizerPanel.RB_KEY, "newButton.txt"), (Object)"", (Object)""))};
            return commands;
        }

        public void performAction(Object action) {
        }

        @Override
        public String getName() {
            return this.getNodeText();
        }

        public String getLabel() {
            return this.getNodeExpandedText();
        }

        @Override
        public AssociationList getComputedValues() {
            return this.asl;
        }

        @Override
        public void setComputedValues(AssociationList computedValueList) throws TableException {
            if (this.asl == null) {
                this.asl = computedValueList;
            } else {
                for (int i = 0; i < computedValueList.count(); ++i) {
                    this.asl.set(computedValueList.getKey(i), computedValueList.get(i));
                }
            }
            this.setComputedValueNeedsRefresh(true);
        }

        public synchronized void setComputedValueNeedsRefresh(boolean refresh) {
            this._refreshCV = refresh;
        }

        public synchronized boolean computedValueNeedsRefresh() {
            return this._refreshCV;
        }
    }
}

