/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.ModelInterface;
import com.sas.awt.Panel;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.NodeInterface;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.RB;
import com.sas.table.TableException;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.DualSelector;
import com.sas.visuals.OkCancelHelpDialog;
import java.awt.Frame;
import java.awt.LayoutManager;

class AxisSelectorDialog
extends OkCancelHelpDialog {
    public static final String RB_KEY = "AxisSelectorDialog.";
    public static final int COLUMN_AXIS = 0;
    public static final int ROW_AXIS = 1;
    protected transient DualSelector dualSelector;
    protected transient MultidimensionalTableInterface table;
    protected transient int type;
    private transient String[] excludedDimensions;
    private transient String[] selectedDimensions;
    private transient boolean buttonCancelled = false;

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        panel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, true, true));
        panel.setInsets(10, 10, 10, 10);
        this.dualSelector = new DualSelector();
        this.dualSelector.initialize();
        panel.add(this.dualSelector);
        this.getAxis();
    }

    private void getAxis() {
        if (this.table != null) {
            OrderedCollection oc = new OrderedCollection();
            OrderedCollection selOC = new OrderedCollection();
            try {
                DimensionInterface[] dimensions = this.table.getDimensions(0, -1);
                int cnt = dimensions.length;
                for (int i = 0; i < cnt; ++i) {
                    if (dimensions[i] instanceof Dimension && ((Dimension)dimensions[i]).isMeasure() || this.dimensionContained(dimensions[i], this.excludedDimensions)) continue;
                    if (this.dimensionContained(dimensions[i], this.selectedDimensions)) {
                        selOC.add((Object)new DimensionElement(dimensions[i]));
                        continue;
                    }
                    oc.add((Object)new DimensionElement(dimensions[i]));
                }
            }
            catch (TableException ex) {
                ex.printStackTrace();
            }
            this.dualSelector.attachModel((ModelInterface)oc);
            this.dualSelector.setList2ModelInterface((ModelInterface)selOC);
        }
    }

    private boolean dimensionContained(DimensionInterface dim, String[] dimensions) {
        if (dimensions == null) {
            return false;
        }
        try {
            String name = dim.getName();
            int cnt = dimensions.length;
            for (int i = 0; i < cnt; ++i) {
                if (!Util.equal((Object)name, (Object)dimensions[i])) continue;
                return true;
            }
        }
        catch (TableException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public AxisSelectorDialog(Frame parent, int type, MultidimensionalTableInterface table, String[] excludedDimensions, String[] selectedDimensions) {
        super(parent, AxisSelectorDialog.getTitle(type));
        this.type = type;
        this.table = table;
        this.excludedDimensions = excludedDimensions;
        this.selectedDimensions = selectedDimensions;
    }

    private NodeInterface[] getSelectedDimensions() {
        int i;
        int cnt;
        if (this.selectedDimensions == null || this.selectedDimensions.length == 0) {
            return null;
        }
        OrderedCollection oc = new OrderedCollection();
        try {
            DimensionInterface[] dimensions = this.table.getDimensions(0, -1);
            cnt = dimensions.length;
            for (i = 0; i < cnt; ++i) {
                if (!this.dimensionContained(dimensions[i], this.selectedDimensions)) continue;
                oc.add((Object)new DimensionElement(dimensions[i]));
            }
        }
        catch (TableException ex) {
            ex.printStackTrace();
        }
        if (oc.count() == 0) {
            return null;
        }
        NodeInterface[] nodes = new NodeInterface[oc.count()];
        cnt = nodes.length;
        for (i = 0; i < cnt; ++i) {
            nodes[i] = ((DimensionElement)oc.get((int)i)).dimension;
        }
        return nodes;
    }

    public NodeInterface[] getSelectedMDDBNodes() {
        if (this.buttonCancelled) {
            return this.getSelectedDimensions();
        }
        StaticOrderedCollectionInterface selItems = this.dualSelector.getList2Items();
        if (selItems == null || selItems.count() == 0) {
            return null;
        }
        NodeInterface[] nodes = new NodeInterface[selItems.count()];
        int cnt = nodes.length;
        for (int i = 0; i < cnt; ++i) {
            nodes[i] = ((DimensionElement)selItems.get((int)i)).dimension;
        }
        return nodes;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.buttonCancelled = true;
    }

    public DualSelector getDualSelector() {
        return this.dualSelector;
    }

    private static String getTitle(int type) {
        switch (type) {
            case 0: {
                return RB.getStringResource(RB_KEY, "columnAxisLabel.txt");
            }
            case 1: {
                return RB.getStringResource(RB_KEY, "rowAxisLabel.txt");
            }
        }
        throw new IllegalArgumentException("invalid type: " + type);
    }

    class DimensionElement {
        DimensionInterface dimension;

        public DimensionElement(DimensionInterface dimension) {
            this.dimension = dimension;
        }

        public String toString() {
            try {
                return this.dimension.getLabel();
            }
            catch (TableException ex) {
                return null;
            }
        }
    }
}

