/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.collection.AssociationList;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StringCollection;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.models.CacheException;
import com.sas.models.NodeInterface;
import com.sas.models.SequentialCache;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.mdtable.AbstractChildrenReader;
import com.sas.sasserver.mdtable.Dimension;
import com.sas.sasserver.mdtable.ExtendedNodeInterface;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.RB;
import com.sas.table.TableException;
import com.sas.text.Message;

public class Axis
extends ParentNode
implements AxisInterface {
    static final long serialVersionUID = 1607416798347728058L;
    private transient SequentialCache _dependentIndex;
    private transient SequentialCache _pointIndexes;
    private transient int _pointCount;
    private transient LevelInterface[] _axisLevels;
    private transient Level _root;
    private transient AxisLabelInterface axisLabel;
    private transient int _sortOrder;
    private transient int[][] persistentPoints;
    private transient int persistentStart;
    private transient int lastCoord;
    private transient int[] isam;
    static final int LOOKAHEAD_VALUE = 400;
    static final int MAX_CACHED_ITEMS = 5000;
    protected static final String RB_KEY = "Axis.";

    public Axis(int index, MultidimensionalTableInterface mdDelegate) throws TableException {
        super(mdDelegate);
        if (index == 0) {
            this.setName("Column");
        } else if (index == 1) {
            this.setName("Row");
        }
        this.setOrdinal(index);
        this.reset();
    }

    public synchronized void reset(boolean clearAll) {
        if (this._dependentIndex != null) {
            this._dependentIndex.invalidateCache();
        }
        if (this._pointIndexes != null) {
            this._pointIndexes.invalidateCache();
        }
        this.isam = null;
        this.persistentPoints = null;
        this.persistentStart = -1;
        this.lastCoord = 0;
        this._pointCount = -1;
        this._axisLevels = null;
        this._root = null;
        if (clearAll) {
            try {
                this.clearCache();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.reset(true);
    }

    public AxisLabelInterface getSortIdentifier() {
        return this.axisLabel;
    }

    void setSortIdentifier(AxisLabelInterface tuple) {
        if (this.axisLabel != null && tuple == null) {
            ((Member)this.axisLabel).setTopBottomN(0);
        }
        this.axisLabel = tuple;
    }

    private synchronized int[][] getPointIndexes(int startIndex, int count) {
        try {
            if (this._pointIndexes == null) {
                this._pointIndexes = new SequentialCache((StaticCacheInterface)new PointIndexReader(), 5000, 400);
            }
            if (this.isam == null) {
                try {
                    this.isam = new int[this.getMagnitude() / 400 + 1];
                    for (int i = 0; i < this.isam.length; ++i) {
                        this.isam[i] = -1;
                    }
                }
                catch (TableException te) {
                    return null;
                }
            }
            if (this.persistentPoints == null || startIndex < this.persistentStart || startIndex >= this.persistentStart + this.persistentPoints.length) {
                int chunkNumber = startIndex / 400;
                this.persistentStart = chunkNumber * 400;
                this.persistentPoints = null;
                Object[] pidx = this._pointIndexes.getFromCache((long)this.persistentStart, (long)(this.persistentStart + 400 - 1), false);
                this.persistentPoints = new int[pidx.length][];
                for (int i = 0; i < pidx.length; ++i) {
                    HList hlist = (HList)pidx[i];
                    this.persistentPoints[i] = new int[hlist.count()];
                    for (int j = 0; j < hlist.count(); ++j) {
                        this.persistentPoints[i][j] = (int)hlist.getDouble(j);
                    }
                }
                this.isam[chunkNumber] = this.persistentPoints[this.persistentPoints.length - 1][0];
            }
            return this.persistentPoints;
        }
        catch (CacheException ce) {
            return null;
        }
    }

    public String[][] getPointLabels(int startCoord, int endCoord) throws TableException {
        AssociationList _pointLabels = new AssociationList();
        HListInterface pidx = this.Imddb._getPointIndexes(this.getOrdinal(), startCoord, -1);
        LevelInterface[] li = this.getLevels();
        for (int i = 0; i < li.length; ++i) {
            String levelLabel = li[i].getName();
            _pointLabels.add(i, (Object)levelLabel, (Object)new OrderedCollection((Object[])this.Imddb.getLabels(levelLabel)));
        }
        String[][] labels = new String[pidx.count()][li.length];
        for (int j = startCoord; j < pidx.count(); ++j) {
            HList h = (HList)pidx.getList(j);
            for (int i = 0; i < h.count(); ++i) {
                OrderedCollection oc;
                int memNum = (int)h.getDouble(i);
                if (memNum > (oc = (OrderedCollection)_pointLabels.get((Object)li[i].getName())).count() || memNum < 0) continue;
                labels[j][i] = (String)oc.get(memNum);
            }
        }
        return labels;
    }

    protected synchronized HListInterface getDependentIndexes(int startIndex, int count) {
        try {
            if (this._dependentIndex == null) {
                this._dependentIndex = new SequentialCache((StaticCacheInterface)new DependentIndexReader(), this.getMagnitude(), 400);
            }
            Object[] didx = this._dependentIndex.getFromCache((long)startIndex, (long)(startIndex + count - 1), false);
            HList returnList = new HList();
            for (int i = 0; i < didx.length; ++i) {
                returnList.addItem((HListInterface)didx[i], i, Integer.toString(startIndex + i));
            }
            return returnList;
        }
        catch (CacheException ce) {
            return null;
        }
        catch (TableException te) {
            return null;
        }
    }

    public synchronized LevelInterface[] getLevels() throws TableException {
        HListInterface hlist;
        if (this._axisLevels == null && (hlist = this.Imddb._getAxisLevels(this.getOrdinal())) != null) {
            this.getDimensions(0, -1);
            Dictionary allLevels = this.Imddb.getAllLevels();
            int count = hlist.count();
            this._axisLevels = new LevelInterface[count];
            for (int i = 0; i < count; ++i) {
                String name = hlist.getName(i);
                Level l = null;
                if (this.Imddb instanceof MultidimensionalTableV3Interface) {
                    l = ((MultidimensionalTableV3Interface)this.Imddb).findLevel(name);
                } else if (allLevels.containsKey((Object)name)) {
                    l = (Level)allLevels.get((Object)name);
                }
                if (l != null) {
                    l.setAxisOffset(i);
                    this._axisLevels[i] = l;
                }
                if (l != null) continue;
                throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "invalidAxis.ex.txt"), (Object)name));
            }
        }
        return this._axisLevels;
    }

    @Override
    public int getDimensionCount() throws TableException {
        return this.countNodeChildren(0);
    }

    @Override
    public DimensionInterface getDimension(int index) throws TableException {
        return this.getDimensions(index, 1)[0];
    }

    @Override
    public DimensionInterface[] getDimensions(int index, int count) throws TableException {
        SimpleNodeInterface[] si;
        DimensionInterface[] di = null;
        if (count == -1) {
            count = this.getDimensionCount() - index;
        }
        if ((si = this.getNodeChildren(index, count)) != null) {
            di = new DimensionInterface[si.length];
            for (int i = 0; i < si.length; ++i) {
                di[i] = (DimensionInterface)si[i];
            }
        }
        return di;
    }

    @Override
    public int getMagnitude() throws TableException {
        if (this._pointCount == -1) {
            this._pointCount = this.Imddb._getPointCount(this.getOrdinal());
        }
        return this._pointCount;
    }

    @Override
    public synchronized AxisLabelInterface[] getLabels(int tupleOrdinal) throws TableException {
        AxisLabelInterface[] members = null;
        int axis = this.getOrdinal();
        if (tupleOrdinal < this.getMagnitude()) {
            int[][] wholeArray = this.getPointIndexes(tupleOrdinal, 400);
            int[] tuple = wholeArray[tupleOrdinal % 400];
            LevelInterface[] levels = this.getLevels();
            int count = tuple.length;
            if (count > 0 && count <= levels.length) {
                members = new AxisLabelInterface[count];
                int di = -1;
                ParentNode parent = (ParentNode)this.getRoot();
                ParentNode child = null;
                boolean found = false;
                for (int i = 0; i < count; ++i) {
                    found = false;
                    di = tuple[i];
                    if (di < 0) {
                        throw new TableException(this.Imddb.getMessage());
                    }
                    int numKids = parent.countNodeChildren(0);
                    child = di < numKids ? (ParentNode)parent.getNodeChild(di) : null;
                    if (child != null && child.getDelegate().getOrdinal() == di) {
                        members[i] = (AxisLabelInterface)((Object)child);
                        parent = child;
                        found = true;
                    }
                    for (int j = 0; j < numKids && !found; ++j) {
                        child = (ParentNode)parent.getNodeChild(j);
                        if (child.getDelegate().getOrdinal() != di) continue;
                        members[i] = (AxisLabelInterface)((Object)child);
                        parent = child;
                        found = true;
                    }
                    if (found) continue;
                    throw new TableException(Message.format((String)RB.getStringResource(RB_KEY, "invalidLabel.ex.txt"), (Object)new Integer(i), (Object)this.getLabel(), (Object)new Integer(tupleOrdinal)));
                }
            }
        }
        return members;
    }

    protected synchronized int getAxisCoordinate(OrderedCollection labels) throws TableException {
        int[] indexes = new int[labels.count()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = ((Member)labels.get(i)).getDelegate().getOrdinal();
        }
        return this.getAxisCoordinate(indexes);
    }

    public synchronized int getAxisCoordinate(Member[] labels) throws TableException {
        Level statLevel;
        int[] indexes = new int[labels.length];
        boolean isV3 = this.Imddb instanceof MultidimensionalTableV2Interface;
        LevelInterface[] levels = this.getLevels();
        if (isV3 && levels.length < labels.length && (statLevel = ((MultidimensionalTableV3Interface)this.Imddb).findLevel("_STATS_")) != null && ((MultidimensionalTableV3Interface)this.Imddb).isStatisticLabelHidden() && statLevel.getMemberCount() == 1) {
            indexes = new int[labels.length - 1];
        }
        int coord = -1;
        ExtendedNodeInterface root = labels[0].getRootParent();
        if (root instanceof Member) {
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = labels[i].getDelegate().getOrdinal();
            }
            coord = this.getAxisCoordinate(indexes);
        } else if (root instanceof Axis) {
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = labels[i].getOrdinal();
            }
            coord = this.getAxisCoordinate(indexes);
        } else {
            String[] slabels = new String[labels.length];
            for (int i = 0; i < slabels.length; ++i) {
                slabels[i] = labels[i].getLabel();
            }
            coord = this.getAxisCoordinate(slabels);
        }
        return coord;
    }

    public synchronized int getAxisCoordinate(String[] labels) throws TableException {
        Level statLevel;
        int coord = -1;
        MultidimensionalTableInterface mddb = this.getImddb();
        boolean isV3 = mddb instanceof MultidimensionalTableV3Interface;
        boolean isV2 = mddb instanceof MultidimensionalTableV2Interface;
        int[] indexes = new int[labels.length];
        LevelInterface[] levels = this.getLevels();
        if (isV3 && levels.length < labels.length && (statLevel = ((MultidimensionalTableV3Interface)this.Imddb).findLevel("_STATS_")) != null && ((MultidimensionalTableV3Interface)this.Imddb).isStatisticLabelHidden() && statLevel.getMemberCount() == 1) {
            indexes = new int[labels.length - 1];
        }
        if (levels.length >= indexes.length) {
            if (isV2) {
                MultidimensionalTableV2Interface v2mddb = (MultidimensionalTableV2Interface)mddb;
                for (int i = 0; i < indexes.length; ++i) {
                    if (labels[i].length() == 0) {
                        int j;
                        int numKids = levels[i].getMemberCount();
                        for (j = 0; j < numKids && !labels[i].equals(((Level)levels[i]).getMember(j).getLabel()); ++j) {
                        }
                        if (j < numKids) {
                            indexes[i] = j;
                            continue;
                        }
                        return -1;
                    }
                    indexes[i] = v2mddb._findMember(levels[i].getName(), labels[i], false, true, "Y", 0, 1);
                    if (indexes[i] != -1) continue;
                    return indexes[i];
                }
            } else {
                for (int i = 0; i < indexes.length; ++i) {
                    int j;
                    int numKids = levels[i].getMemberCount();
                    for (j = 0; j < numKids && !labels[i].equals(((Level)levels[i]).getMember(j).getLabel()); ++j) {
                    }
                    if (j >= numKids) {
                        return -1;
                    }
                    indexes[i] = j;
                }
            }
            coord = this.getAxisCoordinate(indexes);
        }
        return coord;
    }

    private int getAxisCoordinate(int[] indexes) throws TableException {
        int position;
        int coord = -1;
        int indexeslength = indexes.length;
        int startIdx = indexes[0];
        int magnitude = this.getMagnitude();
        int startCoord = position = Math.max(startIdx, this.lastCoord);
        boolean wrapped = false;
        while ((!wrapped && position >= startCoord || wrapped && position < startCoord) && coord == -1) {
            while (coord == -1) {
                int i;
                int[][] wholeArray = this.getPointIndexes(position, 400);
                if (wholeArray[0][0] <= startIdx && wholeArray[wholeArray.length - 1][0] >= startIdx) {
                    for (i = 0; i < wholeArray.length; ++i) {
                        int j;
                        int count = Math.min(indexeslength, wholeArray[i].length);
                        for (j = 0; j < count && indexes[j] == wholeArray[i][j]; ++j) {
                        }
                        if (j != count) continue;
                        coord = position / 400 * 400 + i;
                        break;
                    }
                }
                if (position + wholeArray.length > magnitude || startIdx < wholeArray[wholeArray.length - 1][0]) {
                    wrapped = true;
                    position = 0;
                    for (i = 0; i < this.isam.length && this.isam[i] != -1 && startIdx > this.isam[i]; ++i) {
                    }
                    if (this.isam[i] == -1) continue;
                    position = i * 400;
                    continue;
                }
                position += wholeArray.length;
            }
        }
        if (coord > 0) {
            this.lastCoord = coord;
        }
        return coord;
    }

    @Override
    public NodeInterface getRoot() {
        try {
            if (this._root == null) {
                this._root = new Level(null, this.getName(), this.getLabel(), this.Imddb);
                this._root.setParent(this._root);
            }
            this._root.setDelegate((Level)this.getLevels()[0]);
        }
        catch (TableException te) {
            return this._root;
        }
        return this._root;
    }

    @Override
    protected StaticCacheInterface createCache() {
        return new ChildrenReader();
    }

    class PointIndexReader
    extends AbstractChildrenReader {
        PointIndexReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            HListInterface pidx = Axis.this.Imddb._getPointIndexes(Axis.this.getOrdinal(), (int)startOrdinal, (int)(endOrdinal - startOrdinal + 1L));
            Object[] indexes = new Object[pidx.count()];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = pidx.getList(i);
            }
            return indexes;
        }

        @Override
        public int count() {
            try {
                return Axis.this.getMagnitude();
            }
            catch (TableException te) {
                this.count = -1;
                return 0;
            }
        }
    }

    class DependentIndexReader
    extends AbstractChildrenReader {
        DependentIndexReader() {
        }

        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            HListInterface didx = Axis.this.Imddb._getDependentIndexes(Axis.this.getOrdinal(), (int)startOrdinal, (int)(endOrdinal - startOrdinal + 1L), "");
            Object[] indexes = new Object[didx.count()];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = didx.getList(i);
            }
            return indexes;
        }

        @Override
        public int count() {
            try {
                LevelInterface l = Axis.this.getLevels()[0];
                return l.getMemberCount();
            }
            catch (TableException te) {
                this.count = -1;
                return 0;
            }
        }
    }

    class ChildrenReader
    extends AbstractChildrenReader {
        ChildrenReader() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            int index = Axis.this.getOrdinal();
            int i = 0;
            DimensionInterface[] di = null;
            String[] axisDimensions = null;
            try {
                if (index == 0) {
                    String[] colDims = Axis.this.Imddb.getColumnAxis();
                    if (colDims != null && colDims.length > 0) {
                        StringCollection oc = new StringCollection(colDims);
                        oc.add("Measures");
                        axisDimensions = oc.getStringItems();
                    } else {
                        axisDimensions = new String[]{"Measures"};
                    }
                } else if (index == 1) {
                    axisDimensions = Axis.this.Imddb.getRowAxis();
                }
                if (axisDimensions == null || axisDimensions.length <= 0) throw new CacheException(Message.format((String)RB.getStringResource(Axis.RB_KEY, "uninitializedAxis.ex.txt"), (Object)Axis.this.getName()));
                OrderedCollection dims = new OrderedCollection((Object[])Axis.this.Imddb.getDimensions(0, -1));
                int offset = (int)startOrdinal;
                int count = (int)(endOrdinal - startOrdinal + 1L);
                if (count > axisDimensions.length) {
                    if (readFully) {
                        throw new CacheException();
                    }
                    count = (int)((long)axisDimensions.length - startOrdinal);
                }
                di = new DimensionInterface[count];
                i = 0;
                while (i < count) {
                    Dimension d = new Dimension(Axis.this, axisDimensions[offset], null, Axis.this.Imddb);
                    if (dims.contains((Object)d)) {
                        int idx = dims.getIndex((Object)d, 0);
                        d.setDelegate((ExtendedNodeInterface)dims.get(idx));
                    } else {
                        if (Axis.this.Imddb instanceof MultidimensionalTableV3Interface) {
                            Level l = ((MultidimensionalTableV3Interface)Axis.this.Imddb).findLevel(d.getName());
                            if (l == null) {
                                l = ((MultidimensionalTableV3Interface)Axis.this.Imddb).findLevel(d.getLabel());
                            }
                            if (l == null) throw new TableException(Message.format((String)RB.getStringResource(Axis.RB_KEY, "invalidDimension.ex.txt"), (Object)axisDimensions[offset]));
                            d.setName(l.getName());
                            d.setLabel(l.getLabel());
                        } else {
                            Dictionary allLevels = Axis.this.Imddb.getAllLevels();
                            if (!allLevels.containsKey((Object)d.getName())) {
                                throw new TableException(Message.format((String)RB.getStringResource(Axis.RB_KEY, "invalidDimension.ex.txt"), (Object)axisDimensions[offset]));
                            }
                        }
                        Dimension dCube = new Dimension(null, d.getName(), d.getLabel(), Axis.this.Imddb);
                        dCube.setType(2);
                        d.setDelegate(dCube);
                        d.setType(2);
                    }
                    di[i] = d;
                    ++i;
                    ++offset;
                }
            }
            catch (TableException te) {
                te.printStackTrace();
            }
            if (di == null) return di;
            for (i = 0; i < di.length; ++i) {
                try {
                    ((Dimension)di[i]).getActiveHierarchy().getLevels(0, -1);
                    continue;
                }
                catch (TableException tableException) {
                    // empty catch block
                }
            }
            return di;
        }

        @Override
        public int count() {
            try {
                if (this.count == -1) {
                    String[] dims = null;
                    int axis = Axis.this.getOrdinal();
                    dims = axis == 0 ? Axis.this.Imddb.getColumnAxis() : Axis.this.Imddb.getRowAxis();
                    this.count = dims != null ? dims.length : 0;
                    if (axis == 0) {
                        ++this.count;
                    }
                }
                return this.count;
            }
            catch (TableException te) {
                this.count = -1;
                return 0;
            }
        }
    }
}

