/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable;

import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.StaticCacheInterface;

public abstract class AbstractChildrenReader
implements StaticCacheInterface {
    private String _name;
    boolean DEBUG;
    protected transient int count = -1;
    protected int direction = 256;

    public AbstractChildrenReader(String cacheName) {
        this._name = cacheName;
    }

    public AbstractChildrenReader() {
    }

    public Object getFromCache(long key) throws CacheException {
        if (this.DEBUG) {
            System.out.println(this._name + "getFromCache(SecondaryCache) key:" + key);
        }
        return this.getFromCache(key, key, true)[0];
    }

    public Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
        if (this.DEBUG) {
            System.out.println(this._name + "getFromCache(SecondaryCache) keys[0]:" + keys[0] + " keys[length-1]:" + keys[keys.length - 1]);
        }
        return this.getFromCache(keys[0], keys[keys.length - 1], readFully);
    }

    public abstract Object[] getFromCache(long var1, long var3, boolean var5) throws CacheException;

    public long[] computeCacheKeyRange(long startOrdinal, long endOrdinal, int bufferSize) throws CacheException {
        long[] l = null;
        if (this.DEBUG) {
            System.out.println(this._name + "seqKeys(ENTER)--: start=" + startOrdinal + " end=" + endOrdinal + " bufferSize=" + bufferSize + " direction=" + this.direction);
        }
        int cacheCount = this.count();
        if (this.direction == 256) {
            int diff;
            if (bufferSize > cacheCount) {
                startOrdinal = 0L;
                endOrdinal = cacheCount - 1;
            } else if (bufferSize > 0 && Math.abs(diff = (int)startOrdinal - (int)endOrdinal + 1) < bufferSize) {
                endOrdinal = (int)startOrdinal + bufferSize - 1;
            }
            if (endOrdinal > (long)(cacheCount - 1)) {
                endOrdinal = cacheCount - 1;
            }
            l = SequentialCache.computeSequentialKeyRange((long)startOrdinal, (long)endOrdinal);
        } else {
            long diff;
            if (bufferSize > cacheCount) {
                bufferSize = cacheCount;
            }
            if (endOrdinal > (long)(cacheCount - 1) && (long)bufferSize > (diff = (endOrdinal = (long)(cacheCount - 1)) - startOrdinal + 1L)) {
                bufferSize = (int)diff;
            }
            if (endOrdinal < (long)bufferSize || bufferSize == 0) {
                bufferSize = (int)Math.max(1L, endOrdinal + 1L);
            }
            l = SequentialCache.computeDirectionalCacheKeyRange((long)endOrdinal, (int)bufferSize, (int)this.direction);
        }
        if (this.DEBUG) {
            System.out.println(this._name + " ComputeCacheKeyRange(SecondaryCache) l[0]:" + l[0] + " l[length-1]:" + l[l.length - 1] + " direction:" + this.direction);
        }
        return l;
    }

    public long[] getCacheKeys() throws CacheException {
        long[] keys = new long[this.count()];
        for (long i = 0L; i < (long)keys.length; ++i) {
            keys[(int)i] = i;
        }
        return keys;
    }

    public boolean cacheContainsKey(long key) throws CacheException {
        return key < (long)this.count();
    }

    public int getCacheKeyUse() {
        return 0;
    }

    public void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
    }

    public void useBufferHints(BufferHints hints) {
        while (hints != null) {
            if (hints.what == 16384) {
                this.direction = hints.how;
            }
            hints = hints.moreHints;
        }
        if (this.DEBUG) {
            System.out.println("DIRECTION---------------------------: " + this.direction);
        }
    }

    public abstract int count();

    public StaticCacheInterface getSecondaryCache() {
        return null;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

