/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.librarylist;

import com.sas.GlobalInfoTable;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.SASListNodeDelegate;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.sasserver.librarylist.RB;
import com.sas.sasserver.sasfilelist.SASFileListInterface;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;

public class LibraryListDelegate
extends SASListNodeDelegate {
    static final String RB_KEY = "LibraryListDelegate.";
    private transient LibraryListInterface m_remoteObject;
    protected transient String rootText;
    protected transient String filter;
    protected transient boolean libraryDisplayed;
    protected transient boolean pathDisplayed;
    protected transient boolean serverDisplayed;
    protected transient boolean engineDisplayed;
    protected transient boolean sasFilesDisplayed;
    protected transient boolean dataSetColumnsDisplayed;
    protected transient boolean catalogEntriesDisplayed;
    protected transient String sasFilesTypeFilter;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (LibraryListInterface)this.remoteObject();
    }

    protected synchronized String parseItem(HListInterface membersList, int index, boolean libraryDisplayed, boolean engineDisplayed, boolean pathDisplayed, boolean serverDisplayed) {
        HListInterface subList = membersList.getList(index);
        String stringItem = "";
        if (libraryDisplayed) {
            stringItem = stringItem + subList.getString("NAME") + " ";
        }
        if (engineDisplayed) {
            stringItem = stringItem + subList.getString("ENGINE") + " ";
        }
        if (pathDisplayed) {
            stringItem = stringItem + subList.getString("PATH") + " ";
        }
        if (serverDisplayed) {
            stringItem = stringItem + subList.getString("SERVER") + " ";
        }
        stringItem = stringItem.trim();
        return stringItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void parseList(HListInterface membersList, OrderedCollectionInterface parsedList) {
        OrderedCollectionInterface orderedCollectionInterface = parsedList;
        synchronized (orderedCollectionInterface) {
            parsedList.removeAll();
            boolean libraryDisplayed = this.isLibraryDisplayed();
            boolean engineDisplayed = this.isEngineDisplayed();
            boolean pathDisplayed = this.isPathDisplayed();
            boolean serverDisplayed = this.isServerDisplayed();
            int count = membersList.count();
            for (int i = 0; i < count; ++i) {
                parsedList.add((Object)this.parseItem(membersList, i, libraryDisplayed, engineDisplayed, pathDisplayed, serverDisplayed));
            }
        }
    }

    public synchronized String getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(String filter) {
        String previousFilter = this.getFilter();
        if (!Util.equal((Object)filter, (Object)previousFilter)) {
            this.filter = filter;
            this.m_remoteObject._setFilter(filter);
            this.fireContentsChanged();
            this.firePropertyChange("filter", previousFilter, filter);
        }
    }

    public synchronized boolean isLibraryDisplayed() {
        return this.libraryDisplayed;
    }

    public synchronized void setLibraryDisplayed(boolean libraryDisplayed) {
        if (libraryDisplayed != this.isLibraryDisplayed()) {
            this.libraryDisplayed = libraryDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("libraryDisplayed", libraryDisplayed ? Boolean.FALSE : Boolean.TRUE, libraryDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getLibrary(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, true, false, false, false);
    }

    public synchronized boolean isPathDisplayed() {
        return this.pathDisplayed;
    }

    public synchronized void setPathDisplayed(boolean pathDisplayed) {
        if (pathDisplayed != this.isPathDisplayed()) {
            this.pathDisplayed = pathDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("pathDisplayed", pathDisplayed ? Boolean.FALSE : Boolean.TRUE, pathDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getPath(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, false, true, false);
    }

    public synchronized boolean isServerDisplayed() {
        return this.serverDisplayed;
    }

    public synchronized void setServerDisplayed(boolean serverDisplayed) {
        if (serverDisplayed != this.isServerDisplayed()) {
            this.serverDisplayed = serverDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("serverDisplayed", serverDisplayed ? Boolean.FALSE : Boolean.TRUE, serverDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getServer(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, false, false, true);
    }

    public synchronized boolean isEngineDisplayed() {
        return this.engineDisplayed;
    }

    public synchronized void setEngineDisplayed(boolean engineDisplayed) {
        if (engineDisplayed != this.isEngineDisplayed()) {
            this.engineDisplayed = engineDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("engineDisplayed", engineDisplayed ? Boolean.FALSE : Boolean.TRUE, engineDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getEngine(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, true, false, false);
    }

    public synchronized void assignLibrary(String library, String path) {
        this.m_remoteObject._assignLibrary(library, path);
        this.fireContentsChanged();
    }

    public synchronized void deassignLibrary(String library) {
        this.m_remoteObject._deassignLibrary(library);
        this.fireContentsChanged();
    }

    @Override
    public synchronized int getNodeChildCount() {
        int childCount = this.count();
        if (childCount == 0 && this.hasChildren) {
            this.hasChildren = false;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return childCount;
    }

    @Override
    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        int nodeChildCount = this.getNodeChildCount();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        if (nodeChildCount == 0) {
            return childrenArray;
        }
        RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_remoteObject);
        Connection rocfContext = rbc._RemoteObject_getContext();
        Rocf classFactory = rbc._RemoteObject_getClassFactory();
        for (int index = startIndex; index < startIndex + count && index < startIndex + nodeChildCount; ++index) {
            SASFileListInterface sasFileList;
            String libraryName = this.getLibrary(index);
            try {
                sasFileList = (SASFileListInterface)classFactory.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.sasfilelist.SASFileListInterface"), rocfContext);
            }
            catch (Exception e) {
                break;
            }
            sasFileList.setPendingLibrary(libraryName);
            sasFileList.setLeafNode(!this.sasFilesDisplayed);
            sasFileList.setDataSetColumnsDisplayed(this.dataSetColumnsDisplayed);
            sasFileList.setCatalogEntriesDisplayed(this.catalogEntriesDisplayed);
            if (this.sasFilesTypeFilter != null) {
                sasFileList.setTypeFilter(this.sasFilesTypeFilter);
            }
            childrenArray[index - startIndex] = sasFileList;
        }
        return childrenArray;
    }

    @Override
    public synchronized boolean isLeafNode() {
        return !this.hasChildren;
    }

    @Override
    public synchronized String getNodeText() {
        if (this.rootText == null) {
            return RB.getStringResource(RB_KEY, "rootText.txt");
        }
        return this.rootText;
    }

    @Override
    public synchronized IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"SASSystem"));
    }

    public synchronized void setDefaultValues() {
        super.setDefaultValues();
        this.libraryDisplayed = true;
        this.sasFilesDisplayed = true;
        this.dataSetColumnsDisplayed = true;
        this.catalogEntriesDisplayed = true;
    }

    public synchronized void setSASFilesDisplayed(boolean sasFilesDisplayed) {
        this.sasFilesDisplayed = sasFilesDisplayed;
    }

    public synchronized void setCatalogEntriesDisplayed(boolean catalogEntriesDisplayed) {
        this.catalogEntriesDisplayed = catalogEntriesDisplayed;
    }

    public synchronized void setDataSetColumnsDisplayed(boolean dataSetColumnsDisplayed) {
        this.dataSetColumnsDisplayed = dataSetColumnsDisplayed;
    }

    public synchronized void setSASFilesTypeFilter(String sasFilesTypeFilter) {
        this.sasFilesTypeFilter = sasFilesTypeFilter;
    }

    public synchronized void setRootText(String rootText) {
        String oldRootText = this.rootText;
        if (!Util.equal((Object)oldRootText, (Object)rootText)) {
            this.rootText = rootText;
            this.firePropertyChange("rootText", oldRootText, rootText);
        }
    }
}

