/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.datawizard;

import com.sas.collection.ContentsChangedEvent;
import com.sas.lang.DoubleData;
import com.sas.rmi.LocalModelInterface;
import com.sas.sasserver.dataset.DataSetDelegate;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.datawizard.MetaData;
import com.sas.sasserver.datawizard.StackChecker;
import com.sas.sasserver.datawizard.StackCheckerFilter;
import com.sas.table.TableException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class DataWizardDelegate
extends DataSetDelegate
implements LocalModelInterface,
PropertyChangeListener,
StackCheckerFilter {
    public static final int NEXTSUPPORTED = 0;
    public static final int PREVIOUSSUPPORTED = 1;
    public static final int FIRSTSUPPORTED = 2;
    public static final int LASTSUPPORTED = 3;
    public static final int COMMITSUPPORTED = 4;
    public static final int INSERTSUPPORTED = 5;
    public static final int DELETESUPPORTED = 6;
    transient boolean[] supported = new boolean[7];
    transient int m_curPos;
    transient DataSetInterface m_dataSet;
    transient Vector m_metaData;
    transient int m_columnCount;
    transient boolean m_unknownCount = false;
    transient boolean m_onRow = false;
    transient boolean m_newRow = false;
    transient Object[] m_rawCols;
    transient boolean[] m_rawColsModified;
    transient Object[] m_formattedCols;
    transient boolean[] m_formattedColsModified;
    protected transient String m_defaultDataSet;
    protected transient String[] m_selectedCols;
    boolean m_dataSetNameIsSet = false;
    boolean m_checkSets = true;
    boolean m_whereEOF = false;

    public String _RemoteObject_getInterfaceName() {
        return "com.sas.sasserver.dataset.DataSet";
    }

    @Override
    public void _setRemoteHandle(Object proxy) {
        super._setRemoteHandle(proxy);
        this.m_dataSet = (DataSetInterface)proxy;
        this.m_dataSet.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    @Override
    public synchronized void initialize() {
        super.initialize();
        if (!this.m_dataSetNameIsSet) {
            this.setDataSet(this.m_defaultDataSet);
        }
        if (this.m_selectedCols != null) {
            this.m_dataSet.setDisplayedColumns(this.m_selectedCols);
        }
        this._init();
    }

    @Override
    public void setDataSet(String name) {
        this.m_dataSetNameIsSet = true;
        super.setDataSet(name);
    }

    @Override
    public void setWhere(String where) {
        super.setWhere(where);
        this.first();
    }

    public void _setSelectedCols(String[] cols) {
        this.m_selectedCols = cols;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        String pName = event.getPropertyName();
        if (pName != null && pName.equals("where")) {
            this._init();
        }
    }

    public String _getColumnValue(String name) {
        if (this.m_columnCount == 0) {
            return null;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return null;
        }
        return (String)this.m_formattedCols[md.index];
    }

    public String _getRawColumnValue(String name) {
        if (this.m_columnCount == 0) {
            return null;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return null;
        }
        String s = null;
        Object o = this.m_rawCols[md.index];
        if (o != null) {
            if (o instanceof String) {
                s = (String)o;
            } else if (o instanceof Double) {
                s = DoubleData.toString((Double)((Double)o));
            }
        }
        return s;
    }

    public double _getRawColumnDoubleValue(String name) {
        if (this.m_columnCount == 0) {
            return 0.0;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return 0.0;
        }
        double d = 0.0;
        Object o = this.m_rawCols[md.index];
        if (o != null) {
            if (o instanceof Double) {
                d = (Double)o;
            } else if (o instanceof String) {
                d = DoubleData.valueOf((String)((String)o));
            }
        }
        return d;
    }

    public void _setColumnValue(String name, String value) {
        if (this.m_columnCount == 0) {
            return;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return;
        }
        if (value != null && value.length() == 0 && this.m_checkSets) {
            StackChecker sc = new StackChecker((StackCheckerFilter)this);
            if (sc.checkStack((Object)"Rocf.setDesignTimeAttributes")) {
                return;
            }
            if (sc.checkStack((Object)"PropertyLinkAdaptor.addLink")) {
                return;
            }
        }
        if (value == null) {
            if (this.m_formattedCols[md.index] != null) {
                this.m_formattedColsModified[md.index] = true;
                this.m_rawColsModified[md.index] = false;
            }
        } else if (this.m_formattedCols[md.index] == null) {
            this.m_formattedColsModified[md.index] = true;
            this.m_rawColsModified[md.index] = false;
        } else if (!((String)this.m_formattedCols[md.index]).equals(value)) {
            this.m_formattedColsModified[md.index] = true;
            this.m_rawColsModified[md.index] = false;
        }
        this.m_formattedCols[md.index] = value;
        this.m_dataSet.firePropertyChange("formatted" + name, null, value);
    }

    public void _setRawColumnValue(String name, String value) {
        if (this.m_columnCount == 0) {
            return;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return;
        }
        if (value != null && value.length() == 0 && this.m_checkSets) {
            StackChecker sc = new StackChecker((StackCheckerFilter)this);
            if (sc.checkStack((Object)"Rocf.setDesignTimeAttributes")) {
                return;
            }
            if (sc.checkStack((Object)"PropertyLinkAdaptor.addLink")) {
                return;
            }
        }
        if (value == null) {
            if (this.m_rawCols[md.index] != null) {
                this.m_rawColsModified[md.index] = true;
                this.m_formattedColsModified[md.index] = false;
            }
        } else if (this.m_rawCols[md.index] == null) {
            this.m_rawColsModified[md.index] = true;
            this.m_formattedColsModified[md.index] = false;
        } else if (this.m_rawCols[md.index] instanceof String && !((String)this.m_rawCols[md.index]).equals(value)) {
            this.m_rawColsModified[md.index] = true;
            this.m_formattedColsModified[md.index] = false;
        }
        this.m_rawCols[md.index] = value;
        this.m_dataSet.firePropertyChange(Introspector.decapitalize(name), null, value);
    }

    public void _setRawColumnValue(String name, double value) {
        if (this.m_columnCount == 0) {
            return;
        }
        MetaData md = this._getMetaData(name);
        if (md == null) {
            return;
        }
        if (value == 0.0 && this.m_checkSets) {
            StackChecker sc = new StackChecker((StackCheckerFilter)this);
            if (sc.checkStack((Object)"Rocf.setDesignTimeAttributes")) {
                return;
            }
            if (sc.checkStack((Object)"PropertyLinkAdaptor.addLink")) {
                return;
            }
        }
        boolean valueChanged = false;
        if (this.m_rawCols[md.index] == null || !(this.m_rawCols[md.index] instanceof Double)) {
            this.m_rawColsModified[md.index] = true;
            this.m_formattedColsModified[md.index] = false;
            valueChanged = true;
        } else if (this.m_rawCols[md.index] instanceof Double && (Double)this.m_rawCols[md.index] != value) {
            this.m_rawColsModified[md.index] = true;
            this.m_formattedColsModified[md.index] = false;
            valueChanged = true;
        }
        this.m_rawCols[md.index] = new Double(value);
        if (valueChanged) {
            this.m_dataSet.firePropertyChange(Introspector.decapitalize(name), null, new Double(value));
        }
    }

    private void _setAll() {
        for (int i = 0; i < this.m_metaData.size(); ++i) {
            MetaData md = (MetaData)this.m_metaData.elementAt(i);
            this._setColumnValue(md.label, this._getColumnValue(md.label));
            Object value = this._getRawColumnValue(md.label);
            if (this.m_rawCols[md.index] instanceof Double) {
                value = new Double(this._getRawColumnDoubleValue(md.label));
            }
            this.m_dataSet.firePropertyChange(Introspector.decapitalize(md.label), null, value);
        }
    }

    private MetaData _getMetaData(String name) {
        MetaData metadata = null;
        for (int i = 0; i < this.m_metaData.size(); ++i) {
            MetaData md = (MetaData)this.m_metaData.elementAt(i);
            if (md.label == null || !md.label.equalsIgnoreCase(name)) continue;
            metadata = md;
            break;
        }
        if (metadata == null) {
            System.out.println("Unable to locate column '" + name + "'");
        }
        return metadata;
    }

    public boolean previous() {
        this.m_whereEOF = false;
        this.m_checkSets = false;
        this._getRow(this.m_curPos - 1);
        return this.m_onRow;
    }

    public boolean next() {
        this.m_checkSets = false;
        boolean rc = this._getRow(this.m_curPos + 1);
        return rc;
    }

    public boolean first() {
        this.m_whereEOF = false;
        if (this.m_columnCount == 0) {
            return false;
        }
        this.m_unknownCount = this.m_dataSet._getRowCount() == -1;
        this._getRow(1);
        return this.m_onRow;
    }

    private boolean _getRow(int pos) {
        this.m_onRow = false;
        if (pos <= 0) {
            this._setAll();
            this._fireAll();
            return false;
        }
        this._clearUpdateFlags();
        boolean rc = false;
        int count = this.m_dataSet._getRowCount();
        if (count >= pos || this.m_unknownCount) {
            try {
                Object[] raw = this.m_dataSet.getRow(pos);
                if (raw == null) {
                    this.m_rawCols = null;
                } else {
                    this.m_rawCols = new Object[raw.length];
                    for (int i = 0; i < raw.length; ++i) {
                        this.m_rawCols[i] = raw[i];
                    }
                }
                String[] formatted = this.m_dataSet.getFormattedRow(pos);
                if (formatted == null) {
                    this.m_formattedCols = null;
                } else {
                    this.m_formattedCols = new Object[formatted.length];
                    for (int i = 0; i < formatted.length; ++i) {
                        this.m_formattedCols[i] = formatted[i];
                    }
                }
                this.m_curPos = pos;
                this.m_onRow = true;
                this._setAll();
                rc = true;
                this.m_newRow = false;
            }
            catch (IndexOutOfBoundsException e) {
                if (this.m_unknownCount) {
                    if (pos == 1) {
                        this.clearAll(false);
                    } else {
                        this.m_onRow = true;
                    }
                    this.m_whereEOF = true;
                }
            }
            catch (TableException e) {
                e.printStackTrace();
            }
        }
        this._clearUpdateFlags();
        this._fireAll();
        return rc;
    }

    private void _clearUpdateFlags() {
        int i;
        if (this.m_formattedColsModified == null) {
            this.m_formattedColsModified = new boolean[this.m_columnCount];
        }
        for (i = 0; i < this.m_formattedColsModified.length; ++i) {
            this.m_formattedColsModified[i] = false;
        }
        if (this.m_rawColsModified == null) {
            this.m_rawColsModified = new boolean[this.m_columnCount];
        }
        for (i = 0; i < this.m_rawColsModified.length; ++i) {
            this.m_rawColsModified[i] = false;
        }
    }

    public boolean last() {
        this.m_checkSets = false;
        if (this.m_unknownCount) {
            return false;
        }
        this._getRow(this.m_dataSet._getRowCount());
        return this.m_onRow;
    }

    public boolean insert() {
        this.m_checkSets = false;
        if (!this.isInsertSupported()) {
            return false;
        }
        this.m_newRow = true;
        if (this.m_rawColsModified == null) {
            this.m_rawColsModified = new boolean[this.m_columnCount];
        }
        if (this.m_rawCols == null) {
            this.m_rawCols = new Object[this.m_columnCount];
        }
        if (this.m_formattedColsModified == null) {
            this.m_formattedColsModified = new boolean[this.m_columnCount];
        }
        if (this.m_formattedCols == null) {
            this.m_formattedCols = new Object[this.m_columnCount];
        }
        this.clearAll(false);
        this._fireAll();
        return true;
    }

    protected void clearAll(boolean modified) {
        int i;
        for (i = 0; i < this.m_formattedCols.length; ++i) {
            this.m_rawCols[i] = null;
            this.m_formattedCols[i] = "";
        }
        this._setAll();
        for (i = 0; i < this.m_formattedCols.length; ++i) {
            this.m_formattedColsModified[i] = modified;
            this.m_rawColsModified[i] = false;
        }
    }

    public boolean move(int row) {
        boolean rc = true;
        if (this.m_curPos != row) {
            rc = this._getRow(row);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() {
        this.m_checkSets = false;
        if (!this.isCommitSupported()) {
            return false;
        }
        if (!this.isModified()) {
            return false;
        }
        boolean rc = true;
        try {
            int i;
            this.m_dataSet.disableEvents();
            int lastRow = this.m_dataSet._getRowCount();
            if (this.m_newRow) {
                if (lastRow == -1) {
                    boolean addFormattedData = false;
                    for (int i2 = 0; i2 < this.m_formattedColsModified.length; ++i2) {
                        if (!this.m_formattedColsModified[i2]) continue;
                        addFormattedData = true;
                        break;
                    }
                    if (addFormattedData) {
                        Object[] tempFormattedCols = new String[this.m_formattedCols.length + 1];
                        System.arraycopy(this.m_formattedCols, 0, tempFormattedCols, 0, this.m_formattedCols.length);
                        tempFormattedCols[tempFormattedCols.length - 1] = "__FORMATTED__";
                        this.m_dataSet.addRow(-1, tempFormattedCols);
                    } else {
                        this.m_dataSet.addRow(-1, this.m_rawCols);
                    }
                } else {
                    this.m_dataSet.addRow(-1);
                    this.m_curPos = this.m_dataSet._getRowCount();
                    if (this.m_curPos != -1 && this.m_curPos <= lastRow) {
                        throw new TableException("Unable to add new row");
                    }
                    for (i = 0; i < this.m_formattedCols.length; ++i) {
                        if (this.m_formattedColsModified[i]) {
                            this.m_dataSet.setFormattedCell(this.m_curPos, i + 1, (String)this.m_formattedCols[i]);
                            continue;
                        }
                        if (!this.m_rawColsModified[i]) continue;
                        this.m_dataSet.setCell(this.m_curPos, i + 1, this.m_rawCols[i]);
                    }
                    this.m_dataSet.commitRow();
                }
            } else {
                for (i = 0; i < this.m_formattedCols.length; ++i) {
                    if (this.m_formattedColsModified[i]) {
                        this.m_dataSet.setFormattedCell(this.m_curPos, i + 1, (String)this.m_formattedCols[i]);
                        continue;
                    }
                    if (!this.m_rawColsModified[i]) continue;
                    this.m_dataSet.setCell(this.m_curPos, i + 1, this.m_rawCols[i]);
                }
                this.m_dataSet.commitRow();
            }
            for (i = 0; i < this.m_formattedCols.length; ++i) {
                this.m_rawColsModified[i] = false;
                this.m_formattedColsModified[i] = false;
            }
            if (this.m_newRow) {
                this.m_newRow = false;
            }
            this._getRow(this.m_curPos);
        }
        catch (TableException e) {
            e.printStackTrace();
            rc = false;
        }
        finally {
            this.m_newRow = false;
            this.m_dataSet.enableEvents();
        }
        return rc;
    }

    public boolean delete() {
        this.m_checkSets = false;
        if (!this.isDeleteSupported()) {
            return false;
        }
        boolean rc = true;
        try {
            int n = this.m_curPos;
            if (this.m_newRow) {
                this.m_newRow = false;
            } else {
                this.m_dataSet.deleteRow(this.m_curPos);
                n = this.m_dataSet._getRowCount();
            }
            if (this.m_unknownCount) {
                this.m_curPos = 1;
            } else if (this.m_curPos > n) {
                this.m_curPos = n;
            }
            if (this.m_curPos == 0) {
                for (int i = 0; i < this.m_formattedCols.length; ++i) {
                    this.m_formattedCols[i] = "";
                    this.m_rawColsModified[i] = false;
                    this.m_formattedColsModified[i] = false;
                }
            }
            this._getRow(this.m_curPos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            rc = false;
        }
        return rc;
    }

    public boolean isPreviousSupported() {
        return this.isFirstSupported();
    }

    public boolean isNextSupported() {
        if (this.m_columnCount == 0) {
            return false;
        }
        if (!this.m_onRow) {
            return false;
        }
        if (this.m_newRow) {
            return false;
        }
        if (this.m_unknownCount) {
            return !this.m_whereEOF;
        }
        int count = this.m_dataSet._getRowCount();
        return this.m_curPos < count;
    }

    public boolean isFirstSupported() {
        if (this.m_columnCount == 0) {
            return false;
        }
        if (!this.m_onRow) {
            return false;
        }
        if (this.m_newRow) {
            return false;
        }
        return this.m_curPos > 1;
    }

    public boolean isLastSupported() {
        if (this.m_columnCount == 0) {
            return false;
        }
        if (this.m_unknownCount) {
            return false;
        }
        if (this.m_newRow) {
            return false;
        }
        return this.isNextSupported();
    }

    public boolean isInsertSupported() {
        if (this.m_columnCount == 0) {
            return false;
        }
        if (this.m_newRow) {
            return false;
        }
        return !this.m_dataSet.isReadOnly();
    }

    public boolean isCommitSupported() {
        boolean rc;
        if (this.m_columnCount == 0) {
            return false;
        }
        boolean bl = rc = !this.m_dataSet.isReadOnly();
        if (rc) {
            rc = this.isCursorValid();
        }
        if (!rc) {
            rc = this.m_newRow;
        }
        return rc;
    }

    public boolean isDeleteSupported() {
        boolean rc;
        if (this.m_columnCount == 0) {
            return false;
        }
        if (this.m_newRow) {
            return true;
        }
        boolean bl = rc = !this.m_dataSet.isReadOnly();
        if (rc) {
            try {
                rc = this.m_dataSet.isRowsDeletable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rc) {
            rc = this.isCursorValid();
        }
        return rc;
    }

    public boolean isModified() {
        int i;
        boolean rc = false;
        if (this.m_formattedColsModified != null) {
            for (i = 0; i < this.m_formattedColsModified.length; ++i) {
                if (!this.m_formattedColsModified[i]) continue;
                rc = true;
                break;
            }
        }
        if (!rc && this.m_rawColsModified != null) {
            for (i = 0; i < this.m_rawColsModified.length; ++i) {
                if (!this.m_rawColsModified[i]) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    public boolean isCursorValid() {
        if (this.m_columnCount == 0) {
            return false;
        }
        return this.m_onRow;
    }

    protected void _init() {
        if (this.isDesignTime()) {
            this.m_columnCount = 0;
            return;
        }
        this.m_metaData = new Vector();
        this.m_columnCount = this.m_dataSet._getColumnCount();
        int i = 0;
        while (i < this.m_columnCount) {
            MetaData md = new MetaData();
            try {
                String temp = (String)this.m_dataSet.getColumnInfo(i + 1, "NAME");
                md.label = temp.toUpperCase();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            md.type = new String().getClass();
            md.index = i++;
            this.m_metaData.addElement(md);
        }
        this.m_rawColsModified = new boolean[this.m_columnCount];
        this.m_rawCols = new Object[this.m_columnCount];
        this.m_formattedColsModified = new boolean[this.m_columnCount];
        this.m_formattedCols = new Object[this.m_columnCount];
        this.first();
    }

    protected void _fireAll() {
        this.fpc("nextSupported", this.isNextSupported(), 0);
        this.fpc("previousSupported", this.isPreviousSupported(), 1);
        this.fpc("firstSupported", this.isFirstSupported(), 2);
        this.fpc("lastSupported", this.isLastSupported(), 3);
        this.fpc("commitSupported", this.isCommitSupported(), 4);
        this.fpc("insertSupported", this.isInsertSupported(), 5);
        this.fpc("deleteSupported", this.isDeleteSupported(), 6);
    }

    @Override
    public synchronized void contentsChanged(ContentsChangedEvent cce) {
        super.contentsChanged(cce);
        if (cce.getSource() == this.m_dataSet && !this.m_newRow) {
            if (this.isCursorValid()) {
                this._getRow(this.m_curPos);
            }
            if (!this.isCursorValid()) {
                this.first();
            }
        }
    }

    public boolean acceptStackLine(String line, Object clientData) {
        boolean rc = false;
        if (line.indexOf((String)clientData) > 0) {
            rc = true;
        }
        return rc;
    }

    protected void fpc(String propertyName, boolean newValue, int index) {
        if (this.supported[index] != newValue) {
            this.m_dataSet.firePropertyChange(propertyName, null, newValue ? Boolean.TRUE : Boolean.FALSE);
            this.supported[index] = newValue;
        }
    }
}

