/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.ComponentException;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.SASProcedureTemplate;
import com.sas.sasserver.dataset.DataSetDelegate;
import com.sas.sasserver.sclfuncs.SclfuncsV3Interface;
import com.sas.sasserver.submit.SubmitV2Interface;
import com.sas.table.SortException;

public class DataSetV2Delegate
extends DataSetDelegate {
    static final String RB_KEY = "DataSetV2Delegate.";
    protected String viewName;
    protected String originalDataSetName;
    protected RemoteBaseClient rbo;
    protected Connection con;
    protected SubmitV2Interface submit;
    protected SclfuncsV3Interface functions;
    protected boolean sortAllowed = true;
    protected String[] columnNames;
    protected int[] direction;

    public void sort(String[] columnNames, int[] direction) throws SortException {
        this.sort(columnNames, direction, false, false, null);
    }

    public void sort(String[] columnNames, int[] direction, boolean removeDuplicates, boolean sortInPlace, String outputLocation) throws SortException {
        if (this.isSortAllowed()) {
            this.columnNames = columnNames;
            this.direction = direction;
            this.sortEventFlag = false;
            if (columnNames.length == 0) {
                this.sortEventFlag = true;
                this.setDataSet(this.originalDataSetName);
            } else {
                if (this.originalDataSetName == null) {
                    this.originalDataSetName = this.dataSetName;
                }
                if (this.rbo == null) {
                    this.rbo = (RemoteBaseClient)((Object)this.getRemoteHandle());
                }
                if (this.con == null) {
                    this.con = this.rbo._RemoteObject_getContext();
                }
                if (this.functions == null) {
                    try {
                        this.functions = (SclfuncsV3Interface)this.con.getClassFactory().newInstance(SclfuncsV3Interface.class, this.con);
                    }
                    catch (Exception e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
                if (this.submit == null) {
                    try {
                        this.submit = (SubmitV2Interface)this.con.getClassFactory().newInstance(SubmitV2Interface.class, this.con);
                    }
                    catch (Exception e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
                if (columnNames.length != direction.length) {
                    throw new SortException();
                }
                for (int i = 0; i < direction.length - 1; ++i) {
                    if (!(direction[i] != 0 & direction[i] != 1)) continue;
                    throw new SortException();
                }
                if (!sortInPlace & outputLocation != null) {
                    String sortString = this.getSortStatement(columnNames, direction, removeDuplicates, sortInPlace, outputLocation);
                    this.submitProcedure(sortString);
                    this.sortEventFlag = true;
                    this.setDataSet(outputLocation);
                } else if (!sortInPlace) {
                    if (this.viewName == null) {
                        this.viewName = this.newViewName();
                        this.setReadOnly(true);
                    }
                    if (this.viewName != null) {
                        String sortString = this.getViewSortStatement(columnNames, direction, removeDuplicates, this.originalDataSetName, this.viewName);
                        this.submitProcedure(sortString);
                        this.sortEventFlag = true;
                        this.setDataSet(this.viewName);
                        this.setReadOnly(true);
                    }
                } else {
                    String sortString = this.getSortStatement(columnNames, direction, removeDuplicates, sortInPlace, outputLocation);
                    String currentName = this.dataSetName;
                    this.close();
                    this.submitProcedure(sortString);
                    this.sortEventFlag = true;
                    this.setDataSet(currentName);
                }
            }
        }
    }

    protected String newViewName() {
        String newName = null;
        int returnCode = 1;
        while (returnCode == 1) {
            newName = "WORK.V" + Long.toHexString(System.currentTimeMillis()).substring(0, 7);
            returnCode = this.functions.exist(newName, "VIEW");
        }
        return newName;
    }

    protected String getViewSortStatement(String[] columnNames, int[] direction, boolean removeDuplicates, String dataSetName, String viewName) {
        SASProcedureTemplate newSql = new SASProcedureTemplate();
        String templateString = !removeDuplicates ? "PROC %PROC; CREATE VIEW %OUTPUT AS SELECT %COLUMNS FROM %DATASET ORDER BY %ORDERBY ;" : "PROC %PROC; CREATE VIEW %OUTPUT AS SELECT DISTINCT %COLUMNS FROM %DATASET ORDER BY %ORDERBY ;";
        newSql.setTemplate(templateString);
        newSql.setProc("SQL");
        newSql.setOutput(viewName);
        newSql.setDataSet(dataSetName);
        newSql.setProcPrint(false);
        String byString = this.getByString(columnNames, direction);
        newSql.setOption("ORDERBY", byString);
        if (this.displayedColumns != null) {
            String columnString = "";
            for (int i = 0; i < this.displayedColumns.length; ++i) {
                columnString = i < this.displayedColumns.length - 1 ? columnString + this.displayedColumns[i] + ", " : columnString + this.displayedColumns[i] + " ";
            }
            newSql.setOption("COLUMNS", columnString);
        } else {
            newSql.setOption("COLUMNS", "*");
        }
        return newSql.getText();
    }

    protected String getSortStatement(String[] columnNames, int[] direction, boolean removeDuplicates, boolean sortInPlace, String outputLocation) {
        SASProcedureTemplate newSort = new SASProcedureTemplate();
        newSort.setProc("SORT");
        newSort.setDataSet(this.dataSetName);
        if (!sortInPlace) {
            newSort.setOutput(outputLocation);
        }
        if (removeDuplicates) {
            String templateString = "PROC %PROC %DATASET(DATA=%DATASET,) %OUTPUT( OUT=%OUTPUT, ) %NODUPRECS; %BY(BY %BY;) RUN;";
            newSort.setTemplate(templateString);
            newSort.setOption("NODUPRECS", "NODUPRECS");
            newSort.setProcPrint(false);
        }
        newSort.setBy(this.getByString(columnNames, direction));
        return newSort.getText();
    }

    protected void submitProcedure(String procedureString) {
        this.submit.setProgramText(procedureString);
    }

    protected String getByString(String[] columnNames, int[] direction) {
        int maxColumns = columnNames.length;
        String byString = new String();
        String directionString = new String();
        for (int i = 0; i < maxColumns; ++i) {
            directionString = direction[i] == 1 ? (this.viewName == null ? "DESCENDING " : " DESC") : "";
            byString = this.viewName == null ? byString + directionString + columnNames[i] : byString + columnNames[i] + directionString;
            if (maxColumns <= 1) continue;
            if (this.viewName == null) {
                byString = byString + " ";
                continue;
            }
            if (i >= maxColumns - 1) continue;
            byString = byString + ", ";
        }
        return byString;
    }

    public boolean isColumnSortable(String columnName) {
        return true;
    }

    public boolean isSortAllowed() {
        return this.sortAllowed;
    }

    public void setSortAllowed(boolean sortAllowed) {
        this.sortAllowed = sortAllowed;
    }

    public String[] getSortedColumns() {
        if (this.columnNames == null) {
            this.columnNames = new String[0];
        }
        return this.columnNames;
    }

    public int[] getSortedDirections() {
        if (this.direction == null) {
            this.direction = new int[0];
        }
        return this.direction;
    }
}

