/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.NodeIcon;
import com.sas.models.NodeInterface;
import com.sas.models.SequentialCache;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticCacheInterface;
import com.sas.sasserver.SASListDelegate;
import com.sas.sasserver.dataset.DataSetColumn;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.dataset.DataSetNode;
import com.sas.sasserver.dataset.RB;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.ColumnLabelChangedEvent;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.RowChangedEvent;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.util.Vector;

public class DataSetDelegate
extends SASListDelegate {
    private transient DataSetInterface m_remoteObject;
    static final String RB_KEY = "DataSetDelegate.";
    protected transient HListInterface datasetInfoList;
    protected transient OrderedCollection columnInfos;
    protected transient int numCols;
    protected transient int numRows;
    protected transient int levelColumn;
    protected transient int textColumn;
    protected transient int indexColumn;
    protected transient String whereClause;
    protected transient String dataSetName;
    protected transient boolean readOnly;
    protected transient long countedRows;
    protected transient boolean initializeCalled;
    protected transient boolean setDataSetPending;
    protected transient boolean setWherePending;
    protected transient boolean setSourcePending;
    protected transient boolean setEntryPending;
    protected transient boolean setDisplayedColumnsPending;
    protected transient String pendingDataSet;
    protected transient String[] displayedColumns;
    protected transient int bufferSize;
    protected transient int bufferBlocks;
    protected transient String rootText;
    protected transient SequentialCache rawCache;
    protected transient SequentialCache formattedCache;
    protected boolean readFormatted;
    protected transient DataSetNode dataSetNode;
    protected transient String source;
    protected transient String entry;
    protected transient String columnInfoUsed;
    protected transient boolean dataSetOpen;
    protected boolean sortEventFlag;
    boolean leafNode;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (DataSetInterface)this.remoteObject();
    }

    public DataSetInterface getRemoteHandle() {
        return this.m_remoteObject;
    }

    protected synchronized void initializeAllData() {
        this.columnInfos = new OrderedCollection();
        this.parsedList = new OrderedCollection();
        this.countedRows = -1L;
        this.rawCache = new SequentialCache((StaticCacheInterface)new DataSetReader(false));
        this.formattedCache = new SequentialCache((StaticCacheInterface)new DataSetReader(true));
    }

    protected synchronized void clearAllData() {
        this.rawCache.invalidateCache();
        this.formattedCache.invalidateCache();
    }

    @Override
    protected synchronized void resubmitQuery() {
        if (this.dataSetName == null) {
            return;
        }
        if (this.needs_refresh) {
            this.callFInfo();
            if (this.membersList != null) {
                this.parseList(this.membersList, this.parsedList);
            }
            this.clearAllData();
            this.countedRows = -1L;
        }
        this.needs_refresh = false;
    }

    private synchronized void refreshColumnInfos() {
        if (this.numCols > this.columnInfos.count()) {
            HListInterface outerList = this.datasetInfoList == null ? this.m_remoteObject._getColumnAttributes(0) : this.datasetInfoList.getList("ATTRIB");
            int outerListCount = outerList.count();
            for (int columnIndex = 0; columnIndex < outerListCount; ++columnIndex) {
                DataSetColumn columnInfo;
                HListInterface attrValueList = outerList.getList(columnIndex);
                String table = attrValueList.getString("TABLE");
                String label = attrValueList.getString("LABEL");
                String name = attrValueList.getString("NAME");
                String type = attrValueList.getString("TYPE").toUpperCase();
                String format = attrValueList.getString("FORMAT");
                String informat = attrValueList.getString("INFORMAT");
                int length = (int)attrValueList.getDouble("LENGTH");
                int intType = type.startsWith("C") || type.startsWith("c") ? DataSetColumn.CHARACTER : DataSetColumn.NUMERIC;
                DataSetColumn dataSetColumn = columnInfo = this.columnInfos.count() > columnIndex ? (DataSetColumn)this.columnInfos.get(columnIndex) : null;
                if (columnInfo == null) {
                    columnInfo = new DataSetColumn();
                    this.columnInfos.append(columnIndex, (Object)columnInfo);
                }
                columnInfo.setTable(table);
                columnInfo.setLabel(label);
                columnInfo.setName(name);
                columnInfo.setType(intType);
                columnInfo.setFormat(format);
                columnInfo.setInformat(informat);
                columnInfo.setLength(length);
                columnInfo.setStyleList(attrValueList);
            }
        }
    }

    protected synchronized void commonSetCell(int rowIndex, int columnIndex, Object value, boolean formatted) throws TableException {
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        if (!this.isCellsModifiable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidAccess.ex.txt"));
        }
        this.resubmitQuery();
        HList columnList = new HList();
        HList dataList = new HList();
        DoubleItem index = new DoubleItem((double)columnIndex);
        columnList.addItem((HListItem)index);
        if (formatted) {
            StringItem val = new StringItem((String)value);
            dataList.addItem((HListItem)val);
            int rc = this.m_remoteObject._setFormattedRow(rowIndex, (HListInterface)columnList, (HListInterface)dataList);
            if (rc != 0) {
                throw new TableException(RB.getStringResource(RB_KEY, "invalidSetFormattedRow.ex.txt"));
            }
        } else {
            Class type = this.getCellClass(rowIndex, columnIndex);
            Object val = null;
            val = type == String.class ? new StringItem((String)value) : new DoubleItem(((Double)value).doubleValue());
            dataList.addItem((HListItem)val);
            int rc = this.m_remoteObject._setRow(rowIndex, (HListInterface)columnList, (HListInterface)dataList);
            if (rc != 0) {
                throw new TableException(RB.getStringResource(RB_KEY, "invalidSetFormattedRow.ex.txt"));
            }
        }
        try {
            if (formatted) {
                if (this.formattedCache.cacheContainsKey((long)(rowIndex - 1))) {
                    this.formattedCache.invalidateCache((long)(rowIndex - 1));
                }
            } else if (this.rawCache.cacheContainsKey((long)(rowIndex - 1))) {
                this.rawCache.invalidateCache((long)(rowIndex - 1));
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        if (this.source == "" || this.source == null || this.entry == "" || this.entry == null) {
            this.fireContentsChanged(new DataCellChangedEvent(this.m_remoteObject, rowIndex, columnIndex, 1, 1));
        } else {
            this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, rowIndex, 1, 4));
        }
    }

    private synchronized void commonSetCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] cells, boolean formatted) throws TableException {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        if (startRowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startRowIndex)));
        }
        if (!this.isCellsModifiable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidAccess.ex.txt"));
        }
        if (rowCount > 1 && !this.isMultipleRowUpdateSupported()) {
            throw new TableException(RB.getStringResource(RB_KEY, "multipleRowUpdate.ex.txt"));
        }
        if (columnCount > 1 && !this.isMultipleColumnUpdateSupported()) {
            throw new TableException(RB.getStringResource(RB_KEY, "multipleColumnUpdate.ex.txt"));
        }
        this.resubmitQuery();
        this.disableEvents();
        if (formatted) {
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    this.setFormattedCell(startRowIndex + r, startColumnIndex + c, (String)cells[r][c]);
                }
            }
        } else {
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < columnCount; ++c) {
                    this.setCell(startRowIndex + r, startColumnIndex + c, cells[r][c]);
                }
            }
        }
        this.enableEventsSilently(false);
        if (this.source == "" || this.source == null || this.entry == "" || this.entry == null) {
            this.fireContentsChanged(new DataCellChangedEvent(this.m_remoteObject, startRowIndex, startColumnIndex, rowCount, columnCount));
        } else {
            this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, startRowIndex, rowCount, 4));
        }
    }

    private synchronized void commonSetColumn(int columnIndex, Object[] cells, boolean formatted) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        if (!this.isCellsModifiable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidAcces.ex.txt"));
        }
        if (cells.length > 1 && !this.isMultipleRowUpdateSupported()) {
            throw new TableException(RB.getStringResource(RB_KEY, "multipleRowUpdate.ex.txt"));
        }
        this.resubmitQuery();
        this.disableEvents();
        int rowCount = this.getRowCount();
        if (rowCount == -1) {
            throw new TableException(RB.getStringResource(RB_KEY, "unknownRowCount.ex.txt"));
        }
        if (formatted) {
            for (int r = 1; r <= rowCount; ++r) {
                this.setFormattedCell(r, columnIndex, (String)cells[r - 1]);
            }
        } else {
            for (int r = 1; r <= rowCount; ++r) {
                this.setCell(r, columnIndex, cells[r - 1]);
            }
        }
        this.enableEventsSilently(false);
        this.fireContentsChanged(new ColumnChangedEvent(this.m_remoteObject, columnIndex, 1, 4));
    }

    private synchronized void commonSetRow(int rowIndex, Object[] cells, boolean formatted) throws TableException {
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        if (!this.isCellsModifiable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidAcces.ex.txt"));
        }
        if (cells.length > 1 && !this.isMultipleColumnUpdateSupported()) {
            throw new TableException(RB.getStringResource(RB_KEY, "multipleColumnUpdate.ex.txt"));
        }
        this.resubmitQuery();
        this.disableEvents();
        int columnCount = this.getColumnCount();
        if (formatted) {
            for (int c = 1; c <= columnCount; ++c) {
                this.setFormattedCell(rowIndex, c, (String)cells[c - 1]);
            }
        } else {
            for (int c = 1; c <= columnCount; ++c) {
                this.setCell(rowIndex, c, cells[c - 1]);
            }
        }
        this.enableEventsSilently(false);
        this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, rowIndex, 1, 4));
    }

    public synchronized int countColumns(int maxCount) throws TableException {
        return this.getColumnCount();
    }

    public synchronized int countRows(int maximumRowCount) throws TableException {
        this.resubmitQuery();
        int numRows = this.getRowCount();
        if (numRows >= 0) {
            return numRows;
        }
        if (this.countedRows >= (long)maximumRowCount) {
            return (int)this.countedRows;
        }
        if (maximumRowCount == 0) {
            maximumRowCount = Integer.MAX_VALUE;
        }
        this.countedRows = this.m_remoteObject._countRows(maximumRowCount);
        return (int)this.countedRows;
    }

    public synchronized Object getCell(int rowIndex, int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        this.resubmitQuery();
        try {
            Row row = (Row)this.rawCache.getFromCache((long)(rowIndex - 1));
            return row.data[columnIndex - 1];
        }
        catch (IndexOutOfBoundsException iobe) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        catch (CacheException ce) {
            String message = RB.getStringResource(RB_KEY, "invalidCell.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex), (Object)new Integer(columnIndex)));
        }
    }

    public synchronized Class getCellClass(int rowIndex, int columnIndex) throws TableException {
        this.resubmitQuery();
        return this.getColumnClass(columnIndex);
    }

    public synchronized Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        if (startRowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startRowIndex)));
        }
        this.resubmitQuery();
        Class[][] types = new Class[rowCount][columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            Class columnClass = this.getColumnClass(startColumnIndex + c - 1);
            for (int r = 1; r <= rowCount; ++r) {
                types[r - 1][c - 1] = columnClass;
            }
        }
        return types;
    }

    public synchronized Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        this.resubmitQuery();
        Object[][] cells = new Object[rowCount][columnCount];
        for (int r = 1; r <= rowCount; ++r) {
            for (int c = 1; c <= columnCount; ++c) {
                cells[r - 1][c - 1] = this.getCell(startRowIndex + r - 1, startColumnIndex + c - 1);
            }
        }
        return cells;
    }

    public synchronized Object[] getColumn(int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        this.resubmitQuery();
        int rowCount = this.getRowCount();
        if (rowCount == -1) {
            Vector<Object> columnValues = new Vector<Object>();
            int i = 1;
            try {
                while (true) {
                    Object cellValue = this.m_remoteObject.getCell(i++, columnIndex);
                    columnValues.addElement(cellValue);
                }
            }
            catch (IndexOutOfBoundsException e) {
                int numberOfColumnValues = columnValues.size();
                Object[] returnArray = new Object[numberOfColumnValues];
                for (int r = 0; r < numberOfColumnValues; ++r) {
                    returnArray[r] = columnValues.elementAt(r);
                }
                return returnArray;
            }
        }
        Object[] cells = new Object[rowCount];
        for (int r = 1; r <= rowCount; ++r) {
            cells[r - 1] = this.getCell(r, columnIndex);
        }
        return cells;
    }

    public synchronized int getColumnCount() throws TableException {
        if (this.datasetInfoList != null) {
            return (int)this.datasetInfoList.getDouble("NUMCOLS");
        }
        this.resubmitQuery();
        return this.numCols;
    }

    public synchronized Object[] getRow(int rowIndex) throws TableException {
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        this.resubmitQuery();
        try {
            Row row = (Row)this.rawCache.getFromCache((long)(rowIndex - 1));
            return row.data;
        }
        catch (CacheException ce) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
    }

    public synchronized int getRowCount() throws TableException {
        if (this.datasetInfoList != null) {
            return (int)this.datasetInfoList.getDouble("NUMROWS");
        }
        this.resubmitQuery();
        return this.numRows;
    }

    public synchronized Class getColumnClass(int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        this.resubmitQuery();
        this.refreshColumnInfos();
        int type = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getType();
        if (type == DataSetColumn.CHARACTER) {
            return String.class;
        }
        if (type == DataSetColumn.NUMERIC) {
            return Double.class;
        }
        throw new TableException(RB.getStringResource(RB_KEY, "invalidColumnType.ex.txt"));
    }

    public synchronized Class[] getColumnClasses(int startColumnIndex, int columnCount) throws TableException {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        this.resubmitQuery();
        Class[] types = new Class[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            types[c - 1] = this.getColumnClass(startColumnIndex + c - 1);
        }
        return types;
    }

    public synchronized boolean isCellsModifiable() {
        boolean returnValue = true;
        if (this.isReadOnly()) {
            returnValue = false;
        } else {
            int rc = this.m_remoteObject._setRow(1, null, null);
            if (rc != 0) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public synchronized boolean isMultipleColumnUpdateSupported() {
        return this.isCellsModifiable();
    }

    public synchronized boolean isMultipleRowUpdateSupported() {
        return this.isCellsModifiable();
    }

    public synchronized void setCell(int rowIndex, int columnIndex, Object value) throws TableException {
        this.commonSetCell(rowIndex, columnIndex, value, false);
    }

    public synchronized void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] cells) throws TableException {
        this.commonSetCells(startRowIndex, startColumnIndex, rowCount, columnCount, cells, false);
    }

    public synchronized void setColumn(int columnIndex, Object[] cells) throws TableException {
        this.commonSetColumn(columnIndex, cells, false);
    }

    public synchronized void setRow(int rowIndex, Object[] cells) throws TableException {
        this.commonSetRow(rowIndex, cells, false);
    }

    public synchronized String getFormattedCell(int rowIndex, int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        this.resubmitQuery();
        try {
            Row row = (Row)this.formattedCache.getFromCache((long)(rowIndex - 1));
            return row.formattedData[columnIndex - 1];
        }
        catch (CacheException ce) {
            String message = RB.getStringResource(RB_KEY, "invalidCell.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex), (Object)new Integer(columnIndex)));
        }
    }

    public synchronized String[][] getFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        if (startRowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startRowIndex)));
        }
        this.resubmitQuery();
        String[][] formattedCells = new String[rowCount][columnCount];
        for (int r = 1; r <= rowCount; ++r) {
            for (int c = 1; c <= columnCount; ++c) {
                formattedCells[r - 1][c - 1] = this.getFormattedCell(startRowIndex + r - 1, startColumnIndex + c - 1);
            }
        }
        return formattedCells;
    }

    public synchronized String[] getFormattedColumn(int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        this.resubmitQuery();
        int rowCount = this.getRowCount();
        if (rowCount == -1) {
            Vector<String> columnValues = new Vector<String>();
            int i = 1;
            try {
                while (true) {
                    String cellValue = this.getFormattedCell(i++, columnIndex);
                    columnValues.addElement(cellValue);
                }
            }
            catch (IndexOutOfBoundsException e) {
                int numberOfColumnValues = columnValues.size();
                String[] returnArray = new String[numberOfColumnValues];
                for (int r = 0; r < numberOfColumnValues; ++r) {
                    returnArray[r] = (String)columnValues.elementAt(r);
                }
                return returnArray;
            }
        }
        String[] formattedCells = new String[rowCount];
        for (int r = 1; r <= rowCount; ++r) {
            formattedCells[r - 1] = this.getFormattedCell(r, columnIndex);
        }
        return formattedCells;
    }

    public synchronized String[] getFormattedRow(int rowIndex) throws TableException {
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        this.resubmitQuery();
        try {
            Row row = (Row)this.formattedCache.getFromCache((long)(rowIndex - 1));
            return row.formattedData;
        }
        catch (CacheException ce) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
    }

    public synchronized void setFormattedCell(int rowIndex, int columnIndex, String value) throws TableException {
        this.commonSetCell(rowIndex, columnIndex, value, true);
    }

    public synchronized void setFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, String[][] values) throws TableException {
        this.commonSetCells(startRowIndex, startColumnIndex, rowCount, columnCount, values, true);
    }

    public synchronized void setFormattedColumn(int columnIndex, String[] values) throws TableException {
        this.commonSetColumn(columnIndex, values, true);
    }

    public synchronized void setFormattedRow(int rowIndex, String[] values) throws TableException {
        this.commonSetRow(rowIndex, values, true);
    }

    public synchronized void addColumn(int index, Class cellClass, Object defaultValue) throws TableException {
        throw new TableException(RB.getStringResource(RB_KEY, "columnsExtendableInsertable.ex.txt"));
    }

    public synchronized void addRow(int rowIndex) throws TableException {
        if (!this.isRowsExtendable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "rowsExtendable.ex.txt"));
        }
        if (!this.isRowsInsertable() && rowIndex != -1) {
            throw new TableException(RB.getStringResource(RB_KEY, "rowsInsertable.ex.txt"));
        }
        HList columnList = new HList();
        HList dataList = new HList();
        this.m_remoteObject._addRow((HListInterface)columnList, (HListInterface)dataList);
        this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, rowIndex, 1, 3));
    }

    public synchronized void addRow(int rowIndex, Object[] cells) throws TableException {
        if (!this.isRowsExtendable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "rowsExtendable.ex.txt"));
        }
        if (!this.isRowsInsertable() && rowIndex != -1) {
            throw new TableException(RB.getStringResource(RB_KEY, "rowsInsertable.ex.txt"));
        }
        boolean isRaw = true;
        if (cells.length >= 1 && cells[cells.length - 1] instanceof String && cells[cells.length - 1] != null && cells[cells.length - 1].equals("__FORMATTED__")) {
            isRaw = false;
        }
        HList columnList = new HList();
        HList dataList = new HList();
        if (!isRaw) {
            columnList.addItem((HListItem)new DoubleItem(-1.0));
            dataList.addItem((HListItem)new StringItem("__FORMATTED__"));
        }
        int limit = cells.length - (isRaw ? 0 : 1);
        for (int valuesIndex = 0; valuesIndex < limit; ++valuesIndex) {
            if (cells[valuesIndex] == null) continue;
            DoubleItem itemIndex = new DoubleItem((double)(valuesIndex + 1));
            columnList.addItem((HListItem)itemIndex);
            Class itemType = this.getCellClass(rowIndex, valuesIndex + 1);
            StringItem itemValue = null;
            if (isRaw) {
                if (itemType == Double.class) {
                    itemValue = new DoubleItem(((Double)cells[valuesIndex]).doubleValue());
                } else if (itemType == String.class) {
                    itemValue = new StringItem((String)cells[valuesIndex]);
                }
            } else {
                itemValue = new StringItem((String)cells[valuesIndex]);
            }
            dataList.addItem((HListItem)itemValue);
        }
        this.m_remoteObject._addRow((HListInterface)columnList, (HListInterface)dataList);
        this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, rowIndex, 1, 3));
    }

    public synchronized void deleteColumn(int index) throws TableException {
        throw new TableException(RB.getStringResource(RB_KEY, "columnsDeletable.ex.txt"));
    }

    public synchronized void deleteRow(int rowIndex) throws TableException {
        if (rowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        if (!this.isRowsDeletable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "rowsDeletable.ex.txt"));
        }
        int rc = this.m_remoteObject._deleteRow(rowIndex);
        if (rc > 0) {
            String message = RB.getStringResource(RB_KEY, "unableToDeleteRow.ex.txt");
            throw new IllegalArgumentException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
        this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject, rowIndex, 1, 2));
    }

    public synchronized Object getColumnDefaultValue(int index) throws TableException {
        if (!this.isColumnsRedefinable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "columnsRedefinable.ex.txt"));
        }
        return null;
    }

    public synchronized Object[] getColumnDefaultValues(int startIndex, int count) throws TableException {
        if (!this.isColumnsRedefinable()) {
            throw new TableException(RB.getStringResource(RB_KEY, "columnsRedefinable.ex.txt"));
        }
        return null;
    }

    public synchronized boolean isColumnsDeletable() throws TableException {
        return false;
    }

    public synchronized boolean isColumnsExtendable() throws TableException {
        return false;
    }

    public synchronized boolean isColumnsInsertable() throws TableException {
        return false;
    }

    public synchronized boolean isColumnsRedefinable() throws TableException {
        return false;
    }

    public synchronized boolean isRowsDeletable() throws TableException {
        return this.isCellsModifiable();
    }

    public synchronized boolean isRowsExtendable() throws TableException {
        return this.isCellsModifiable();
    }

    public synchronized boolean isRowsInsertable() throws TableException {
        return false;
    }

    public synchronized void setColumnClass(int index, Class newClass) throws TableException {
        throw new TableException(RB.getStringResource(RB_KEY, "columnsRedefinable.ex.txt"));
    }

    public synchronized void setColumnDefaultValue(int index, Object newValue) throws TableException {
        throw new TableException(RB.getStringResource(RB_KEY, "columnsRedefinable.ex.txt"));
    }

    public synchronized Object getColumnLabel(int columnIndex) throws TableException {
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        this.resubmitQuery();
        this.refreshColumnInfos();
        Object columnLabel = this.getColumnInfo(columnIndex, this.getColumnInfoUsed());
        if (columnLabel == null || columnLabel.toString().length() == 0) {
            columnLabel = this.getColumnInfo(columnIndex, "NAME");
        }
        return columnLabel;
    }

    public synchronized Object[] getColumnLabels(int startColumnIndex, int columnCount) throws TableException {
        if (startColumnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startColumnIndex)));
        }
        this.resubmitQuery();
        Object[] labels = new Object[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            labels[c - 1] = this.getColumnLabel(startColumnIndex + c - 1);
        }
        return labels;
    }

    public synchronized boolean isColumnLabelsSupported() throws TableException {
        return true;
    }

    public synchronized boolean isColumnsLabelSupported() throws TableException {
        return false;
    }

    public synchronized Object getRowLabel(int rowIndex) throws TableException {
        this.resubmitQuery();
        try {
            Row row = this.rawCache.cacheContainsKey((long)(rowIndex - 1)) ? (Row)this.rawCache.getFromCache((long)(rowIndex - 1)) : (Row)this.formattedCache.getFromCache((long)(rowIndex - 1));
            return row.label;
        }
        catch (CacheException ce) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(rowIndex)));
        }
    }

    public synchronized Object[] getRowLabels(int startRowIndex, int rowCount) throws TableException {
        if (startRowIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidRow.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(startRowIndex)));
        }
        this.resubmitQuery();
        Object[] labels = new Object[rowCount];
        for (int r = 1; r <= rowCount; ++r) {
            labels[r - 1] = this.getRowLabel(startRowIndex + r - 1);
        }
        return labels;
    }

    public synchronized boolean isRowLabelsSupported() throws TableException {
        return true;
    }

    public synchronized boolean isRowsLabelSupported() throws TableException {
        return false;
    }

    public synchronized Object getColumnInfo(int columnIndex, String columnInfoName) throws TableException {
        Object columnInfo;
        if (columnIndex <= 0) {
            String message = RB.getStringResource(RB_KEY, "invalidColumn.ex.txt");
            throw new IndexOutOfBoundsException(Message.format((String)message, (Object)new Integer(columnIndex)));
        }
        this.resubmitQuery();
        this.refreshColumnInfos();
        if (columnInfoName.equalsIgnoreCase("TABLE")) {
            columnInfo = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getTable();
        } else if (columnInfoName.equalsIgnoreCase("NAME")) {
            columnInfo = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getName();
        } else if (columnInfoName.equalsIgnoreCase("LABEL")) {
            String label = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getLabel();
            if (label.trim().length() == 0) {
                label = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getLabel();
            }
            columnInfo = label;
        } else if (columnInfoName.equalsIgnoreCase("TYPE")) {
            int type = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getType();
            columnInfo = type == DataSetColumn.NUMERIC ? "N" : "C";
        } else if (columnInfoName.equalsIgnoreCase("FORMAT")) {
            String format = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getFormat();
            columnInfo = format;
        } else if (columnInfoName.equalsIgnoreCase("INFORMAT")) {
            String informat = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getInformat();
            columnInfo = informat;
        } else if (columnInfoName.equalsIgnoreCase("LENGTH")) {
            int length = ((DataSetColumn)this.columnInfos.get(columnIndex - 1)).getLength();
            columnInfo = new Integer(length);
        } else {
            throw new TableException(RB.getStringResource(RB_KEY, "invalidColumnInfoName.ex.txt"));
        }
        return columnInfo;
    }

    public synchronized String[] getColumnInfoNames() throws TableException {
        String[] columnInfoNames = new String[]{"NAME", "LABEL", "FORMAT", "INFORMAT", "LENGTH"};
        return columnInfoNames;
    }

    public synchronized String[] formatValues(int index, Object[] inputValuesArray) throws TableException {
        this.resubmitQuery();
        this.refreshColumnInfos();
        String formatName = ((DataSetColumn)this.columnInfos.get(index - 1)).getFormat();
        if (formatName.trim().length() == 0) {
            return null;
        }
        HList inputValues = new HList();
        for (int i = 0; inputValuesArray != null && i < inputValuesArray.length; ++i) {
            if (inputValuesArray[i] instanceof Double) {
                inputValues.addItem((HListItem)new DoubleItem(((Double)inputValuesArray[i]).doubleValue()));
                continue;
            }
            if (inputValuesArray[i] instanceof String) {
                inputValues.addItem((HListItem)new StringItem((String)inputValuesArray[i]));
                continue;
            }
            throw new TableException(RB.getStringResource(RB_KEY, "invalidInputValueType.ex.txt"));
        }
        HListInterface outputValues = this.m_remoteObject._formatValues(formatName, (HListInterface)inputValues);
        String[] outputValuesArray = new String[outputValues.count()];
        int outputValuesCount = outputValues.count();
        for (int i = 0; i < outputValuesCount; ++i) {
            outputValuesArray[i] = outputValues.getString(i);
        }
        return outputValuesArray;
    }

    public synchronized int getColumnIndex(String columnName) throws IllegalArgumentException, TableException {
        this.resubmitQuery();
        this.refreshColumnInfos();
        int n = this.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String name = (String)this.getColumnInfo(i, "NAME");
            if (!columnName.equalsIgnoreCase(name)) continue;
            return i;
        }
        String message = RB.getStringResource(RB_KEY, "invalidColumnName.ex.txt");
        throw new IllegalArgumentException(Message.format((String)message, (Object)columnName));
    }

    public String getDataSetName() {
        if (this.dataSetName == null) {
            return null;
        }
        String name = this.dataSetName;
        int openParenIndex = name.indexOf("(");
        if (openParenIndex > 0) {
            name = name.substring(0, openParenIndex);
        }
        return name;
    }

    public String getDataSetOptions() {
        if (this.dataSetName == null) {
            return null;
        }
        String options = this.dataSetName;
        int openParenIndex = options.lastIndexOf("(");
        options = openParenIndex > 0 ? options.substring(openParenIndex) : "";
        return options;
    }

    public String getColumnInfoUsed() {
        return this.columnInfoUsed;
    }

    public synchronized void setColumnInfoUsed(String columnInfoUsed) throws TableException {
        String oldValue = this.getColumnInfoUsed();
        if (columnInfoUsed == null || columnInfoUsed.trim().length() == 0) {
            columnInfoUsed = "NAME";
        }
        this.columnInfoUsed = columnInfoUsed;
        String newValue = this.getColumnInfoUsed();
        if (!Util.equal((Object)oldValue, (Object)newValue)) {
            int columnCount = this.getColumnCount();
            if (columnCount != 0) {
                this.fireContentsChanged(new ColumnLabelChangedEvent(this.m_remoteObject, 1, columnCount));
            }
            this.firePropertyChange("columnInfoUsed", oldValue, newValue);
        }
    }

    public synchronized void close() {
        if (this.dataSetOpen && this.initializeCalled) {
            String previousDataSetName = this.dataSetName;
            this.setDisplayedColumns(null);
            this.columnInfos.removeAll();
            this.m_remoteObject._close();
            this.dataSetOpen = false;
            this.datasetInfoList = null;
            this.dataSetName = null;
            this.numCols = 0;
            this.numRows = 0;
            this.dataSetNode = null;
            this.fireContentsChanged(new ContentsChangedEvent((Object)this.m_remoteObject));
            this.firePropertyChange("dataSet", previousDataSetName, this.dataSetName);
        }
    }

    public synchronized void enableEventsSilently(boolean forceRefresh) {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
        }
        if (forceRefresh) {
            this.needs_refresh = true;
            this.hasChildren = true;
        }
    }

    public synchronized void commitRow() {
        this.m_remoteObject._commitRow();
    }

    public synchronized int getBufferBlocks() {
        return this.bufferBlocks;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public void useBufferHints(BufferHints hints) {
        while (hints != null) {
            if ((hints.how & 1) == 1) {
                if (hints.what == 8192) {
                    this.setBufferBlocks(hints.count);
                } else if (hints.what == 4096) {
                    this.setBufferSize(hints.count);
                }
            }
            hints = hints.moreHints;
        }
    }

    public synchronized String getDataSet() {
        return this.dataSetName;
    }

    public synchronized String[] getDisplayedColumns() {
        return this.displayedColumns;
    }

    public synchronized String getWhere() {
        return this.whereClause;
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setBufferBlocks(int bufferBlocks) {
        this.bufferBlocks = bufferBlocks;
        try {
            this.rawCache.configureCache(bufferBlocks * this.bufferSize, -1, -1, -1, -1);
            this.formattedCache.configureCache(bufferBlocks * this.bufferSize, -1, -1, -1, -1);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        try {
            this.rawCache.configureCache(this.bufferBlocks * bufferSize, bufferSize, -1, -1, -1);
            this.formattedCache.configureCache(this.bufferBlocks * bufferSize, bufferSize, -1, -1, -1);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void refresh() {
        String tempDataSetName = this.getDataSet();
        String[] tempDisplayedColumns = this.getDisplayedColumns();
        this.close();
        this.setDisplayedColumns(tempDisplayedColumns);
        this.setDataSet(tempDataSetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSet(String dataSetName) {
        String previousDataSetName = this.getDataSet();
        DataSetDelegate dataSetDelegate = this;
        synchronized (dataSetDelegate) {
            this.disableEvents();
            String[] preservedColumns = this.displayedColumns;
            this.close();
            if (this.sortEventFlag) {
                this.setDisplayedColumns(preservedColumns);
            }
            this.enableEventsSilently(false);
            if (dataSetName != null) {
                dataSetName = dataSetName.toUpperCase();
            }
            if (this.initializeCalled) {
                int rc = this.m_remoteObject._setDataSet(dataSetName, this.isReadOnly() ? "BROWSE" : "EDIT");
                if (rc > 0) {
                    String message = Message.format((String)RB.getStringResource(RB_KEY, "unableToOpenDataSet.ex.txt"), (Object)dataSetName);
                    throw new IllegalArgumentException(message);
                }
                this.dataSetOpen = true;
                this.setDataSetPending = false;
            } else {
                this.setDataSetPending = true;
            }
            this.numCols = this.datasetInfoList != null ? (int)this.datasetInfoList.getDouble("NUMCOLS") : this.m_remoteObject._getColumnCount();
            this.dataSetName = dataSetName;
            if (this.whereClause != null) {
                this.setWhere(this.whereClause);
            }
            if (this.displayedColumns != null) {
                this.setDisplayedColumns(this.displayedColumns);
            }
            this.columnInfos.removeAll();
            this.refreshColumnInfos();
            this.pendingDataSet = dataSetName;
        }
        if (this.sortEventFlag) {
            this.fireContentsChanged(new RowChangedEvent(this.m_remoteObject));
        } else {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this.m_remoteObject));
        }
        this.firePropertyChange("dataSet", previousDataSetName, dataSetName);
        this.firePropertyChange("dataSetName", null, null);
        this.firePropertyChange("dataSetOptions", null, null);
    }

    public synchronized void setDisplayedColumns(String[] displayedColumns) {
        String[] previousDisplayedColumns = this.getDisplayedColumns();
        if (this.initializeCalled && this.dataSetOpen) {
            HList displayedColumnsList = new HList();
            if (displayedColumns != null) {
                for (int c = 0; c < displayedColumns.length; ++c) {
                    StringItem item = new StringItem(displayedColumns[c]);
                    displayedColumnsList.addItem((HListItem)item);
                }
            }
            this.m_remoteObject._setDisplayedColumns((HListInterface)displayedColumnsList);
            this.refreshAllColumnInfo();
            this.needs_refresh = true;
            this.resubmitQuery();
            this.setDisplayedColumnsPending = false;
        } else {
            this.setDisplayedColumnsPending = true;
        }
        this.displayedColumns = displayedColumns;
        this.fireContentsChanged();
        this.firePropertyChange("displayedColumns", previousDisplayedColumns, displayedColumns);
    }

    public synchronized String getRootText() {
        return this.rootText;
    }

    public synchronized void setRootText(String rootText) {
        this.rootText = rootText;
    }

    public synchronized void setPendingDataSet(String name) {
        this.pendingDataSet = name = name.toUpperCase();
    }

    public synchronized void setReadOnly(boolean readOnly) {
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"readOnly", (boolean)readOnly);
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"cellsModifiable", (!readOnly ? 1 : 0) != 0);
            if (this.initializeCalled) {
                int rc = this.m_remoteObject._setDataSet(this.dataSetName, this.isReadOnly() ? "BROWSE" : "EDIT");
                if (rc > 0) {
                    String message = Message.format((String)RB.getStringResource(RB_KEY, "unableToOpenDataSet.ex.txt"), (Object)this.dataSetName);
                    throw new IllegalArgumentException(message);
                }
                String[] displayedColumns = this.getDisplayedColumns();
                if (displayedColumns != null) {
                    HList displayedColumnsList = new HList();
                    for (int i = 0; i < displayedColumns.length; ++i) {
                        StringItem item = new StringItem(displayedColumns[i]);
                        displayedColumnsList.addItem((HListItem)item);
                    }
                    this.m_remoteObject._setDisplayedColumns((HListInterface)displayedColumnsList);
                }
            }
        }
    }

    public synchronized void setWhere(String whereClause) {
        String previousWhereClause = this.getWhere();
        if (this.initializeCalled) {
            if (this.getDataSet() == null || this.getDataSet().length() < 1) {
                return;
            }
            HListInterface whereList = DataSetDelegate.parseWhereClauseToList(whereClause);
            this.m_remoteObject._setWhere(whereList);
            this.setWherePending = false;
        } else {
            this.setWherePending = true;
        }
        this.whereClause = whereClause;
        this.fireContentsChanged();
        this.firePropertyChange("where", previousWhereClause, whereClause);
    }

    private static HListInterface parseWhereClauseToList(String whereClause) {
        int whereClauseLength;
        HList whereList = new HList();
        if (whereClause != null && (whereClauseLength = whereClause.length()) > 0) {
            StringItem stringItem = new StringItem(whereClause);
            whereList.addItem((HListItem)stringItem);
        }
        return whereList;
    }

    public synchronized int getIndexColumn() {
        return this.indexColumn;
    }

    public synchronized void setIndexColumn(int columnIndex) {
        int previousIndexColumn = this.indexColumn;
        if (previousIndexColumn != columnIndex) {
            this.indexColumn = columnIndex;
            this.dataSetNode = null;
            this.fireContentsChanged();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"indexColumn", (int)previousIndexColumn, (int)columnIndex);
        }
    }

    public synchronized int getLevelColumn() {
        return this.levelColumn;
    }

    public synchronized void setLevelColumn(int columnIndex) {
        int previousLevelColumn = this.levelColumn;
        if (previousLevelColumn != columnIndex) {
            this.levelColumn = columnIndex;
            this.dataSetNode = null;
            this.fireContentsChanged();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"levelColumn", (int)previousLevelColumn, (int)columnIndex);
        }
    }

    public synchronized int getTextColumn() {
        return this.textColumn;
    }

    public synchronized void setTextColumn(int columnIndex) {
        int previousTextColumn = this.textColumn;
        if (previousTextColumn != columnIndex) {
            this.textColumn = columnIndex;
            this.dataSetNode = null;
            this.fireContentsChanged();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"textColumn", (int)previousTextColumn, (int)columnIndex);
        }
    }

    protected void refreshAllColumnInfo() {
        this.callFInfo();
        this.columnInfos.removeAll();
        this.refreshColumnInfos();
    }

    public synchronized String getSource() {
        return this.source;
    }

    public synchronized void setSource(String source) {
        String previousSource = this.getSource();
        if (this.initializeCalled) {
            if (Util.equal((Object)previousSource, (Object)source) && !this.setSourcePending) {
                return;
            }
            int rc = this.m_remoteObject._setSource(source);
            if (rc != 0) {
                String message = RB.getStringResource(RB_KEY, "invalidSource.ex.txt");
                throw new IllegalArgumentException(Message.format((String)message, (Object)source));
            }
            if (this.getEntry() != null && !this.setEntryPending) {
                this.refreshAllColumnInfo();
            }
            this.setSourcePending = false;
        } else {
            this.setSourcePending = true;
        }
        this.source = source;
        this.fireContentsChanged();
        this.firePropertyChange("source", previousSource, source);
    }

    public synchronized String getEntry() {
        return this.entry;
    }

    public synchronized void setEntry(String entry) {
        String previousEntry = this.getEntry();
        if (this.initializeCalled) {
            if (Util.equal((Object)previousEntry, (Object)entry) && !this.setEntryPending) {
                return;
            }
            int rc = this.m_remoteObject._setEntry(entry);
            if (rc != 0) {
                String message = RB.getStringResource(RB_KEY, "invalidEntry.ex.txt");
                throw new IllegalArgumentException(Message.format((String)message, (Object)entry));
            }
            if (this.getSource() != null && !this.setSourcePending) {
                this.refreshAllColumnInfo();
            }
            this.setEntryPending = false;
        } else {
            this.setEntryPending = true;
        }
        this.entry = entry;
        this.fireContentsChanged();
        this.firePropertyChange("entry", previousEntry, entry);
    }

    public synchronized NodeInterface getRoot() {
        if (this.isDesignTime() || this.isLeafNode()) {
            return null;
        }
        NodeInterface root = this.m_remoteObject;
        try {
            block7: {
                int columnCount = this.getColumnCount();
                if (this.levelColumn <= 0) break block7;
                if (this.textColumn <= 0) break;
                if (this.indexColumn <= 0) break;
                if (this.levelColumn > columnCount) break;
                if (this.textColumn > columnCount) break;
                if (this.indexColumn > columnCount) break;
                if (this.getColumnClass(this.levelColumn) != Double.class) break;
                if (this.getColumnClass(this.indexColumn) == Double.class) {
                    if (this.dataSetNode == null) {
                        this.dataSetNode = new DataSetNode(this.m_remoteObject, this.getNodeText(), 0, 0, 0);
                    }
                    root = this.dataSetNode;
                    return root;
                }
                break;
            }
        }
        catch (TableException tableException) {}
        finally {
            return root;
        }
    }

    public synchronized int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public synchronized SimpleNodeInterface getNodeChild(int index) {
        return this.getNodeChildren(index, 1)[0];
    }

    public synchronized int getNodeChildCount() {
        int childCount;
        if (this.pendingDataSet != null && !this.pendingDataSet.equalsIgnoreCase(this.getDataSet())) {
            this.setDataSet(this.pendingDataSet);
        }
        if ((childCount = this.count()) == 0 && this.hasChildren) {
            this.hasChildren = false;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this.m_remoteObject, (String)"leafNode", (boolean)true);
        }
        return childCount;
    }

    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        int nodeChildCount = this.getNodeChildCount();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        if (nodeChildCount == 0) {
            return childrenArray;
        }
        ImageView columnImage = new ImageView(Resources.getImage((String)"Column"));
        for (int index = startIndex; index < startIndex + count && index < startIndex + nodeChildCount; ++index) {
            String columnName = (String)this.get(index);
            NodeIcon node = new NodeIcon(columnName, "Column");
            node.setDefaultIcon(columnImage);
            childrenArray[index - startIndex] = node;
        }
        return childrenArray;
    }

    public synchronized boolean isLeafNode() {
        if (this.leafNode) {
            return true;
        }
        if (this.pendingDataSet != null && !this.pendingDataSet.equalsIgnoreCase(this.getDataSet())) {
            if (this.pendingDataSet.trim().length() == 0) {
                this.hasChildren = false;
            }
        } else if (this.getDataSet() == null || this.getDataSet().trim().length() == 0) {
            this.hasChildren = false;
        }
        return !this.hasChildren;
    }

    public synchronized void setLeafNode(boolean leafNode) {
        this.leafNode = leafNode;
    }

    public synchronized String getNodeExpandedText() {
        return this.getNodeText();
    }

    public synchronized String getNodeText() {
        String tempRootText = this.getRootText();
        if (tempRootText != null) {
            return tempRootText;
        }
        return this.pendingDataSet;
    }

    public synchronized String getNodeType() {
        return null;
    }

    public synchronized IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"DataSet"));
    }

    public synchronized IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public synchronized IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public synchronized IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }

    @Override
    public synchronized void initialize() {
        this.needs_refresh = true;
        this.hasChildren = true;
        this.initializeCalled = true;
        super.initialize();
        this.disableEvents();
        if (this.setDataSetPending) {
            this.setDataSet(this.getDataSet());
        }
        if (this.setSourcePending) {
            this.setSource(this.getSource());
        }
        if (this.setEntryPending) {
            this.setEntry(this.getEntry());
        }
        this.enableEvents();
    }

    public synchronized void setDefaultValues() {
        super.setDefaultValues();
        this.initializeAllData();
        this.readOnly = true;
        this.columnInfoUsed = "NAME";
        this.bufferSize = 16;
        this.bufferBlocks = 2;
    }

    public int _setDataSet(String dataSetName, String mode) {
        if (dataSetName == null) {
            this.datasetInfoList = null;
            return 0;
        }
        this.datasetInfoList = this.m_remoteObject._fopen(dataSetName, mode);
        if (this.datasetInfoList == null) {
            return 1;
        }
        return (int)this.datasetInfoList.getDouble("OPENRC");
    }

    private void callFInfo() {
        if (this.dataSetName != null && this.dataSetName.length() != 0) {
            this.datasetInfoList = this.m_remoteObject._finfo();
        } else {
            this.datasetInfoList = new HList();
            this.datasetInfoList.setItem("NUMCOLS", 0.0);
            this.datasetInfoList.setItem("NUMROWS", 0.0);
            this.datasetInfoList.setItem("ATTRIB", (HListInterface)new HList());
            this.datasetInfoList.setItem("MEMBERS", (HListInterface)new HList());
        }
        this.numCols = (int)this.datasetInfoList.getDouble("NUMCOLS");
        this.numRows = (int)this.datasetInfoList.getDouble("NUMROWS");
        this.membersList = this.datasetInfoList.getList("MEMBERS");
    }

    static class Row {
        public String label;
        public Object[] data;
        public String[] formattedData;

        Row() {
        }
    }

    class DataSetReader
    implements StaticCacheInterface {
        private boolean readFormatted;

        public DataSetReader(boolean readFormatted) {
            this.readFormatted = readFormatted;
        }

        public int count() {
            return DataSetDelegate.this.numRows;
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }

        public Object getFromCache(long rowNum) throws CacheException {
            return this.getFromCache(rowNum, rowNum, true)[0];
        }

        public Object[] getFromCache(long[] rowNums, boolean readFully) throws CacheException {
            int nRows = rowNums.length;
            for (int i = 1; i < nRows; ++i) {
                if (rowNums[i] == rowNums[i - 1] + 1L) continue;
                throw new CacheException(Message.format((String)RB.getStringResource(DataSetDelegate.RB_KEY, "nonSeqRead.ex.txt"), (Object)new Long(rowNums[i - 1]), (Object)new Long(rowNums[i])));
            }
            return this.getFromCache(rowNums[0], rowNums[rowNums.length - 1], readFully);
        }

        public Object[] getFromCache(long startRow, long endRow, boolean readFully) throws CacheException {
            HListInterface cacheList = readFully ? (this.readFormatted ? DataSetDelegate.this.m_remoteObject._getFormattedRows((int)startRow + 1, (int)endRow + 1) : DataSetDelegate.this.m_remoteObject._getRows((int)startRow + 1, (int)endRow + 1)) : (this.readFormatted ? DataSetDelegate.this.m_remoteObject._getPartialFormattedRows((int)startRow + 1, (int)endRow + 1) : DataSetDelegate.this.m_remoteObject._getPartialRows((int)startRow + 1, (int)endRow + 1));
            int nRows = cacheList.count();
            if (readFully && (long)nRows != endRow - startRow + 1L) {
                throw new CacheException(RB.getStringResource(DataSetDelegate.RB_KEY, "readFailed.ex.txt"));
            }
            Object[] rows = new Row[nRows];
            int i = 0;
            for (int r = 0; r < nRows; ++r) {
                int c;
                Object[] data;
                Row row;
                HListInterface dataList = cacheList.getList(i++);
                rows[r] = row = new Row();
                row.label = dataList.getString(0);
                if (this.readFormatted) {
                    row.formattedData = new String[DataSetDelegate.this.numCols];
                    data = row.formattedData;
                    for (c = 0; c < DataSetDelegate.this.numCols; ++c) {
                        try {
                            data[c] = dataList.getString(c + 1);
                            continue;
                        }
                        catch (ClassCastException e) {
                            throw new CacheException((Exception)e);
                        }
                    }
                    continue;
                }
                row.data = new Object[DataSetDelegate.this.numCols];
                data = row.data;
                for (c = 0; c < DataSetDelegate.this.numCols; ++c) {
                    HListItem hli = dataList.getItem(c + 1);
                    if (hli instanceof StringItem) {
                        StringItem si2 = (StringItem)hli;
                        data[c] = si2.getValue();
                        continue;
                    }
                    if (hli instanceof DoubleItem) {
                        DoubleItem di = (DoubleItem)hli;
                        if (di.isMissing()) {
                            data[c] = di.getMissingValue();
                            continue;
                        }
                        data[c] = new Double(di.getValue());
                        continue;
                    }
                    String errMsg = RB.getStringResource(DataSetDelegate.RB_KEY, "invalidListItem.ex.txt");
                    throw new CacheException(errMsg);
                }
            }
            DataSetDelegate.this.countedRows = Math.max(startRow + (long)nRows, DataSetDelegate.this.countedRows);
            return rows;
        }

        public long[] computeCacheKeyRange(long startRow, long endRow, int size) throws CacheException {
            return SequentialCache.computeSequentialKeyRange((long)startRow, (long)endRow, (int)size);
        }

        public long[] getCacheKeys() throws CacheException {
            throw new CacheException(RB.getStringResource(DataSetDelegate.RB_KEY, "gckNotImplemented.ex.txt"));
        }

        public boolean cacheContainsKey(long key) throws CacheException {
            return key < (long)DataSetDelegate.this.numRows;
        }

        public int getCacheKeyUse() {
            return 0;
        }

        public synchronized void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        }

        public void useBufferHints(BufferHints hints) {
        }
    }
}

