/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.catalogentrylist;

import com.sas.GlobalInfoTable;
import com.sas.models.NodeIcon;
import com.sas.models.SimpleNodeInterface;
import com.sas.sasserver.SASListNode;
import com.sas.sasserver.catalogentrylist.CatalogEntryListInterface;
import java.util.Enumeration;

public class SASCatalogEntryListNode
extends SASListNode {
    static final long serialVersionUID = 209871569641258684L;
    protected String catalogName;
    protected CatalogEntryListInterface catalogEntryList;
    protected String typeFilter;

    public SASCatalogEntryListNode() {
        this.setIconNames("Catalog", "CatalogExpanded");
    }

    public SASCatalogEntryListNode(String text) {
        super(text);
        this.catalogName = text;
        this.setIconNames("Catalog", "CatalogExpanded");
    }

    public SASCatalogEntryListNode(String text, String nodeType) {
        super(text, nodeType);
        this.catalogName = text;
        this.setIconNames("Catalog", "CatalogExpanded");
    }

    public SASCatalogEntryListNode(String text, String expandedText, String nodeType) {
        super(text, nodeType);
        this.setNodeExpandedText(expandedText);
        this.catalogName = expandedText;
        this.setIconNames("Catalog", "CatalogExpanded");
    }

    protected CatalogEntryListInterface getCatalogEntryList() {
        if (this.catalogEntryList == null) {
            try {
                this.catalogEntryList = (CatalogEntryListInterface)this.classFactory.newInstance(GlobalInfoTable.loadClass((String)"com.sas.sasserver.catalogentrylist.CatalogEntryListInterface"), this.rocfContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.catalogEntryList.setCatalog(this.catalogName);
            if (this.typeFilter != null && this.typeFilter.length() > 0) {
                this.catalogEntryList.setTypeFilter(this.typeFilter);
            }
        }
        return this.catalogEntryList;
    }

    public synchronized int getNodeChildCount() {
        CatalogEntryListInterface list = this.getCatalogEntryList();
        return list.count();
    }

    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        CatalogEntryListInterface list = this.getCatalogEntryList();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        int i = 0;
        Enumeration items = list.getItems(startIndex, startIndex + count);
        while (items.hasMoreElements()) {
            String item = (String)items.nextElement();
            NodeIcon node = new NodeIcon(item);
            node.setNodeExpandedText(this.catalogName + "." + item);
            childrenArray[i++] = node;
        }
        return childrenArray;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(String typeFilter) {
        this.typeFilter = typeFilter;
    }
}

