/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.models.NodeIcon;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.util.Hashtable;

public abstract class SASListNode
extends NodeIcon {
    protected Connection rocfContext;
    protected Rocf classFactory;
    protected boolean isLeafNode;
    protected String defaultIconName;
    protected String expandedIconName;
    protected static Hashtable imageViewCache;

    public SASListNode() {
    }

    public SASListNode(String text) {
        super(text);
    }

    public SASListNode(String text, String nodeType) {
        super(text, nodeType);
    }

    public void setRocfInfo(Connection rocfContext, Rocf classFactory) {
        this.rocfContext = rocfContext;
        this.classFactory = classFactory;
    }

    public void setIconNames(String defaultIconName, String expandedIconName) {
        this.defaultIconName = defaultIconName;
        this.expandedIconName = expandedIconName;
    }

    public boolean isLeafNode() {
        return this.isLeafNode;
    }

    public void setLeafNode(boolean isLeafNode) {
        this.isLeafNode = isLeafNode;
    }

    @Override
    public synchronized IconInterface getDefaultIcon() {
        return SASListNode.getImage(this.defaultIconName);
    }

    @Override
    public synchronized IconInterface getExpandedIcon() {
        return SASListNode.getImage(this.expandedIconName);
    }

    protected static synchronized IconInterface getImage(String name) {
        if (imageViewCache == null) {
            imageViewCache = new Hashtable();
        }
        if (imageViewCache.containsKey(name)) {
            return (IconInterface)imageViewCache.get(name);
        }
        ImageView icon = new ImageView(Resources.getImage((String)name));
        imageViewCache.put(name, icon);
        return icon;
    }
}

