/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.hlist.HListInterface;
import com.sas.rmi.LocalModelInterface;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteSASListInterface;
import com.sas.util.ApplyInterface;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class SASListDelegate
extends Component
implements LocalModelInterface,
ContentsChangedListener {
    static final String RB_KEY = "SASListDelegate.";
    private transient Object m_remoteObject;
    protected transient boolean needs_refresh;
    protected transient OrderedCollectionInterface parsedList = new OrderedCollection();
    protected transient HListInterface membersList;
    protected transient int pendingEventGateCount;
    protected transient boolean hasChildren = true;
    protected transient boolean libExists = true;
    protected transient ContentsChangedListenerList allContentsChangedListeners;

    public Object remoteObject() {
        return this.m_remoteObject;
    }

    @Override
    public void _setRemoteHandle(Object o) {
        this.m_remoteObject = o;
        if (!(o instanceof RemoteSASListInterface) || !(o instanceof ContentsChangedSource)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRemoteObject.ex.txt"));
        }
    }

    public void firePropertyChange(String prop, Object oldv, Object newv) {
        ComponentInterface ci = (ComponentInterface)this.m_remoteObject;
        ci.firePropertyChange(prop, oldv, newv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void parseList(HListInterface membersList, OrderedCollectionInterface parsedList) {
        OrderedCollectionInterface orderedCollectionInterface = parsedList;
        synchronized (orderedCollectionInterface) {
            parsedList.removeAll();
            int count = membersList.count();
            for (int i = 0; i < count; ++i) {
                parsedList.add((Object)membersList.getString(i));
            }
        }
    }

    protected synchronized void resubmitQuery() {
        if (this.needs_refresh) {
            this.membersList = ((RemoteSASListInterface)this.m_remoteObject)._getMembers();
            if (this.membersList != null) {
                this.parseList(this.membersList, this.parsedList);
            }
            if (!this.libExists) {
                this.parsedList.removeAll();
            }
        }
        this.needs_refresh = false;
    }

    public synchronized boolean contains(Object element) {
        this.resubmitQuery();
        return this.parsedList.contains(element);
    }

    public synchronized void apply(ApplyInterface action) {
        this.resubmitQuery();
        this.parsedList.apply(action);
    }

    public synchronized int count() {
        this.resubmitQuery();
        return this.parsedList.count();
    }

    public synchronized Enumeration getItems() {
        this.resubmitQuery();
        return this.parsedList.getItems();
    }

    public synchronized Object get(int index) {
        this.resubmitQuery();
        return this.parsedList.get(index);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        this.resubmitQuery();
        return this.parsedList.equals(orderedCollection);
    }

    public synchronized int getIndex(Object element, int startIndex) {
        this.resubmitQuery();
        return this.parsedList.getIndex(element, startIndex);
    }

    public synchronized Enumeration getItems(int start, int end) {
        this.resubmitQuery();
        return this.getItems();
    }

    public synchronized int getLastIndex(Object element, int startIndex) {
        this.resubmitQuery();
        return this.parsedList.getLastIndex(element, startIndex);
    }

    public synchronized String toString() {
        return this.parsedList.toString();
    }

    public synchronized void contentsChanged(ContentsChangedEvent cce) {
        if (cce.getSource() == this.m_remoteObject) {
            this.needs_refresh = true;
            this.hasChildren = true;
            this.resubmitQuery();
        }
    }

    public synchronized void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public synchronized void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        if (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    protected void fireContentsChanged() {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        this.fireContentsChanged(new ContentsChangedEvent(this.m_remoteObject));
    }

    public synchronized void disableEvents() {
        ++this.pendingEventGateCount;
    }

    public synchronized void enableEvents() {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.pendingEventGateCount == 0) {
                this.fireContentsChanged();
            }
        }
    }

    public synchronized void initialize() {
        this.needs_refresh = true;
        this.hasChildren = true;
        super.initialize();
        this.resubmitQuery();
        ((ContentsChangedSource)this.m_remoteObject).removeContentsChangedListener((ContentsChangedListener)this);
        ((ContentsChangedSource)this.m_remoteObject).addContentsChangedListener((ContentsChangedListener)this);
    }
}

