/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.swing.visuals.CommandProgress;
import com.sas.swing.visuals.ProgressDialog;
import com.sas.text.Message;
import com.sas.util.ThreadedCommand;
import com.sas.visuals.MessageBox;
import com.sas.visuals.OkCancelHelpDialog;
import java.awt.Component;
import java.awt.Frame;

public abstract class RemoteObjectSelectorDialog
extends OkCancelHelpDialog {
    protected Connection connection;
    protected Rocf rocf;
    protected Component owner;
    protected OrderedCollection remoteObjects;
    private boolean customRocf;
    private boolean wasCancelled;
    private boolean exceptionThrown;
    private boolean cloneConnection;

    public RemoteObjectSelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String title) {
        this(parent, owner, connection, true, rocf, title);
    }

    public RemoteObjectSelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String title) {
        super(parent);
        this.setTitle(title);
        this.rocf = rocf;
        this.connection = cloneConnection ? (Connection)connection.clone() : connection;
        this.cloneConnection = cloneConnection;
        this.owner = owner;
        this.customRocf = rocf != null;
    }

    protected void registerRemoteBaseClient(RemoteBaseClient rbc) {
        if (this.remoteObjects == null) {
            this.remoteObjects = new OrderedCollection();
        }
        if (rbc != null) {
            this.remoteObjects.add((Object)rbc);
        }
    }

    @Override
    public void initialize() {
        block5: {
            super.initialize();
            boolean deferUserInfo = this.connection.isDeferUserInfoUntilRuntime();
            boolean deferApplUserInfo = this.connection.isDeferApplicationUserInfoUntilRuntime();
            try {
                this.exceptionThrown = false;
                this.wasCancelled = false;
                if (deferUserInfo || deferApplUserInfo) {
                    this.createRemoteObjects();
                } else {
                    CommandProgress.executeAsynchronously(new Connect(), null, RB.getStringResource("progressDialogTitle.txt"), Message.format((String)RB.getStringResource("progressDialogText.txt"), (Object)this.connection.getHost()), this, this.owner);
                }
            }
            catch (Exception e) {
                if (deferUserInfo || deferApplUserInfo) {
                    this.disposeRemoteObjects();
                    this.showException(e);
                }
                boolean bl = this.wasCancelled = e.getMessage() == com.sas.visuals.RB.getStringResource((String)"CommandProgress.cancelMessage.txt");
                if (this.wasCancelled) break block5;
                this.showException(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.disposeRemoteObjects();
        super.dispose();
    }

    protected void disposeRemoteObjects() {
        ProgressDialog progressDialog = CommandProgress.getProgressDialog();
        if (progressDialog != null) {
            progressDialog.dispose();
        }
        if (this.remoteObjects != null) {
            int cnt = this.remoteObjects.count();
            for (int i = 0; i < cnt; ++i) {
                RemoteBaseClient rbc = (RemoteBaseClient)this.remoteObjects.get(i);
                if (rbc == null) continue;
                rbc.stop();
            }
        }
        if (this.cloneConnection) {
            this.connection.stop();
        }
        if (!this.customRocf) {
            this.rocf.stop();
        }
    }

    @Override
    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public boolean wasExceptionThrown() {
        return this.exceptionThrown;
    }

    @Override
    public void setVisible(boolean newValue) {
        if (this.wasCancelled || this.exceptionThrown) {
            return;
        }
        super.setVisible(newValue);
    }

    protected void createRemoteObjects() throws Exception {
        if (this.rocf == null) {
            this.rocf = new Rocf(this.owner);
        }
        this.rocf.connect(this.connection);
    }

    private void showException(Exception e) {
        this.exceptionThrown = true;
        e.printStackTrace();
        MessageBox mb = new MessageBox(Util.getParentFrame(this.owner), RB.getStringResource("exceptionDialogTitle.txt"), true, Message.format((String)RB.getStringResource("exceptionDialogText.txt"), (Object)e.getMessage()), 1, 1, 2);
        mb.centerOver(this.owner);
        mb.setVisible(true);
    }

    class Connect
    implements ThreadedCommand {
        Connect() {
        }

        public void execute(Object o) {
            try {
                RemoteObjectSelectorDialog.this.createRemoteObjects();
            }
            catch (Exception e) {
                RemoteObjectSelectorDialog.this.disposeRemoteObjects();
                RemoteObjectSelectorDialog.this.showException(e);
            }
        }

        public void interrupt() {
            RemoteObjectSelectorDialog.this.disposeRemoteObjects();
        }
    }
}

