/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;

public class LibrarySelectorDialog
extends RemoteObjectSelectorDialog {
    public static final String RB_KEY = "LibrarySelectorDialog.";
    protected LibraryListInterface libraryList;
    protected ListBox listbox;
    protected String library;

    public LibrarySelectorDialog(Frame parent, Connection connection, Rocf rocf, String library) {
        this(parent, parent, connection, rocf, library);
    }

    public LibrarySelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String library) {
        this(parent, owner, connection, true, rocf, library);
    }

    public LibrarySelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String library) {
        super(parent, owner, connection, cloneConnection, rocf, RB.getStringResource(RB_KEY, "DialogTitle.txt"));
        this.library = library;
    }

    public String getLibrary() {
        return this.library;
    }

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1);
        layout.setVgap(5);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        panel.setLayout((LayoutManager)layout);
        panel.setInsets(new Insets(10, 10, 10, 10));
        Label libraryListBoxlabel = new Label(RB.getStringResource(RB_KEY, "libraryListBoxLabel.txt"));
        panel.add(libraryListBoxlabel);
        this.listbox = new ListBox();
        panel.add(this.listbox);
        if (!this.wasCancelled() && !this.wasExceptionThrown() && this.libraryList != null) {
            this.listbox.setModelInterface((ModelInterface)this.libraryList);
            this.listbox.setSelectedItem(this.library);
        }
    }

    @Override
    protected void close() {
        this.library = this.listbox.getSelectedItem();
        super.close();
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        this.libraryList = (LibraryListInterface)this.rocf.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.librarylist.LibraryListInterface"), this.connection);
        if (this.libraryList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.libraryList));
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        this.libraryList = null;
        super.disposeRemoteObjects();
    }
}

