/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.collection.OrderedCollection;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.sasserver.metabaselist.MetabaseListInterface;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class EISSelectorDialog
extends RemoteObjectSelectorDialog
implements ItemListener {
    public static final String RB_KEY = "EISSelectorDialog.";
    private static final OrderedCollection NO_ENTRIES_OC;
    private static final OrderedCollection EMPTY_OC;
    private static final String NO_ENTRIES;
    private static final char DOT = '.';
    protected MetabaseListInterface metabaseList;
    protected ListBox libraryListBox;
    protected ListBox catalogListBox;
    protected ListBox catalogEntryListBox;
    private String eisEntry;

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        panel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 3, 5, 5, true, true, true));
        panel.setInsets(10, 10, 10, 10);
        Label libraryLabel = new Label(RB.getStringResource(RB_KEY, "libraryListTitle.txt"));
        panel.add(libraryLabel);
        Label catalogLabel = new Label(RB.getStringResource(RB_KEY, "catalogListTitle.txt"));
        panel.add(catalogLabel);
        Label catalogEntryLabel = new Label(RB.getStringResource(RB_KEY, "catalogEntryListTitle.txt"));
        panel.add(catalogEntryLabel);
        this.libraryListBox = new ListBox();
        this.libraryListBox.addItemListener(this);
        panel.add(this.libraryListBox);
        this.catalogListBox = new ListBox();
        this.catalogListBox.addItemListener(this);
        panel.add(this.catalogListBox);
        this.catalogEntryListBox = new ListBox();
        panel.add(this.catalogEntryListBox);
        if (!this.wasCancelled() && !this.wasExceptionThrown() && this.metabaseList != null) {
            this.libraryListBox.setModelInterface((ModelInterface)this.getApplicationLibraries());
            if (this.eisEntry != null && this.eisEntry.length() > 0) {
                int dotcount = 0;
                int cnt = this.eisEntry.length();
                for (int i = 0; i < cnt; ++i) {
                    if (this.eisEntry.charAt(i) != '.') continue;
                    ++dotcount;
                }
                if (dotcount == 3) {
                    int dotpos2;
                    int dotpos = this.eisEntry.indexOf(46);
                    if (dotpos > 0) {
                        String libraryName = this.eisEntry.substring(0, dotpos).toUpperCase();
                        Object[] array = this.metabaseList.getApplicationCatalogs(libraryName);
                        OrderedCollection oc = new OrderedCollection(array);
                        this.catalogListBox.setModelInterface((ModelInterface)oc);
                        this.libraryListBox.setSelectedItem(libraryName);
                    }
                    if ((dotpos2 = this.eisEntry.indexOf(46, dotpos + 1)) > 0) {
                        String catalogName = this.eisEntry.substring(0, dotpos2).toUpperCase();
                        this.catalogEntryListBox.setModelInterface((ModelInterface)this.getShortApplicationEntries(catalogName));
                        this.catalogListBox.setSelectedItem(catalogName);
                    }
                    String eisEntryName = this.eisEntry.substring(dotpos2 + 1, this.eisEntry.length()).toUpperCase();
                    this.catalogEntryListBox.setSelectedItem(eisEntryName);
                }
            }
        }
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        this.metabaseList = (MetabaseListInterface)this.rocf.newInstance(GlobalInfoTable.loadClass((String)"com.sas.sasserver.metabaselist.MetabaseListInterface"), this.connection);
        if (this.metabaseList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.metabaseList));
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        this.metabaseList = null;
        super.disposeRemoteObjects();
    }

    public EISSelectorDialog(Frame parent, Connection connection, Rocf rocf, String eisEntry) {
        this(parent, parent, connection, rocf, eisEntry);
    }

    public EISSelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String eisEntry) {
        this(parent, owner, connection, true, rocf, eisEntry);
    }

    public EISSelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String eisEntry) {
        super(parent, owner, connection, cloneConnection, rocf, RB.getStringResource(RB_KEY, "dialogTitle.txt"));
        if (eisEntry != null) {
            this.eisEntry = eisEntry.toUpperCase();
        }
    }

    public String getEISEntry() {
        String catalogEntryValue = this.catalogEntryListBox.getSelectedItem();
        if (catalogEntryValue == null || catalogEntryValue == NO_ENTRIES || this.metabaseList == null) {
            return null;
        }
        return this.metabaseList.getApplicationLocation(this.getFullEntryName(catalogEntryValue));
    }

    private OrderedCollection getApplicationLibraries() {
        if (this.metabaseList == null) {
            return null;
        }
        String[] array = this.metabaseList.getApplicationCatalogs(new String[0]);
        if (array == null) {
            return null;
        }
        OrderedCollection oc = new OrderedCollection();
        String lastLibrary = null;
        int cnt = array.length;
        for (int i = 0; i < cnt; ++i) {
            String library = this.getLibrary(array[i]);
            if (Util.equal((Object)library, lastLibrary)) continue;
            oc.add((Object)library);
            lastLibrary = library;
        }
        return oc;
    }

    private String getLibrary(String twoLevelName) {
        int cnt = twoLevelName.length();
        for (int i = 0; i < cnt; ++i) {
            if (twoLevelName.charAt(i) != '.') continue;
            return twoLevelName.substring(0, i);
        }
        return null;
    }

    private OrderedCollection getApplicationEntries(String catalogName) {
        if (this.metabaseList == null) {
            return null;
        }
        String[] filters = new String[]{"MULTI", "GRAPHS"};
        Object[] array = this.metabaseList.getApplicationNames(catalogName, filters);
        if (array == null) {
            return NO_ENTRIES_OC;
        }
        return new OrderedCollection(array);
    }

    private OrderedCollection getShortApplicationEntries(String catalogName) {
        OrderedCollection apps = this.getApplicationEntries(catalogName);
        OrderedCollection returnApps = new OrderedCollection();
        for (int i = 0; i < apps.count(); ++i) {
            String eisEntry = (String)apps.get(i);
            if (eisEntry == null || eisEntry.length() <= 0) continue;
            int dotcount = 0;
            int cnt = eisEntry.length();
            for (int j = 0; j < cnt; ++j) {
                if (eisEntry.charAt(j) != '.') continue;
                ++dotcount;
            }
            if (dotcount != 3) continue;
            int dotpos = eisEntry.indexOf(46);
            dotpos = eisEntry.indexOf(46, dotpos + 1);
            returnApps.add((Object)eisEntry.substring(dotpos + 1, eisEntry.length()).toUpperCase());
        }
        return returnApps.count() > 0 ? returnApps : NO_ENTRIES_OC;
    }

    private String getFullEntryName(String eisEntry) {
        if (eisEntry != null && eisEntry.length() > 0) {
            int dotcount = 0;
            int cnt = eisEntry.length();
            for (int i = 0; i < cnt; ++i) {
                if (eisEntry.charAt(i) != '.') continue;
                ++dotcount;
            }
            if (dotcount == 1) {
                String s = this.catalogListBox.getSelectedItem();
                eisEntry = s + '.' + eisEntry;
            }
        }
        return eisEntry;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (event.getStateChange() == 1) {
            if (source == this.libraryListBox) {
                String s = this.libraryListBox.getSelectedItem();
                if (this.metabaseList != null) {
                    OrderedCollection oc = new OrderedCollection((Object[])this.metabaseList.getApplicationCatalogs(s));
                    this.catalogListBox.setModelInterface((ModelInterface)oc);
                }
                this.catalogEntryListBox.setModelInterface((ModelInterface)EMPTY_OC);
            } else if (source == this.catalogListBox) {
                String s = this.catalogListBox.getSelectedItem();
                if (this.metabaseList != null) {
                    this.catalogEntryListBox.setModelInterface((ModelInterface)this.getShortApplicationEntries(s));
                }
            }
        }
    }

    static {
        NO_ENTRIES = RB.getStringResource(RB_KEY, "noEntries.txt");
        EMPTY_OC = new OrderedCollection();
        NO_ENTRIES_OC = new OrderedCollection();
        NO_ENTRIES_OC.add((Object)NO_ENTRIES);
    }
}

