/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.awt.util.ChangeCursorCommand;
import com.sas.awt.util.Util;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.sasserver.sasfilelist.DataSetListInterface;
import com.sas.util.ApplyInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DataSetSelectorDialog
extends RemoteObjectSelectorDialog {
    static final String RB_KEY = "DataSetSelectorDialog.";
    protected LibraryListInterface libraryList;
    protected DataSetListInterface dataSetList;
    protected ListBox libraryListBox;
    protected ListBox dataSetListBox;
    protected String dataSet;

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 2);
        layout.setVgap(5);
        layout.setHgap(5);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        panel.setLayout((LayoutManager)layout);
        panel.setInsets(new Insets(10, 10, 10, 10));
        Label libraryListBoxLabel = new Label(RB.getStringResource(RB_KEY, "libraryListBoxLabel.txt"));
        panel.add(libraryListBoxLabel);
        Label dataSetListBoxLabel = new Label(RB.getStringResource(RB_KEY, "dataSetListBoxLabel.txt"));
        panel.add(dataSetListBoxLabel);
        this.libraryListBox = new ListBox();
        panel.add(this.libraryListBox);
        this.dataSetListBox = new ListBox();
        panel.add(this.dataSetListBox);
        if (!this.wasCancelled() && !this.wasExceptionThrown() && this.dataSetList != null) {
            this.libraryListBox.setModelInterface((ModelInterface)this.libraryList);
            this.dataSetListBox.setModelInterface((ModelInterface)this.dataSetList);
            int dotpos = this.dataSet.indexOf(46);
            if (dotpos > 0) {
                String libraryName = this.dataSet.substring(0, dotpos).toUpperCase();
                try {
                    this.dataSetList.setLibrary(libraryName);
                }
                catch (IllegalArgumentException e) {
                    this.dataSetList.setLibrary("");
                }
            }
            this.libraryListBox.addLink("selectedItem", this.dataSetList, "library");
            this.dataSetListBox.setSelectedItem(this.dataSet);
            this.libraryListBox.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public DataSetSelectorDialog(Frame parent, Connection connection, Rocf rocf, String dataSet) {
        this(parent, parent, connection, rocf, dataSet);
    }

    public DataSetSelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String dataSet) {
        this(parent, owner, connection, true, rocf, dataSet);
    }

    public DataSetSelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String dataSet) {
        super(parent, owner, connection, cloneConnection, rocf, RB.getStringResource(RB_KEY, "DialogTitle.txt"));
        this.dataSet = dataSet.toUpperCase();
    }

    public String getDataSet() {
        return this.dataSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() == this.libraryListBox && evt.getPropertyName().equals("selectedItem")) {
            ChangeCursorCommand cmd = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
            Util.setEnabledOnContainer(this, false);
            Util.apply(this, (ApplyInterface)cmd);
            LibraryRun run = new LibraryRun(this, this.dataSetList, this.libraryListBox, cmd);
            new Thread(run).start();
        }
    }

    @Override
    protected void close() {
        this.dataSet = this.dataSetListBox.getSelectedItem();
        super.close();
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        this.libraryList = (LibraryListInterface)this.rocf.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.librarylist.LibraryListInterface"), this.connection);
        if (this.libraryList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.libraryList));
        }
        this.dataSetList = (DataSetListInterface)this.rocf.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.sasfilelist.DataSetListInterface"), this.connection);
        if (this.dataSetList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.dataSetList));
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        this.libraryList = null;
        this.dataSetList = null;
        super.disposeRemoteObjects();
    }

    class LibraryRun
    implements Runnable {
        DataSetListInterface dataSetList;
        ListBox libraryListBox;
        Container container;
        ChangeCursorCommand cmd;

        LibraryRun(Container cont, DataSetListInterface dsList, ListBox listBox, ChangeCursorCommand command) {
            this.container = cont;
            this.dataSetList = dsList;
            this.libraryListBox = listBox;
            this.cmd = command;
        }

        @Override
        public void run() {
            this.dataSetList.setLibrary(this.libraryListBox.getSelectedItem());
            Util.setEnabledOnContainer(this.container, true);
            this.cmd.undoAll();
        }
    }
}

