/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.Component;
import com.sas.collection.hlist.HListInterface;
import com.sas.rmi.LocalModelInterface;
import com.sas.sasserver.BookmarkException;
import com.sas.sasserver.BookmarkManagerInterface;
import com.sas.sasserver.BookmarkManagerV2Interface;

public class BookmarkManagerDelegate
extends Component
implements LocalModelInterface {
    BookmarkManagerInterface bkmgr;

    @Override
    public void _setRemoteHandle(Object b) {
        this.bkmgr = (BookmarkManagerInterface)b;
    }

    public BookmarkManagerInterface getRemoteHandle() {
        return this.bkmgr;
    }

    public Object getBookmarks(long documentID, String userName) throws BookmarkException {
        return ((BookmarkManagerV2Interface)this.bkmgr)._getPublicBookmarks(documentID, userName);
    }

    public Object getBookmarks(long documentID, String userName, String password) throws BookmarkException {
        HListInterface hli = this.bkmgr._getBookmarks(documentID, userName, password);
        if (hli.getId() == 0) {
            return null;
        }
        if (hli.find("ERROR", 1, 0) >= 0) {
            throw new BookmarkException(this.getMessage());
        }
        return hli;
    }

    public void setBookmarks(String documentName, long documentID, String userName, String password, Object bookmarks) throws BookmarkException {
        long inError = this.bkmgr._setBookmarks(documentName, documentID, userName, password, (HListInterface)bookmarks);
        if (inError > 0L) {
            throw new BookmarkException(this.getMessage());
        }
    }

    public String[] getUsers(long documentID, boolean all) throws BookmarkException {
        HListInterface hlist = this.bkmgr._getUsers(documentID, all);
        if (hlist.find("ERROR", 1, 0) >= 0) {
            throw new BookmarkException(this.getMessage());
        }
        int cnt = hlist.count();
        String[] users = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            users[i] = hlist.getString(i);
        }
        return users;
    }

    public int validateUser(String userName, String password) throws BookmarkException {
        int isValid = (int)this.bkmgr._validateUser(userName, password);
        if (isValid == 1 || isValid == 0 || isValid == -1) {
            return isValid;
        }
        throw new BookmarkException(this.getMessage());
    }

    private String getMessage() {
        String[] errMsg = this.bkmgr._getMessage();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < errMsg.length; ++i) {
            sbuf.append(errMsg[i]);
            sbuf.append(System.getProperty("line.separator"));
        }
        return sbuf.toString();
    }

    public Object getBookmarkData(Object bookmarkID) throws BookmarkException {
        HListInterface hlist = this.bkmgr._getBookmarkData((HListInterface)bookmarkID);
        if (hlist.find("ERROR", 1, 0) >= 0) {
            throw new BookmarkException(this.getMessage());
        }
        return hlist;
    }
}

