/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.ProxyName;
import com.sas.rmi.Template;
import com.sas.rmi.UTC102Template;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class UTC102Target
extends CodeGeneratorBaseTarget {
    int m_ordinal = 0;
    protected Hashtable getTable;

    @Override
    public String getGeneratorName() {
        return "Ultra_Thin_Client";
    }

    @Override
    public Template getTemplate() {
        return new UTC102Template();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod("UTC102");
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        String type;
        int j;
        Class<?>[] params = method.getParameterTypes();
        Hashtable<String, String> types = new Hashtable<String, String>();
        types.put("boolean", "Boolean");
        types.put("byte", "Byte");
        types.put("short", "Short");
        types.put("char", "Char");
        types.put("int", "Int");
        types.put("long", "Long");
        types.put("float", "Float");
        types.put("double", "Double");
        types.put("java.lang.String", "UTF");
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 1);
        String s = "public synchronized " + ret + " " + method.getName() + "(";
        out.println(s, 1);
        String p = "";
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            s = "";
            if (j == 0) {
                s = "throws ";
            }
            s = s + exceptions[j].getName();
            if (j + 1 < exceptions.length) {
                s = s + ",";
            }
            out.println(s, 3);
        }
        out.println("{", 2);
        String retValue = null;
        if (!ret.equals("void")) {
            retValue = ret + " returnValue = ";
            retValue = ret.equals("boolean") ? retValue + "false;" : (ret.equals("byte") || ret.equals("char") || ret.equals("short") || ret.equals("int") || ret.equals("long") || ret.equals("float") || ret.equals("double") ? retValue + "0;" : retValue + "null;");
            out.println(retValue, 3);
        }
        out.println("try {", 3);
        out.println("java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();", 4);
        out.println("java.io.DataOutputStream out = _RemoteObject_startMethod(baos, " + this.m_ordinal + ");", 4);
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName());
            type = (String)types.get(s);
            if (type == null) {
                throw new Exception("Invalid parameter type '" + s + "' for use with Java 1.0.2 proxies");
            }
            out.println("out.write" + type + "(p" + (j + 1) + ");", 4);
        }
        out.println("java.io.DataInputStream in = _RemoteObject_invoke(baos);", 4);
        if (retValue != null) {
            type = (String)types.get(ret);
            if (type == null) {
                throw new Exception("Invalid return type '" + ret + "' for use with Java 1.0.2 proxies");
            }
            out.println("returnValue = in.read" + type + "();", 4);
        }
        out.println("}", 3);
        out.println("catch (Exception ex) {", 3);
        out.println("ex.printStackTrace();", 4);
        out.println("}", 3);
        if (retValue != null) {
            out.println("return returnValue;", 3);
        }
        out.println("}", 2);
        ++this.m_ordinal;
    }

    @Override
    public boolean supportsLocalImplementation() {
        return false;
    }
}

