/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.ProxyName;
import com.sas.rmi.Template;
import com.sas.rmi.UTC102ServerTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class UTC102ServerTarget
extends CodeGeneratorBaseTarget {
    int m_ordinal = 0;

    @Override
    public String getGeneratorName() {
        return "UTC_Server";
    }

    @Override
    public Template getTemplate() {
        return new UTC102ServerTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod("UTC102");
        pn.setClassName(sourceName);
        return pn.getServerProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        String type;
        Hashtable<String, String> types = new Hashtable<String, String>();
        types.put("boolean", "Boolean");
        types.put("byte", "Byte");
        types.put("short", "Short");
        types.put("char", "Char");
        types.put("int", "Int");
        types.put("long", "Long");
        types.put("float", "Float");
        types.put("double", "Double");
        types.put("java.lang.String", "UTF");
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 3);
        out.println("case " + this.m_ordinal + ":", 3);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (int j = 0; j < params.length; ++j) {
            String s = CodeGenerator.convertType(params[j].getName());
            if (p.length() > 0) {
                p = p + ", ";
            }
            String argName = "p" + this.m_ordinal + "_" + (j + 1);
            p = p + argName;
            type = (String)types.get(s);
            if (type == null) {
                throw new Exception("Invalid parameter type '" + s + "' for use with Java 1.0.2 proxies");
            }
            out.println(s + " " + argName + " = in.read" + type + "();", 4);
        }
        if (ret.equals("void")) {
            out.println("_target." + method.getName() + "(" + p + ");", 4);
            out.println("out.writeInt(ordinal);", 4);
        } else {
            String varName = "returnValue" + this.m_ordinal;
            out.println(ret + " " + varName + " = _target." + method.getName() + "(" + p + ");", 4);
            out.println("out.writeInt(ordinal);", 4);
            type = (String)types.get(ret);
            if (type == null) {
                throw new Exception("Invalid return type '" + ret + "' for use with Java 1.0.2 proxies");
            }
            out.println("out.write" + type + "(" + varName + ");", 4);
        }
        out.println("break;", 4);
        ++this.m_ordinal;
    }

    @Override
    public boolean implementationMustExist() {
        return false;
    }

    @Override
    public boolean generatesServerCode() {
        return true;
    }
}

