/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpAwareServerSocket;
import com.sas.rmi.HttpSendSocket;
import com.sas.rmi.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class TunnelingSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory,
Serializable {
    static final long serialVersionUID = 1311670783321135742L;
    String protocol = "http";
    String host = "localhost";
    String file = "/servlet/rmiservlethandler.ServletHandler";
    transient String protocol2;

    public TunnelingSocketFactory(String protocol, String host, String file) {
        this.protocol = protocol;
        this.host = host;
        this.file = file;
        Logger.p(this, "<init>");
    }

    public TunnelingSocketFactory() {
        Logger.p(this, "<init>");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        String tprotocol = this.protocol2 == null ? this.protocol : this.protocol2;
        URL url = null;
        try {
            url = new URL(this.protocol, host, this.file + "?forward=" + port);
        }
        catch (MalformedURLException e) {
            if (this.protocol2 == null && this.protocol.equalsIgnoreCase("https")) {
                System.out.println("https not supported: using http");
                this.protocol2 = "http";
                return this.createSocket(host, port);
            }
            throw e;
        }
        System.out.println("createSocket(" + url + ")");
        Logger.p(this, ":createSocket(" + url + ")");
        return new HttpSendSocket(host, port, url);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        Logger.p(this, ":createServerSocket(" + port + ")");
        return new HttpAwareServerSocket(port);
    }

    public boolean equals(Object o) {
        return o instanceof TunnelingSocketFactory;
    }

    public int hashCode() {
        return 2141261685;
    }

    public String toString() {
        return super.toString() + ",p=" + this.protocol + ",f=" + this.file;
    }
}

