/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Date;

public class TemplateGenerator {
    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) {
        boolean failed = false;
        int n = args.length;
        int namePos = 0;
        boolean overwrite = false;
        boolean verbose = false;
        String targetClass = null;
        String pkg = null;
        String targetName = null;
        if (n <= 0) {
            n = namePos + 2;
        } else {
            for (int i = 0; i < n; ++i) {
                if (args[i].equals("-o")) {
                    ++namePos;
                    overwrite = true;
                }
                if (args[i].equals("-v")) {
                    ++namePos;
                    verbose = true;
                }
                if (args[i].equals("-t")) {
                    if (i + 1 < n) {
                        targetClass = args[i + 1];
                        namePos += 2;
                    } else {
                        failed = true;
                        break;
                    }
                }
                if (!args[i].equals("-p")) continue;
                if (i + 1 < n) {
                    pkg = args[i + 1];
                    namePos += 2;
                    continue;
                }
                failed = true;
                break;
            }
        }
        if (failed || namePos != n - 1 || targetClass == null) {
            System.out.println("\nUsage: TemplateGenerator [-p <package>] -t <target> <template name>");
            return;
        }
        if (failed) return;
        String sourcePath = args[namePos];
        String source = sourcePath.substring(sourcePath.lastIndexOf("/") + 1, sourcePath.length());
        RandomAccessFile raf = TemplateGenerator.openTemplate(sourcePath);
        if (raf == null) return;
        targetName = targetClass.substring(targetClass.lastIndexOf("/") + 1, targetClass.length());
        String targetFileName = targetName + ".java";
        FileOutputStream out = TemplateGenerator.createTarget(targetClass + ".java");
        if (out == null) return;
        failed = TemplateGenerator.createHeader(source, targetFileName, targetName, pkg, out);
        if (failed) return;
        TemplateGenerator.createTemplate(raf, out);
        TemplateGenerator.cleanup(raf, out);
    }

    private static RandomAccessFile openTemplate(String name) {
        RandomAccessFile raf = null;
        File f = new File(name);
        if (!f.exists()) {
            System.out.println("Template file " + name + " not found");
        } else {
            try {
                raf = new RandomAccessFile(f, "r");
            }
            catch (Exception ex) {
                System.out.println("Unable to access template file " + name);
            }
        }
        return raf;
    }

    private static FileOutputStream createTarget(String name) {
        FileOutputStream fos = null;
        try {
            File f = new File(name);
            if (f.exists()) {
                f.delete();
            }
            fos = new FileOutputStream(f);
        }
        catch (Exception ex) {
            System.out.println("Unable to create " + name + ": " + ex.getMessage());
        }
        return fos;
    }

    private static boolean createHeader(String source, String target, String targetClass, String pkg, FileOutputStream out) {
        boolean failed = false;
        TemplateGenerator.println(out, "/**");
        TemplateGenerator.println(out, " * " + target);
        TemplateGenerator.println(out, " * Template class for " + source);
        TemplateGenerator.println(out, " * ");
        TemplateGenerator.println(out, " * Created by com.sas.rmi.TemplateGenerator " + new Date().toString());
        TemplateGenerator.println(out, " *");
        TemplateGenerator.println(out, " * !!!!! DO NOT EDIT !!!!!");
        TemplateGenerator.println(out, " *");
        TemplateGenerator.println(out, "**/");
        TemplateGenerator.println(out, "");
        if (pkg != null) {
            TemplateGenerator.println(out, "package " + pkg + ";");
        }
        TemplateGenerator.println(out, "public class " + targetClass + " implements com.sas.rmi.Template");
        TemplateGenerator.println(out, "{");
        return failed;
    }

    private static void createTemplate(RandomAccessFile in, FileOutputStream out) {
        TemplateGenerator.println(out, "public String[] getTemplate()", 1);
        TemplateGenerator.println(out, "{", 2);
        TemplateGenerator.println(out, "String s[] = {", 3);
        String line = TemplateGenerator.readLine(in);
        String nextLine = TemplateGenerator.readLine(in);
        while (line != null) {
            String s = "\"" + line + "\"";
            s = nextLine != null ? s + "," : s + "};";
            TemplateGenerator.println(out, s, 5);
            line = nextLine;
            nextLine = TemplateGenerator.readLine(in);
        }
        TemplateGenerator.println(out, "return s;", 3);
        TemplateGenerator.println(out, "}", 2);
    }

    private static void cleanup(RandomAccessFile in, FileOutputStream out) {
        TemplateGenerator.println(out, "}");
        try {
            in.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String readLine(RandomAccessFile f) {
        String s = null;
        try {
            if (f.getFilePointer() < f.length() && ((s = f.readLine()).endsWith("\n") || s.endsWith("\r"))) {
                s = s.substring(0, s.length() - 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Error reading file: " + ex.getMessage());
        }
        return s;
    }

    private static void println(FileOutputStream fos, String line, int indent) {
        try {
            if (fos != null) {
                if (line != null) {
                    String indentSpaces = "  ";
                    for (int i = 0; i < indent; ++i) {
                        fos.write(indentSpaces.getBytes());
                    }
                    fos.write(line.getBytes());
                }
                fos.write(10);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to write to file: " + ex.getMessage());
        }
    }

    private static void println(FileOutputStream fos, String line) {
        TemplateGenerator.println(fos, line, 0);
    }
}

