/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;

public class TargetMethod {
    Vector castExceptions = new Vector();
    Vector broadcastExceptions = new Vector();
    Vector throwExceptions = new Vector();

    public void addBroadcastException(Class exception) {
        this.broadcastExceptions.addElement(exception);
        this.dumpVecs("after add");
    }

    public void addCastException(Class exception) {
        this.castExceptions.addElement(exception);
        this.dumpVecs("after add");
    }

    public void addThrowException(Class exception) {
        this.throwExceptions.addElement(exception);
        this.dumpVecs("after add");
    }

    public boolean generateMethodCodeHeader(Class source, Method method, CodeGeneratorOutputStream out) throws IOException {
        return this.generateMethodCodeHeader(source, method, out, true);
    }

    public boolean generateMethodCodeHeader(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws IOException {
        return this.generateMethodCodeHeader(source, method, methodName, out, true);
    }

    public boolean generateMethodCodeHeader(Class source, Method method, CodeGeneratorOutputStream out, boolean remote) throws IOException {
        return this.generateMethodCodeHeader(source, method, method.getName(), out, remote);
    }

    public void generateMethodCodeStart(Method method, String methodName, CodeGeneratorOutputStream out, boolean remote) throws IOException {
        String s;
        int j;
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        String sync = "";
        out.println("");
        out.println("public " + sync + ret + " " + methodName + "(", 1);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class[] exceptions = this.throwVec(method);
        for (j = 0; j < exceptions.length; ++j) {
            s = "";
            int indent = 7;
            if (j == 0) {
                s = s + "throws  ";
                indent = 3;
            }
            s = s + exceptions[j].getName();
            if (j < exceptions.length - 1) {
                s = s + ", ";
            }
            out.println(s, indent);
        }
        out.println("{", 1);
        if (remote) {
            if (!ret.equals("void")) {
                if (ret.equals("double") || ret.equals("byte") || ret.equals("char") || ret.equals("short") || ret.equals("int") || ret.equals("long") || ret.equals("float")) {
                    out.println(ret + " value = 0;", 2);
                } else if (ret.equals("boolean")) {
                    out.println(ret + " value = false;", 2);
                } else {
                    out.println(ret + " value = null;", 2);
                }
            }
            out.println("Object _o = null;", 2);
        }
    }

    public void generateMethodCodeEnd(Method method, CodeGeneratorOutputStream out) throws IOException {
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        if (!ret.equals("void")) {
            out.println("return value;", 2);
        }
        out.println("}", 1);
    }

    public boolean generateMethodCodeHeader(Class source, Method method, String methodName, CodeGeneratorOutputStream out, boolean remote) throws IOException {
        this._p("Generating code for " + methodName);
        this.generateMethodCodeStart(method, methodName, out, remote);
        if (remote) {
            out.println("try", 2);
            out.println("{", 2);
            out.println("_o = _RemoteObject_enter(\"" + methodName + "\");", 3);
        }
        return true;
    }

    public void generateMethodCodeTrailer(Class source, Method method, CodeGeneratorOutputStream out) throws IOException {
        this.generateMethodCodeTrailer(source, method, method.getName(), out);
    }

    public void generateMethodCodeTrailer(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws IOException {
        int k;
        boolean skip;
        String supName;
        Class sup;
        String subName;
        Class sub;
        int j;
        Class[] exceptions = this.throwVec(method);
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        int n = 1;
        out.println("}", 2);
        for (j = 0; j < this.broadcastExceptions.size(); ++j) {
            sub = (Class)this.broadcastExceptions.elementAt(j);
            subName = sub.getName();
            sup = null;
            supName = null;
            skip = false;
            for (k = 0; !skip && k < exceptions.length; ++k) {
                sup = exceptions[k];
                supName = sup.getName();
                skip = subName.equals(supName) || CodeGenerator.isSuperClass(sub, sup.getName());
            }
            if (skip) {
                out.println("// protocol broadcasts but user throws so throw " + subName + " because of previous super " + supName, 2);
                out.println("catch (" + subName + " e" + n + ")", 2);
                out.println("{", 2);
                out.println("throw e" + n + ";", 3);
                out.println("}", 2);
                ++n;
                continue;
            }
            out.println("catch (" + subName + " e" + n + ")", 2);
            out.println("{", 2);
            out.println("_RemoteObject_broadcast(e" + n + ");", 3);
            out.println("}", 2);
            ++n;
        }
        this.dumpVecs("after broadcast");
        for (j = 0; j < this.castExceptions.size(); ++j) {
            sub = (Class)this.castExceptions.elementAt(j);
            subName = sub.getName();
            sup = null;
            supName = null;
            skip = false;
            for (k = 0; !skip && k < exceptions.length; ++k) {
                sup = exceptions[k];
                supName = sup.getName();
                skip = subName.equals(supName) || CodeGenerator.isSuperClass(sub, sup.getName());
            }
            for (k = 0; !skip && k < this.broadcastExceptions.size(); ++k) {
                sup = (Class)this.broadcastExceptions.elementAt(k);
                supName = sup.getName();
                skip = subName.equals(supName) || CodeGenerator.isSuperClass(sub, sup.getName());
            }
            if (skip) {
                out.println("// protocol casts,broadcasts but user throws so throw " + subName + " because of previous super " + supName, 2);
                out.println("catch (" + subName + " e" + n + ")", 2);
                out.println("{", 2);
                out.println("throw e" + n + ";", 3);
                out.println("}", 2);
                ++n;
                continue;
            }
            out.println("catch (" + subName + " e" + n + ")", 2);
            out.println("{", 2);
            out.println("_RemoteObject_broadcast(new java.io.IOException(e" + n + ".toString()));", 3);
            out.println("}", 2);
            ++n;
        }
        this.dumpVecs("after cast");
        out.println("finally", 2);
        out.println("{", 2);
        out.println("_RemoteObject_exit(\"" + method.getName() + "\",_o);", 3);
        out.println("}", 2);
        this.generateMethodCodeEnd(method, out);
    }

    public boolean generateMethodCodeStub(Method method, String methodName, CodeGeneratorOutputStream out, boolean remote, String[] message) throws IOException {
        this.generateMethodCodeStart(method, methodName, out, remote);
        out.println("\t//Stub - Should never be called.", 1);
        if (message != null) {
            for (int i = 0; i < message.length; ++i) {
                out.println("\t//" + message[i], 1);
            }
        }
        this.generateMethodCodeEnd(method, out);
        return true;
    }

    void _p(String s) {
    }

    void dumpVecs(String s) {
        this._p(s);
        this.dumpVec(this.throwExceptions, "throw");
        this.dumpVec(this.broadcastExceptions, "broadcast");
        this.dumpVec(this.castExceptions, "cast");
    }

    void dumpVec(Vector v, String s) {
        int n = v == null ? 0 : v.size();
        this._p(s + ":" + n);
        for (int i = 0; i < n; ++i) {
            this._p("   " + ((Class)v.elementAt(i)).getName());
        }
    }

    Class[] throwVec(Method method) {
        int i;
        Vector<Class<Object>> v = new Vector<Class<Object>>();
        Class<?>[] exceptions = method.getExceptionTypes();
        for (i = 0; i < exceptions.length; ++i) {
            v.addElement(exceptions[i]);
        }
        for (i = 0; i < this.throwExceptions.size(); ++i) {
            v.addElement((Class<Object>)this.throwExceptions.elementAt(i));
        }
        Class[] cv = new Class[v.size()];
        for (int i2 = 0; i2 < cv.length; ++i2) {
            Class c;
            Object o = v.elementAt(i2);
            cv[i2] = c = (Class)o;
        }
        return cv;
    }
}

