/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConfiguration;
import com.sas.rmi.BrokerConnector;
import com.sas.rmi.BrokerEvent;
import com.sas.rmi.BrokerEventListener;
import com.sas.rmi.BrokerEventServer;
import com.sas.rmi.BrokerPool;
import com.sas.rmi.BrokerProperties;
import com.sas.rmi.Connection;
import com.sas.rmi.FactoryThread;
import com.sas.rmi.RocfClass;
import com.sas.security.BaseSecuritySupport;
import java.io.IOException;
import java.util.Vector;

public class ServerFactory
implements Runnable,
BrokerEventListener {
    private Thread m_thread = null;
    private Vector m_factoryThreads = new Vector();
    private Vector m_pools = new Vector();
    private boolean m_debug = false;
    private Vector m_eventListeners;
    private String m_connectorClass = "com.sas.rmi.J2Connector";
    private BrokerEventServer m_eventServer;

    public void start() {
        this.startEventServer();
        this.sleep(200);
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
            this.sleep(200);
            this.addBrokerEventListener(this);
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    @Override
    public void run() {
        int slice = 1000;
        while (true) {
            try {
                while (true) {
                    this.checkDeadThreads();
                    this.sleep(slice);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void checkDeadThreads() throws IOException {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.m_factoryThreads.size()) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            if (!f.getIsReady()) {
                if (now - f.getCreatedMillis() > f.getTimeoutMillis()) {
                    if (!this.m_debug) continue;
                    this.fireBrokerEvent(this, "Connection for " + f.getPool().getPoolDescription() + " taking too long to initialize");
                    this.freeFactoryThread(f, true);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    private void displayStats() {
        String line = "";
        String time = "" + System.currentTimeMillis();
        time = time.substring(0, time.length() - 3) + "." + time.substring(time.length() - 3);
        line = line + time + " ServerFactory: ";
        int n = this.m_factoryThreads.size();
        line = line + "" + n + " Connection";
        if (n != 1) {
            line = line + "s";
        }
        line = line + ", ";
        int ready = this.getReadyCount();
        int inuse = this.getInUseCount();
        line = line + "" + (ready - inuse) + " ready, ";
        line = line + "" + inuse + " in use, ";
        n = this.getQueueSize();
        line = line + "" + n + " queued";
        this.fireBrokerEvent(this, line, 1);
    }

    public ServerFactory(String[] args) {
        this.processArgs(args);
        if (this.createConnector() == null) {
            System.exit(1);
        }
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    protected synchronized FactoryThread getFactoryThread(BrokerPool pool) throws IOException {
        FactoryThread f = null;
        for (int pass = 0; pass < 2 && f == null; ++pass) {
            block5: for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
                f = (FactoryThread)this.m_factoryThreads.elementAt(i);
                if (!f.getPool().equals(pool) || f.getInUse()) continue;
                switch (pass) {
                    case 0: {
                        if (!f.getIsReady()) continue block5;
                        this.consume(f);
                        return f;
                    }
                    case 1: {
                        this.consume(f);
                        return f;
                    }
                }
            }
        }
        return null;
    }

    public void consume(FactoryThread f) throws IOException {
        f.setInUse(true);
        this.fireBrokerEvent(this, "Assigning " + f.getConnection());
        this.createSessions(f.getPool(), 8);
    }

    public FactoryThread getFactoryThread(Connection context) throws IOException {
        FactoryThread f = null;
        BrokerPool pool = this.findPool(context, true);
        if (pool == null) {
            pool = this.findPool(context, false);
        }
        if (pool == null) {
            pool = new BrokerPool(this);
            pool.setDebug(this.m_debug);
            pool.setConfig(context);
            this.createSessions(pool);
            this.m_pools.addElement(pool);
            this.updatePoolStatus();
        } else {
            this.createSessions(pool);
        }
        while (f == null) {
            f = this.getFactoryThread(pool);
            if (f != null) continue;
            this.sleep(100);
        }
        return f;
    }

    public void freeFactoryThread(BrokerProperties props) {
        if (props == null) {
            return;
        }
        for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            BrokerProperties p = f.getConnection();
            if (p == null || !p.equals(props)) continue;
            try {
                this.freeFactoryThread(f, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break;
        }
    }

    public void freeFactoryThread(FactoryThread ft, boolean replace) throws IOException {
        for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            if (!ft.equals(f)) continue;
            if (!f.getInUse()) {
                f.stop();
                this.fireBrokerEvent(this, "Destroyed connection for " + f.getPool().getPoolDescription());
            }
            this.m_factoryThreads.removeElementAt(i);
            this.fireBrokerEvent(this, "Thread removed for " + f.getPool().getPoolDescription());
            if (!replace) continue;
            this.createSessions(f.getPool());
        }
    }

    private int getThreadCount(BrokerPool pool) {
        int n = 0;
        for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            if (f.getInUse() || !f.getPool().equals(pool)) continue;
            ++n;
        }
        return n;
    }

    private int getInUseCount() {
        int n = 0;
        for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            if (!f.getInUse()) continue;
            ++n;
        }
        return n;
    }

    private int getReadyCount() {
        int n = 0;
        for (int i = 0; i < this.m_factoryThreads.size(); ++i) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
            if (!f.getIsReady()) continue;
            ++n;
        }
        return n;
    }

    public synchronized void updateConfiguration(BrokerConfiguration config) {
        this.fireBrokerEvent(this, "Updating configuration with " + config);
        if (config.getKillAll()) {
            this.fireBrokerEvent(this, "Request to kill all pool sessions");
            this.killAll();
            this.updatePoolStatus();
            return;
        }
        BrokerPool pool = this.findPool(config);
        if (pool == null) {
            if (config.getSessions() <= 0) {
                if (this.m_debug) {
                    System.out.println("Nothing to do!");
                }
            } else {
                pool = new BrokerPool(this);
                pool.setConfig(config);
                pool.setDebug(this.m_debug);
                this.createSessions(pool);
                this.m_pools.addElement(pool);
            }
        } else {
            pool.update(config);
            this.updateSessions(pool);
        }
        this.updatePoolStatus();
    }

    private void updatePoolStatus() {
        this.fireBrokerEvent(this, "", 2);
        for (int i = 0; i < this.m_pools.size(); ++i) {
            BrokerPool p = (BrokerPool)this.m_pools.elementAt(i);
            this.fireBrokerEvent(this, "" + p, 2);
        }
    }

    private void createSessions(BrokerPool pool) {
        this.createSessions(pool, 0);
    }

    private void createSessions(BrokerPool pool, int delaySeconds) {
        int toCreate = pool.getMaxSessions() - this.getThreadCount(pool) - pool.getQueueSize();
        for (int i = 0; i < toCreate; ++i) {
            pool.createFactoryThread(delaySeconds);
        }
    }

    private void updateSessions(BrokerPool pool) {
        if (this.getThreadCount(pool) >= pool.getMaxSessions() && pool.getQueueSize() > 0) {
            pool.clearQueue();
        }
        if (pool.getQueueSize() > 0 && this.getThreadCount(pool) < pool.getMaxSessions()) {
            int n = pool.getMaxSessions() - this.getThreadCount(pool);
            pool.setQueueSize(n);
        }
        block2: while (this.getThreadCount(pool) > pool.getMaxSessions()) {
            for (int i = this.m_factoryThreads.size() - 1; i >= 0; --i) {
                FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(i);
                if (f.getInUse() || !f.getPool().equals(pool)) continue;
                try {
                    this.freeFactoryThread(f, false);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                continue block2;
            }
        }
        this.createSessions(pool);
    }

    private void removePool(BrokerPool pool) {
    }

    private BrokerPool findPool(BrokerConfiguration config) {
        BrokerPool pool = null;
        for (int i = 0; i < this.m_pools.size(); ++i) {
            BrokerPool p = (BrokerPool)this.m_pools.elementAt(i);
            if (!p.equals(config)) continue;
            pool = p;
            break;
        }
        return pool;
    }

    private int getQueueSize() {
        int n = 0;
        for (int i = 0; i < this.m_pools.size(); ++i) {
            BrokerPool p = (BrokerPool)this.m_pools.elementAt(i);
            n += p.getQueueSize();
        }
        return n;
    }

    public Vector getFactories() {
        return this.m_factoryThreads;
    }

    public void addBrokerEventListener(BrokerEventListener l) {
        if (this.m_eventListeners == null) {
            this.m_eventListeners = new Vector();
        }
        this.m_eventListeners.addElement(l);
    }

    public void removeBrokerEventListener(BrokerEventListener l) {
        if (this.m_eventListeners != null) {
            this.m_eventListeners.removeElement(l);
            if (this.m_eventListeners.size() == 0) {
                this.m_eventListeners = null;
            }
        }
    }

    public void fireBrokerEvent(Object source, String msg) {
        this.fireBrokerEvent(source, msg, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBrokerEvent(Object source, String msg, int type) {
        if (this.m_eventListeners != null) {
            Vector listeners;
            ServerFactory serverFactory = this;
            synchronized (serverFactory) {
                listeners = (Vector)this.m_eventListeners.clone();
            }
            BrokerEvent e = new BrokerEvent(source, msg, type);
            for (int i = 0; i < listeners.size(); ++i) {
                BrokerEventListener l = (BrokerEventListener)listeners.elementAt(i);
                if (l == null) continue;
                l.brokerEvent(e);
            }
        }
    }

    @Override
    public void brokerEvent(BrokerEvent event) {
        switch (event.getType()) {
            case 0: {
                if (this.m_debug) {
                    System.out.println(event.getMessage());
                }
                this.displayStats();
                break;
            }
            case 1: {
                if (!this.m_debug) break;
                System.out.println(event.getMessage());
                break;
            }
        }
    }

    public BrokerPool findPool(Connection context, boolean hasAvailable) {
        String host = ServerFactory.nullIfBlank(context.getHost());
        String command = context.getCommand();
        String user = ServerFactory.nullIfBlank(context.getUsername());
        String password = ServerFactory.nullIfBlank(context.getPassword());
        for (int i = 0; i < this.m_pools.size(); ++i) {
            BrokerPool p = (BrokerPool)this.m_pools.elementAt(i);
            if (!p.doesHostUserPasswordEqual(host, command, user, password)) continue;
            if (hasAvailable) {
                if (this.getThreadCount(p) <= 0) continue;
                return p;
            }
            return p;
        }
        return null;
    }

    public static String nullIfBlank(String s) {
        if (s != null && s.trim().length() == 0) {
            s = null;
        }
        return s;
    }

    protected void killAll() {
        for (int i = 0; i < this.m_pools.size(); ++i) {
            BrokerPool pool = (BrokerPool)this.m_pools.elementAt(i);
            pool.clearQueue();
        }
        while (this.m_factoryThreads.size() > 0) {
            FactoryThread f = (FactoryThread)this.m_factoryThreads.elementAt(0);
            try {
                this.freeFactoryThread(f, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.m_pools.removeAllElements();
    }

    public BrokerConnector getConnector() {
        return this.createConnector();
    }

    private void processArgs(String[] args) {
        if (args == null) {
            System.out.println("null");
            return;
        }
        String s = this.getArg(args, "-c");
        if (s != null) {
            this.m_connectorClass = s;
        }
    }

    private String getArg(String[] args, String s) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            arg = args[i].substring(s.length());
            if (arg.length() != 0) break;
            arg = null;
            break;
        }
        return arg;
    }

    private BrokerConnector createConnector() {
        BrokerConnector connector = null;
        try {
            Object o = RocfClass.forName(this.m_connectorClass).newInstance();
            if (o instanceof BrokerConnector) {
                connector = (BrokerConnector)o;
            } else {
                System.out.println("FATAL ERROR:");
                System.out.println("Invalid BrokerConnector class: " + this.m_connectorClass);
            }
        }
        catch (Exception ex) {
            System.out.println("FATAL ERROR:");
            System.out.println("Could not load the connector class: " + this.m_connectorClass);
            ex.printStackTrace();
        }
        return connector;
    }

    private void startEventServer() {
        try {
            this.m_eventServer = new BrokerEventServer();
            this.m_eventServer.start();
            this.addBrokerEventListener(this.m_eventServer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getEventServerPort() {
        int port = 0;
        if (this.m_eventServer != null) {
            port = this.m_eventServer.getPort();
        }
        return port;
    }

    private void sleep(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

