/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Streamer;
import com.sas.security.BaseSecuritySupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class RunCommand
implements Runnable {
    boolean execute = true;
    boolean echo = true;
    Thread thread = null;
    Runtime rt;
    Process proc;
    int maxSleep = 20000;
    int sleepAmount = 50;
    String[] ncmd;
    String lastErr;
    String lastOut;
    boolean suppressLog = false;
    Streamer errStream;
    Streamer outStream;

    public void setSuppressLog(boolean b) {
        this.suppressLog = b;
    }

    public String getLastErr() {
        return this.lastErr;
    }

    public String getLastOut() {
        return this.lastOut;
    }

    public void setMaxSleep(int ms) {
        this.maxSleep = ms;
    }

    public void setSleepAmount(int sa) {
        this.sleepAmount = sa;
    }

    public void setEcho(boolean b) {
        this.echo = b;
    }

    public void setExecute(boolean b) {
        this.execute = b;
    }

    public int processCommand(String s) {
        return this.processCommand(new String[]{s});
    }

    private String[] parse(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int l = st.countTokens();
        String[] sv = new String[l];
        for (int i = 0; i < l; ++i) {
            sv[i] = st.nextToken();
        }
        return sv;
    }

    private String[] parseArray(String[] cmd) {
        String[] cmd2 = new String[]{};
        for (int i = 0; i < cmd.length; ++i) {
            StringTokenizer st = new StringTokenizer(cmd[i]);
            int count = st.countTokens();
            String[] temp = new String[cmd2.length + count];
            System.arraycopy(cmd2, 0, temp, 0, cmd2.length);
            int k = cmd2.length;
            for (int j = 0; j < count; ++j) {
                String next = st.nextToken();
                temp[k++] = next;
            }
            cmd2 = new String[temp.length];
            System.arraycopy(temp, 0, cmd2, 0, temp.length);
        }
        return cmd2;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    @Override
    public void run() {
        if (this.maxSleep == 0) {
            return;
        }
        for (int i = 0; this.proc != null && i < this.maxSleep; i += this.sleepAmount) {
            this.pause(this.sleepAmount);
        }
        if (this.proc != null) {
            System.out.println("Destroying process that ran over " + this.maxSleep + " ms");
            this.proc.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new Throwable(e.toString());
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processCommand(String[] cmd) {
        cmd = this.parseArray(cmd);
        this.thread = null;
        this.errStream = null;
        this.outStream = null;
        this.proc = null;
        int rc = 0;
        if (cmd == null) {
            return rc;
        }
        if (this.echo) {
            for (int q = 0; q < cmd.length && cmd[q] != null; ++q) {
                System.out.print(cmd[q] + " ");
            }
            System.out.println();
        }
        if (this.execute) {
            try {
                String javaClasspath = System.getProperty("java.class.path");
                String webAFClasspath = System.getProperty("webaf.class.path");
                String classpath = "";
                if (webAFClasspath != null && webAFClasspath.length() != 0) {
                    classpath = classpath + webAFClasspath;
                }
                if (javaClasspath != null && javaClasspath.length() != 0) {
                    classpath = classpath.length() == 0 ? javaClasspath : classpath + System.getProperty("path.separator") + javaClasspath;
                }
                this.proc = Runtime.getRuntime().exec(cmd, new String[]{"CLASSPATH=" + classpath});
                InputStream in = this.proc.getInputStream();
                InputStream err = this.proc.getErrorStream();
                BufferedInputStream bisin = new BufferedInputStream(in);
                BufferedInputStream biserr = new BufferedInputStream(err);
                ByteArrayOutputStream baosin = new ByteArrayOutputStream();
                ByteArrayOutputStream baoserr = new ByteArrayOutputStream();
                this.outStream = new Streamer(bisin, baosin);
                this.errStream = new Streamer(biserr, baoserr);
                this.outStream.start();
                this.errStream.start();
                this.start();
                rc = this.proc.waitFor();
                this.proc = null;
                err.close();
                in.close();
                byte[] bufin = baosin.toByteArray();
                String sin = new String(bufin);
                if (sin != null && sin.length() > 0 && !this.suppressLog) {
                    System.out.println(sin);
                }
                this.lastOut = sin;
                byte[] buferr = baoserr.toByteArray();
                String serr = new String(buferr);
                if (serr != null && serr.length() > 0 && !this.suppressLog) {
                    System.err.println(serr);
                }
                this.lastErr = serr;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.cleanup();
            }
            if (rc != 0) {
                System.out.println("\nProcess exited with " + rc + "\n");
            }
        }
        return rc;
    }

    private void cleanup() {
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
        if (this.errStream != null) {
            this.errStream.stop();
            this.errStream = null;
        }
        if (this.outStream != null) {
            this.outStream.stop();
            this.outStream = null;
        }
        if (this.errStream != null) {
            this.errStream.stop();
            this.errStream = null;
        }
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    private void pause(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

