/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.QueueKey;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBReferenceObject;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBTreeInterface;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.rmi.TerminatedServerException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public abstract class RocfORBTree
extends RocfORBReferenceObject
implements RocfORBTreeInterface {
    private transient long constructionTime = System.currentTimeMillis();
    private transient ArrayList children = new ArrayList();
    private transient RocfORBTree parent;
    private transient RocfORBTree qroot;
    private transient int maxKids = Integer.MAX_VALUE;
    private transient boolean depthfirst = true;
    private transient String creationTime;
    private transient boolean active;
    private transient int clientUsageCount;
    private transient int preloadUsageCount;
    private transient Object localSynchObj = new Object();
    private transient Object quickSynch;
    private transient SingleThreadedQueue stq = null;
    private transient long defaultTimeout = 900000L;
    private transient String myClassName = "";
    private transient boolean gra;
    private transient Object idleSynch = new Object();
    private transient Object addSynchObject = new Object();
    private transient int pending;
    private transient boolean debugTiming = false;

    public RocfORBTree() throws RemoteException {
        this.creationTime = this.getCurrentTimestamp();
        this.myClassName = this.getClass().getName();
        int li = this.myClassName.lastIndexOf(46);
        if (li >= 0) {
            this.myClassName = this.myClassName.substring(li + 1);
        }
        if (this.myClassName.startsWith("_rprxRemote")) {
            this.myClassName = this.myClassName.substring(11);
        }
        if (this.myClassName.endsWith("Server")) {
            this.myClassName = this.myClassName.substring(0, this.myClassName.length() - 6);
        }
        this.stq = new SingleThreadedQueue(this.myClassName);
    }

    public Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        return this._RemoteObject_enter(methodName, this.defaultTimeout);
    }

    public Object _RemoteObject_enter(String methodName, long timeout) throws ServerBusyTimeoutException {
        SingleThreadedQueue stq = this._r_getSTQ();
        Object key = stq.acquire(this.myClassName, methodName);
        try {
            boolean canEnterMethod = stq.enter(key, timeout);
            if (!canEnterMethod) {
                throw new ServerBusyTimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new ServerBusyTimeoutException();
        }
        return key;
    }

    public void _RemoteObject_exit(String methodName, Object o) {
        SingleThreadedQueue stq = this._r_getSTQ();
        QueueKey qk = (QueueKey)o;
        stq.exit(qk);
    }

    public SingleThreadedQueue _r_getSTQ() {
        return this.stq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        RocfORB orb = (RocfORB)this._Rocf_root();
        Object ret = null;
        Object _o = null;
        String methodName = "getChild";
        try {
            _o = orb._RemoteObject_enter(methodName);
            if (orb != this && desc instanceof RocfORBSessionDescriptor) {
                RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
                if (orb.getrefcnt().releasedClient(sdesc.callback)) {
                    throw new TerminatedServerException();
                }
            }
            ret = this._RemoteObject_getChildImpl(desc);
        }
        finally {
            orb._RemoteObject_exit(methodName, _o);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _RemoteObject_remove() throws RemoteException {
        RocfORB orb = (RocfORB)this._Rocf_root();
        Object _o = null;
        String methodName = "remove";
        try {
            _o = orb._RemoteObject_enter(methodName);
            this._RemoteObject_removeImpl();
        }
        finally {
            orb._RemoteObject_exit(methodName, _o);
        }
    }

    void _r_setGRActive(boolean b) {
        this.gra = b;
    }

    boolean _r_isGRActive() {
        return this.gra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _r_addUser(boolean preloadUser, Object callback) {
        Object object = this.addSynchObject;
        synchronized (object) {
            if (preloadUser) {
                ++this.preloadUsageCount;
            } else {
                ++this.clientUsageCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _r_releaseUser(boolean preloadUser, Object callback) {
        Object object = this.addSynchObject;
        synchronized (object) {
            if (preloadUser) {
                --this.preloadUsageCount;
            } else {
                --this.clientUsageCount;
            }
            if (this.preloadUsageCount == 0 && this.clientUsageCount == 0) {
                try {
                    this._RemoteObject_remove();
                }
                catch (RemoteException rex) {
                    rex.printStackTrace();
                }
            }
        }
    }

    String _r_usageString() {
        return " Hash=" + this.hashCode() + " Nodes=" + this._Rocf_numKids();
    }

    Object _r_syncher() {
        if (this.quickSynch == null) {
            this.quickSynch = this._Rocf_root().localSynchObj;
        }
        return this.quickSynch;
    }

    int _r_getClientUsageCount() {
        return this.clientUsageCount;
    }

    int _r_getPreloadUsageCount() {
        return this.preloadUsageCount;
    }

    int _r_pending() {
        return this.pending;
    }

    void _r_clearpending() {
        this.pending = 0;
    }

    void _r_addpending() {
        ++this.pending;
    }

    void _r_decpending() {
        --this.pending;
        if (this.pending < 0) {
            this.pending = 0;
        }
    }

    boolean _r_hasroom() {
        return this.children.size() + this.pending < this.maxKids;
    }

    Iterator _Rocf_iter() {
        return this.children.iterator();
    }

    public int _Rocf_getMaxKids() {
        return this.maxKids;
    }

    public void _Rocf_setMaxKids(int maxKids) {
        this.maxKids = maxKids;
    }

    public boolean _Rocf_getDepthFirst() {
        return this.depthfirst;
    }

    public void _Rocf_setDepthFirst(boolean depthfirst) {
        this.depthfirst = depthfirst;
    }

    public RocfORBTree _Rocf_getParent() {
        return this.parent;
    }

    public void _Rocf_setParent(RocfORBTree parent) {
        this.parent = parent;
    }

    public void _Rocf_addChild(RocfORBTree child) {
        this.children.add(child);
        child._Rocf_setParent(this);
    }

    public void _Rocf_removeChild(RocfORBTree t) throws RemoteException {
        this.children.remove(t);
        if (this.children.size() == 0) {
            this._Rocf_lastChildRemoved();
        }
    }

    public void _Rocf_lastChildRemoved() throws RemoteException {
        if (this.pending == 0) {
            this._RemoteObject_remove();
        }
    }

    public void _Rocf_refresh() {
        if (this._Rocf_root() != this) {
            this._Rocf_root()._Rocf_refresh();
        }
    }

    public RocfORBTree _Rocf_root() {
        if (this.qroot == null) {
            this.qroot = this;
            RocfORBTree t = null;
            while ((t = this.qroot._Rocf_getParent()) != null) {
                this.qroot = t;
            }
        }
        return this.qroot;
    }

    public abstract Object _RemoteObject_getChildImpl(Object var1) throws RemoteException;

    public void _RemoteObject_removeImpl() throws RemoteException {
        this.preloadUsageCount = 0;
        this.clientUsageCount = 0;
        if (this.parent != null) {
            this.parent._Rocf_removeChild(this);
        }
    }

    void _Rocf_pruneBranches() throws RemoteException {
        while (this.children.size() > 0) {
            RocfORBTree t = (RocfORBTree)this.children.get(0);
            t._RemoteObject_remove();
        }
    }

    int _Rocf_childIndex() {
        RocfORBTree prnt = this._Rocf_getParent();
        return prnt == null ? -1 : prnt.children.indexOf(this) + 1;
    }

    String StarInt(int i) {
        return i == Integer.MAX_VALUE ? "*" : String.valueOf(i);
    }

    Object _Rocf_getKid(int index) {
        return this.children.get(index);
    }

    int _Rocf_numKids() {
        return this.children.size();
    }

    boolean _Rocf_nokids() {
        return this.children.size() == 0;
    }

    void pstat() {
        for (RocfORBTree t = this; t != null; t = t._Rocf_getParent()) {
            System.out.println(t.getClass().getName() + " hc=" + t.hashCode() + " cur=" + this.StarInt(t._Rocf_numKids()) + " max=" + this.StarInt(t._Rocf_getMaxKids()) + " pending=" + this.pending);
        }
    }

    boolean _Rocf_full() {
        boolean hasRoom = false;
        if (this.children.size() < this._Rocf_getMaxKids()) {
            hasRoom = true;
        }
        if (!hasRoom) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                RocfORBTree kid = (RocfORBTree)this.children.get(i);
                boolean bl = hasRoom = !kid._Rocf_full();
                if (hasRoom) break;
            }
        }
        return !hasRoom;
    }

    private String getCurrentTimestamp() {
        return RMIUtil.currentTimeStamp();
    }

    String _Rocf_getCreationTime() {
        return this.creationTime;
    }

    boolean _Rocf_isActive() {
        return this.active;
    }

    void _Rocf_setActive(boolean b) {
        this.active = b;
    }

    boolean _Rocf_isBusy() {
        return false;
    }

    void _r_waitUntilIdle() {
    }

    Object _r_tvstart() {
        if (!this.debugTiming) {
            return null;
        }
        Vector<Long> v = new Vector<Long>();
        v.addElement(new Long(this._r_msecs()));
        return v;
    }

    void _r_tvadd(Object o) {
        if (!this.debugTiming) {
            return;
        }
        Vector v = (Vector)o;
        v.addElement(new Long(this._r_msecs()));
    }

    void _r_tvdump(String s, Object o) {
        if (!this.debugTiming) {
            return;
        }
        Vector v = (Vector)o;
        v.addElement(new Long(this._r_msecs()));
        System.out.print(this.getClass().getName() + "::" + s + ":");
        for (int i = 1; i < v.size(); ++i) {
            Long lprev = (Long)v.elementAt(i - 1);
            Long lcurr = (Long)v.elementAt(i);
            long ldiff = lcurr - lprev;
            System.out.print(" op#" + i + "=" + ldiff);
        }
        System.out.println();
    }

    long _r_msecs() {
        return System.currentTimeMillis();
    }

    long _r_getConstructionTime() {
        return this.constructionTime;
    }

    void _r_releaseKids() {
        this.children.clear();
        this.pending = 0;
    }

    void _r_setQueueWaitTimeout(long l) {
        this.defaultTimeout = l * 1000L;
    }
}

