/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.IOMBaseClient;
import com.sas.rmi.IOMFactory;
import com.sas.rmi.J2Factory;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBPreloadThread;
import com.sas.rmi.RocfORBRefCnt;
import com.sas.rmi.RocfORBResPool;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBSessionInterface;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.RocfORBTreeInterface;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.rmi.TerminatedServerException;
import com.sas.sasserver.sclfuncs.SclfuncsV2Interface;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class RocfORBSession
extends RocfORBTree
implements RocfORBSessionInterface {
    private transient Connection m_ctxt;
    private transient J2Factory globalObjectFactory;
    private transient IOMFactory iomGlobalObjectFactory;
    private transient String host;
    private transient boolean started;
    private transient boolean bdontDie;
    private transient Rocf rocf = new Rocf();
    private transient RocfORBSessionDescriptor pdesc;
    private transient boolean setupComplete;
    private transient boolean m_hadAsynchKillRequest;
    private transient Object deathSynch = new Object();
    private transient SclfuncsV2Interface sclfuncs;
    private transient boolean isDead;
    private transient RemoteException rex;
    private transient String hver = "";
    private transient Timer timer = new Timer(true);
    boolean cleanupPending;

    Timer getTimer() {
        return this.timer;
    }

    void validateLife() throws RemoteException {
        if (this.getRemoteException() != null) {
            throw this.getRemoteException();
        }
        if (this.qisdead() || this.m_hadAsynchKillRequest || this._r_getSTQ().isFailAll()) {
            System.out.println("Note: attempt to use terminated session");
            throw new TerminatedServerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        Object ret = super._RemoteObject_getChild(desc);
        RocfORBClient client = (RocfORBClient)ret;
        RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
        Object clientCallback = sdesc.callback;
        RocfORBRefCnt refcnt = this.getORB().getrefcnt();
        Object clientLoc = refcnt.getClientLoc(clientCallback);
        boolean foundPreload = clientLoc instanceof RocfORBClient;
        Object _o = null;
        RocfORB _orb = this.getORB();
        String methodName = "StartSession";
        if (this.pdesc != null) {
            try {
                _o = this._RemoteObject_enter(methodName);
                this.postSetup();
            }
            catch (RemoteException e) {
                System.out.println("Caught");
                e.printStackTrace();
                throw e;
            }
            finally {
                this._RemoteObject_exit(methodName, _o);
            }
        }
        if (foundPreload) {
            boolean alive = false;
            methodName = "VerifyLife";
            try {
                _o = this._RemoteObject_enter(methodName);
                alive = this.verifyLife();
            }
            finally {
                this._RemoteObject_exit(methodName, _o);
            }
            if (!alive) {
                RocfORBMachine machine = this.getMachine();
                sdesc.ctxt = machine.getResPool().getConnection();
                refcnt.moveref(clientCallback, machine);
                int countRestarts = this.cleanupDeadSession(clientCallback);
                this.spawnRestart(countRestarts, clientCallback);
                RocfORBTreeInterface tsession = (RocfORBTreeInterface)machine._RemoteObject_getChild(sdesc);
                RocfORBTreeInterface tclient = (RocfORBTreeInterface)tsession._RemoteObject_getChild(sdesc);
                RocfORBClient clnt = (RocfORBClient)tclient;
                return clnt;
            }
        }
        methodName = "SetupClient";
        try {
            _o = this._RemoteObject_enter(methodName);
            String auser = sdesc.ctxt.getApplicationUsername();
            String apwd = sdesc.ctxt.getApplicationPassword();
            Connection curconn = client.getConnection();
            if (this.m_ctxt.isIOM()) {
                if (curconn == null) {
                    sdesc.ctxt = (Connection)this.m_ctxt.clone();
                    String[] keys = new String[]{IOMBaseClient.WORKSPACEKEY, Connection.WORKSPACE, Connection.SESSION};
                    for (int k = 0; k < keys.length; ++k) {
                        sdesc.ctxt.setObject(keys[k], this.m_ctxt.getObject(keys[k]));
                    }
                    sdesc.ctxt.setApplicationUsername(auser);
                    sdesc.ctxt.setApplicationPassword(apwd);
                } else {
                    sdesc.ctxt = curconn;
                }
            } else if (curconn == null) {
                sdesc.ctxt = this.m_ctxt.hotclone();
                sdesc.ctxt.setObject("::j2factory", null);
                sdesc.ctxt.setApplicationUsername(auser);
                sdesc.ctxt.setApplicationPassword(apwd);
            } else {
                sdesc.ctxt = curconn;
            }
            client.setup(sdesc);
        }
        catch (RemoteException e) {
            System.out.println("Caught");
            e.printStackTrace();
            throw e;
        }
        finally {
            this._RemoteObject_exit(methodName, _o);
        }
        return client;
    }

    @Override
    public Object _RemoteObject_getChildImpl(Object desc) throws RemoteException {
        boolean allChildrenAllocated;
        RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
        Object clientCallback = sdesc.callback;
        RocfORBRefCnt refcnt = this.getORB().getrefcnt();
        Object clientLoc = refcnt.getClientLoc(clientCallback);
        refcnt.validate(this, clientCallback);
        RocfORBClient client = null;
        if (clientLoc instanceof RocfORBClient) {
            client = (RocfORBClient)clientLoc;
        }
        RocfORB _orb = this.getORB();
        boolean failed = false;
        boolean foundPreload = client != null;
        boolean depthFirst = this._Rocf_getDepthFirst();
        boolean breadthFirst = !depthFirst;
        boolean bl = allChildrenAllocated = this._Rocf_numKids() >= this._Rocf_getMaxKids();
        if (allChildrenAllocated && client == null) {
            System.out.println("Warning: attach client to full session");
        }
        if (foundPreload) {
            refcnt.qrelease(client.getCallback());
        } else {
            client = new RocfORBClient();
            this._Rocf_addChild(client);
            if (clientLoc == this) {
                this._r_decpending();
            }
            refcnt.validate(this, clientCallback);
            refcnt.moveref(clientCallback, client);
        }
        return client;
    }

    void spawnRelease(final Object callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RocfORBSession.this.getORB().getrefcnt().release(callback);
            }
        }).start();
    }

    RocfORB getORB() {
        return (RocfORB)this._Rocf_root();
    }

    Rocf getRocf() {
        return this.rocf;
    }

    void setup(RocfORBSessionDescriptor sdesc) throws RemoteException {
        this.pdesc = sdesc;
        this.m_ctxt = sdesc.ctxt;
        this._r_getSTQ().setQueueName("MWS-Session");
        this._r_setQueueWaitTimeout(this.m_ctxt.getQueueWaitTimeout());
    }

    void setRemoteException(RemoteException rex) {
        this.rex = rex;
    }

    RemoteException getRemoteException() {
        return this.rex;
    }

    void postSetup() throws RemoteException {
        RocfORBSessionDescriptor sdesc = this.pdesc;
        this.pdesc = null;
        this.m_ctxt = sdesc.ctxt;
        try {
            this.setupComplete = false;
            if (!this.started) {
                long l1s = System.currentTimeMillis();
                if (this.m_ctxt.isJ2()) {
                    this.m_ctxt.setAccessMethod(Connection.ACCESS_METHOD_JCONNECT);
                    this.m_ctxt.setFunnel(false);
                    Rocf rocf = this.getRocf();
                    this._p("connecting");
                    rocf.connect(this.m_ctxt);
                    this.globalObjectFactory = new J2Factory(rocf, this.m_ctxt, false);
                    RocfORBResPool gparent = this.getMachine().getResPool();
                    int npreloads = gparent._r_getPreloadUsageCount();
                    int nclients = gparent._r_getClientUsageCount();
                    int waitFactor = npreloads + nclients;
                    if (waitFactor < 1) {
                        waitFactor = 1;
                    }
                    if (waitFactor > 20) {
                        waitFactor = 20;
                    }
                    this.globalObjectFactory.setWaitFactor(waitFactor);
                    this.m_ctxt.setJ2Factory(this.globalObjectFactory);
                    this.globalObjectFactory.setSkipAppl(true);
                    this._p("logon");
                    this.globalObjectFactory.logon();
                    this._p("ready");
                    this.hver = "SAS" + this.m_ctxt.getSASVersion();
                    this.started = true;
                } else if (this.m_ctxt.isIOM() || this.m_ctxt.isGMS() || this.m_ctxt.isOLAP()) {
                    this.m_ctxt.setFunnel(false);
                    Rocf rocf = this.getRocf();
                    this.m_ctxt.setClassFactory(rocf);
                    IOMBaseClient.iominit(this.m_ctxt);
                    this.iomGlobalObjectFactory = new IOMFactory(rocf, this.m_ctxt, false);
                    this.m_ctxt.setObject("::iomfactory", this.iomGlobalObjectFactory);
                    this.iomGlobalObjectFactory.setSkipAppl(true);
                    this.iomGlobalObjectFactory.logon();
                    this.hver = "SAS" + this.m_ctxt.getSASVersion();
                    this.started = true;
                }
                this.setupLifeChecker();
                this.setupComplete = true;
                this.psesmsg("started", l1s);
            }
        }
        catch (Exception e) {
            System.out.println("Handling following SESSION start exception:");
            e.printStackTrace();
            throw new RemoteException(e.toString());
        }
    }

    private void _p(String s) {
    }

    Connection getConnection() {
        return this.m_ctxt;
    }

    @Override
    public void _RemoteObject_remove() throws RemoteException {
        this.getTimer().schedule((TimerTask)new SessionKiller(), 10L);
        super._RemoteObject_remove();
    }

    void spawnKill() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RocfORBSession.this.internalKill();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalKill() {
        Object _o = null;
        String methodName = "StopSession";
        try {
            _o = this._RemoteObject_enter(methodName);
            this.x_RemoteObject_removeImpl();
        }
        catch (RemoteException e) {
            System.out.println("Caught");
            e.printStackTrace();
        }
        finally {
            this._RemoteObject_exit(methodName, _o);
        }
    }

    public void x_RemoteObject_removeImpl() throws RemoteException {
        int pending;
        int children = this._Rocf_numKids();
        if (children + (pending = this._r_pending()) > 0) {
            System.out.println(this.getClass().getName() + ":Remove ignored, clients are active,  children=" + children + " pending=" + pending);
            return;
        }
        boolean quickDeathCheck = this.qisdead();
        this.isDead = true;
        Object _o = null;
        String methodName = "ENDSAS";
        if (!quickDeathCheck && !this._r_getSTQ().isFailAll() && this.setupComplete) {
            long l1s = System.currentTimeMillis();
            this.m_ctxt.stop();
            this.rocf.stop();
            this.psesmsg("terminated", l1s);
        }
        this.isDead = true;
    }

    @Override
    boolean _Rocf_isBusy() {
        boolean busy = this._r_getSTQ().size() > 0;
        return busy;
    }

    boolean isSetupComplete() {
        return this.setupComplete;
    }

    public String getHost() {
        return this.host;
    }

    void dontDie() {
        this.bdontDie = true;
    }

    RocfORBMachine getMachine() {
        return (RocfORBMachine)this._Rocf_getParent();
    }

    RocfORBClient getClient(int index) {
        return (RocfORBClient)this._Rocf_getKid(index);
    }

    int getClientCount() {
        return this._Rocf_numKids();
    }

    String fid() {
        String ret = "F=0";
        if (this.globalObjectFactory != null) {
            ret = "F=" + this.globalObjectFactory.factoryId();
        }
        return ret;
    }

    @Override
    public String toString() {
        String s = "Session#" + this._Rocf_childIndex() + (this.isDead ? " DEAD " : "") + this._r_usageString() + " Pending=" + this._r_pending() + " " + this._Rocf_getCreationTime() + " MaxClients=" + this.StarInt(this._Rocf_getMaxKids());
        return s;
    }

    public String getActiveMethodString() {
        SingleThreadedQueue q = this._r_getSTQ();
        int nq = q.size();
        String s = " Pending=" + (nq < 2 ? 0 : nq - 1);
        s = nq > 0 ? s + " Active=" + q.topKey() : s + " Active=0";
        return s;
    }

    void pcon(String s, Connection ctxt) {
        s = (s + "                 ").substring(0, 21);
        s = s + " J2Factory=" + this.p1(ctxt.getObject("::j2factory")) + " Workspace=" + this.p1(ctxt.getObject(IOMBaseClient.WORKSPACEKEY)) + " Factory=" + this.p1(ctxt.getObject(IOMBaseClient.FACTORYKEY)) + "";
        System.out.println(s);
    }

    String p1(Object o) {
        return o == null ? "null   " : "" + o.hashCode();
    }

    void setupLifeChecker() throws Exception {
        if (!this.m_ctxt.isRMI()) {
            this.sclfuncs = (SclfuncsV2Interface)this.rocf.newInstance(SclfuncsV2Interface.class, this.m_ctxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean qisdead() {
        Object object = this.deathSynch;
        synchronized (object) {
            return this.isDead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyLife() throws RemoteException {
        Object object = this.deathSynch;
        synchronized (object) {
            if (this.isDead) {
                return this.isDead;
            }
            boolean isAlive = true;
            if (this.m_ctxt.isRMI()) {
                return isAlive;
            }
            try {
                double d = this.sclfuncs.symgetn("SYSVER");
            }
            catch (Exception e) {
                System.out.println(this.getClass().getName() + "::SAS session died");
                isAlive = false;
                this.isDead = true;
            }
            return isAlive;
        }
    }

    int resetRestarts() {
        int restartCount = 0;
        for (int i = this.getClientCount() - 1; i >= 0; --i) {
            RocfORBClient c = this.getClient(i);
            if (!c.isAutoRestart()) continue;
            ++restartCount;
            c.setAutoRestart(false);
        }
        return restartCount;
    }

    int cleanupDeadSession(Object liveUserCallback) {
        int restartCount = 0;
        if (this.cleanupPending) {
            return 0;
        }
        this.cleanupPending = true;
        RocfORBRefCnt refcnt = this.getORB().getrefcnt();
        for (int i = this.getClientCount() - 1; i >= 0; --i) {
            RocfORBClient c = this.getClient(i);
            Object callback = c.getCallback();
            if (callback == null) continue;
            refcnt.qrelease(callback);
        }
        restartCount = this.resetRestarts();
        this._r_releaseKids();
        try {
            this._RemoteObject_remove();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return restartCount;
    }

    @Override
    void _r_waitUntilIdle() {
    }

    boolean hadAsynchKillRequest() {
        return this.m_hadAsynchKillRequest;
    }

    void dbp(String s) {
    }

    @Override
    public void _RemoteObject_exit(String methodName, Object o) {
        super._RemoteObject_exit(methodName, o);
        if (!this._r_getSTQ().isFailAll() && !this.qisdead()) {
            this.getMachine().registerIdle(this);
        }
    }

    void psesmsg(String msg, long start) {
        System.out.println(this.hver + " session hash=" + this.hashCode() + " " + msg + " in " + RMIUtil.timeFormat((long)(System.currentTimeMillis() - start)) + " on " + new Date());
    }

    void spawnRestart(int howMany, Object callback) {
        if (howMany == 0) {
            return;
        }
        DeadRestart r = new DeadRestart(this.getORB(), this.getMachine().getResPool().getConnection(), false, howMany);
        this.getORB().getTimer().schedule((TimerTask)r, 20000L);
    }

    class DeadRestart
    extends TimerTask {
        RocfORB orb;
        Connection ctxt;
        boolean retain;
        int howMany;

        DeadRestart(RocfORB orb, Connection ctxt, boolean retain, int howMany) {
            this.orb = orb;
            this.ctxt = ctxt;
            this.retain = retain;
            this.howMany = howMany;
        }

        @Override
        public void run() {
            for (int j = 0; j < this.howMany; ++j) {
                RocfORBSessionDescriptor sdesc = new RocfORBSessionDescriptor();
                sdesc.ctxt = this.ctxt;
                sdesc.callback = new Object();
                sdesc.host = RocfORBPreloadThread.AVAIL;
                int maxretries = 1;
                RocfORBClient xclnt = null;
                for (int i = 1; xclnt == null && i <= maxretries; ++i) {
                    try {
                        RocfORBTreeInterface respool = (RocfORBTreeInterface)this.orb._RemoteObject_getChild((Object)sdesc);
                        RocfORBTreeInterface machine = (RocfORBTreeInterface)respool._RemoteObject_getChild(sdesc);
                        RocfORBTreeInterface tsession = (RocfORBTreeInterface)machine._RemoteObject_getChild(sdesc);
                        RocfORBTreeInterface tclient = (RocfORBTreeInterface)tsession._RemoteObject_getChild(sdesc);
                        RocfORBClient clnt = (RocfORBClient)tclient;
                        clnt.setAutoRestart(true);
                        clnt.setRetain(this.retain);
                        xclnt = clnt;
                        continue;
                    }
                    catch (RemoteException e) {
                        System.out.println("ERROR recreating client workspace");
                        e.printStackTrace();
                        System.out.println("Attempting again (" + i + "/" + maxretries + ")");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Bad exception during restart, continuing after");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class SessionKiller
    extends TimerTask {
        SessionKiller() {
        }

        @Override
        public void run() {
            RocfORBSession.this.internalKill();
        }
    }

    class DeferredStarter
    implements Runnable {
        DeferredStarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object _o = null;
            String methodName = "StartSAS";
            try {
                _o = RocfORBSession.this._RemoteObject_enter(methodName);
                DeferredStarter deferredStarter = this;
                synchronized (deferredStarter) {
                    this.notifyAll();
                }
                RocfORBSession.this.postSetup();
            }
            catch (RemoteException rex) {
                RocfORBSession.this.setRemoteException(rex);
            }
            finally {
                RocfORBSession.this._RemoteObject_exit(methodName, _o);
            }
        }
    }
}

