/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.OutOfResourcesException;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBPreloadThread;
import com.sas.rmi.RocfORBRefCnt;
import com.sas.rmi.RocfORBResPoolInterface;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.ServerBusyTimeoutException;
import java.rmi.RemoteException;

public class RocfORBResPool
extends RocfORBTree
implements RocfORBResPoolInterface {
    private transient Connection m_ctxt;
    private transient String[] rolloverMachines;
    private transient boolean[] inUse;
    private transient boolean setupComplete;

    private void updateUseVec() throws RemoteException {
        int i;
        for (i = 0; i < this.rolloverMachines.length; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i < this.rolloverMachines.length; ++i) {
            String rhost = this.rolloverMachines[i];
            boolean found = false;
            for (int j = 0; !found && j < this.getMachineCount(); ++j) {
                String mhost = this.getMachine(j).getHost();
                found = this.getORB().sameHost(rhost, mhost);
            }
            this.inUse[i] = found;
        }
    }

    private void noMoreRoom() throws RemoteException {
        this.getORB().traceRB("moreClients.txt");
        String msg = "Server Resources exceeded.  Try to connect later.";
        throw new OutOfResourcesException(msg);
    }

    @Override
    public Object _RemoteObject_getChildImpl(Object desc) throws RemoteException {
        int ns;
        RocfORBMachine _machine;
        int im;
        int nm;
        RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
        Object clientCallback = sdesc.callback;
        RocfORBRefCnt refcnt = this.getORB().getrefcnt();
        Object clientLoc = refcnt.getClientLoc(clientCallback);
        refcnt.validate(this, clientCallback);
        RocfORBMachine machine = null;
        Object _resPoolClient = null;
        RocfORB _orb = this.getORB();
        RocfORBResPool _respool = this;
        boolean needSetup = false;
        String targetHost = null;
        boolean depthFirst = this._Rocf_getDepthFirst();
        boolean breadthFirst = !depthFirst;
        boolean allChildrenAllocated = this._Rocf_numKids() >= this._Rocf_getMaxKids();
        boolean isForPreload = sdesc.host.equals(RocfORBPreloadThread.AVAIL);
        if (sdesc.host != null && !sdesc.host.equals(RocfORBPreloadThread.AVAIL)) {
            if (breadthFirst && this.getMachineCount() > 0) {
                nm = this.getMachineCount();
                for (im = 0; machine == null && im < nm; ++im) {
                    _machine = this.getMachine(im);
                    if (_machine.getSessionCount() <= 0) continue;
                    RocfORBSession _session = _machine.getSession(_machine._getNextBreadthFirstChild(false));
                    int nc = _session.getClientCount();
                    for (int ic = 0; machine == null && ic < nc; ++ic) {
                        RocfORBClient _client = _session.getClient(ic);
                        if (!_client.isAvailable() || !_client.sameUser(sdesc.ctxt)) continue;
                        machine = _machine;
                        _client.setAvailable(false);
                        refcnt.validate(this, clientCallback);
                        refcnt.moveref(clientCallback, _client);
                    }
                }
            }
            nm = this.getMachineCount();
            for (im = 0; machine == null && im < nm; ++im) {
                _machine = this.getMachine(im);
                ns = _machine.getSessionCount();
                for (int is = 0; machine == null && is < ns; ++is) {
                    RocfORBSession _session = _machine.getSession(is);
                    int nc = _session.getClientCount();
                    for (int ic = 0; machine == null && ic < nc; ++ic) {
                        RocfORBClient _client = _session.getClient(ic);
                        if (!_client.isAvailable() || !_client.sameUser(sdesc.ctxt)) continue;
                        machine = _machine;
                        _client.setAvailable(false);
                        refcnt.validate(this, clientCallback);
                        refcnt.moveref(clientCallback, _client);
                    }
                }
            }
        }
        if (machine == null && breadthFirst && !allChildrenAllocated) {
            nm = this.getMachineCount();
            for (im = 0; machine == null && im < nm; ++im) {
                _machine = this.getMachine(im);
                if (_machine._r_hasroom()) {
                    machine = _machine;
                } else {
                    ns = _machine.getSessionCount();
                    for (int is = 0; machine == null && is < ns; ++is) {
                        RocfORBSession _session = _machine.getSession(is);
                        if (!_session._r_hasroom()) continue;
                        machine = _machine;
                    }
                }
                if (machine == null) continue;
                refcnt.validate(this, clientCallback);
                refcnt.moveref(clientCallback, machine);
            }
        }
        if (machine == null && (depthFirst || allChildrenAllocated)) {
            nm = this.getMachineCount();
            for (im = 0; machine == null && im < nm; ++im) {
                _machine = this.getMachine(im);
                if (_machine._r_hasroom()) {
                    machine = _machine;
                    refcnt.validate(this, clientCallback);
                    refcnt.moveref(clientCallback, machine);
                    continue;
                }
                ns = _machine.getSessionCount();
                for (int is = 0; machine == null && is < ns; ++is) {
                    RocfORBSession _session = _machine.getSession(is);
                    if (!_session._r_hasroom()) continue;
                    machine = _machine;
                    if (depthFirst) {
                        _session._r_addpending();
                        refcnt.validate(this, clientCallback);
                        refcnt.moveref(clientCallback, _session);
                        continue;
                    }
                    refcnt.validate(this, clientCallback);
                    refcnt.moveref(clientCallback, machine);
                }
            }
        }
        if (machine == null) {
            this.updateUseVec();
            for (int i = 0; i < this.inUse.length; ++i) {
                if (this.inUse[i]) continue;
                targetHost = this.rolloverMachines[i];
                machine = new RocfORBMachine();
                int maxkids = this.getORB().getMaxSessionsForMachine(targetHost);
                machine._Rocf_setMaxKids(maxkids);
                needSetup = true;
                this._Rocf_addChild(machine);
                refcnt.validate(this, clientCallback);
                refcnt.moveref(clientCallback, machine);
                break;
            }
        }
        if (machine == null) {
            String msg = "Server Resources exceeded.  Try to connect later.";
            System.out.println(this.getClass().getName() + ":" + msg);
            _orb.pinfo();
            throw new OutOfResourcesException(msg);
        }
        if (needSetup) {
            RocfORBSessionDescriptor tsdesc = (RocfORBSessionDescriptor)sdesc.clone();
            tsdesc.ctxt = (Connection)this.m_ctxt.clone();
            tsdesc.ctxt.setHost(targetHost);
            try {
                machine.setup(tsdesc);
            }
            catch (RemoteException re) {
                refcnt.release(clientCallback);
                throw re;
            }
        }
        return machine;
    }

    void setup(RocfORBSessionDescriptor sdesc) throws RemoteException {
        this.setupComplete = false;
        this.m_ctxt = sdesc.ctxt;
        RocfORB orb = this.getORB();
        if (this.m_ctxt.getUseProfile()) {
            this.rolloverMachines = orb.getMachinesForProfile(this.m_ctxt.getProfileName());
        }
        if (this.rolloverMachines == null) {
            this.rolloverMachines = new String[1];
            this.rolloverMachines[0] = this.m_ctxt.getHost();
        } else {
            String[] s = new String[this.rolloverMachines.length + 1];
            s[0] = this.m_ctxt.getHost();
            for (int i = 0; i < this.rolloverMachines.length; ++i) {
                s[i + 1] = this.rolloverMachines[i];
            }
            this.rolloverMachines = s;
        }
        for (int i = 0; i < this.rolloverMachines.length; ++i) {
            this.rolloverMachines[i] = RMIUtil.hostNormalize((String)this.rolloverMachines[i]);
            this.rolloverMachines[i] = orb.findDupKey(this.rolloverMachines[i]);
        }
        this.inUse = new boolean[this.rolloverMachines.length];
        this._Rocf_setMaxKids(this.rolloverMachines.length);
        this._Rocf_setDepthFirst(orb._Rocf_getDepthFirst());
        this.setupComplete = true;
    }

    @Override
    public void _RemoteObject_removeImpl() throws RemoteException {
        int pending;
        int children = this._Rocf_numKids();
        if (children + (pending = this._r_pending()) > 0) {
            System.out.println(this.getClass().getName() + ":Remove ignored, clients are active,  children=" + children + " pending=" + pending);
            return;
        }
        if (this.setupComplete) {
            // empty if block
        }
        super._RemoteObject_removeImpl();
    }

    RocfORBMachine getMachine(int index) {
        return (RocfORBMachine)this._Rocf_getKid(index);
    }

    int getMachineCount() {
        return this._Rocf_numKids();
    }

    RocfORB getORB() {
        return (RocfORB)this._Rocf_getParent();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Resource Pool#" + this._Rocf_childIndex());
        sb.append(this._r_usageString());
        if (this.m_ctxt == null || this.m_ctxt.getProfileName() == null) {
            sb.append(" Unnamed");
        } else {
            if (this.m_ctxt.getUseProfile()) {
                sb.append(" Profile=" + this.m_ctxt.getProfileName());
            } else {
                sb.append(" Profile=");
            }
            int nro = this.rolloverMachines.length;
            if (nro > 0) {
                sb.append(" RO=");
                for (int i = 0; i < nro; ++i) {
                    sb.append(this.rolloverMachines[i]);
                    if (i >= nro - 1) continue;
                    sb.append(",");
                }
            }
        }
        return sb.toString();
    }

    Connection getConnection() {
        return this.m_ctxt;
    }

    @Override
    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        return super._RemoteObject_getChild(desc);
    }

    @Override
    public void _RemoteObject_remove() throws RemoteException {
        super._RemoteObject_remove();
    }

    int _getNextBreadthFirstMachine(boolean isForPreload) {
        int nextMachine = 0;
        int minKids = 0;
        RocfORBMachine machine = this.getMachine(0);
        int ns = machine.getSessionCount();
        for (int is = 0; is < ns; ++is) {
            RocfORBSession session = machine.getSession(is);
            int nc = session.getClientCount();
            for (int ic = 0; ic < nc; ++ic) {
                RocfORBClient client = session.getClient(ic);
                if ((isForPreload || client.getHost().equals(RocfORBPreloadThread.AVAIL)) && (!isForPreload || !client.isAutoRestart())) continue;
                ++minKids;
            }
        }
        int nm = this.getMachineCount();
        for (int im = 1; im < nm; ++im) {
            machine = this.getMachine(im);
            int numKids = 0;
            int ns2 = machine.getSessionCount();
            for (int is = 0; is < ns2; ++is) {
                RocfORBSession session = machine.getSession(is);
                int nc = session.getClientCount();
                for (int ic = 0; ic < nc; ++ic) {
                    RocfORBClient client = session.getClient(ic);
                    if ((isForPreload || client.getHost().equals(RocfORBPreloadThread.AVAIL)) && (!isForPreload || !client.isAutoRestart())) continue;
                    ++numKids;
                }
            }
            if (numKids >= minKids) continue;
            minKids = numKids;
            nextMachine = im;
        }
        return nextMachine;
    }
}

