/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBPreloadConnection;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBTreeInterface;
import com.sas.security.BaseSecuritySupport;
import java.rmi.RemoteException;
import java.util.Vector;

public class RocfORBPreloadThread
implements Runnable {
    RocfORB orb;
    Connection connection;
    RocfORBPreloadConnection preload;
    public static String AVAIL = "available-PreLoad";

    public RocfORBPreloadThread(RocfORB orb, Connection connection, RocfORBPreloadConnection preload) {
        this.orb = orb;
        this.connection = connection;
        this.preload = preload;
    }

    @Override
    public void run() {
        String name = this.preload.profile + " (" + this.preload.key + ")";
        this.orb.traceRB("preloading.txt", name);
        try {
            int i;
            Vector<Thread> clientThreads = new Vector<Thread>();
            for (i = 0; i < this.preload.preloadedClients; ++i) {
                RocfORBSessionDescriptor sdesc = new RocfORBSessionDescriptor();
                sdesc.ctxt = this.connection;
                sdesc.host = AVAIL;
                Client clnt = new Client(this.orb, sdesc, this.preload, i);
                if (this.preload.asynchronousStartup) {
                    Thread t = BaseSecuritySupport.securitySupport.createThread((Runnable)clnt);
                    t.start();
                    Thread.sleep(100L);
                    clientThreads.addElement(t);
                    continue;
                }
                clnt.run();
            }
            for (i = 0; i < clientThreads.size(); ++i) {
                Thread t = (Thread)clientThreads.elementAt(i);
                t.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.orb.traceRB("preloadingComplete.txt", name);
    }

    class Client
    implements Runnable {
        RocfORB orb;
        RocfORBSessionDescriptor sdesc;
        RocfORBPreloadConnection preload;
        int index;

        Client(RocfORB orb, RocfORBSessionDescriptor sdesc, RocfORBPreloadConnection preload, int index) {
            this.orb = orb;
            this.sdesc = sdesc;
            this.preload = preload;
            this.index = index;
        }

        @Override
        public void run() {
            block2: {
                Object callback = null;
                try {
                    RocfORBSessionDescriptor sdesc = new RocfORBSessionDescriptor();
                    sdesc.ctxt = RocfORBPreloadThread.this.connection;
                    sdesc.host = AVAIL;
                    sdesc.callback = callback = new Object();
                    RocfORBTreeInterface respool = (RocfORBTreeInterface)this.orb._RemoteObject_getChild((Object)sdesc);
                    RocfORBTreeInterface machine = (RocfORBTreeInterface)respool._RemoteObject_getChild(sdesc);
                    String host = ((RocfORBMachine)machine).getHost();
                    System.out.println(" Starting client#" + (this.index + 1) + " on " + host);
                    RocfORBTreeInterface session = (RocfORBTreeInterface)machine._RemoteObject_getChild(sdesc);
                    RocfORBTreeInterface tclient = (RocfORBTreeInterface)session._RemoteObject_getChild(sdesc);
                    RocfORBClient clnt = (RocfORBClient)tclient;
                    clnt.setAutoRestart(this.preload.autoRestart);
                    clnt.setRetain(this.preload.retain);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if (callback == null) break block2;
                    this.orb.getrefcnt().release(callback);
                }
            }
        }
    }
}

