/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.OutOfResourcesException;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachineInterface;
import com.sas.rmi.RocfORBPreloadThread;
import com.sas.rmi.RocfORBRefCnt;
import com.sas.rmi.RocfORBResPool;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.TerminatedServerException;
import java.rmi.RemoteException;

public class RocfORBMachine
extends RocfORBTree
implements RocfORBMachineInterface {
    private transient String host;
    transient int maxSessions;
    transient int rolloverType;
    private transient Connection m_ctxt;
    private transient boolean setupComplete;
    private transient Object idleWaiter = new Object();
    private transient RocfORBSession emptySession;
    private transient RocfORBSession idleSession;

    @Override
    public Object _RemoteObject_getChildImpl(Object desc) throws RemoteException {
        boolean isForPreload;
        RocfORBSession _session;
        RocfORBSession _session2;
        int is;
        int ns;
        boolean allChildrenAllocated;
        RocfORBSessionDescriptor sdesc = (RocfORBSessionDescriptor)desc;
        Object clientCallback = sdesc.callback;
        RocfORBRefCnt refcnt = this.getORB().getrefcnt();
        Object clientLoc = refcnt.getClientLoc(clientCallback);
        RocfORBSession session = null;
        boolean failed = false;
        refcnt.validate(this, clientCallback);
        if (clientLoc instanceof RocfORBClient) {
            RocfORBClient _client = (RocfORBClient)clientLoc;
            RocfORBSession _session3 = _client.getSession();
            session = _session3._Rocf_isBusy() ? _session3 : _session3;
        } else if (clientLoc instanceof RocfORBSession) {
            RocfORBSession _session4;
            session = _session4 = (RocfORBSession)clientLoc;
        }
        boolean needSetup = false;
        RocfORB _orb = this.getORB();
        boolean depthFirst = this._Rocf_getDepthFirst();
        boolean breadthFirst = !depthFirst;
        boolean bl = allChildrenAllocated = this._Rocf_numKids() >= this._Rocf_getMaxKids();
        if (session == null && sdesc.host != null && !sdesc.host.equals(RocfORBPreloadThread.AVAIL)) {
            ns = this.getSessionCount();
            for (is = 0; session == null && is < ns; ++is) {
                _session2 = this.getSession(is);
                int nc = _session2.getClientCount();
                for (int ic = 0; session == null && ic < nc; ++ic) {
                    RocfORBClient _client = _session2.getClient(ic);
                    if (!_client.isAvailable() || !_client.sameUser(sdesc.ctxt)) continue;
                    session = _client.getSession();
                    _client.setAvailable(false);
                    refcnt.validate(this, clientCallback);
                    refcnt.moveref(clientCallback, _client);
                }
            }
        }
        if (session == null && breadthFirst && allChildrenAllocated && (_session = this.getSession(this._getNextBreadthFirstChild(isForPreload = sdesc.host.equals(RocfORBPreloadThread.AVAIL))))._r_hasroom()) {
            session = _session;
            session._r_addpending();
            refcnt.validate(this, clientCallback);
            refcnt.moveref(clientCallback, _session);
        }
        if (session == null && (depthFirst || allChildrenAllocated)) {
            ns = this.getSessionCount();
            for (is = 0; session == null && is < ns; ++is) {
                _session2 = this.getSession(is);
                if (!_session2._r_hasroom()) continue;
                session = _session2;
                session._r_addpending();
                refcnt.validate(this, clientCallback);
                refcnt.moveref(clientCallback, _session2);
            }
        }
        if (refcnt.releasedClient(clientCallback)) {
            throw new TerminatedServerException();
        }
        if (session == null && !allChildrenAllocated) {
            session = new RocfORBSession();
            session._Rocf_setMaxKids(this.getORB().getMaxClientsForSession(this.host));
            session._Rocf_setDepthFirst(this.getORB()._Rocf_getDepthFirst());
            session._r_addpending();
            this._Rocf_addChild(session);
            refcnt.validate(this, clientCallback);
            refcnt.moveref(clientCallback, session);
            needSetup = true;
        }
        if (session == null) {
            String msg = "Server Resources exceeded.  Try to connect later.";
            System.out.println(this.getClass().getName() + ":" + msg);
            throw new OutOfResourcesException(msg);
        }
        if (needSetup) {
            sdesc.ctxt = (Connection)this.m_ctxt.clone();
            try {
                session.setup(sdesc);
            }
            catch (RemoteException reme) {
                refcnt.release(clientCallback);
                throw reme;
            }
            catch (Exception e) {
                System.out.println("Handling:" + e);
                e.printStackTrace();
                refcnt.release(clientCallback);
                throw new RemoteException(e.toString());
            }
        }
        return session;
    }

    RocfORBSession findPreload() {
        RocfORBSession session = null;
        int ns = this.getSessionCount();
        for (int is = 0; session == null && is < ns; ++is) {
            boolean sessionHasPreloads;
            int sessionClients;
            RocfORBSession tsess = this.getSession(is);
            int sessionMaxKids = tsess._Rocf_getMaxKids();
            int sessionPreloads = tsess._r_getPreloadUsageCount();
            boolean sessionHasRoom = sessionPreloads + (sessionClients = tsess._r_getClientUsageCount()) <= sessionMaxKids;
            boolean sessionIsSetup = tsess.isSetupComplete();
            boolean sessionIsIdle = !tsess._Rocf_isBusy();
            boolean bl = sessionHasPreloads = sessionPreloads > 0;
            if (!sessionHasPreloads || !sessionIsIdle || !sessionHasRoom || !sessionIsSetup) continue;
            session = tsess;
        }
        return session;
    }

    RocfORBSession findExisting() {
        RocfORBSession session = null;
        long r1 = System.currentTimeMillis();
        int ns = this.getSessionCount();
        for (int is = 0; session == null && is < ns; ++is) {
            int sessionClients;
            RocfORBSession tsess = this.getSession(is);
            int sessionMaxKids = tsess._Rocf_getMaxKids();
            int sessionPreloads = tsess._r_getPreloadUsageCount();
            boolean sessionHasRoom = sessionPreloads + (sessionClients = tsess._r_getClientUsageCount()) < sessionMaxKids;
            boolean sessionIsSetup = tsess.isSetupComplete();
            boolean sessionIsIdle = !tsess._Rocf_isBusy();
            boolean sessionGRA = tsess._r_isGRActive();
            if (sessionHasRoom && (sessionIsIdle || sessionGRA) && sessionIsSetup) {
                session = tsess;
                continue;
            }
            if (!sessionHasRoom || sessionIsSetup) continue;
            session = tsess;
        }
        long r2 = System.currentTimeMillis();
        return session;
    }

    void setup(RocfORBSessionDescriptor sdesc) throws RemoteException {
        this.setupComplete = false;
        this.m_ctxt = sdesc.ctxt;
        this.setHost(this.m_ctxt.getHost());
        RocfORB orb = (RocfORB)this._Rocf_root();
        this._Rocf_setMaxKids(orb.getMaxSessionsForMachine(this.host));
        this._Rocf_setDepthFirst(orb._Rocf_getDepthFirst());
        this.setupComplete = true;
    }

    @Override
    public void _RemoteObject_removeImpl() throws RemoteException {
        int pending;
        int children = this._Rocf_numKids();
        if (children + (pending = this._r_pending()) > 0) {
            System.out.println(this.getClass().getName() + ":Remove ignored, clients are active,  children=" + children + " pending=" + pending);
            return;
        }
        Object _o = null;
        String methodName = "remove";
        if (this.setupComplete) {
            // empty if block
        }
        super._RemoteObject_removeImpl();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String s) throws RemoteException {
        this.host = s;
    }

    RocfORB getORB() {
        return this.getResPool().getORB();
    }

    RocfORBResPool getResPool() {
        return (RocfORBResPool)this._Rocf_getParent();
    }

    RocfORBSession getSession(int index) {
        return (RocfORBSession)this._Rocf_getKid(index);
    }

    int getSessionCount() {
        return this._Rocf_numKids();
    }

    @Override
    public String toString() {
        String s = "Machine#" + this._Rocf_childIndex() + this._r_usageString() + " Host=" + this.getHost() + " MaxSessions=" + this.StarInt(this._Rocf_getMaxKids());
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RocfORBSession waitForIdleSession() {
        RocfORBSession retval = null;
        long maxWait = 2000L;
        long startWait = System.currentTimeMillis();
        this.emptySession = null;
        this.idleSession = null;
        Object object = this.idleWaiter = new Object();
        synchronized (object) {
            try {
                this.idleWaiter.wait(maxWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.idleWaiter = null;
        long elapsedWait = System.currentTimeMillis() - startWait;
        if (this.emptySession != null) {
            retval = this.emptySession;
        } else if (this.idleSession != null) {
            retval = this.idleSession;
        }
        return retval;
    }

    void registerIdle(RocfORBSession idleSession) {
    }

    @Override
    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        return super._RemoteObject_getChild(desc);
    }

    @Override
    public void _RemoteObject_remove() throws RemoteException {
        super._RemoteObject_remove();
    }

    Connection getConnection() {
        return this.m_ctxt;
    }

    int _getNextBreadthFirstChild(boolean isForPreload) {
        int nextChild = 0;
        int minKids = 0;
        RocfORBSession session = this.getSession(0);
        int nc = session.getClientCount();
        for (int ic = 0; ic < nc; ++ic) {
            RocfORBClient client = session.getClient(ic);
            if ((isForPreload || client.getHost().equals(RocfORBPreloadThread.AVAIL)) && (!isForPreload || !client.isAutoRestart())) continue;
            ++minKids;
        }
        int ns = this.getSessionCount();
        for (int is = 1; is < ns; ++is) {
            session = this.getSession(is);
            int numKids = 0;
            int nc2 = session.getClientCount();
            for (int ic = 0; ic < nc2; ++ic) {
                RocfORBClient client = session.getClient(ic);
                if ((isForPreload || client.getHost().equals(RocfORBPreloadThread.AVAIL)) && (!isForPreload || !client.isAutoRestart())) continue;
                ++numKids;
            }
            if (numKids >= minKids) continue;
            minKids = numKids;
            nextChild = is;
        }
        return nextChild;
    }
}

