/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.iom.SAS.IWorkspace;
import com.sas.rmi.Connection;
import com.sas.rmi.IOMBaseClient;
import com.sas.rmi.IOMFactory;
import com.sas.rmi.J2Factory;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RMIBaseServer;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfClass;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClientInterface;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBObjectDescriptor;
import com.sas.rmi.RocfORBPreloadThread;
import com.sas.rmi.RocfORBRefCnt;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBSessionDescriptor;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.RocfORBTreeInterface;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import java.rmi.RemoteException;
import java.util.TimerTask;

public class RocfORBClient
extends RocfORBTree
implements RocfORBClientInterface {
    private transient J2Factory localObjectFactory;
    private transient IWorkspace localWorkspace;
    private transient IOMFactory iomFactory;
    private transient Object callback;
    private transient String host = "NewClient";
    private transient boolean autoRestart;
    private transient boolean available;
    private transient boolean retain;
    private transient long pingDelay = 10000L;
    private transient long remoteMethodStartTime = 0L;
    private transient long lastServerAccessTime = 0L;
    private transient long lastPingTime = 0L;
    private transient String lastRemoteMethodName = null;
    private transient long id;
    private transient boolean setupComplete;
    private transient Connection m_ctxt;
    private transient RocfORBSession session;
    private transient boolean removed;

    RocfORBSession getSession() {
        return (RocfORBSession)this._Rocf_getParent();
    }

    RMIBaseServer getObject(int index) {
        return (RMIBaseServer)this._Rocf_getKid(index);
    }

    int getObjectCount() {
        return this._Rocf_numKids();
    }

    @Override
    public Object _RemoteObject_getChild(Object desc) throws RemoteException, ServerBusyTimeoutException {
        Object ret = super._RemoteObject_getChild(desc);
        RMIBaseServer bobj = (RMIBaseServer)ret;
        RocfORBObjectDescriptor odesc = (RocfORBObjectDescriptor)desc;
        Object _o = null;
        String methodName = "StartClient";
        try {
            _o = this._RemoteObject_enter(methodName);
            bobj.setup(odesc);
        }
        catch (RemoteException e) {
            System.out.println("Caught");
            e.printStackTrace();
            throw e;
        }
        finally {
            this._RemoteObject_exit(methodName, _o);
        }
        return bobj;
    }

    @Override
    public Object _RemoteObject_getChildImpl(Object parms) throws RemoteException {
        RMIBaseServer bobj = null;
        RocfORBRefCnt refcnt = this.session.getORB().getrefcnt();
        refcnt.validate(this, this.callback);
        ProxyName pn = new ProxyName();
        RocfORBObjectDescriptor odesc = (RocfORBObjectDescriptor)parms;
        pn.setAccessMethod(Connection.ACCESS_METHOD_RMI);
        pn.setClassName(odesc.serverObjectName);
        String fullName = pn.getFullServerProxyName();
        try {
            Class c = RocfClass.forName(fullName);
            Object o = c.newInstance();
            bobj = (RMIBaseServer)o;
        }
        catch (ClassNotFoundException cfne) {
            throw new RemoteException(cfne.toString());
        }
        catch (IllegalAccessException iae) {
            throw new RemoteException(iae.toString());
        }
        catch (InstantiationException ie) {
            throw new RemoteException(ie.toString());
        }
        this._Rocf_addChild(bobj);
        return bobj;
    }

    void setHost(String s) {
        this.host = s;
    }

    void setup(RocfORBSessionDescriptor sdesc) throws RemoteException {
        this.session = this.getSession();
        RocfORBMachine machine = this.session.getMachine();
        RocfORB orb = machine.getORB();
        Rocf rocf = this.session.getRocf();
        this.host = sdesc.host;
        this.m_ctxt = sdesc.ctxt;
        this.setupComplete = false;
        this.callback = sdesc.callback;
        if (this.m_ctxt.isJ2()) {
            if (this.localObjectFactory == null) {
                try {
                    this.localObjectFactory = new J2Factory(rocf, this.m_ctxt, true);
                    this.m_ctxt.setJ2Factory(this.localObjectFactory);
                    this.localObjectFactory.logon();
                }
                catch (Exception e) {
                    this.localObjectFactory = null;
                    this.clientStartException(e);
                }
            } else {
                String applUser = this.m_ctxt.getApplicationUsername();
                String string = this.m_ctxt.getApplicationPassword();
            }
        } else if (this.m_ctxt.isIOM() || this.m_ctxt.isGMS() || this.m_ctxt.isOLAP()) {
            if (this.iomFactory == null) {
                try {
                    String key = IOMBaseClient.WORKSPACEKEY;
                    IWorkspace globalWorkspace = (IWorkspace)this.session.getConnection().getObject(key);
                    this.localWorkspace = globalWorkspace.GetNewWorkspace();
                    this.m_ctxt.setObject(key, this.localWorkspace);
                    IOMBaseClient.iominit(this.m_ctxt);
                    this.iomFactory = new IOMFactory(rocf, this.m_ctxt, true);
                    this.m_ctxt.setObject("::iomfactory", this.iomFactory);
                    this.iomFactory.logon();
                }
                catch (Exception e) {
                    this.iomFactory = null;
                    this.clientStartException(e);
                }
            } else {
                String applUser = this.m_ctxt.getApplicationUsername();
                String string = this.m_ctxt.getApplicationPassword();
            }
        }
        this.setupComplete = true;
    }

    void clientStartException(Exception e) throws RemoteException {
        String CLIENTSTARTEXCEPTION = "Handling following CLIENT start exception:";
        System.out.println(CLIENTSTARTEXCEPTION);
        e.printStackTrace();
        throw new RemoteException(e.toString());
    }

    J2Factory getFactory() {
        return this.localObjectFactory;
    }

    @Override
    public void _Rocf_lastChildRemoved() throws RemoteException {
    }

    @Override
    public void _RemoteObject_remove() throws RemoteException {
        this.getSession().getTimer().schedule((TimerTask)new ClientKiller(), 0L);
        super._RemoteObject_remove();
    }

    void spawnKill() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RocfORBClient.this.internalKill();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalKill() {
        Object _o = null;
        String methodName = "StopClient";
        try {
            _o = this._RemoteObject_enter(methodName);
            this.x_RemoteObject_removeImpl();
        }
        catch (RemoteException e) {
            System.out.println("Caught");
            e.printStackTrace();
        }
        finally {
            this._RemoteObject_exit(methodName, _o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x_RemoteObject_removeImpl() throws RemoteException {
        if (this.removed) {
            return;
        }
        this.removed = true;
        long l1 = System.currentTimeMillis();
        RocfORBSessionDescriptor sdesc = new RocfORBSessionDescriptor();
        RemoteException rex = null;
        if (this.setupComplete) {
            Object _o = null;
            String methodName = "Stop";
            try {
                if (!this.session.qisdead() && !this.session._r_getSTQ().isFailAll()) {
                    if (this.m_ctxt.isJ2() && this.localObjectFactory != null) {
                        this.localObjectFactory.logoff();
                    } else if ((this.m_ctxt.isIOM() || this.m_ctxt.isGMS() || this.m_ctxt.isOLAP()) && this.iomFactory != null) {
                        this.iomFactory.logoff();
                        if (this.localWorkspace != null) {
                            this.localWorkspace.Close();
                            this.m_ctxt.setObject(IOMBaseClient.WORKSPACEKEY, null);
                        }
                    }
                }
            }
            catch (RemoteException e) {
                System.out.println("Warning: problem taking down client:");
                rex = e;
                rex.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Warning: problem taking down client:");
                rex = new RemoteException("" + e);
                e.printStackTrace();
            }
        }
        long l2 = System.currentTimeMillis();
        if (this.setupComplete) {
            this.localObjectFactory = null;
            sdesc.ctxt = this.m_ctxt;
            sdesc.callback = new Object();
            sdesc.host = RocfORBPreloadThread.AVAIL;
            if (this.autoRestart) {
                sdesc.ctxt = this.session.getMachine().getResPool().getConnection();
                sdesc.callback = new Object();
                sdesc.host = RocfORBPreloadThread.AVAIL;
                Restart r = new Restart(this.session.getORB(), sdesc, this.retain);
                this.session.getORB().getTimer().schedule((TimerTask)r, 9000L);
            }
        }
        long l3 = System.currentTimeMillis();
        long l4 = System.currentTimeMillis();
    }

    public String getHost() {
        return this.host;
    }

    public Object getCallback() {
        return this.callback;
    }

    String fid() {
        String ret = "F=0";
        if (this.localObjectFactory != null) {
            ret = "F=" + this.localObjectFactory.factoryId();
        }
        return ret;
    }

    @Override
    public Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        return this.getSession()._RemoteObject_enter(this.munge(methodName));
    }

    @Override
    public Object _RemoteObject_enter(String methodName, long timeout) throws ServerBusyTimeoutException {
        return this.getSession()._RemoteObject_enter(this.munge(methodName), timeout);
    }

    @Override
    public void _RemoteObject_exit(String methodName, Object o) {
        this.getSession()._RemoteObject_exit(this.munge(methodName), o);
    }

    private String munge(String methodName) {
        String mName = "Client#" + this._Rocf_childIndex() + "." + methodName;
        return mName;
    }

    @Override
    public SingleThreadedQueue _r_getSTQ() {
        return this.getSession()._r_getSTQ();
    }

    public void setRemoteMethodStartStats(String methodName, long methodStartTime) {
        this.lastRemoteMethodName = methodName;
        this.remoteMethodStartTime = methodStartTime;
        this.lastServerAccessTime = methodStartTime;
    }

    public void setRemoteMethodStopStats() {
        this.lastRemoteMethodName = null;
        this.remoteMethodStartTime = 0L;
        this.lastServerAccessTime = System.currentTimeMillis();
    }

    public boolean needsAPing(long pingInterval) {
        long currentTime = System.currentTimeMillis();
        boolean firePing = true;
        if (currentTime - this.lastPingTime <= pingInterval) {
            firePing = false;
        } else if (this.inRemoteMethod()) {
            if (currentTime - this.remoteMethodStartTime <= pingInterval + this.pingDelay) {
                firePing = false;
            }
        } else if (currentTime - this.lastServerAccessTime <= pingInterval) {
            firePing = false;
        }
        return firePing;
    }

    public void setLastPingTime() {
        this.lastPingTime = System.currentTimeMillis();
    }

    protected boolean inRemoteMethod() {
        return this.lastRemoteMethodName != null;
    }

    @Override
    public String toString() {
        String ar = this.isAutoRestart() ? "auto-restart" : "single-use";
        String arr = this.isRetain() ? "retain" : "release";
        String host = this.getHost();
        if (host.equals(RocfORBPreloadThread.AVAIL)) {
            host = "<i>" + host + "</i>";
        }
        String s = "Client#" + this._Rocf_childIndex() + " Hash=" + this.hashCode() + " " + this._Rocf_getCreationTime() + " Host=" + host + " " + ar + " " + arr;
        return s;
    }

    void setAvailable(boolean b) {
        if (b) {
            System.out.println("snh");
            Thread.dumpStack();
        } else {
            this.host = "PendingRemoteConsumption";
        }
    }

    boolean isAvailable() {
        return this.host.equals(RocfORBPreloadThread.AVAIL);
    }

    @Override
    boolean _Rocf_isBusy() {
        return this.session._Rocf_isBusy();
    }

    void setAutoRestart(boolean b) {
        this.autoRestart = b;
    }

    boolean isAutoRestart() {
        return this.autoRestart;
    }

    void setRetain(boolean b) {
        this.retain = b;
    }

    boolean isRetain() {
        return this.retain;
    }

    @Override
    public void setId(long orbId) throws RemoteException {
        this.id = orbId;
    }

    @Override
    public long getId() throws RemoteException {
        return this.id;
    }

    Connection getConnection() {
        return this.m_ctxt;
    }

    @Override
    void _r_waitUntilIdle() {
        this.session._r_waitUntilIdle();
    }

    boolean sameUser(Connection c) {
        String incomingUser;
        boolean isSameUser = false;
        String currentUser = this.getConnection().getApplicationUsername();
        if (currentUser == null) {
            currentUser = "";
        }
        if ((incomingUser = c.getApplicationUsername()) == null) {
            incomingUser = "";
        }
        isSameUser = incomingUser.length() == 0 ? true : incomingUser.equals(currentUser);
        return isSameUser;
    }

    class Restart
    extends TimerTask {
        RocfORBSessionDescriptor sdesc;
        boolean retain;
        RocfORB orb;

        Restart(RocfORB orb, RocfORBSessionDescriptor sdesc, boolean retain) {
            this.orb = orb;
            this.sdesc = sdesc;
            this.retain = retain;
        }

        @Override
        public void run() {
            RocfORBClient xclnt = null;
            int maxretries = 3;
            for (int i = 1; xclnt == null && i <= maxretries; ++i) {
                try {
                    RocfORBTreeInterface respool = (RocfORBTreeInterface)this.orb._RemoteObject_getChild((Object)this.sdesc);
                    RocfORBTreeInterface machine = (RocfORBTreeInterface)respool._RemoteObject_getChild(this.sdesc);
                    RocfORBTreeInterface tsession = (RocfORBTreeInterface)machine._RemoteObject_getChild(this.sdesc);
                    RocfORBTreeInterface tclient = (RocfORBTreeInterface)tsession._RemoteObject_getChild(this.sdesc);
                    RocfORBClient clnt = (RocfORBClient)tclient;
                    clnt.setAutoRestart(true);
                    clnt.setRetain(this.retain);
                    xclnt = clnt;
                    continue;
                }
                catch (RemoteException e) {
                    System.out.println("ERROR recreating client workspace");
                    e.printStackTrace();
                    if (i >= maxretries) continue;
                    System.out.println("Attempting again (" + i + "/" + maxretries + ")");
                }
            }
        }
    }

    class ClientKiller
    extends TimerTask {
        ClientKiller() {
        }

        @Override
        public void run() {
            RocfORBClient.this.internalKill();
        }
    }
}

