/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteEvent;
import com.sas.rmi.RemoteListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.EventObject;
import java.util.Vector;

public class RemoteListenerFilter
implements RemoteListener {
    public Vector m_RemoteListeners;
    public Vector m_PropertyChangeListeners;
    public Vector m_ContentsChangedListeners;
    Vector propListeners = new Vector();
    Vector vetoListeners = new Vector();
    Vector contListeners = new Vector();
    Object sender;
    boolean m_debug;
    RemoteBaseClient rbc;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setSender(Object o) {
        this.sender = o;
        this.rbc = this.sender instanceof RemoteBaseClient ? (RemoteBaseClient)this.sender : null;
    }

    private HListInterface getList(HListInterface hl, int index) {
        int listLen = 0;
        HListItem hli = null;
        ListItem li = null;
        HListInterface retVal = null;
        if (hl != null && (listLen = hl.count()) > index && (hli = hl.getItem(index)) != null && hli instanceof ListItem && (li = (ListItem)hli) != null) {
            retVal = li.getValue();
        }
        return retVal;
    }

    private String getString(HListInterface hl, int index) {
        int listLen = 0;
        HListItem hli = null;
        StringItem si = null;
        String retVal = null;
        if (hl != null && (listLen = hl.count()) > index && (hli = hl.getItem(index)) != null && hli instanceof StringItem && (si = (StringItem)hli) != null) {
            retVal = si.getValue();
        }
        return retVal;
    }

    @Override
    public void remotePerformed(RemoteEvent re) {
        String eventName = null;
        HListInterface hl1 = null;
        Object hl2 = null;
        Object hl3 = null;
        if (re == null || (hl1 = re.getHList()) == null || (eventName = this.getString(hl1, 1)) == null) {
            System.out.println("1=" + hl1);
            System.out.println("2=" + hl2);
            System.out.println("3=" + hl3);
            return;
        }
        if (eventName.equalsIgnoreCase("contents changed")) {
            ContentsChangedEvent cce = new ContentsChangedEvent(this.sender);
            this.vecBroadcast(this.contListeners, (EventObject)cce);
        } else if (eventName.equalsIgnoreCase("property change")) {
            String propertyName = this.getString(hl1, 1);
            String oldValue = this.getString(hl1, 2);
            String newValue = this.getString(hl1, 3);
            PropertyChangeEvent pce = new PropertyChangeEvent(this.sender, propertyName, oldValue, newValue);
            if (this.rbc != null) {
                this.rbc.firePropertyChange(pce);
            } else {
                this.vecBroadcast(this.propListeners, pce);
            }
        } else if (eventName.equalsIgnoreCase("vetoable change")) {
            String propertyName = this.getString(hl1, 1);
            String oldValue = this.getString(hl1, 2);
            String newValue = this.getString(hl1, 3);
            PropertyChangeEvent pce = new PropertyChangeEvent(this.sender, propertyName, oldValue, newValue);
            if (this.rbc != null) {
                try {
                    this.rbc.fireVetoableChange(propertyName, oldValue, newValue);
                }
                catch (PropertyVetoException pve) {
                    throw new RuntimeException(pve.toString());
                }
            } else {
                this.vecBroadcast(this.vetoListeners, pce);
            }
        }
    }

    public void addContentsChangedListener(ContentsChangedListener pcl) {
        this._p("addContentsChangedListener:" + pcl);
        this.vecAdd(this.contListeners, pcl);
    }

    public void removeContentsChangedListener(ContentsChangedListener pcl) {
        this._p("removeContentsChangedListener:" + pcl);
        this.vecRemove(this.contListeners, pcl);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._p("addPropertyChangeListener:" + pcl);
        this.vecAdd(this.propListeners, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._p("removePropertyChangeListener:" + pcl);
        this.vecRemove(this.propListeners, pcl);
    }

    public void addVetoableChangeListener(VetoableChangeListener pcl) {
        this.vecAdd(this.vetoListeners, pcl);
    }

    public void removeVetoableChangeListener(VetoableChangeListener pcl) {
        this.vecRemove(this.vetoListeners, pcl);
    }

    protected void vecAdd(Vector v, Object o) {
        int i = v.indexOf(o);
        if (i < 0) {
            v.addElement(o);
        }
    }

    protected void vecRemove(Vector v, Object o) {
        int i = v.indexOf(o);
        if (i >= 0) {
            v.removeElementAt(i);
        }
    }

    private void _p(String s) {
        if (this.m_debug) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    protected void vecBroadcast(Vector v, EventObject eo) {
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            Object o = v.elementAt(i);
            if (o instanceof ContentsChangedListener && eo instanceof ContentsChangedEvent) {
                ContentsChangedListener ccl = (ContentsChangedListener)o;
                ContentsChangedEvent cce = (ContentsChangedEvent)eo;
                this._p("vecBroadcast:ContentsChanged:enter:" + ccl);
                ccl.contentsChanged(cce);
                this._p("vecBroadcast:ContentsChanged:exit:" + ccl);
                continue;
            }
            if (o instanceof PropertyChangeListener && eo instanceof PropertyChangeEvent) {
                PropertyChangeListener pcl = (PropertyChangeListener)o;
                PropertyChangeEvent pce = (PropertyChangeEvent)eo;
                this._p("vecBroadcast:PropertyChange:enter:" + pcl);
                pcl.propertyChange(pce);
                this._p("vecBroadcast:PropertyChange:exit:" + pcl);
                continue;
            }
            System.out.println("RemoteListenerFilter::vecBroadcastunhandled l=" + o + " e=" + eo);
        }
    }
}

