/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.rmi.RemoteEvent;
import com.sas.rmi.RemoteSourceSocket;
import com.sas.rmi.RemoteUtility;
import com.sas.security.BaseSecuritySupport;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class RemoteEventListener
implements Runnable {
    Thread m_thread;
    ServerSocket m_serverSocket;
    Socket m_socket;
    DataInputStream m_in;
    InputStream m_is;
    RemoteSourceSocket m_disp;
    HListInterface m_hl;
    Object m_sender;
    RemoteEvent m_re;
    RemoteUtility m_ru;
    boolean m_debug;
    String m_methodName;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    private void _p(String s) {
        if (this.m_debug) {
            System.out.println(this.getClass().getName() + "::" + this.m_methodName + ":" + s);
        }
    }

    private void _setMethodName(String s) {
        this.m_methodName = s;
        this._p("Entered");
    }

    public int setup(RemoteSourceSocket dispatcher, Object o) throws IOException {
        this._setMethodName("setup");
        this.m_sender = o;
        this.m_disp = dispatcher;
        this._p("Setting up socket");
        this.m_serverSocket = new ServerSocket(0);
        int portNum = this.m_serverSocket.getLocalPort();
        this._p("Event will be sent from " + this.m_sender + " on portnum=" + portNum);
        return portNum;
    }

    public void start() {
        this._setMethodName("start");
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        this._setMethodName("stop");
        try {
            if (this.m_thread != null) {
                this.m_thread.stop();
                this.m_thread = null;
            }
            if (this.m_socket != null) {
                this.m_socket.close();
                this.m_socket = null;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this._setMethodName("run");
        try {
            this.m_socket = this.m_serverSocket.accept();
            this.m_is = this.m_socket.getInputStream();
            this.m_in = new DataInputStream(this.m_is);
            this.m_ru = new RemoteUtility(this.m_in, null);
            this._p("Connection established: data flow enabled");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        while (true) {
            try {
                while (true) {
                    this._p("Creating a new HList");
                    this.m_hl = new HList();
                    this._p("waiting for the blocked socket to return");
                    int packetLen = this.m_ru.readLen();
                    this._p("packetLen=" + packetLen);
                    byte status = this.m_ru.readByte();
                    this._p("status=" + status);
                    int sequence = this.m_ru.readSequence();
                    this._p("sequence=" + sequence);
                    short type = this.m_ru.readType();
                    this._p("type=" + type);
                    if (!this.m_ru.isList(type)) {
                        String errMsg = this.getClass().getName() + "bad event type broadcast from remote sender";
                        throw new RuntimeException(errMsg);
                    }
                    this.m_hl = this.m_ru.readList(type);
                    this._p("run:list=" + this.m_hl);
                    this.m_re = new RemoteEvent(this.m_sender, this.m_hl);
                    this.m_disp.broadcast(this.m_re, sequence);
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
                this.stop();
                continue;
            }
            break;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }
}

