/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteEvent;
import com.sas.rmi.RemoteEventListener;
import com.sas.rmi.RemoteEventSender;
import com.sas.rmi.RemoteListener;
import com.sas.rmi.RemoteListenerFilter;
import com.sas.rmi.RemoteSource;
import com.sas.rmi.RemoteSourceSocket;
import com.sas.rmi.RemoteUtility;
import java.io.IOException;
import java.util.Vector;

public class RemoteEventDispatcher
implements RemoteSourceSocket,
RemoteListener {
    Vector m_l = new Vector();
    RemoteEventSender m_sen = null;
    RemoteEventListener m_lis = null;
    Object m_sender;
    RemoteUtility m_ru = null;
    boolean m_debug = false;
    String m_methodName = "";

    @Override
    public void addRemoteListener(RemoteListener rl) {
        this._setMethodName("addRemoteListener");
        int i = this.m_l.indexOf(rl);
        this._p("i=" + i + " rl=" + rl);
        if (i < 0) {
            this.m_l.addElement(rl);
        }
        if (rl instanceof RemoteListenerFilter) {
            RemoteListenerFilter rlf = (RemoteListenerFilter)rl;
            rlf.setDebug(this.m_debug);
        }
    }

    @Override
    public void removeRemoteListener(RemoteListener rl) {
        this._setMethodName("removeRemoteListener");
        int i = this.m_l.indexOf(rl);
        if (i < 0) {
            this.m_l.removeElementAt(i);
        }
    }

    public void setDebug(boolean debug) {
        this._setMethodName("setDebug");
        this.m_debug = debug;
        if (this.m_lis != null) {
            this.m_lis.setDebug(debug);
        }
    }

    @Override
    public void broadcast(RemoteEvent re) throws IOException {
        this._setMethodName("broadcast(RemoteEvent)");
        this._p("eventHList=" + re.getHList());
        int n = this.m_l.size();
        for (int i = 0; i < n; ++i) {
            RemoteListener rl = (RemoteListener)this.m_l.elementAt(i);
            this._p("verifying listener=" + rl);
            if (!this.legalListener(re, rl)) continue;
            boolean rmiListener = rl instanceof RemoteListenerFilter;
            if (!rmiListener) {
                this._p("listener=" + rl + ":entering");
            }
            rl.remotePerformed(re);
            if (rmiListener) continue;
            this._p("listener=" + rl + ":leaving");
        }
    }

    private boolean legalListener(RemoteEvent re, RemoteListener rl) {
        this._setMethodName("legalListener");
        HListInterface hl = null;
        HListItem hli = null;
        DoubleItem di = null;
        double d = -1.0;
        RemoteBaseClient rbc = (RemoteBaseClient)this.m_sender;
        boolean retVal = false;
        int sclHandle = 0;
        hl = re.getHList();
        if (hl != null && hl.count() > 0 && (hli = hl.getItem(0)) != null && hli instanceof DoubleItem && (di = (DoubleItem)hli) != null) {
            double d2;
            d = di.getValue();
            if (d2 > 0.0 && rbc != null && (sclHandle = rbc._RemoteObject_getSCLHandle()) > 0 && d == (double)sclHandle) {
                retVal = true;
            }
        }
        if (!retVal) {
            // empty if block
        }
        this._p("retVal=" + retVal);
        return retVal;
    }

    public void setRemoteUtility(RemoteUtility ru) {
        this._setMethodName("addRemoteListener");
        this.m_ru = ru;
    }

    @Override
    public void broadcast(RemoteEvent re, int sequence) throws IOException {
        this._setMethodName("broadcast(RemoteEvent,int)");
        this._p("event=" + re + " sequence=" + sequence);
        this._p("ru=" + this.m_ru);
        if (this.m_ru != null) {
            this.m_ru.sequenceComplete(sequence);
        }
        this.broadcast(re);
    }

    public void setSender(Object o) {
        this._setMethodName("setSender");
        this.m_sender = o;
        this._p("Event will be sent from " + this.m_sender);
    }

    public void setRemoteSource(RemoteSource re) {
        this._setMethodName("setRemoteSource");
    }

    public void setupSender(String host, int port) throws IOException {
        this._setMethodName("setupSender");
        this._p("host=" + host + " port=" + port);
        this.m_sen = new RemoteEventSender();
        this.m_sen.setDebug(this.m_debug);
        this.m_sen.setup(host, port);
    }

    public int setupListener() throws IOException {
        this._setMethodName("setupListener");
        this.m_lis = new RemoteEventListener();
        this.m_lis.setDebug(this.m_debug);
        return this.m_lis.setup(this, this.m_sender);
    }

    @Override
    public void sendEvent(HListInterface hl) throws IOException {
        this._setMethodName("sendEvent");
        this._p("event=" + hl);
        this.m_sen.sendEvent(hl);
    }

    @Override
    public void getEvents() throws IOException {
        this._setMethodName("getEvents");
        this.m_lis.start();
    }

    @Override
    public void remotePerformed(RemoteEvent re) throws IOException {
        this._setMethodName("remotePerformed");
        this._p("event=" + re);
        this.sendEvent(re.getHList());
    }

    public void cleanup() throws IOException {
        this._setMethodName("cleanup");
        if (this.m_lis != null) {
            this.m_lis.stop();
            this.m_lis = null;
        }
    }

    private void _p(String s) {
        if (this.m_debug) {
            System.out.println(this.getClass().getName() + "::" + this.m_methodName + ":" + s);
        }
    }

    private void _setMethodName(String s) {
        this.m_methodName = s;
        this._p("Entered");
    }

    protected void finalize() throws Throwable {
        this._setMethodName("finalize");
        super.finalize();
    }
}

