/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.J2GeneratorTarget;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RSCLGeneratorTarget;
import com.sas.rmi.RemoteDesignTimeTemplate;
import com.sas.rmi.Template;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class RemoteDesignTimeTarget
extends CodeGeneratorBaseTarget {
    protected Hashtable getTable = new Hashtable();

    @Override
    public String getGeneratorName() {
        return "Design_Time";
    }

    public RemoteDesignTimeTarget() {
        this.getTable.put("boolean", "_getBooleanValue");
        this.getTable.put("byte", "_getByteValue");
        this.getTable.put("char", "_getCharValue");
        this.getTable.put("short", "_getShortValue");
        this.getTable.put("int", "_getIntValue");
        this.getTable.put("long", "_getLongValue");
        this.getTable.put("float", "_getFloatValue");
        this.getTable.put("double", "_getDoubleValue");
    }

    @Override
    public Template getTemplate() {
        return new RemoteDesignTimeTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_REMOTEDESIGNTIME);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateAttributes(Class source, CodeGeneratorOutputStream out) throws Exception {
        String name = source.getName();
        String pkg = "";
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            pkg = name.substring(0, pos + 1);
            name = name.substring(pos + 1);
        }
        if (name.endsWith("Interface")) {
            name = name.substring(0, name.length() - 9);
        }
        CodeGeneratorBaseTarget target = new J2GeneratorTarget();
        out.println("String m_proxy1 = \"" + pkg + target.getTargetName(name) + "\";", 1);
        target = new RSCLGeneratorTarget();
        out.println("String m_proxy2 = \"" + pkg + target.getTargetName(name) + "\";", 1);
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int j;
        Class<?>[] params = method.getParameterTypes();
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 1);
        String s = "public " + ret + " " + method.getName() + "(";
        out.println(s, 1);
        String p = "";
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            s = "";
            if (j == 0) {
                s = "throws ";
            }
            s = s + exceptions[j].getName();
            if (j + 1 < exceptions.length) {
                s = s + ",";
            }
            out.println(s, 3);
        }
        out.println("{", 2);
        if (method.getName().startsWith("set") && ret.equals("void") && method.getName().length() > 3 && params.length == 1) {
            out.println("_setValue(\"" + method.getName().substring(3) + "." + CodeGenerator.convertType(params[0].getName()) + "\", p1);", 3);
        } else if (method.getName().startsWith("get") && !ret.equals("void") && method.getName().length() > 3 && params.length == 0) {
            String methodName = (String)this.getTable.get(ret);
            String key = "\"" + method.getName().substring(3) + "." + ret + "\"";
            if (methodName == null) {
                out.println("return (" + ret + ") _getValue(" + key + ");", 3);
            } else {
                out.println("return " + methodName + "(" + key + ");", 3);
            }
        } else if (method.getName().startsWith("is") && ret.equals("boolean") && method.getName().length() > 2 && params.length == 0) {
            String methodName = (String)this.getTable.get(ret);
            String key = "\"" + method.getName().substring(2) + "." + ret + "\"";
            out.println("return " + methodName + "(" + key + ");", 3);
        } else if (!ret.equals("void")) {
            if (ret.equals("double") || ret.equals("byte") || ret.equals("char") || ret.equals("short") || ret.equals("int") || ret.equals("long") || ret.equals("float")) {
                out.println("return 0;", 3);
            } else if (ret.equals("boolean")) {
                out.println("return false;", 3);
            } else {
                out.println("return null;", 3);
            }
        }
        out.println("}", 2);
    }

    @Override
    public boolean definedInTemplate(Method method) {
        Class<?>[] params = method.getParameterTypes();
        boolean rc = false;
        if (method.getName().equals("clone") && params.length == 0) {
            rc = true;
        }
        return rc;
    }

    @Override
    public boolean supportsLocalImplementation() {
        return false;
    }
}

