/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.Component;
import com.sas.RunningObjectTable;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionLoginInterface;
import com.sas.rmi.DesignTimeInf;
import com.sas.rmi.LocalModelInterface;
import com.sas.rmi.RB;
import com.sas.rmi.RemoteListenerFilter;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfRemoteObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class RemoteBaseClient
extends Component
implements RocfRemoteObject,
DesignTimeInf,
ConnectionLoginInterface {
    static final long serialVersionUID = 7030212280255059575L;
    public static int SETUP_COMPLETE = 0;
    public static int SETUP_RUNNING = 1;
    public static int SETUP_ERRORED = 2;
    private transient String m_name;
    private transient boolean m_paramsAreUpdate;
    protected transient Object m_baseObject;
    private transient Object m_utility;
    private transient Connection m_ctxt;
    private transient Rocf m_rocf;
    private transient String m_catalog;
    private transient String m_cname;
    private transient boolean m_reuse;
    private transient RemoteListenerFilter m_rlf;
    private transient boolean m_debug;
    private transient int m_sclHandle;
    private transient LocalModelInterface m_local;
    private transient boolean m_localSet;
    private transient int m_setupID;
    private transient int m_setupState;
    private transient String m_setupStatus;
    private transient boolean m_setupStatusRead;
    private transient Exception m_setupException;
    private transient boolean m_lock;
    private transient boolean m_initComplete;
    private transient String m_localName;
    private transient boolean m_reuseSingleDelegate;
    private transient String m_interfaceName;
    private transient Vector m_callRemote;
    private transient int m_deadlockWaitTime;
    public static final String RB_KEY = "RemoteBaseClient.";

    public RemoteBaseClient() {
        this._init();
    }

    private void _init() {
        if (!this.m_initComplete) {
            this.m_setupID = 0;
            this.m_catalog = "";
            this.m_cname = "";
            this.m_setupState = SETUP_COMPLETE;
            this.m_initComplete = true;
            this.m_localName = "";
            this.m_initComplete = true;
        }
    }

    public long _RemoteObject_entering(String methodName) {
        boolean success;
        this._init();
        long retVal = 0L;
        this.m_ctxt.setInRemoteMethodCall(true);
        if (this.m_debug) {
            retVal = this._time();
            this._p(methodName + ":Enter:" + retVal);
            this.m_ctxt.traceEnter(this, methodName);
        }
        if (this.m_setupID != 0 && !(success = this._RemoteObject_waitForSetupCompletion())) {
            String msg = "Remote object setup failed";
            if (this.m_setupException != null) {
                msg = this.m_setupException.toString();
            }
            this._RemoteObject_broadcast(new IOException(msg));
        }
        return retVal;
    }

    private long _time() {
        this._init();
        return System.currentTimeMillis();
    }

    public void _RemoteObject_exiting(String methodName, long t1) {
        this._init();
        this.m_ctxt.setInRemoteMethodCall(false);
        if (this.m_debug) {
            long t2 = this._time();
            long diff = t2 - t1;
            this._p(methodName + ":Exit:" + t2 + ":Elapsed:" + diff);
            this.m_ctxt.traceExit(this, methodName, diff);
        }
    }

    private void _RemoteObject_timeEcho(String mn, String dir) {
        this._init();
        this._p(mn + ":" + dir + ":" + System.currentTimeMillis());
    }

    @Override
    public abstract int _RemoteObject_version();

    public void _p(String s) {
        this._init();
        if (this.m_debug) {
            String longs = this.getClass().getName() + "::" + s;
            System.out.println(longs);
        }
    }

    public void _RemoteObject_debug(boolean doDebug) {
        this._init();
        this.m_debug = doDebug;
    }

    public boolean _RemoteObject_getDebug() {
        this._init();
        return this.m_debug;
    }

    public Object _RemoteObject_getObject() {
        this._init();
        return this.m_baseObject;
    }

    public void _RemoteObject_setObject(Object rbi) {
        this._init();
        this.m_baseObject = rbi;
    }

    public Rocf _RemoteObject_getClassFactory() {
        this._init();
        return this.m_rocf;
    }

    public void _RemoteObject_setClassFactory(Rocf rocf) {
        this._init();
        this.m_rocf = rocf;
    }

    public Connection _RemoteObject_getContext() {
        this._init();
        return this.m_ctxt;
    }

    public void _RemoteObject_setContext(Connection ctxt) {
        this._init();
        this.m_ctxt = ctxt;
    }

    public String _RemoteObject_getName() {
        this._init();
        return this.m_name;
    }

    @Override
    public void setContextClassPath(String x) {
        this._init();
        this._RemoteObject_setCatalog(x);
    }

    @Override
    public String getContextClassPath() {
        this._init();
        return this._RemoteObject_getCatalog();
    }

    public void setContextName(String x) {
        String me;
        Object o = RunningObjectTable.lookupComponent((String)x);
        if (o == null && x.indexOf(".") == -1 && (me = RunningObjectTable.lookupComponentName((Object)this)) != null) {
            String frameName = me.toString();
            int dotIx = frameName.indexOf(".");
            frameName = frameName.substring(0, dotIx);
            o = RunningObjectTable.lookupComponent((String)(frameName + "." + x));
        }
        if (o != null && !(o instanceof Connection)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "contextNameBadArg.ex.txt"));
        }
        this._init();
        this.m_cname = x;
    }

    public String getContextName() {
        this._init();
        return this.m_cname;
    }

    public void _RemoteObject_setName(String name) {
        this._init();
        this.m_name = name;
    }

    public String _RemoteObject_getCatalog() {
        this._init();
        return this.m_catalog;
    }

    public void _RemoteObject_setReuse(boolean reuse) {
        this._init();
        this.m_reuse = reuse;
    }

    public boolean _RemoteObject_getReuse() {
        this._init();
        return this.m_reuse;
    }

    public void _RemoteObject_setSCLHandle(int sclHandle) {
        this._init();
        this.m_sclHandle = sclHandle;
    }

    public int _RemoteObject_getSCLHandle() {
        this._init();
        return this.m_sclHandle;
    }

    public void _RemoteObject_setCatalog(String catalog) {
        this._init();
        if (this.m_catalog == null || catalog != null && catalog.length() > 0) {
            this.m_catalog = catalog;
        }
    }

    public boolean _RemoteObject_isDesignTime() {
        this._init();
        return false;
    }

    @Override
    public void _RemoteObject_setup(Connection ctxt) throws Exception {
        ctxt.login(this);
    }

    @Override
    public void connectToHost(Connection ctxt) throws Exception {
        this._init();
        this.m_ctxt = ctxt;
        String ctxtParameterMode = ctxt.getParameterMode();
        String updateString = Connection.PARAMETERMODE_UPDATE;
        this.m_paramsAreUpdate = ctxtParameterMode.equals(updateString);
        this.m_debug = ctxt.isTraceProxyClient();
        String methodName = "_RemoteObject_setupClient";
        boolean isacr = ctxt.isAppletCodebaseRelative();
        this.m_deadlockWaitTime = ctxt.getDeadlockWaitTime();
        long l = 0L;
        ctxt.setStopped(false);
        this._RemoteObject_setupClient(ctxt);
        if (this.getReuseSingleDelegate()) {
            this._RemoteObject_getInstance();
        } else {
            this._RemoteObject_newInstance();
        }
    }

    public void _RemoteObject_setupDualImplementation() {
        this._init();
        this._getLocal();
    }

    public abstract void _RemoteObject_setupClient(Connection var1) throws Exception;

    public abstract void _RemoteObject_getInstance() throws Exception;

    public abstract void _RemoteObject_newInstance() throws Exception;

    public boolean _RemoteObject_updateParms() {
        this._init();
        return this.m_paramsAreUpdate;
    }

    public void _RemoteObject_setUtility(Object o) {
        this._init();
        this.m_utility = o;
    }

    public Object _RemoteObject_getUtility() {
        this._init();
        return this.m_utility;
    }

    @Override
    public void _RemoteObject_action(int actionCode) throws Exception {
        this._init();
        if (actionCode == 1) {
            try {
                this.finalize();
            }
            catch (Throwable t) {
                throw new Exception(t.toString());
            }
        }
    }

    public void stop() {
        this._init();
        this._p("stop");
        if (this.m_ctxt != null) {
            this.m_ctxt.removeElement(this);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void _RemoteObject_broadcast(IOException e) {
        this._init();
        if (!this._RemoteObject_isDesignTime()) {
            this.m_ctxt.broadcast(e);
        }
    }

    public void _RemoteObject_setLocalName(String name) {
        this._init();
        this.m_localName = name;
    }

    public String _RemoteObject_getLocalName() {
        this._init();
        return this.m_localName;
    }

    public void _RemoteObject_setReuseSingleDelegate(boolean b) {
        this._init();
        this.m_reuseSingleDelegate = b;
    }

    public boolean getReuseSingleDelegate() {
        this._init();
        return this.m_reuseSingleDelegate;
    }

    protected Object _getLocal() {
        this._init();
        if (this.m_local == null && this instanceof LocalModelInterface && this.m_localName != null && this.m_localName.length() > 0) {
            try {
                this.m_local = (LocalModelInterface)this.m_rocf.forName(this.m_localName).newInstance();
                if (!this.m_localSet) {
                    this.m_local._setRemoteHandle(this);
                    this.m_localSet = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.m_local;
    }

    public boolean _RemoteObject_useThreads() {
        this._init();
        return false;
    }

    public void _RemoteObject_setSetupID(int id) {
        this._init();
        this.m_setupID = id;
    }

    public int _RemoteObject_getSetupID() {
        this._init();
        return this.m_setupID;
    }

    public void _RemoteObject_setSetupStatus(String status) {
        this._init();
        this.m_setupStatus = status;
        this.m_setupStatusRead = false;
    }

    public String _RemoteObject_getSetupStatus() {
        this._init();
        this.m_setupStatusRead = true;
        return this.m_setupStatus;
    }

    public boolean _RemoteObject_isSetupStatusRead() {
        this._init();
        return this.m_setupStatusRead;
    }

    public void _RemoteObject_setSetupState(int state) {
        this._init();
        this.m_setupState = state;
    }

    public void _RemoteObject_setSetupException(Exception ex) {
        this._init();
        this.m_setupState = SETUP_ERRORED;
        this.m_setupException = ex;
    }

    public boolean _RemoteObject_isSetupComplete() {
        this._init();
        boolean complete = false;
        if (this.m_setupState == SETUP_COMPLETE) {
            complete = true;
        }
        return complete;
    }

    public boolean _RemoteObject_isSetupError() {
        this._init();
        boolean error = false;
        if (this.m_setupState == SETUP_ERRORED) {
            error = true;
        }
        return error;
    }

    public boolean _RemoteObject_waitForSetupCompletion() {
        this._init();
        if (this._RemoteObject_isSetupComplete()) {
            return true;
        }
        if (this._RemoteObject_isSetupError()) {
            return false;
        }
        while (this.m_setupState == SETUP_RUNNING) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                this._RemoteObject_setSetupException(e);
            }
        }
        return this._RemoteObject_isSetupComplete();
    }

    public void _RemoteObject_lock() {
        this._init();
        this.m_lock = true;
    }

    public void _RemoteObject_unlock() {
        this._init();
        this.m_lock = false;
    }

    public void _RemoteObject_detectDeadlock() {
        this._init();
        String methodName = "_RemoteObject_detectDeadlock";
        boolean printed = false;
        int maxloop = 1000 * this.m_deadlockWaitTime;
        int sleeptime = 10;
        for (int i = 0; this.m_lock && i < maxloop; i += sleeptime) {
            if (!printed) {
                this._p(methodName + ":waiting for lock release");
                printed = true;
            }
            try {
                Thread.sleep(sleeptime);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.toString());
            }
        }
        if (this.m_lock) {
            RuntimeException e1 = new RuntimeException("Possible Deadlock Detected");
            throw e1;
        }
    }

    public String _RemoteObject_getTrueCatalog() {
        this._init();
        String s = this._RemoteObject_getCatalog();
        int i = s.indexOf(".");
        if (i >= 0 && (i = s.indexOf(".", i + 1)) >= 0) {
            s = s.substring(0, i);
        }
        return s.trim();
    }

    public String _RemoteObject_getTrueName() {
        this._init();
        String c = this._RemoteObject_getCatalog();
        String tc = this._RemoteObject_getTrueCatalog();
        String s = c.substring(tc.length());
        if (s.equals(".")) {
            s = "";
        } else if (s.startsWith(".")) {
            s = s.substring(1);
        }
        if (s.length() > 0) {
            int i = s.indexOf(".");
            if (i >= 0) {
                s = s.substring(0, i);
            }
        } else {
            s = this._RemoteObject_getName();
        }
        return s.trim();
    }

    public void _RemoteObject_preMethodInvocation() {
        this._init();
    }

    public void _RemoteObject_postMethodInvocation() {
        this._init();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void _RemoteObject_preSet() {
    }

    public void _RemoteObject_setInterfaceName(String s) {
        this.m_interfaceName = s;
    }

    public String _RemoteObject_getInterfaceName() {
        return this.m_interfaceName;
    }

    public Object _getDelegate(Class c) {
        return null;
    }

    public Object _getDelegate() {
        return this._getDelegate(this._getDelegateClass());
    }

    public Class _getDelegateClass() {
        return null;
    }
}

