/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RSCLTemplate;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.io.IOException;
import java.lang.reflect.Method;

public class RSCLGeneratorTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();

    @Override
    public String getGeneratorName() {
        return "SAM";
    }

    public RSCLGeneratorTarget() {
        this.m_tm.addBroadcastException(IOException.class);
    }

    @Override
    public Template getTemplate() {
        return new RSCLTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_RSCL);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int i;
        boolean found;
        int j;
        Class<?>[] params = method.getParameterTypes();
        if (!this.m_tm.generateMethodCodeHeader(source, method, out)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        String[][] types = new String[][]{{"boolean", "param", "booleanMethod"}, {"byte", "param", "byteMethod"}, {"char", "param", "charMethod"}, {"short", "param", "shortMethod"}, {"int", "param", "intMethod"}, {"long", "param", "longMethod"}, {"float", "param", "floatMethod"}, {"double", "param", "doubleMethod"}, {"java.lang.String", "param", "stringMethod"}, {"boolean[]", "param", "booleanA1Method"}, {"byte[]", "param", "byteA1Method"}, {"char[]", "param", "charA1Method"}, {"short[]", "param", "shortA1Method"}, {"int[]", "param", "intA1Method"}, {"long[]", "param", "longA1Method"}, {"float[]", "param", "floatA1Method"}, {"double[]", "param", "doubleA1Method"}, {"java.lang.String[]", "param", "stringA1Method"}, {"com.sas.collection.hlist.HListInterface", "param", "hlistMethod"}};
        String[] retValues = new String[params.length];
        out.println("long _l2 = _RemoteObject_entering(\"" + method.getName() + "_TR_\");", 3);
        out.println("remote.methodHeader(\"" + method.getName() + "\");", 3);
        out.println("remote.numParams(" + params.length + ");", 3);
        for (j = 0; j < params.length; ++j) {
            String s = CodeGenerator.convertType(params[j].getName());
            found = false;
            for (i = 0; i < types.length; ++i) {
                found = s.equals(types[i][0]);
                if (!found) continue;
                out.println("remote." + types[i][1] + "(p" + (j + 1) + ", paramsAreUpdate);", 3);
                break;
            }
            if (!found) {
                out.println("remote.objectParam(p" + (j + 1) + ", paramsAreUpdate);", 3);
            }
            retValues[j] = found ? "remote.readUpdateParam(p" + (j + 1) + ", paramsAreUpdate);" : null;
        }
        if (ret.equals("void")) {
            out.println("remote.voidMethod();", 3);
        } else {
            found = false;
            for (i = 0; i < types.length; ++i) {
                found = ret.equals(types[i][0]);
                if (!found) continue;
                out.println("value = remote." + types[i][2] + "();", 3);
                break;
            }
            if (!found) {
                out.println("value = (" + ret + ") remote.objectMethod(" + ret + ".class);", 3);
            }
        }
        for (j = 0; j < retValues.length; ++j) {
            if (retValues[j] == null) continue;
            out.println(retValues[j], 3);
        }
        out.println("_RemoteObject_exiting(\"" + method.getName() + "_TR_\",_l2);", 3);
        out.println("remote.endMethod();", 3);
        this.m_tm.generateMethodCodeTrailer(source, method, out);
    }
}

