/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteUtility;
import java.io.IOException;
import java.net.Socket;

public abstract class RSCLBaseClient
extends RemoteBaseClient {
    private RemoteUtility m_remote;
    private boolean m_lockConnection;
    private Connection m_ctxt;
    private String m_clsName = this.getClass().getName();

    @Override
    public void _RemoteObject_setupClient(Connection ctxt) throws Exception {
        String methodName = "_RemoteObject_setupClient";
        this._p(methodName);
        this.m_ctxt = ctxt;
        this.m_lockConnection = this.m_ctxt.getLockConnection();
        Socket socket = (Socket)this.m_ctxt.getObject(Connection.SOCKET);
        String host = this.m_ctxt.getHost();
        int port = this.m_ctxt.getSAMPort();
        String cgiurl = this.m_ctxt.getCGIBinURL();
        this.m_remote = new RemoteUtility(host, port, this.m_lockConnection, socket, cgiurl);
        this.m_remote.setRocf(this._RemoteObject_getClassFactory());
        this.m_remote.setContext(this._RemoteObject_getContext());
        this.m_remote.setTraceProxyClient(this._RemoteObject_getDebug());
    }

    @Override
    public void _RemoteObject_newInstance() throws Exception {
        String methodName = "_RemoteObject_newInstance";
        this._p(methodName);
        String catalog = this._RemoteObject_getTrueCatalog();
        String name = "";
        if (catalog != null && catalog.length() > 0) {
            name = name + catalog + ".";
        }
        name = name + this._RemoteObject_getTrueName() + ".class";
        this._p(methodName + ":name=" + name);
        int sclHandle = this._RemoteObject_getSCLHandle();
        if (sclHandle < 1) {
            this.m_remote.init(name.toUpperCase());
            this._RemoteObject_setSCLHandle(this.m_remote.getSCLHandle());
        } else {
            this.m_remote.bind(sclHandle);
        }
        if (this.m_lockConnection) {
            this.m_ctxt.setObject(Connection.SOCKET, this.m_remote.getLockSocket());
        }
        this._RemoteObject_setUtility(this.m_remote);
    }

    @Override
    public void _RemoteObject_getInstance() throws Exception {
        String methodName = "_RemoteObject_getInstance";
        this._p(methodName);
        System.out.println(methodName + ":not supported, default to newInstance");
        this._RemoteObject_newInstance();
    }

    @Override
    public void stop() {
        this._p("stop");
        try {
            if (this.m_remote != null) {
                this.m_remote._finalize();
                this.m_remote = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.stop();
    }

    @Override
    public boolean _RemoteObject_ping() {
        boolean isThere = false;
        this.setStatusWorking("Checking remote object");
        try {
            RemoteUtility remote = (RemoteUtility)this._RemoteObject_getUtility();
            remote.methodHeader("_TYPE_OF_");
            remote.numParams(0);
            remote.stringMethod();
            remote.endMethod();
            isThere = true;
            this.setStatusSuccess();
        }
        catch (Exception ex) {
            this.setStatusFailed(ex.getMessage());
            ex.printStackTrace();
        }
        return isThere;
    }

    protected void setStatusWorking(String status) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(0, status);
        }
    }

    protected void setStatusSuccess() {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(1, "Success");
        }
    }

    protected void setStatusFailed(String msg) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(2, "Failure: " + msg);
        }
    }

    public void _RemoteObject_socketInit() throws IOException {
    }

    public void _RemoteObject_allocateEventDispatcher() {
        try {
            String methodName = "_RemoteObject_allocateEventDispatcher";
            this._p(methodName);
            this._RemoteObject_socketInit();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public Object _getDelegate(Class c) {
        return null;
    }
}

