/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class RMIThreadAction
implements PrivilegedAction {
    private Runnable runnable;
    private String name;
    private boolean daemon;
    private boolean nonSystem;
    private static ThreadGroup systemGroup;
    private static ThreadGroup nonSystemGroup;

    public RMIThreadAction(Runnable runnable, String name, boolean daemon) {
        this(runnable, name, daemon, false);
    }

    public RMIThreadAction(Runnable runnable, String name, boolean daemon, boolean nonSystem) {
        this.runnable = runnable;
        this.name = name;
        this.daemon = daemon;
        this.nonSystem = nonSystem;
    }

    public Object run() {
        Thread t = new Thread(this.getThreadGroup(), this.runnable, "RMI " + this.name);
        t.setDaemon(this.daemon);
        return t;
    }

    private ThreadGroup getThreadGroup() {
        if (this.nonSystem) {
            return RMIThreadAction.getNonSystemGroup();
        }
        return RMIThreadAction.getSystemGroup();
    }

    private static synchronized ThreadGroup getNonSystemGroup() {
        if (nonSystemGroup == null) {
            try {
                final ThreadGroup finalNonSystemParent = RMIThreadAction.getSystemGroup();
                nonSystemGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ThreadGroup(finalNonSystemParent, "RMI Runtime");
                    }
                });
            }
            catch (SecurityException e) {
                nonSystemGroup = new ThreadGroup("RMI runtime (applet)");
            }
        }
        return nonSystemGroup;
    }

    private static synchronized ThreadGroup getSystemGroup() {
        ThreadGroup root = null;
        if (systemGroup == null) {
            ThreadGroup parent;
            root = Thread.currentThread().getThreadGroup();
            while ((parent = root.getParent()) != null) {
                root = parent;
            }
            systemGroup = root;
        }
        return systemGroup;
    }
}

