/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RMIServerTemplate;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class RMIGeneratorServerTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();

    public RMIGeneratorServerTarget() {
        this.m_tm.addThrowException(ServerBusyTimeoutException.class);
    }

    @Override
    public String getGeneratorName() {
        return "RMI_Server";
    }

    @Override
    public Template getTemplate() {
        return new RMIServerTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_RMI);
        pn.setClassName(sourceName);
        return pn.getServerProxyName();
    }

    @Override
    public void generateConstructorCode(Class source, Constructor constructor, CodeGeneratorOutputStream out) throws Exception {
        int j;
        Class<?>[] params = constructor.getParameterTypes();
        out.println("");
        out.println("// _RemoteConstructor", 1);
        out.println("public void _RemoteConstructor(", 1);
        String p = "";
        params = constructor.getParameterTypes();
        for (j = 0; j < params.length; ++j) {
            String s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        out.println("throws java.rmi.RemoteException", 1);
        Class<?>[] exceptions = constructor.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            out.println(exceptions[j].getName(), 3);
        }
        String className = source.getName();
        int pos = className.lastIndexOf(".");
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        if (className.endsWith("Interface")) {
            className = className.substring(0, className.length() - 9);
        }
        out.println("{", 1);
        out.println("if (mTracing) System.out.println(\"Instantiating " + className + " Server\");", 2);
        out.println("mObject = new " + className + "(" + p + ");", 2);
        out.println("}", 1);
    }

    @Override
    public void generateConstructorCode(Class source, String className, CodeGeneratorOutputStream out) throws Exception {
        String name = source.getName();
        int pos = name.lastIndexOf(".");
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if (name.endsWith("Interface")) {
            name = name.substring(0, name.length() - 9);
        }
        out.println("");
        out.println("// _RemoteConstructor", 1);
        out.println("public void _RemoteConstructor() throws java.rmi.RemoteException", 1);
        out.println("{", 1);
        out.println("}", 1);
    }

    @Override
    public void generateMethodCode(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws Exception {
        String s = null;
        if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
            return;
        }
        if (!this.m_tm.generateMethodCodeHeader(source, method, methodName, out)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (int j = 0; j < params.length; ++j) {
            p = p + "p" + (j + 1);
            if (j + 1 >= params.length) continue;
            p = p + ",";
        }
        s = !ret.equals("void") ? "value= " : "";
        s = s + "mObject." + method.getName() + "(" + p + ");";
        out.println(s, 3);
        this.m_tm.generateMethodCodeTrailer(source, method, methodName, out);
    }

    @Override
    public boolean implementationMustExist() {
        return false;
    }

    @Override
    public boolean generatesServerCode() {
        return true;
    }
}

