/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RMIClientTemplate;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class RMIGeneratorClientTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();

    @Override
    public String getGeneratorName() {
        return "RMI_Client";
    }

    public RMIGeneratorClientTarget() {
        this.m_tm.addBroadcastException(IOException.class);
    }

    @Override
    public Template getTemplate() {
        return new RMIClientTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_RMI);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateConstructorCode(Class source, Constructor constructor, CodeGeneratorOutputStream out) throws Exception {
        String s;
        int j;
        Class<?>[] params = constructor.getParameterTypes();
        out.println("");
        out.println("// _RemoteConstructor", 1);
        out.println("public void _RemoteConstructor(", 1);
        String p = "";
        params = constructor.getParameterTypes();
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        out.println("throws Exception, java.rmi.RemoteException", 1);
        Class<?>[] exceptions = constructor.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            out.println(exceptions[j].getName(), 3);
        }
        out.println("{", 1);
        out.println("}", 1);
        out.println("", 1);
        out.println("// newRemoteObject", 1);
        out.println("public void newRemoteObject(", 1);
        p = "";
        params = constructor.getParameterTypes();
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        out.println("throws Exception", 1);
        exceptions = constructor.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            out.println(exceptions[j].getName(), 3);
        }
        out.println("{", 1);
        out.println("mObject._RemoteConstructor(" + p + ");", 2);
        out.println("}", 1);
    }

    @Override
    public void generateConstructorCode(Class source, String className, CodeGeneratorOutputStream out) throws Exception {
        out.println("");
        out.println("// _RemoteConstructor", 1);
        out.println("public void _RemoteConstructor() throws Exception, java.rmi.RemoteException", 1);
        out.println("{", 1);
        out.println("}", 1);
        out.println("");
        out.println("// newRemoteObject", 1);
        out.println("public void newRemoteObject() throws Exception", 1);
        out.println("{", 1);
        out.println("mObject._RemoteConstructor();", 2);
        out.println("}", 1);
    }

    @Override
    public void generateMethodCode(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws Exception {
        String s = null;
        if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
            return;
        }
        if (!this.m_tm.generateMethodCodeHeader(source, method, methodName, out)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (int j = 0; j < params.length; ++j) {
            p = p + "p" + (j + 1);
            if (j + 1 >= params.length) continue;
            p = p + ",";
        }
        s = !ret.equals("void") ? "value= " : "";
        s = s + "mObject." + method.getName() + "(" + p + ");";
        out.println(s, 3);
        this.m_tm.generateMethodCodeTrailer(source, method, methodName, out);
    }
}

